/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.templates;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.templates.TemplateAction;
import chemaxon.marvin.sketch.swing.templates.TemplateDisplayOption;
import chemaxon.marvin.sketch.swing.templates.TemplatePresentationModel;
import chemaxon.marvin.uif.action.support.ToggleButtonBinding;
import chemaxon.marvin.uif.util.swing.ExtendedToolBar;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ToolBarUI;

public class TemplateToolBar
extends ExtendedToolBar
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private SketchPanel sketchPanel;
    private TemplateDisplayOption displayOptions;

    public TemplateToolBar(SketchPanel sketchPanel) {
        this.sketchPanel = sketchPanel;
        this.displayOptions = new TemplateDisplayOption(24);
        this.displayOptions.setDisplayMode(0);
        this.displayOptions.setBackground(this.getBackground());
        this.displayOptions.setAtomSize(0.6);
        this.displayOptions.setSimpleMoleculeScale(15.0);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setRollover(true);
    }

    @Override
    public void setUI(ToolBarUI ui) {
        super.setUI(ui);
    }

    public TemplateDisplayOption getDisplayOptions() {
        return this.displayOptions;
    }

    private synchronized void templateToolBarActionsChanged(final List<TemplateAction> actions) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateToolBar.this.removeAll();
                for (int i = 0; i < actions.size(); ++i) {
                    TemplateAction a = (TemplateAction)actions.get(i);
                    a.setDisplayOptions(TemplateToolBar.this.displayOptions);
                    JToggleButton tb = new JToggleButton(a);
                    tb.setFocusable(false);
                    ToggleButtonBinding.bind(tb, a);
                    if (a.getTemplate().isEditable()) {
                        TemplateToolBar.this.sketchPanel.getTemplatePresentationModel().addPopupMenu(tb, a);
                    }
                    TemplateToolBar.this.add(tb);
                    tb.setText(null);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("useLargeIcons")) {
            boolean b = (Boolean)evt.getNewValue();
            this.displayOptions.setSize(b ? 24 : 16);
            TemplatePresentationModel pm = this.sketchPanel.getTemplatePresentationModel();
            ArrayList<TemplateAction> actions = pm.getToolbarTemplateActions();
            this.templateToolBarActionsChanged(actions);
            this.repaint();
        } else if ("templateToolBarActions".equals(evt.getPropertyName())) {
            try {
                ArrayList<TemplateAction> templates = ((TemplatePresentationModel)evt.getSource()).getToolbarTemplateActions();
                this.templateToolBarActionsChanged(templates);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

