/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.templates;

import chemaxon.struc.Molecule;

public final class Template {
    public static final String ABBREVIATION = "abbreviation";
    public static final String RIGHT_ABBREVIATION = "right_abbreviation";
    public static final String ROTATION_UNIT = "rotation.unit";
    private Molecule molecule;
    private String longName;
    private String leftAbbreviation;
    private String rightAbbreviation;
    private int rotationUnit;
    private boolean editable = false;

    public static Template createTemplate(Molecule mol) {
        Template template = new Template(mol);
        template.setLongName(mol.getName());
        if ("".equals(mol.getName()) && mol.isAtom()) {
            template.setLongName(mol.getAtom(0).getAliasstr());
            if (template.getLongName() == null) {
                template.setLongName(mol.getAtom(0).getSymbol());
            }
        }
        template.setLeftAbbreviation(Template.getAbbreviation(mol));
        template.setRightAbbreviation(mol.getProperty(RIGHT_ABBREVIATION));
        template.setRotationUnit(mol.getProperty(ROTATION_UNIT));
        return template;
    }

    public static String getAbbreviation(Molecule mol) {
        String prop;
        String abbreviation = null;
        if (mol.getSgroupLigands() != null) {
            abbreviation = mol.getSgroup(0).getSubscript();
        }
        return (prop = mol.getProperty(ABBREVIATION)) != null ? prop : abbreviation;
    }

    public static void setAbbreviation(Molecule mol, String abbrev) {
        if (mol.getSgroupLigands() != null) {
            mol.getSgroup(0).setSubscript(abbrev);
        }
        mol.setProperty(ABBREVIATION, abbrev);
    }

    public Template(Molecule molecule) {
        this.molecule = molecule;
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.molecule.setName(longName);
        this.longName = longName;
    }

    public String getLeftAbbreviation() {
        return this.leftAbbreviation;
    }

    public void setLeftAbbreviation(String leftAbbreviation) {
        if (leftAbbreviation != null) {
            this.leftAbbreviation = leftAbbreviation;
            Template.setAbbreviation(this.molecule, leftAbbreviation);
        }
    }

    public String getRightAbbreviation() {
        return this.rightAbbreviation;
    }

    public void setRightAbbreviation(String rightAbbreviation) {
        this.rightAbbreviation = rightAbbreviation;
    }

    public int getRotationUnit() {
        return this.rotationUnit;
    }

    public void setRotationUnit(String rotationUnit) {
        if (rotationUnit == null) {
            return;
        }
        try {
            this.rotationUnit = Integer.parseInt(rotationUnit);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

