/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.templates;

import chemaxon.marvin.sketch.templates.Template;
import chemaxon.marvin.sketch.templates.TemplateSetLocation;
import java.util.ArrayList;

public class TemplateSet {
    private String name;
    private String location;
    private String identifier;
    private boolean containsTemplates = true;
    private boolean editable = false;
    private ArrayList<Template> templates = null;
    private ArrayList<TemplateSet> templateSets = new ArrayList();

    public TemplateSet(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isContainsTemplates() {
        return this.containsTemplates;
    }

    public void setContainsTemplates(boolean containsTemplates) {
        this.containsTemplates = containsTemplates;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public ArrayList<Template> getTemplates() {
        return this.getTemplates(Integer.MAX_VALUE);
    }

    public synchronized ArrayList<Template> getTemplates(int maxCount) {
        if (this.templates == null) {
            ArrayList<Object> arrayList = this.templates = this.containsTemplates ? TemplateSetLocation.importTemplates(this.location, maxCount) : new ArrayList();
            if (this.editable) {
                for (Template t : this.templates) {
                    t.setEditable(this.editable);
                }
            }
        }
        return this.templates;
    }

    public ArrayList<TemplateSet> getTemplateSets() {
        return this.templateSets;
    }

    public TemplateSet getTemplateSet(String loc) {
        for (TemplateSet set : this.templateSets) {
            TemplateSet subset;
            if (!set.containsTemplates && (subset = set.getTemplateSet(loc)) != null) {
                return subset;
            }
            if (!loc.equals(set.getLocation())) continue;
            return set;
        }
        return null;
    }

    public void setTemplates(ArrayList<Template> templates) {
        this.templates = templates;
    }

    public void setTemplateSets(ArrayList<TemplateSet> templateSets) {
        this.templateSets = templateSets;
    }

    public String toString() {
        return this.getName();
    }

    public void unload() {
        this.templates = null;
    }
}

