/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.calculations.ChargePlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.Smolecule;

public class AtomProperty {
    public MoleculeAtomProperty getAtomProperty() {
        return new MoleculeAtomProperty();
    }

    public SmoleculeAtomProperty getSmoleculeAtomProperty() {
        return new SmoleculeAtomProperty();
    }

    public class SmoleculeAtomProperty
    implements MoleculeIterators.AtomPropertyInterface {
        Smolecule smol = null;
        public float[] xCoords = null;
        public float[] yCoords = null;
        public float[] zCoords = null;

        @Override
        public void setMolecule(Object mol) {
            this.smol = (Smolecule)mol;
        }

        public void setCoordinates(Object coord, int i) {
            switch (i) {
                case 0: {
                    this.xCoords = (float[])coord;
                    break;
                }
                case 1: {
                    this.yCoords = (float[])coord;
                    break;
                }
                case 2: {
                    this.zCoords = (float[])coord;
                }
            }
        }

        @Override
        public int getType(int atomIndex) {
            return this.smol.getAtomType(atomIndex);
        }

        @Override
        public String getLabel(int atomIndex) {
            return null;
        }

        @Override
        public float getCharge(int atomIndex) {
            return 0.0f;
        }

        @Override
        public float getBFactor(int atomIndex) {
            return 0.0f;
        }

        @Override
        public float getPartialAtomCharge(int atomIndex) throws Exception {
            return 0.0f;
        }

        @Override
        public int getResidueTypeId(int atomIndex) {
            return 0;
        }

        @Override
        public int getSecondaryStructureType(int atomIndex) {
            return 0;
        }

        @Override
        public float getX(int atomIndex) {
            return this.xCoords[atomIndex];
        }

        @Override
        public float getY(int atomIndex) {
            return this.yCoords[atomIndex];
        }

        @Override
        public float getZ(int atomIndex) {
            return this.zCoords[atomIndex];
        }
    }

    public class MoleculeAtomProperty
    implements MoleculeIterators.AtomPropertyInterface {
        protected Molecule mol = null;
        private ChargePlugin chargeCalc = null;

        @Override
        public void setMolecule(Object mol) {
            this.mol = (Molecule)mol;
            this.chargeCalc = null;
        }

        @Override
        public int getType(int atomIndex) {
            return this.mol.getAtom(atomIndex).getAtno();
        }

        @Override
        public String getLabel(int atomIndex) {
            String l = this.mol.getAtom(atomIndex).getAliasstr();
            return l != null ? l : PeriodicSystem.getSymbol(this.mol.getAtom(atomIndex).getAtno());
        }

        @Override
        public float getCharge(int atomIndex) {
            return this.mol.getAtom(atomIndex).getCharge();
        }

        @Override
        public float getBFactor(int atomIndex) {
            return 0.0f;
        }

        @Override
        public float getPartialAtomCharge(int atomIndex) throws Exception {
            if (this.chargeCalc == null) {
                this.calcCharges();
            }
            return (float)this.chargeCalc.getTotalCharge(atomIndex);
        }

        @Override
        public int getResidueTypeId(int atomIndex) {
            return -1;
        }

        @Override
        public int getSecondaryStructureType(int atomIndex) {
            return 0;
        }

        @Override
        public float getX(int atomIndex) {
            return (float)this.mol.getAtom(atomIndex).getX();
        }

        @Override
        public float getY(int atomIndex) {
            return (float)this.mol.getAtom(atomIndex).getY();
        }

        @Override
        public float getZ(int atomIndex) {
            return (float)this.mol.getAtom(atomIndex).getZ();
        }

        private void calcCharges() throws PluginException {
            this.chargeCalc = new ChargePlugin();
            this.chargeCalc.setMolecule(this.mol);
            this.chargeCalc.run();
        }
    }
}

