/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import javax.media.opengl.GL;

public class BoundingBox {
    private float[] min = new float[3];
    private float[] max = new float[3];
    private float[] center = new float[3];
    private double d;
    private boolean initialised = false;

    public BoundingBox() {
    }

    public BoundingBox(float minx, float miny, float minz, float maxx, float maxy, float maxz) {
        this.set(minx, miny, minz, maxx, maxy, maxz);
        this.ready();
    }

    public void finalize() {
        this.min = null;
        this.max = null;
        this.center = null;
    }

    public void draw(GL gl) {
        gl.glDisable(2896);
        gl.glEnable(3042);
        gl.glColor3d(1.0, 1.0, 1.0);
        gl.glBegin(1);
        gl.glVertex3fv(this.min, 0);
        gl.glVertex3f(this.min[0], this.min[1], this.max[2]);
        gl.glVertex3fv(this.min, 0);
        gl.glVertex3f(this.min[0], this.max[1], this.min[2]);
        gl.glVertex3fv(this.min, 0);
        gl.glVertex3f(this.max[0], this.min[1], this.min[2]);
        gl.glVertex3fv(this.max, 0);
        gl.glVertex3f(this.max[0], this.max[1], this.min[2]);
        gl.glVertex3fv(this.max, 0);
        gl.glVertex3f(this.max[0], this.min[1], this.max[2]);
        gl.glVertex3fv(this.max, 0);
        gl.glVertex3f(this.min[0], this.max[1], this.max[2]);
        gl.glVertex3f(this.min[0], this.max[1], this.max[2]);
        gl.glVertex3f(this.min[0], this.max[1], this.min[2]);
        gl.glVertex3f(this.min[0], this.max[1], this.max[2]);
        gl.glVertex3f(this.min[0], this.min[1], this.max[2]);
        gl.glVertex3f(this.max[0], this.min[1], this.max[2]);
        gl.glVertex3f(this.min[0], this.min[1], this.max[2]);
        gl.glVertex3f(this.max[0], this.min[1], this.max[2]);
        gl.glVertex3f(this.max[0], this.min[1], this.min[2]);
        gl.glVertex3f(this.max[0], this.max[1], this.min[2]);
        gl.glVertex3f(this.min[0], this.max[1], this.min[2]);
        gl.glVertex3f(this.max[0], this.max[1], this.min[2]);
        gl.glVertex3f(this.max[0], this.min[1], this.min[2]);
        gl.glEnd();
        gl.glDisable(3042);
        gl.glEnable(2896);
    }

    public float minx() {
        return this.min[0];
    }

    public float miny() {
        return this.min[1];
    }

    public float minz() {
        return this.min[2];
    }

    public float getMinX() {
        return this.min[0];
    }

    public float getMinY() {
        return this.min[1];
    }

    public float getMinZ() {
        return this.min[2];
    }

    public void setMin(float minx, float miny, float minz) {
        this.min[0] = minx;
        this.min[1] = miny;
        this.min[2] = minz;
    }

    public void setMinX(float v) {
        this.min[0] = v;
    }

    public void setMinY(float v) {
        this.min[1] = v;
    }

    public void setMinZ(float v) {
        this.min[2] = v;
    }

    public float maxx() {
        return this.max[0];
    }

    public float maxy() {
        return this.max[1];
    }

    public float maxz() {
        return this.max[2];
    }

    public float getMaxX() {
        return this.max[0];
    }

    public float getMaxY() {
        return this.max[1];
    }

    public float getMaxZ() {
        return this.max[2];
    }

    public void setMax(float maxx, float maxy, float maxz) {
        this.max[0] = maxx;
        this.max[1] = maxy;
        this.max[2] = maxz;
    }

    public void setMaxX(float v) {
        this.max[0] = v;
    }

    public void setMaxY(float v) {
        this.max[1] = v;
    }

    public void setMaxZ(float v) {
        this.max[2] = v;
    }

    public float centerx() {
        return this.center[0];
    }

    public float centery() {
        return this.center[1];
    }

    public float centerz() {
        return this.center[2];
    }

    public void clear() {
        this.min[0] = 0.0f;
        this.min[1] = 0.0f;
        this.min[2] = 0.0f;
        this.max[0] = 0.0f;
        this.max[1] = 0.0f;
        this.max[2] = 0.0f;
        this.center[0] = 0.0f;
        this.center[1] = 0.0f;
        this.center[2] = 0.0f;
        this.initialised = false;
    }

    public void ready() {
        this.setCenter();
        this.setD();
    }

    public void set(float minx, float miny, float minz, float maxx, float maxy, float maxz) {
        this.setMin(minx, miny, minz);
        this.setMax(maxx, maxy, maxz);
    }

    public void setWithCondition(float x, float y, float z) {
        if (!this.initialised) {
            this.set(x, y, z, x, y, z);
            this.initialised = true;
            return;
        }
        if (this.min[0] > x) {
            this.min[0] = x;
        }
        if (this.max[0] < x) {
            this.max[0] = x;
        }
        if (this.min[1] > y) {
            this.min[1] = y;
        }
        if (this.max[1] < y) {
            this.max[1] = y;
        }
        if (this.min[2] > z) {
            this.min[2] = z;
        }
        if (this.max[2] < z) {
            this.max[2] = z;
        }
    }

    public void setWithCondition(BoundingBox bb) {
        if (bb.maxx() - bb.minx() <= 0.0f) {
            return;
        }
        if (!this.initialised) {
            this.set(bb.getMinX(), bb.getMinY(), bb.getMinZ(), bb.getMaxX(), bb.getMaxY(), bb.getMaxZ());
            this.initialised = true;
            return;
        }
        if (this.min[0] > bb.getMinX()) {
            this.min[0] = bb.getMinX();
        }
        if (this.max[0] < bb.getMaxX()) {
            this.max[0] = bb.getMaxX();
        }
        if (this.min[1] > bb.getMinY()) {
            this.min[1] = bb.getMinY();
        }
        if (this.max[1] < bb.getMaxY()) {
            this.max[1] = bb.getMaxY();
        }
        if (this.min[2] > bb.getMinZ()) {
            this.min[2] = bb.getMinZ();
        }
        if (this.max[2] < bb.getMaxZ()) {
            this.max[2] = bb.getMaxZ();
        }
    }

    public void extend(float v) {
        int i = 0;
        while (i < 3) {
            int n = i;
            this.min[n] = this.min[n] - v;
            int n2 = i++;
            this.max[n2] = this.max[n2] + v;
        }
        this.ready();
    }

    public float[] getBoundingCenter() {
        return this.center;
    }

    private void setCenter() {
        this.center[0] = (this.min[0] + this.max[0]) / 2.0f;
        this.center[1] = (this.min[1] + this.max[1]) / 2.0f;
        this.center[2] = (this.min[2] + this.max[2]) / 2.0f;
    }

    public double getBoundingRadius() {
        return this.d;
    }

    public boolean contains(float x, float y, float z) {
        return x >= this.minx() && y >= this.miny() && z >= this.minz() && x <= this.maxx() && y <= this.maxy() && z <= this.maxz();
    }

    public void translate(float[] v) {
        this.min[0] = this.min[0] + v[0];
        this.max[0] = this.max[0] + v[0];
        this.center[0] = this.center[0] + v[0];
        this.min[1] = this.min[1] + v[1];
        this.max[1] = this.max[1] + v[1];
        this.center[1] = this.center[1] + v[1];
        this.min[2] = this.min[2] + v[2];
        this.max[2] = this.max[2] + v[2];
        this.center[2] = this.center[2] + v[2];
    }

    private void setD() {
        this.d = Math.sqrt(Math.pow(this.max[2] - this.min[2], 2.0) + Math.pow(this.max[1] - this.min[1], 2.0) + Math.pow(this.max[0] - this.min[0], 2.0));
        this.d /= 2.0;
    }

    public String toString() {
        String ret = "";
        ret = ret + "Min: " + this.minx() + ", " + this.miny() + ", " + this.minz() + "\n";
        ret = ret + "Max: " + this.maxx() + ", " + this.maxy() + ", " + this.maxz() + "\n";
        return ret;
    }
}

