/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.ViewPort;
import chemaxon.marvin.space.monitor.Monitor;
import chemaxon.marvin.space.render.Sphere;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class GraphicCell {
    protected static final int MAX_NUMBER_OF_COMPONENTS_PER_CELL = 256;
    protected static final int DEFAULT_NEAR_EDGE = 30;
    protected static final int MODE_NORMAL = 1;
    protected static final int MODE_PICK = 2;
    private ArrayList components;
    private ArrayList componentsToRemove = new ArrayList();
    private boolean activeCell = false;
    private boolean componentBecameSelected = false;
    private boolean componentBecameUnselected = false;
    private boolean zOrderChanged = true;
    private int inRow = 0;
    private int inColumn = 0;
    private UOID id = new UOID(0, -1);
    private GL gl;
    private GLU glu;
    private double boundingSphereRadius = 1.0;
    private boolean drawSphere = false;
    private boolean smoothBackground = false;
    private byte[] backgroundColor = new byte[4];
    private byte[] backgroundColor2 = new byte[4];
    private Properties cellDrawProperties = new Properties();
    private int nearEdgeTolerance = 30;
    private int mode = 1;
    private int motionmode = 1;
    private int mousex;
    private int mousey;
    private int verboseLevel = 0;
    ViewPort viewport;

    public GraphicCell() {
        this.components = new ArrayList();
        this.viewport = new ViewPort(this);
    }

    public GraphicCell(GL gl, GLU glu) {
        if (gl == null || glu == null) {
            System.out.println("OpenGL interfaces are not initialized properly.");
            throw new RuntimeException();
        }
        this.components = new ArrayList();
        this.gl = gl;
        this.glu = glu;
        this.viewport = new ViewPort(this);
    }

    public boolean isVerbose() {
        return this.verboseLevel != 0;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerbose(boolean flag) {
        this.verboseLevel = flag ? 1 : 0;
    }

    public void setVerbose(int level) {
        this.verboseLevel = level;
    }

    public int getIndex() {
        return this.id.getCellIndex();
    }

    public UOID getId() {
        return this.id;
    }

    public void setIndex(int index) {
        this.id.setCellIndex(index);
        for (GraphicComponent gc : this.components) {
            gc.getId().setCellIndex(index);
        }
    }

    public void setSize(int width, int height) {
        this.viewport.setSize(width, height);
    }

    public double getShiftX() {
        return this.viewport.getShiftX();
    }

    public double getShiftY() {
        return this.viewport.getShiftY();
    }

    public float getNearClip() {
        return this.viewport.getNearClip();
    }

    public float getFarClip() {
        return this.viewport.getFarClip();
    }

    public float getFovY() {
        return this.viewport.getFovY();
    }

    public double getCameraZ() {
        return this.viewport.getCameraZ();
    }

    public int addComponent(GraphicComponent component) throws Exception {
        this.components.add(component);
        component.setCell(this);
        component.addDrawProperties(this.cellDrawProperties);
        component.setRotateMatrix(this.viewport.getRotatationMatrix());
        if (component.modifiesOrigin) {
            this.viewport.resetCameraZ(this.getBoundingBoxAndSetSphereRadius());
        }
        return this.components.size() - 1;
    }

    public void removeSelectedComponents() {
        for (int i = 0; i < this.components.size(); ++i) {
            GraphicComponent gc = (GraphicComponent)this.components.get(i);
            if (!gc.isSelected()) continue;
            this.removeComponent(gc);
            i = -1;
        }
    }

    public void removeUnselectedComponents() {
        for (int i = 0; i < this.components.size(); ++i) {
            GraphicComponent gc = (GraphicComponent)this.components.get(i);
            if (gc.isSelected()) continue;
            this.removeComponent(gc);
            i = -1;
        }
    }

    public void removeUnselectedMonitors() {
        for (int i = 0; i < this.components.size(); ++i) {
            GraphicComponent gc = (GraphicComponent)this.components.get(i);
            if (!(gc instanceof Monitor) || gc.isSelected()) continue;
            this.removeComponent(gc);
            i = -1;
        }
    }

    public boolean removeComponent(GraphicComponent component) {
        if (component.getId().getCellIndex() != this.id.getCellIndex()) {
            System.err.println("Cell does not contain removable component.");
            return false;
        }
        this.componentsToRemove.add(component);
        this.components.remove(component);
        for (GraphicComponent gc : this.components) {
            gc.removeAssociation(component);
        }
        this.removeAssociatedComponents(component);
        this.correctComponentIndices();
        return true;
    }

    public void removeComponent(Class componentClass) {
        for (int i = 0; i < this.components.size(); ++i) {
            GraphicComponent gc = (GraphicComponent)this.components.get(i);
            if (gc.getClass() != componentClass) continue;
            this.removeComponent(gc);
            i = -1;
        }
    }

    public void removeComponent(int componentIndex) {
        this.removeComponent(this.getComponent(componentIndex));
    }

    public void removeAllComponents() {
        this.componentsToRemove.addAll(this.components);
        this.components.clear();
    }

    private void correctComponentIndices() {
        for (GraphicComponent gc : this.components) {
            if (gc.getId().getComponentIndex() == this.components.indexOf(gc)) continue;
            gc.getId().setComponentIndex(this.components.indexOf(gc));
        }
    }

    private void removeAssociatedComponents(GraphicComponent component) {
        Iterator i = component.getAssociatedComponents();
        while (i.hasNext()) {
            GraphicComponent gc = (GraphicComponent)i.next();
            this.removeComponent(gc);
        }
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public boolean hasSelectedComponent() {
        for (GraphicComponent gc : this.components) {
            if (!gc.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedComponentElement() {
        for (GraphicComponent gc : this.components) {
            if (!gc.hasSelectedElements()) continue;
            return true;
        }
        return false;
    }

    public boolean containsComponent(GraphicComponent gc) {
        if (gc.getId() == null) {
            return false;
        }
        return gc.getId().getCellIndex() == this.id.getCellIndex() && gc.getId().getComponentIndex() < this.components.size() && this.getComponent(gc.getId().getComponentIndex()) == gc;
    }

    public GraphicComponent getComponent(int componentIndex) {
        return (GraphicComponent)this.components.get(componentIndex);
    }

    public Iterator getComponentIterator() {
        return this.components.iterator();
    }

    public boolean isSelectedComponent(int componentIndex) {
        return this.getComponent(componentIndex).isSelected();
    }

    public boolean isActive() {
        return this.activeCell;
    }

    public void setActive() {
        this.activeCell = true;
    }

    public void setInactive() {
        this.activeCell = false;
    }

    public void hideSelectedComponents() {
        for (GraphicComponent gc : this.components) {
            gc.hideSelected();
        }
    }

    public void hideUnselectedComponents() {
        for (GraphicComponent gc : this.components) {
            gc.hideUnselected();
        }
    }

    public void fadeSelectedComponents() {
        for (GraphicComponent gc : this.components) {
            gc.fadeSelected();
        }
    }

    public void fadeUnselectedComponents() {
        for (GraphicComponent gc : this.components) {
            gc.fadeUnselected();
        }
    }

    public void showAllComponents() {
        for (GraphicComponent gc : this.components) {
            gc.setVisible(true);
        }
    }

    public void showAllComponents(Class c) {
        for (GraphicComponent gc : this.components) {
            if (!gc.getClass().equals(c)) continue;
            gc.setVisible(true);
        }
    }

    public void hideAllComponents(Class c) {
        for (GraphicComponent gc : this.components) {
            if (!gc.getClass().equals(c)) continue;
            gc.setVisible(false);
        }
    }

    public void showFaded() {
        for (GraphicComponent gc : this.components) {
            gc.showFaded();
        }
    }

    public void hideAllMonitors() {
        for (GraphicComponent gc : this.components) {
            if (!(gc instanceof Monitor)) continue;
            gc.unSelect();
            gc.setVisible(false);
        }
    }

    public void showAllMonitors() {
        for (GraphicComponent gc : this.components) {
            if (!(gc instanceof Monitor)) continue;
            gc.setVisible(true);
        }
    }

    public void setOrigin(int left, int bottom) {
        this.viewport.setOrigin(left, bottom);
    }

    public void setIndices(int inRow, int inColumn) {
        this.inRow = inRow;
        this.inColumn = inColumn;
    }

    public void setNearEdgeTolerance(int tolerance) {
        this.nearEdgeTolerance = tolerance;
    }

    public void setContexts(int inRow, int inColumn, int index, int left, int bottom, GL gl, GLU glu) {
        if (gl == null || glu == null) {
            System.out.println("OpenGL interfaces are not initialized properly.");
            throw new RuntimeException();
        }
        this.inRow = inRow;
        this.inColumn = inColumn;
        this.viewport.setLeft(left);
        this.viewport.setBottom(bottom);
        this.setIndex(index);
        this.gl = gl;
        ViewPort.setGL(this.gl);
        this.glu = glu;
        ViewPort.setGLU(this.glu);
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            ((GraphicComponent)i.next()).setGL(gl, glu);
        }
    }

    public String getCellDrawProperty(String propertyName) {
        return (String)this.cellDrawProperties.get(propertyName);
    }

    public void setCellDrawProperties(Properties drawProperties) throws Exception {
        Enumeration<?> e = drawProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.setDrawProperty(key, drawProperties.getProperty(key));
        }
    }

    public void setDrawProperty(String propertyName, String propertyValue) throws Exception {
        this.cellDrawProperties.setProperty(propertyName, propertyValue);
        if (propertyName.equals("Rotate00")) {
            this.viewport.getRotatationMatrix()[0] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("Rotate01")) {
            this.viewport.getRotatationMatrix()[1] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("Rotate02")) {
            this.viewport.getRotatationMatrix()[2] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("Rotate10")) {
            this.viewport.getRotatationMatrix()[4] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("Rotate11")) {
            this.viewport.getRotatationMatrix()[5] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("Rotate12")) {
            this.viewport.getRotatationMatrix()[6] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("Rotate20")) {
            this.viewport.getRotatationMatrix()[8] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("Rotate21")) {
            this.viewport.getRotatationMatrix()[9] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("Rotate22")) {
            this.viewport.getRotatationMatrix()[10] = Float.parseFloat(propertyValue);
        } else if (propertyName.equals("CenterX")) {
            this.setTransformationCenterX(Float.parseFloat(propertyValue));
        } else if (propertyName.equals("CenterY")) {
            this.setTransformationCenterY(Float.parseFloat(propertyValue));
        } else if (propertyName.equals("CenterZ")) {
            this.setTransformationCenterZ(Float.parseFloat(propertyValue));
        } else if (propertyName.equals("Zoom")) {
            this.viewport.setCameraZ(Double.parseDouble(propertyValue));
        } else {
            if (propertyName.equals("Depthcue")) {
                this.viewport.enableFog(Boolean.valueOf(propertyValue));
                return;
            }
            if (propertyName.equals("DrawSphere")) {
                this.setDrawSphere(Boolean.valueOf(propertyValue));
            } else {
                if (propertyName.equals("Fog")) {
                    this.viewport.setFog(Integer.parseInt(propertyValue), Integer.parseInt(propertyValue));
                    return;
                }
                if (propertyName.equals("Depthcue.Near")) {
                    this.viewport.setDepthCueNear(Integer.parseInt(propertyValue));
                    return;
                }
                if (propertyName.equals("Depthcue.Far")) {
                    this.viewport.setDepthCueFar(Integer.parseInt(propertyValue));
                    return;
                }
                if (propertyName.equals("Clipping.Near")) {
                    this.viewport.setClippingPlane(Float.parseFloat(propertyValue));
                    return;
                }
                if (propertyName.equals("Clipping.Far")) {
                    this.viewport.setFarClippingPlane(Float.parseFloat(propertyValue));
                    return;
                }
            }
        }
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            ((GraphicComponent)i.next()).setDrawProperty(propertyName, propertyValue);
        }
    }

    public void setAntialias(boolean antialias) {
        this.viewport.setAntialias(antialias);
    }

    public void setMotionMode(int mode) {
        this.motionmode = mode;
        for (GraphicComponent gc : this.components) {
            gc.setMotionMode(mode);
        }
    }

    public UOID locateObject(int x, int y) {
        this.mode = 2;
        this.mousex = x;
        this.mousey = y;
        this.gl.glScissor(this.viewport.getLeft(), this.viewport.getBottom(), this.viewport.getWidth(), this.viewport.getHeight());
        this.gl.glClear(16640);
        this.viewport.setMatrices();
        double maxz = -1.0;
        UOID objectId = new UOID(this.id.getCellIndex(), -1);
        for (GraphicComponent comp : this.components) {
            if (!comp.isVisible()) continue;
            this.gl.glPushMatrix();
            this.viewport.setModelviewMatrix();
            double actz = comp.locateObject(x, y);
            if (actz < -1.0 && (objectId.getComponentIndex() == -1 || actz > maxz)) {
                maxz = actz;
                objectId.setComponentIndex(comp.getId().getComponentIndex());
            }
            this.gl.glPopMatrix();
        }
        this.mode = 1;
        return objectId;
    }

    public UOID locateObject(int x, int y, Class componentClass) {
        this.mode = 2;
        this.mousex = x;
        this.mousey = y;
        this.gl.glScissor(this.viewport.getLeft(), this.viewport.getBottom(), this.viewport.getWidth(), this.viewport.getHeight());
        this.gl.glClear(16640);
        this.viewport.setMatrices();
        double maxz = -1.0;
        UOID objectId = new UOID(this.id.getCellIndex(), -1);
        for (GraphicComponent comp : this.components) {
            if (!comp.isVisible() || comp.getClass() != componentClass) continue;
            this.gl.glPushMatrix();
            this.viewport.setModelviewMatrix();
            double actz = comp.locateObject(x, y);
            if (actz < -1.0 && (objectId.getComponentIndex() == -1 || actz > maxz)) {
                maxz = actz;
                objectId.setComponentIndex(comp.getId().getComponentIndex());
            }
            this.gl.glPopMatrix();
        }
        this.mode = 1;
        return objectId;
    }

    public boolean locationNearEdgeX(int x, int y) {
        int bottom = this.inRow * this.viewport.getHeight();
        int top = (this.inRow + 1) * this.viewport.getHeight();
        return top - y <= this.nearEdgeTolerance && y <= top || y <= bottom + this.nearEdgeTolerance && y >= bottom;
    }

    public boolean locationNearEdgeY(int x, int y) {
        int right = this.getRight();
        return x - this.viewport.getLeft() < this.nearEdgeTolerance && x - this.viewport.getLeft() >= 0 || right - x < this.nearEdgeTolerance && right - x > 0;
    }

    public int getWidth() {
        return this.viewport.getWidth();
    }

    public int getHeight() {
        return this.viewport.getHeight();
    }

    public int getTop() {
        return this.viewport.getTop();
    }

    public int getBottom() {
        return this.viewport.getBottom();
    }

    public int getLeft() {
        return this.viewport.getLeft();
    }

    public int getRight() {
        return this.viewport.getRight();
    }

    public void clearSelections() {
        for (GraphicComponent gc : this.components) {
            if (gc.isSelected()) {
                this.componentBecameUnselected = true;
            }
            gc.unSelect();
        }
    }

    public void selectComponentElementsInside(BoundingBox bb) {
        for (GraphicComponent gc : this.components) {
            boolean b = gc.isSelected();
            gc.selectComponentElementsInside(bb);
            if (b || !gc.isSelected()) continue;
            this.componentBecameSelected = true;
        }
    }

    public void exclusiveSelection(int itemIndex) {
        for (int i = 0; i < this.components.size(); ++i) {
            boolean b;
            if (i == itemIndex) {
                b = this.getComponent(itemIndex).isSelected();
                this.getComponent(itemIndex).exclusiveSelection();
                if (b && !this.getComponent(itemIndex).isSelected()) {
                    this.componentBecameUnselected = true;
                }
                if (b || !this.getComponent(itemIndex).isSelected()) continue;
                this.componentBecameSelected = true;
                continue;
            }
            b = this.getComponent(i).isSelected();
            this.getComponent(i).unSelect();
            if (!b || this.getComponent(itemIndex).isSelected()) continue;
            this.componentBecameUnselected = true;
        }
    }

    public void extendSelection(int itemIndex) {
        boolean b = this.getComponent(itemIndex).isSelected();
        this.getComponent(itemIndex).extendSelection();
        if (!b && this.getComponent(itemIndex).isSelected()) {
            this.componentBecameSelected = true;
        }
    }

    public void invertSelection(int itemIndex) {
        boolean b = this.getComponent(itemIndex).isSelected();
        this.getComponent(itemIndex).invertSelection();
        if (!b && this.getComponent(itemIndex).isSelected()) {
            this.componentBecameSelected = true;
        }
        if (b && !this.getComponent(itemIndex).isSelected()) {
            this.componentBecameUnselected = true;
        }
    }

    public boolean componentBecameSelected() {
        boolean b = this.componentBecameSelected;
        this.componentBecameSelected = false;
        return b;
    }

    public boolean componentBecameUnselected() {
        boolean b = this.componentBecameUnselected;
        this.componentBecameUnselected = false;
        return b;
    }

    public void setTransformationCenterX(float value) {
        this.viewport.getOrigin()[0] = value;
    }

    public void setTransformationCenterY(float value) {
        this.viewport.getOrigin()[1] = value;
    }

    public void setTransformationCenterZ(float value) {
        this.viewport.getOrigin()[2] = value;
    }

    public float[] getTransformationCenter() {
        return this.viewport.getOrigin();
    }

    public void setTransformationCenter(UOID itemId) {
        this.getComponent(itemId.getComponentIndex()).getCoordinates(this.viewport.getOrigin());
        this.viewport.setShiftX(0.0);
        this.viewport.setShiftY(0.0);
    }

    public void setTransformationCenter(float x, float y, float z) {
        this.viewport.setShiftX(0.0);
        this.viewport.setShiftY(0.0);
        this.viewport.getOrigin()[0] = x;
        this.viewport.getOrigin()[1] = y;
        this.viewport.getOrigin()[2] = z;
    }

    public GraphicComponent getControllableObject(String type) {
        for (GraphicComponent gc : this.components) {
            if (!gc.isControllable(type)) continue;
            return gc;
        }
        return null;
    }

    void drawComponents() {
        GraphicComponent gc;
        int i;
        for (i = 0; i < this.components.size(); ++i) {
            this.gl.glPushMatrix();
            this.viewport.setFog();
            this.viewport.setModelviewMatrix();
            gc = (GraphicComponent)this.components.get(i);
            gc.draw();
            this.gl.glPopMatrix();
        }
        for (i = 0; i < this.components.size(); ++i) {
            this.gl.glPushMatrix();
            this.viewport.setFog();
            this.viewport.setModelviewMatrix();
            gc = (GraphicComponent)this.components.get(i);
            if (gc.hasTransparentPart()) {
                gc.drawTransparentPart();
            }
            this.gl.glPopMatrix();
        }
        for (i = 0; i < this.components.size(); ++i) {
            this.gl.glPushMatrix();
            this.viewport.setFog();
            this.viewport.setModelviewMatrix();
            gc = (GraphicComponent)this.components.get(i);
            if (gc.has2DPart()) {
                gc.draw2DPart();
            }
            this.gl.glPopMatrix();
        }
    }

    public void notifyZCoordinateChange() {
        this.zOrderChanged = true;
    }

    public void draw() {
        if (!this.componentsToRemove.isEmpty()) {
            Iterator i = this.componentsToRemove.iterator();
            while (i.hasNext()) {
                ((GraphicComponent)i.next()).onRemoveGraphicComponent();
            }
            this.componentsToRemove.clear();
        }
        this.viewport.draw();
    }

    public void drawCell() {
        if (this.mode == 1) {
            this.drawComponents();
            if (this.drawSphere) {
                this.drawSphere();
            }
        }
    }

    public void setBackgroundColor(Color newColor) {
        this.backgroundColor[0] = (byte)(newColor.getRed() / 2);
        this.backgroundColor[1] = (byte)(newColor.getGreen() / 2);
        this.backgroundColor[2] = (byte)(newColor.getBlue() / 2);
        this.backgroundColor2 = Colors.brighter(this.backgroundColor, (byte)65);
    }

    public void setSmoothBackgroud(boolean b) {
        this.smoothBackground = b;
    }

    public void drawSmoothBackground() {
        if (!this.smoothBackground) {
            return;
        }
        this.gl.glViewport(this.viewport.getLeft(), this.viewport.getBottom(), this.viewport.getWidth(), this.viewport.getHeight());
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.gl.glOrtho(0.0, (double)(this.viewport.getWidth() - 1), 0.0, (double)(this.viewport.getHeight() - 1), -1.0, 1.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glDisable(2896);
        this.gl.glDisable(2929);
        this.gl.glBegin(7);
        this.gl.glColor3bv(this.backgroundColor2, 0);
        this.gl.glVertex2i(0, 0);
        this.gl.glVertex2i(this.viewport.getWidth() - 1, 0);
        this.gl.glColor3bv(this.backgroundColor, 0);
        this.gl.glVertex2i(this.viewport.getWidth() - 1, this.viewport.getHeight() - 1);
        this.gl.glVertex2i(0, this.viewport.getHeight() - 1);
        this.gl.glEnd();
        this.gl.glEnable(2929);
        this.gl.glEnable(2896);
    }

    public void setDrawSphere(boolean flag) {
        this.drawSphere = flag;
    }

    private void drawBoundingSphere() {
        Sphere boundingSphere = new Sphere(30);
        boundingSphere.setRadius(this.boundingSphereRadius);
        boundingSphere.setCenter(this.viewport.getOrigin());
        boundingSphere.create();
        this.gl.glPolygonMode(1032, 6913);
        this.gl.glDisable(2884);
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        boundingSphere.getNormals().rewind();
        boundingSphere.getVertices().rewind();
        this.gl.glColor3bv(Colors.gray, 0);
        this.gl.glBegin(5);
        for (int j = 0; j < boundingSphere.getVertexCount(); ++j) {
            this.gl.glNormal3d((double)boundingSphere.getNormals().get(), (double)boundingSphere.getNormals().get(), (double)boundingSphere.getNormals().get());
            this.gl.glVertex3d((double)boundingSphere.getVertices().get(), (double)boundingSphere.getVertices().get(), (double)boundingSphere.getVertices().get());
        }
        this.gl.glEnd();
        this.gl.glEnable(2896);
        this.gl.glEnable(2884);
        this.gl.glDisable(3042);
        this.gl.glPolygonMode(1032, 6914);
    }

    public void drawBorders() {
        this.gl.glScissor(this.viewport.getLeft(), this.viewport.getBottom(), this.viewport.getWidth(), this.viewport.getHeight());
        this.gl.glViewport(this.viewport.getLeft(), this.viewport.getBottom(), this.viewport.getWidth(), this.viewport.getHeight());
        this.gl.glDisable(2896);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glOrtho(0.0, (double)this.viewport.getWidth(), 0.0, (double)this.viewport.getHeight(), -1.0, 1.0);
        this.gl.glPolygonMode(1028, 6913);
        if (this.activeCell) {
            this.gl.glColor3bv(Colors.red, 0);
        } else {
            this.gl.glColor3bv(Colors.lightgray, 0);
        }
        this.gl.glBegin(3);
        this.gl.glVertex3d(1.0, 1.0, 1.0);
        this.gl.glVertex3d((double)(this.viewport.getWidth() - 1), 1.0, 1.0);
        this.gl.glVertex3d((double)(this.viewport.getWidth() - 1), (double)(this.viewport.getHeight() - 1), 1.0);
        this.gl.glVertex3d(1.0, (double)(this.viewport.getHeight() - 1), 1.0);
        this.gl.glVertex3d(1.0, 1.0, 1.0);
        this.gl.glEnd();
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glEnable(2896);
    }

    public void drawSphere() {
        this.gl.glBegin(1);
        this.gl.glVertex3f(0.0f, 0.0f, 0.0f);
        this.gl.glEnd();
        double r = (double)this.viewport.getHeight() * 0.8 / 2.0;
        this.gl.glScissor(this.viewport.getLeft(), this.viewport.getBottom(), this.viewport.getWidth(), this.viewport.getHeight());
        this.gl.glViewport(this.viewport.getLeft(), this.viewport.getBottom(), this.viewport.getWidth(), this.viewport.getHeight());
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glOrtho(0.0, (double)this.viewport.getWidth(), 0.0, (double)this.viewport.getHeight(), -1.0, 1.0);
        this.gl.glColor3bv(Colors.lightgray, 0);
        double angle = 0.0;
        this.gl.glBegin(2);
        for (int i = 0; i < 100; ++i) {
            angle = Math.PI * 2 * (double)i / 100.0;
            this.gl.glVertex2d((double)(this.viewport.getWidth() / 2) + r * Math.cos(angle), (double)(this.viewport.getHeight() / 2) + r * Math.sin(angle));
        }
        this.gl.glEnd();
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    public void resetZoom() {
        if (this.gl == null) {
            System.out.println("gl is null in " + this.inRow + ", " + this.inColumn + ", GraphicCell.resetZoom, will not be executed.");
            return;
        }
        this.viewport.resetZoom(this.getBoundingBoxAndSetSphereRadius());
    }

    public void zoom(double factor) {
        this.viewport.zoom(factor);
    }

    public void rotate(double angleX, double angleY, double angleZ) {
        this.viewport.rotate(angleX, angleY, angleZ);
    }

    public void shift(double shiftx, double shifty) {
        this.viewport.shift(shiftx, shifty);
    }

    public void resetView() {
        if (this.gl == null) {
            System.out.println("gl is null in " + this.inRow + ", " + this.inColumn + ", GraphicCell.resetView, will not be executed.");
            return;
        }
        this.viewport.resetView(this.getBoundingBoxAndSetSphereRadius());
    }

    private void mapGlobalVector(int directionVector) {
        int rm = GeomCalc.newMatrix(this.viewport.getRotatationMatrix());
        int irm = GeomCalc.invertMatrix(rm);
        GeomCalc.multVectorWithMatrix(directionVector, irm);
        GeomCalc.deleteMatrix(irm);
        GeomCalc.deleteMatrix(rm);
    }

    public void updateRotationMatrix() {
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            ((GraphicComponent)i.next()).setRotateMatrix(this.viewport.getRotatationMatrix());
        }
    }

    public float[] getRotateMatrix() {
        return this.viewport.getRotatationMatrix();
    }

    public void setRotateMatrix(float[] rm) {
        System.arraycopy(rm, 0, this.viewport.getRotatationMatrix(), 0, 16);
    }

    public BoundingBox getBoundingBoxAndSetSphereRadius() {
        if (this.components.isEmpty()) {
            return null;
        }
        BoundingBox bb = new BoundingBox();
        for (int i = 0; i < this.components.size(); ++i) {
            GraphicComponent gc = (GraphicComponent)this.components.get(i);
            if (!gc.modifiesOrigin || !gc.isVisible()) continue;
            bb.setWithCondition(gc.boundingBox);
        }
        bb.ready();
        this.boundingSphereRadius = bb.getBoundingRadius();
        return bb;
    }

    public boolean setPickMatrix() {
        boolean projectionMatrixNeedsRefresh = this.mode == 2;
        if (projectionMatrixNeedsRefresh) {
            int[] viewport = new int[4];
            this.gl.glGetIntegerv(2978, viewport, 0);
            this.glu.gluPickMatrix((double)this.mousex, (double)this.mousey, 5.0, 5.0, viewport, 0);
        }
        return projectionMatrixNeedsRefresh;
    }
}

