/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.ProgressBarInterface;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.UsableObject;
import com.sun.opengl.util.BufferUtil;
import java.awt.Color;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public abstract class GraphicComponent
implements UsableObject {
    public static final int RENDERING_QUALITY_LOW = 1;
    public static final int RENDERING_QUALITY_MEDIUM = 2;
    public static final int RENDERING_QUALITY_HIGH = 3;
    protected static final int COMPONENT_TYPE_ENTIRE = 1;
    protected GraphicCell graphicCell = null;
    protected UOID uoid;
    protected String name = this.getClass().getName();
    protected Color color = new Color(255, 255, 255);
    protected ArrayList associatedComponents = new ArrayList();
    protected GL gl = null;
    protected GLU glu = null;
    protected boolean visible = true;
    protected int renderingQuality = 2;
    protected int drawType;
    protected Properties drawProperties = new Properties();
    protected boolean modifiesOrigin = true;
    protected BoundingBox boundingBox = new BoundingBox();
    protected int rm = GeomCalc.newMatrix();
    protected int irm = GeomCalc.newMatrix();
    protected boolean active = false;
    IntBuffer selectBuf = BufferUtil.newIntBuffer((int)4096);
    protected ComponentElement pickedItem;
    protected int mousex;
    protected int mousey;
    protected int motionMode = 1;

    protected GraphicComponent() {
    }

    public void onRemoveGraphicComponent() {
        GeomCalc.deleteMatrix(this.rm);
        GeomCalc.deleteMatrix(this.irm);
    }

    public void setProgressBar(ProgressBarInterface progressBar) {
    }

    @Override
    public UOID getId() {
        return this.uoid;
    }

    void setId(UOID id) {
        this.uoid = id;
    }

    void setId(int cellIndex, int componentIndex) {
        this.uoid = new UOID(cellIndex, componentIndex);
    }

    @Override
    public boolean isGraphicComponent() {
        return true;
    }

    @Override
    public GraphicComponent getGraphicComponent() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void setName(String n) {
        this.name = n;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    public void setColor(int r, int g, int b) {
        this.color = new Color(r, g, b);
    }

    public void setColor(float r, float g, float b) {
        this.color = new Color(r, g, b);
    }

    public GraphicCell getCell() {
        return this.graphicCell;
    }

    void setCell(GraphicCell cell) {
        this.graphicCell = cell;
    }

    public Iterator getAssociatedComponents() {
        return this.associatedComponents.iterator();
    }

    public void associate(GraphicComponent gc) {
        if (!this.associatedComponents.contains(gc)) {
            this.associatedComponents.add(gc);
        }
    }

    public void removeAssociation(GraphicComponent gc) {
        if (this.associatedComponents.contains(gc)) {
            this.associatedComponents.remove(gc);
        }
    }

    public void receiveNotificationOnSelection(GraphicComponent gc) {
    }

    public void receiveNotificationOnUnSelection(GraphicComponent gc) {
    }

    public void receiveNotificationOnVisibility(GraphicComponent gc) {
    }

    public void receiveNotificationOnInvisibility(GraphicComponent gc) {
    }

    public void receiveNotificationOnCoordinateChange(GraphicComponent gc) {
    }

    public void notifySelection() {
        Iterator i = this.associatedComponents.iterator();
        while (i.hasNext()) {
            ((GraphicComponent)i.next()).receiveNotificationOnSelection(this);
        }
    }

    public void notifyUnSelection() {
        Iterator i = this.associatedComponents.iterator();
        while (i.hasNext()) {
            ((GraphicComponent)i.next()).receiveNotificationOnUnSelection(this);
        }
    }

    public void notifyVisibility() {
        Iterator i = this.associatedComponents.iterator();
        while (i.hasNext()) {
            ((GraphicComponent)i.next()).receiveNotificationOnVisibility(this);
        }
    }

    public void notifyInvisibility() {
        Iterator i = this.associatedComponents.iterator();
        while (i.hasNext()) {
            ((GraphicComponent)i.next()).receiveNotificationOnInvisibility(this);
        }
    }

    public void notifyCoordinateChange() {
        Iterator i = this.associatedComponents.iterator();
        while (i.hasNext()) {
            ((GraphicComponent)i.next()).receiveNotificationOnCoordinateChange(this);
        }
    }

    public void setMotionMode(int mode) {
        this.motionMode = mode;
    }

    public void setGL(GL gl, GLU glu) {
        this.gl = gl;
        this.glu = glu;
    }

    public void setRenderingQuality(int quality) {
        this.renderingQuality = quality;
    }

    protected void storeDrawProperty(String propertyName, String propertyValue) {
        this.drawProperties.setProperty(propertyName, propertyValue);
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) throws Exception {
    }

    public String getDrawProperty(String propertyName) {
        return this.drawProperties.getProperty(propertyName);
    }

    public Properties getDrawProperties() {
        return this.drawProperties;
    }

    public void setDrawProperties(Properties drawProperties) throws Exception {
        this.drawProperties.clear();
        this.addDrawProperties(drawProperties);
    }

    public void addDrawProperties(Properties drawProperties) throws Exception {
        Enumeration<?> e = drawProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.setDrawProperty(key, drawProperties.getProperty(key));
        }
    }

    public void setRotateMatrix(float[] rotateMatrix) {
        GeomCalc.setMatrix(this.rm, rotateMatrix);
        GeomCalc.invertMatrix(this.rm, this.irm);
    }

    public void projectVector(float[] vector3) {
        int vector = GeomCalc.newVector(vector3);
        GeomCalc.multVectorWithMatrix(vector, this.irm);
        vector3[0] = GeomCalc.getX(vector);
        vector3[1] = GeomCalc.getY(vector);
        vector3[2] = GeomCalc.getZ(vector);
        GeomCalc.deleteVector(vector);
    }

    public void draw() {
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        this.gl.glLineWidth(2.0f);
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glBegin(1);
        this.gl.glColor3bv(Colors.blue, 0);
        this.gl.glVertex3d(0.0, 0.0, 0.0);
        this.gl.glVertex3d(0.0, 0.0, 20.0);
        this.gl.glColor3bv(Colors.green, 0);
        this.gl.glVertex3d(0.0, 0.0, 0.0);
        this.gl.glVertex3d(0.0, 20.0, 0.0);
        this.gl.glColor3bv(Colors.red, 0);
        this.gl.glVertex3d(0.0, 0.0, 0.0);
        this.gl.glVertex3d(20.0, 0.0, 0.0);
        this.gl.glEnd();
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    protected void glColor() {
        this.gl.glColor3f((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f);
    }

    protected void drawCoordinateAxes() {
        float[] c = new float[3];
        this.getCoordinates(c);
        this.gl.glDisable(2896);
        this.gl.glColor3d(1.0, 1.0, 1.0);
        this.gl.glBegin(1);
        this.gl.glVertex3f(c[0], c[1], c[2]);
        this.gl.glVertex3f(c[0], c[1], c[2] + 20.0f);
        this.gl.glVertex3f(c[0], c[1], c[2]);
        this.gl.glVertex3f(c[0], c[1] + 20.0f, c[2]);
        this.gl.glVertex3f(c[0], c[1], c[2]);
        this.gl.glVertex3f(c[0] + 20.0f, c[1], c[2]);
        this.gl.glEnd();
        this.gl.glEnable(2896);
    }

    protected void drawBoundingBox() {
        this.boundingBox.draw(this.gl);
    }

    protected void drawSelection(int mode) {
        if (mode == 7170) {
            this.gl.glPushName(1);
        }
        this.draw();
        this.drawTransparentPart();
        this.draw2DPart();
        if (mode == 7170) {
            this.gl.glPopName();
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isVisible(ComponentElement element) {
        return this.isVisible();
    }

    @Override
    public void setVisible(boolean state) {
        if (this.visible == state) {
            return;
        }
        this.visible = state;
        if (state) {
            this.notifyVisibility();
        } else {
            this.notifyInvisibility();
        }
    }

    public void hideSelected() {
        if (this.isSelected()) {
            this.unSelect();
            this.setVisible(false);
        }
    }

    public void hideUnselected() {
        if (!this.isSelected()) {
            this.setVisible(false);
        }
    }

    public void showFaded() {
    }

    public void fadeSelected() {
    }

    public void fadeUnselected() {
    }

    public boolean hasTransparentPart() {
        return false;
    }

    public void drawTransparentPart() {
    }

    public boolean has2DPart() {
        return false;
    }

    public void draw2DPart() {
    }

    public float getZCoordinateTo2DPart() {
        return 0.0f;
    }

    public void translate(float[] v) {
        this.boundingBox.translate(v);
        this.notifyCoordinateChange();
    }

    public void rotate(float[] v, float[] center) {
    }

    public void rotate(float[] p, float[] v, float[] center) {
        int gv = GeomCalc.newVector(p);
        this.rotate(gv, v, center);
        System.arraycopy(GeomCalc.getFloatVector(gv), 0, p, 0, 3);
        GeomCalc.deleteVector(gv);
    }

    public void rotate(int p, float[] v, float[] center) {
        GeomCalc.decrease(p, center);
        GeomCalc.rotateX(p, Math.sin(v[0]), Math.cos(v[0]));
        GeomCalc.rotateY(p, Math.sin(v[1]), Math.cos(v[1]));
        GeomCalc.rotateZ(p, Math.sin(v[2]), Math.cos(v[2]));
        GeomCalc.increase(p, center);
    }

    public void resize(double x, double y, double z) {
    }

    public boolean isControllable(String type) {
        return false;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public double getBoundingSphereRadius() {
        return this.boundingBox.getBoundingRadius();
    }

    public int getRenderingQuality() {
        return this.renderingQuality;
    }

    public void getCoordinates(float[] c) {
        if (this.pickedItem != null) {
            if (this.pickedItem.getElementType() == 1 && this.boundingBox != null) {
                float[] bc = this.boundingBox.getBoundingCenter();
                c[0] = bc[0];
                c[1] = bc[1];
                c[2] = bc[2];
            }
            this.getCoordinates(this.pickedItem, c);
            this.pickedItem = null;
        } else if (this.boundingBox != null) {
            float[] bc = this.boundingBox.getBoundingCenter();
            c[0] = bc[0];
            c[1] = bc[1];
            c[2] = bc[2];
        }
    }

    public void getCoordinates(ComponentElement element, float[] c) {
        if (element.getElementType() == 1 && this.boundingBox != null) {
            float[] bc = this.boundingBox.getBoundingCenter();
            c[0] = bc[0];
            c[1] = bc[1];
            c[2] = bc[2];
        }
    }

    public String getDescription() {
        if (this.pickedItem != null) {
            String c = this.getDescription(this.pickedItem);
            this.pickedItem = null;
            return c;
        }
        return this.name;
    }

    public String getDescription(ComponentElement element) {
        if (element.getElementType() == 1) {
            return this.getDescription();
        }
        return this.name;
    }

    public ComponentElement[] getLabelInformation(String labeltype, boolean onlyOnHeavyAtoms) {
        return null;
    }

    public ComponentElement[] getLabelInformation(String labeltype) {
        return this.getLabelInformation(labeltype, false);
    }

    public ComponentElement getComponentElement() {
        if (this.active) {
            this.pickedItem = new ComponentElement(this, 1, 0);
        }
        return this.pickedItem;
    }

    public UsableObject getUsableObject(UOID id) {
        return this;
    }

    public double locateObject(int x, int y) {
        this.mousex = x;
        this.mousey = y;
        this.selectBuf.clear();
        this.gl.glSelectBuffer(4096, this.selectBuf);
        this.gl.glRenderMode(7170);
        this.gl.glInitNames();
        this.drawSelection(7170);
        int hits = this.gl.glRenderMode(7168);
        return this.touchObject(hits);
    }

    protected double touchObject(int hits) {
        this.pickedItem = null;
        if (hits > 0) {
            int offset = 0;
            float[] modelview = new float[16];
            this.gl.glGetFloatv(2982, modelview, 0);
            double[] maxZ = new double[]{-1.0};
            for (int i = 0; i < hits; ++i) {
                ++offset;
                ++offset;
                ++offset;
                this.pickObject(++offset, maxZ, modelview);
                ++offset;
            }
            int errorCode = this.gl.glGetError();
            String errorString = this.glu.gluErrorString(errorCode);
            if (errorString != null && !errorString.equals("no error")) {
                System.out.println("Locate object:  >>>  " + errorString + "  <<<  ");
            }
            return maxZ[0];
        }
        return -1.0;
    }

    protected void pickObject(int offset, double[] maxZ, float[] modelview) {
        this.pickedItem = new ComponentElement(this, 1, 0);
        this.pickedItem.setDescription(this.name);
        maxZ[0] = -200.0;
    }

    @Override
    public boolean isSelected() {
        return this.active;
    }

    public boolean isSelected(ComponentElement element) {
        return this.isSelected();
    }

    public boolean hasSelectedElements() {
        return this.active;
    }

    @Override
    public void select() {
        if (this.active) {
            return;
        }
        this.active = true;
    }

    public void select(ComponentElement element) {
        this.select();
    }

    public void selectComponentElementsInside(BoundingBox bb) {
        if (this.boundingBox.minx() >= bb.minx() && this.boundingBox.miny() >= bb.miny() && this.boundingBox.minz() >= bb.minz() && this.boundingBox.maxx() <= bb.maxx() && this.boundingBox.maxy() <= bb.maxy() && this.boundingBox.maxz() <= bb.maxz()) {
            this.select();
        }
    }

    @Override
    public void unSelect() {
        if (!this.active) {
            return;
        }
        this.active = false;
    }

    public void unSelect(ComponentElement element) {
        this.unSelect();
    }

    public void invertSelection() {
        if (this.pickedItem == null) {
            return;
        }
        if (this.isSelected(this.pickedItem)) {
            this.unSelect(this.pickedItem);
        } else {
            this.select(this.pickedItem);
        }
    }

    public void invertSelection(ComponentElement element) {
        this.invertSelection();
    }

    public void extendSelection() {
        if (this.pickedItem == null) {
            return;
        }
        this.select();
    }

    public void extendSelection(ComponentElement element) {
        this.select();
    }

    public void exclusiveSelection() {
        if (this.pickedItem == null) {
            return;
        }
        this.select();
    }

    public void exclusiveSelection(ComponentElement element) {
        this.select();
    }
}

