/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MolecularSurfaceComponent;
import chemaxon.marvin.space.grid.Grid;
import chemaxon.marvin.space.util.Palette;
import chemaxon.marvin.util.ColorPaletteUtil;

public class GridComponent
extends GraphicComponent {
    Palette palette = null;
    private double lowerCutoff = 0.0;
    private double upperCutoff = 0.0;
    private boolean updated = false;
    private Grid grid;
    private MolecularSurfaceComponent msc;
    int dlist = -1;

    public GridComponent(Grid grid) {
        this(null, grid);
    }

    public GridComponent(MolecularSurfaceComponent msc, Grid grid) {
        this.msc = msc;
        this.grid = grid;
        if (msc != null) {
            this.palette = msc.getPalette();
        }
        this.setBoundingBox();
    }

    private void setBoundingBox() {
        this.boundingBox.clear();
        float maxx = this.grid.getStartX() + (float)this.grid.getSizeX() * this.grid.getStepX();
        float maxy = this.grid.getStartY() + (float)this.grid.getSizeY() * this.grid.getStepY();
        float maxz = this.grid.getStartZ() + (float)this.grid.getSizeZ() * this.grid.getStepZ();
        this.boundingBox.set(this.grid.getStartX(), this.grid.getStartY(), this.grid.getStartZ(), maxx, maxy, maxz);
        this.boundingBox.ready();
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) throws Exception {
        if (propertyName.equals("Surface.Palette")) {
            if (this.msc != null) {
                this.setPalette(this.msc.getPalette());
            } else {
                this.palette.clear();
                this.palette.putColors(ColorPaletteUtil.getBuiltInPalette(propertyValue));
                this.updated = false;
            }
        } else if (propertyName.startsWith("Palette.")) {
            double value = Double.parseDouble(propertyValue);
            if (propertyName.equalsIgnoreCase("Palette.Lower")) {
                this.setLowerCutoffValue(value);
            } else if (propertyName.equalsIgnoreCase("Palette.Upper")) {
                this.setUpperCutoffValue(value);
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        if (this.palette == null) {
            float min = this.grid.get(0, 0, 0);
            float max = this.grid.get(0, 0, 0);
            for (int k = 0; k < this.grid.getSizeZ(); ++k) {
                for (int j = 0; j < this.grid.getSizeY(); ++j) {
                    for (int i = 0; i < this.grid.getSizeX(); ++i) {
                        if (this.grid.get(i, j, k) < min) {
                            min = this.grid.get(i, j, k);
                        }
                        if (!(this.grid.get(i, j, k) > max)) continue;
                        max = this.grid.get(i, j, k);
                    }
                }
            }
            this.palette = new Palette(min, 1.0);
            this.palette.clear();
            this.palette.putColors(ColorPaletteUtil.getBuiltInPalette(1));
        }
        if (!this.updated) {
            this.generateDisplayList();
            this.updated = true;
        }
        this.gl.glCallList(this.dlist);
        if (this.isSelected()) {
            this.boundingBox.draw(this.gl);
        }
    }

    private void generateDisplayList() {
        if (this.dlist == -1) {
            this.dlist = this.gl.glGenLists(1);
        }
        this.gl.glNewList(this.dlist, 4864);
        this.gl.glDisable(2896);
        this.gl.glPointSize(2.0f);
        this.gl.glBegin(0);
        for (int k = 0; k < this.grid.getSizeZ(); ++k) {
            for (int j = this.grid.getSizeY() - 1; j >= 0; --j) {
                for (int i = 0; i < this.grid.getSizeX(); ++i) {
                    if (!((double)this.grid.get(i, j, k) > this.upperCutoff) && !((double)this.grid.get(i, j, k) < this.lowerCutoff)) continue;
                    this.gl.glColor3bv(this.palette.getByteColor(this.grid.get(i, j, k)), 0);
                    this.gl.glVertex3fv(this.grid.getCoordinates(i, j, k), 0);
                }
            }
        }
        this.gl.glEnd();
        this.gl.glEnable(2896);
        this.gl.glEndList();
    }

    public void setPalette(Palette pal) {
        this.palette = pal;
        this.updated = false;
    }

    public void setLowerCutoffValue(double v) throws Exception {
        this.lowerCutoff = v;
        this.updated = false;
    }

    public void setUpperCutoffValue(double v) throws Exception {
        this.upperCutoff = v;
        this.updated = false;
    }
}

