/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MonitorableInputStream;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.MSpaceEventHandler;
import chemaxon.marvin.space.MSpaceInstaller;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.MolecularSurfaceComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.gui.JMSpaceMenuBar;
import chemaxon.marvin.space.gui.JMSpaceOptionsDialog;
import chemaxon.marvin.space.gui.JMSpacePopupMenu;
import chemaxon.marvin.space.gui.JMSpaceProgressBar;
import chemaxon.marvin.space.gui.JMSpaceToolBar;
import chemaxon.marvin.space.gui.JMSpaceTree;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Molecule;
import chemaxon.util.FindCodeBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class MSpaceEasy
implements CallbackIface {
    private GraphicScene graphicScene;
    private MSpaceEventHandler eventHandler;
    protected JMSpaceMenuBar menubar = null;
    protected JMSpaceToolBar toolbar = null;
    protected JMSpacePopupMenu popup = null;
    protected JMSpaceTree selectionBar = null;
    protected JMSpaceProgressBar progressBar = null;
    protected JSplitPane jSplitPane1 = null;
    protected JMSpaceOptionsDialog optionsDialog = null;
    protected JFrame containerFrame = null;
    protected static boolean verbose = false;
    private static String PDB_URL = "http://www.rcsb.org/pdb/downloadFile.do?fileFormat=pdb&compression=NO&structureId=";
    private static String PDB_GZ_URL = "http://www.rcsb.org/pdb/files/";

    public MSpaceEasy(boolean install) throws Exception {
        this(1, 1, install, false, null);
    }

    public MSpaceEasy(int rowCount, int columnCount, boolean install) throws Exception {
        this(rowCount, columnCount, install, false, null);
    }

    public MSpaceEasy(boolean install, boolean verbose, URL codebase) throws Exception {
        this(1, 1, install, verbose, codebase);
    }

    public MSpaceEasy(int rowCount, int columnCount, boolean install, boolean verboseMsg, URL codebase) throws Exception {
        verbose = verboseMsg;
        if (install) {
            this.install(codebase);
        }
        this.graphicScene = new GraphicScene(rowCount, columnCount);
        this.graphicScene.setVerbose(verbose);
        this.graphicScene.setMinimumSize(new Dimension(100, 100));
        this.eventHandler = this.graphicScene.getEventHandler();
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
    }

    public static boolean isURL(String path) {
        return path.startsWith("http:/") || path.startsWith("https:/") || path.startsWith("ftp:/") || path.startsWith("file:/");
    }

    public static void setIconImage(JFrame frame) {
        URL u = MSpaceEasy.class.getResource("/chemaxon/icons/marvin/mspace24.png");
        Image img = new ImageIcon(u).getImage();
        frame.setIconImage(img);
    }

    private void install(URL codebase) throws Exception {
        MSpaceInstaller msi = new MSpaceInstaller(verbose);
        if (codebase != null) {
            msi.install(codebase, verbose);
        } else {
            msi.install(verbose);
        }
    }

    public void setLayout(int rowCount, int columnCount) throws Exception {
        this.graphicScene.setSceneSize(rowCount, columnCount);
    }

    public void setVerbose(boolean flag) {
        verbose = flag;
        this.graphicScene.setVerbose(verbose);
    }

    public void setSize(int w, int h) {
        this.graphicScene.setPreferredSize(new Dimension(w, h));
        if (this.jSplitPane1 != null) {
            int border = this.jSplitPane1.getHeight() - this.graphicScene.getHeight();
            int pw = w + this.jSplitPane1.getDividerSize() + this.jSplitPane1.getRightComponent().getWidth() + border;
            int ph = h + border;
            this.jSplitPane1.setPreferredSize(new Dimension(pw, ph));
            this.jSplitPane1.setDividerLocation(w + 1);
        }
        if (this.containerFrame != null) {
            this.containerFrame.pack();
        }
    }

    public void addMenuBar(RootPaneContainer appletOrFrame) {
        if (this.graphicScene.getRootPane() == null) {
            return;
        }
        this.optionsDialog = new JMSpaceOptionsDialog(this.graphicScene, this.eventHandler);
        this.menubar = new JMSpaceMenuBar(this.graphicScene, this.eventHandler, this.optionsDialog);
        if (appletOrFrame != null) {
            if (appletOrFrame instanceof JApplet) {
                this.menubar.setHelpMenu((JApplet)appletOrFrame);
                ((JApplet)appletOrFrame).setJMenuBar(this.menubar);
            } else if (appletOrFrame instanceof JFrame) {
                this.menubar.setHelpMenu((JFrame)appletOrFrame);
                ((JFrame)appletOrFrame).setJMenuBar(this.menubar);
            }
        }
        this.eventHandler.setMenuBar(this.menubar);
        this.eventHandler.setOptionsdialog(this.optionsDialog);
    }

    public void addToolBar(RootPaneContainer appletOrFrame) {
        this.toolbar = new JMSpaceToolBar(this.graphicScene);
        appletOrFrame.getContentPane().add((Component)this.toolbar, "First");
        this.eventHandler.setToolBar(this.toolbar);
    }

    public void addPopupMenu() {
        this.popup = new JMSpacePopupMenu(this.graphicScene);
        this.popup.addMouseListener(this.eventHandler);
        this.eventHandler.setPopupMenu(this.popup);
    }

    public void addSelectionPanel(RootPaneContainer appletOrFrame) {
        this.selectionBar = new JMSpaceTree(this.graphicScene);
        this.selectionBar.setMinimumSize(new Dimension(150, 180));
        this.selectionBar.setPreferredSize(new Dimension(250, 180));
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setLeftComponent(this.graphicScene);
        this.jSplitPane1.setRightComponent(this.selectionBar);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        appletOrFrame.getContentPane().setLayout(new BorderLayout());
        appletOrFrame.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.eventHandler.setSelectionBar(this.selectionBar);
        if (appletOrFrame instanceof JFrame) {
            this.containerFrame = (JFrame)appletOrFrame;
            ((JFrame)appletOrFrame).addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    final int w = ((JFrame)e.getComponent()).getContentPane().getWidth();
                    int height = ((JFrame)e.getComponent()).getContentPane().getHeight();
                    if (MSpaceEasy.this.menubar != null) {
                        height -= MSpaceEasy.this.menubar.getHeight();
                    }
                    if (MSpaceEasy.this.toolbar != null) {
                        height -= MSpaceEasy.this.toolbar.getHeight();
                    }
                    final int h = height;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MSpaceEasy.this.jSplitPane1.setSize(w, h);
                        }
                    });
                }
            });
        }
    }

    public void addSelectionPanelAndProgressBar(RootPaneContainer appletOrFrame) {
        this.selectionBar = new JMSpaceTree(this.graphicScene);
        this.selectionBar.setMinimumSize(new Dimension(250, 180));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        this.progressBar = new JMSpaceProgressBar(this.graphicScene, " ", " ");
        rightPanel.add(this.selectionBar);
        rightPanel.add(this.progressBar.getProgressPanel());
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setLeftComponent(this.graphicScene);
        this.jSplitPane1.setRightComponent(rightPanel);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        appletOrFrame.getContentPane().setLayout(new BorderLayout());
        appletOrFrame.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.eventHandler.setSelectionBar(this.selectionBar);
        this.eventHandler.setProgressBar(this.progressBar);
        if (appletOrFrame instanceof JFrame) {
            this.containerFrame = (JFrame)appletOrFrame;
            ((JFrame)appletOrFrame).addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    final int w = ((JFrame)e.getComponent()).getContentPane().getWidth();
                    int height = ((JFrame)e.getComponent()).getContentPane().getHeight();
                    if (MSpaceEasy.this.toolbar != null) {
                        height -= MSpaceEasy.this.toolbar.getHeight();
                    }
                    final int h = height;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MSpaceEasy.this.jSplitPane1.setSize(w, h);
                        }
                    });
                }
            });
        }
    }

    public JPanel createSelectionPanel(int maxSize) {
        this.selectionBar = new JMSpaceTree(this.graphicScene);
        this.selectionBar.setMinimumSize(new Dimension(250, 180));
        this.selectionBar.setMaximumSize(new Dimension(maxSize, 180));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.graphicScene, "Center");
        mainPanel.add((Component)this.selectionBar, "East");
        this.eventHandler.setSelectionBar(this.selectionBar);
        return mainPanel;
    }

    public JPanel createSelectionPanelAndProgressBar() {
        this.selectionBar = new JMSpaceTree(this.graphicScene);
        this.selectionBar.setMinimumSize(new Dimension(250, 180));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        this.progressBar = new JMSpaceProgressBar(this.graphicScene, " ", " ");
        rightPanel.add(this.selectionBar);
        rightPanel.add(this.progressBar.getProgressPanel());
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setLeftComponent(this.graphicScene);
        this.jSplitPane1.setRightComponent(rightPanel);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.jSplitPane1, "Center");
        this.eventHandler.setSelectionBar(this.selectionBar);
        this.eventHandler.setProgressBar(this.progressBar);
        mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                final int w = e.getComponent().getWidth();
                final int h = e.getComponent().getHeight();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MSpaceEasy.this.jSplitPane1.setSize(w, h);
                    }
                });
            }
        });
        return mainPanel;
    }

    public void addCanvas(Container container) {
        container.setLayout(new BorderLayout());
        container.add((Component)this.graphicScene, "Center");
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.graphicScene.processEvent(propertyName, propertyValue);
        if (this.graphicScene.isGLInitialized()) {
            this.graphicScene.refresh();
        }
    }

    public void setCellProperty(String propertyName, String propertyValue) {
        this.graphicScene.processCellEvent(propertyName, propertyValue);
        this.graphicScene.refresh();
    }

    public void setComponentProperty(Object component, String propertyName, String propertyValue) {
        this.graphicScene.processComponentEvent(component, propertyName, propertyValue);
        this.graphicScene.refresh();
    }

    public void addPDB(String pdbId) throws Exception {
        this.eventHandler.startOperation("Connecting to http://www.rcsb.org...");
        MolInputStream ms = MSpaceEasy.getMolInputStream(MSpaceEasy.getRCSBLink(pdbId, true));
        this.eventHandler.finishOperation();
        this.eventHandler.readPDB(ms);
        this.graphicScene.resetView();
        this.eventHandler.refresh();
    }

    public void readPDB(String s) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        this.eventHandler.readPDB(new MolInputStream(is));
    }

    public static String getRCSBLink(String pdbId) {
        return MSpaceEasy.getRCSBLink(pdbId, false);
    }

    public static String getRCSBLink(String pdbId, boolean compressed) {
        return compressed ? PDB_GZ_URL + pdbId + ".pdb.gz" : PDB_URL + pdbId;
    }

    public ArrayList<Object> addMolecule(String s) throws Exception {
        return this.eventHandler.readMoleculeFile(s);
    }

    public ArrayList addMoleculeToEmptyCell(String s) throws Exception {
        this.graphicScene.createNewCell();
        return this.eventHandler.readMoleculeFile(s);
    }

    public ArrayList<Object> openMolecule(String s) throws Exception {
        this.graphicScene.removeAllComponents();
        return this.eventHandler.readMoleculeFile(s);
    }

    public MoleculeComponent addMolecule(Molecule mol) throws Exception {
        return this.eventHandler.setMolecule(mol);
    }

    public MoleculeComponent addMoleculeWithoutChange(Molecule mol, boolean reset) throws Exception {
        return this.eventHandler.setMoleculeWithoutChange(mol, reset);
    }

    public MoleculeComponent addMoleculeToEmptyCell(Molecule mol) throws Exception {
        this.graphicScene.createNewCell();
        return this.eventHandler.setMolecule(mol);
    }

    public MoleculeComponent addMoleculeTo(Molecule mol, int cellIndex) throws Exception {
        this.graphicScene.setActiveCell(cellIndex);
        return this.eventHandler.setMolecule(mol);
    }

    public void removeComponent(GraphicComponent gc) {
        this.graphicScene.activateContainerCell(gc);
        this.graphicScene.removeComponent(gc);
        this.eventHandler.updateSelectionBar(gc);
    }

    public void removeAllComponents() {
        this.graphicScene.removeAllComponents();
    }

    public MolecularSurfaceComponent computeSurface(MacroMoleculeComponent.MoleculeVisualizer mv) {
        this.graphicScene.activateContainerCell((GraphicComponent)((Object)mv));
        return this.eventHandler.computeSurface(mv, "Connolly");
    }

    public MolecularSurfaceComponent computeSurface(String type) {
        return this.eventHandler.computeSurface(type);
    }

    public void readPropertyFile(String filename) {
        this.eventHandler.readPropertyFile(filename);
        this.eventHandler.checkPaletteChooser();
        this.eventHandler.refresh();
    }

    public void mapPropertyFile(String filename, float min, float max) {
        this.eventHandler.readPropertyFile(filename);
        this.graphicScene.processEvent("Palette.Minimum", "" + min);
        this.graphicScene.processEvent("Palette.Maximum", "" + max);
        this.eventHandler.checkPaletteChooser();
        this.eventHandler.refresh();
    }

    public void refresh() {
        this.eventHandler.refresh();
    }

    public void resetAll() {
        this.graphicScene.resetAll();
    }

    public void processArguments(int maxMolCount, ArrayList infileName, ArrayList molecules, boolean readStdIn, boolean multicell, boolean singleCell, Properties sceneProperties, String displayQuality) throws Exception {
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int i;
            this.eventHandler.setMaxMolCount(maxMolCount);
            this.eventHandler.setMultiCellMode(multicell);
            this.eventHandler.setSingleCellMode(singleCell);
            if (readStdIn) {
                MolInputStream ms = new MolInputStream(System.in);
                this.eventHandler.readMol(ms);
            }
            for (i = 0; i < infileName.size(); ++i) {
                if (multicell) {
                    if (i == this.graphicScene.getCellCount()) {
                        if (!this.graphicScene.isVerbose()) break;
                        System.out.println("Too many input molecules, the limit is rowCount * columnCount");
                        break;
                    }
                    this.graphicScene.setActiveCell(i);
                }
                String fileName = (String)infileName.get(i);
                this.eventHandler.readMoleculeFile(fileName);
            }
            for (i = 0; i < molecules.size(); ++i) {
                if (multicell) {
                    if (i == this.graphicScene.getCellCount()) {
                        if (!this.graphicScene.isVerbose()) break;
                        System.out.println("Too many input molecules, the limit is rowCount * columnCount");
                        break;
                    }
                    this.graphicScene.setActiveCell(i);
                }
                String mol = (String)molecules.get(i);
                ByteArrayInputStream bs = new ByteArrayInputStream(mol.getBytes());
                try {
                    this.eventHandler.readMol(new MolInputStream(bs));
                    continue;
                }
                catch (IOException ioex) {
                    this.eventHandler.handleMyErrors(ioex, "Input data not found or recogized");
                    throw ioex;
                }
            }
            if (this.graphicScene.isGLInitialized()) {
                this.graphicScene.refresh();
            }
            Enumeration<Object> j = sceneProperties.keys();
            while (j.hasMoreElements()) {
                String k = (String)j.nextElement();
                String v = sceneProperties.getProperty(k);
                this.graphicScene.processEvent(k, v);
            }
            this.graphicScene.setDrawProperty("Quality", displayQuality);
            this.graphicScene.resetAll();
            if (this.graphicScene.isGLInitialized()) {
                this.graphicScene.refresh();
            }
            this.menubar.setValues();
            this.graphicScene.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception e) {
            this.eventHandler.handleMyErrors(e, "Error processing arguments");
            throw e;
        }
    }

    public static MolInputStream getMolInputStream(String s) throws IOException {
        return new MolInputStream(MSpaceEasy.getInputStream(s));
    }

    public static InputStream getInputStream(String s) throws IOException {
        if (verbose) {
            System.out.println("-------getInputStream---------");
            System.out.println("--" + s + "--");
        }
        InputStream is = null;
        if (MSpaceEasy.isURL(s)) {
            if (verbose) {
                System.out.println("URL");
            }
            URLConnection conn = new URL(s).openConnection();
            is = conn.getInputStream();
            is = new MonitorableInputStream(is, conn.getContentLength());
        } else {
            if (verbose) {
                System.out.println("NOT URL");
                System.out.println("-------");
            }
            File f = new File(s);
            try {
                if (f.exists()) {
                    if (verbose) {
                        System.out.println(s + " file exists.");
                    }
                    is = new FileInputStream(f);
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (is == null) {
                if (verbose) {
                    System.out.println(s + " file NOT exists.");
                }
                File f2 = new File(FindCodeBase.getCodeBaseDir() + File.separator + s);
                try {
                    if (f2.exists()) {
                        if (verbose) {
                            System.out.println(f2.getPath() + " file exists.");
                        }
                        is = new FileInputStream(f2);
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                if (is == null) {
                    if (verbose) {
                        System.out.println(f2.getPath() + " file NOT exists.");
                        System.out.println("Trying getResourceAsStream...");
                    }
                    if ((is = BasicEnvironment.getResourceAsStream(MSpaceEasy.class, "/" + s)) == null) {
                        if (verbose) {
                            System.out.println("Read failed, reading ByteStream");
                            System.out.println("-------!!!!!!!---------");
                        }
                        is = new ByteArrayInputStream(s.getBytes());
                    }
                }
            }
        }
        if (s.endsWith(".gz")) {
            if (verbose) {
                System.out.println("GZIPInputStream");
            }
            return new GZIPInputStream(is);
        }
        if (s.endsWith(".zip")) {
            if (verbose) {
                System.out.println("ZipInputStream");
            }
            return new ZipInputStream(is);
        }
        if (verbose) {
            System.out.println("----------------------------");
        }
        return is;
    }

    public MSpaceEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public GraphicScene getGraphicScene() {
        return this.graphicScene;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object callback(String method, Object arg) {
        try {
            if (method.equals("addCanvas")) {
                this.addCanvas((Container)arg);
                return null;
            }
            if (method.equals("addMolecule")) {
                return this.addMolecule((Molecule)arg);
            }
            if (method.equals("addMoleculeWithoutChange")) {
                return this.addMoleculeWithoutChange((Molecule)arg, false);
            }
            if (method.equals("addMoleculeTo")) {
                Object[] args = (Object[])arg;
                return this.addMoleculeTo((Molecule)args[0], (Integer)args[1]);
            }
            if (method.equals("addMoleculeToEmptyCell")) {
                return this.addMoleculeToEmptyCell((Molecule)arg);
            }
            if (method.equals("addPopupMenu")) {
                if (arg == null) {
                    this.addPopupMenu();
                    return null;
                } else {
                    JPopupMenu popup = (JPopupMenu)arg;
                    popup.addMouseListener(this.eventHandler);
                    this.eventHandler.setPopupMenu(popup);
                }
                return null;
            }
            if (method.equals("computeSurface")) {
                return this.computeSurface((MacroMoleculeComponent.MoleculeVisualizer)arg);
            }
            if (method.equals("createLabel")) {
                Object[] args = (Object[])arg;
                return this.eventHandler.createLabel((String)args[0], (float[])args[1]);
            }
            if (method.equals("createAtomLabels")) {
                Object[] args = (Object[])arg;
                return this.eventHandler.createAtomLabels((MoleculeComponent)args[0], (ArrayList)args[1]);
            }
            if (method.equals("createExtraAtomLabels")) {
                this.eventHandler.createExtraAtomLabels((MoleculeComponent)arg);
                return null;
            }
            if (method.equals("getEventHandler")) {
                return this.getEventHandler();
            }
            if (method.equals("getGraphicScene")) {
                return this.getGraphicScene();
            }
            if (method.equals("refresh")) {
                this.refresh();
                return null;
            }
            if (method.equals("resetAll")) {
                this.resetAll();
                return null;
            }
            if (method.equals("removeAllComponents")) {
                this.graphicScene.removeAllComponents();
                return null;
            }
            if (method.equals("setProperty")) {
                Object[] args = (Object[])arg;
                this.setProperty((String)args[0], (String)args[1]);
                return null;
            }
            if (method.equals("setSize")) {
                Object[] args = (Object[])arg;
                this.setSize((Integer)args[0], (Integer)args[1]);
                return null;
            }
            if (method.equals("setLayout")) {
                int[] args = (int[])arg;
                this.setLayout(args[0], args[1]);
                return null;
            }
            if (!method.equals("")) return null;
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }
}

