/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.Pharmacophore3D;
import chemaxon.marvin.alignment.Visualizable;
import chemaxon.marvin.alignment.VolumeOverlapGrid;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.formats.pdb.PDBReader;
import chemaxon.marvin.io.image.exporter.JpegExport;
import chemaxon.marvin.io.image.exporter.MsbmpExport;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.modules.mprop.VolumetricData;
import chemaxon.marvin.space.AnimationDemo;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.CoordinateComponent;
import chemaxon.marvin.space.Event;
import chemaxon.marvin.space.EventQueue;
import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.GridComponent;
import chemaxon.marvin.space.IonVisualizer;
import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.MolecularSurfaceComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.PharmacophoreArrow;
import chemaxon.marvin.space.PharmacophorePoint;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.SecondaryStructureComponent;
import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.WaterVisualizer;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.grid.Grid;
import chemaxon.marvin.space.gui.AlignmentForMSpace;
import chemaxon.marvin.space.gui.ColorMapperTool;
import chemaxon.marvin.space.gui.ErrorDialog;
import chemaxon.marvin.space.gui.JMSpaceMenuBar;
import chemaxon.marvin.space.gui.JMSpaceOptionsDialog;
import chemaxon.marvin.space.gui.JMSpaceProgressBar;
import chemaxon.marvin.space.gui.JMSpaceProgressMonitor;
import chemaxon.marvin.space.gui.JMSpaceToolBarIface;
import chemaxon.marvin.space.gui.JMSpaceTree;
import chemaxon.marvin.space.monitor.AngleMonitor;
import chemaxon.marvin.space.monitor.Control;
import chemaxon.marvin.space.monitor.DihedralMonitor;
import chemaxon.marvin.space.monitor.DistanceMonitor;
import chemaxon.marvin.space.monitor.GlobalLocationControl;
import chemaxon.marvin.space.monitor.GlobalOrientationControl;
import chemaxon.marvin.space.monitor.Label;
import chemaxon.marvin.space.monitor.LocalLocationControl;
import chemaxon.marvin.space.monitor.LocalOrientationControl;
import chemaxon.marvin.space.monitor.MeasurementMonitor;
import chemaxon.marvin.space.monitor.Monitor;
import chemaxon.marvin.space.monitor.PositionMonitor;
import chemaxon.marvin.space.monitor.ResizeControl;
import chemaxon.marvin.space.util.CharmmGridImport;
import chemaxon.marvin.util.ColorPaletteUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import com.sun.opengl.util.TGAWriter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class MSpaceEventHandler
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
DropTargetListener,
DragGestureListener,
DragSourceListener {
    public static final String VDATA_PROPKEY = "VOLUMETRIC_DATA";
    private EventQueue eventQueue = new EventQueue();
    private GraphicScene graphicScene;
    private JPopupMenu popup = null;
    private JMSpaceToolBarIface toolbar = null;
    private ColorMapperTool paletteChooser = null;
    private JSpinner isoSpinner = null;
    private JMSpaceMenuBar menubar = null;
    private JMSpaceTree selectionBar = null;
    private JMSpaceOptionsDialog.MSpaceOptions options = null;
    private DefaultMutableTreeNode lastSelectedNode = null;
    private DragSource dragSource = null;
    private StringWriter errorString = new StringWriter();
    private PrintWriter errorStringWriter = null;
    private ErrorDialog errorDialog;
    private static String CLEAN_PROGRESS = "Computing geometry...";
    private static String SURFACE_PROGRESS = "Computing surface...";
    private static String SURFACE_COLOR_PROGRESS = "Coloring surface...";
    private static String PROPERTY_PROGRESS = "Setting draw properties...";
    private static String PROGRESS = "Computing...";
    private static final String SURFACE_ERROR = "Error creating surface.";
    private static final String LABEL_ERROR = "Error creating label.";
    private static final String MEMORY_ERROR = "Not enough memory to complete operation. \nEither close unnecessary components, or restart \nthe program and increse the memory available to the JVM.";
    private static final String LOG_ERROR = "An error has occured during log processing. \nLog processing has been stopped.";
    private static final String COPY_CONDITION_ERROR = "No molecules are selected, please select a molecule before copying to clipboard.";
    private static final String CUT_CONDITION_ERROR = "No molecules are selected, please select a molecule before cutting.";
    private static final String PROPERTY_MAPPING_CONDITION_ERROR = "No surface found to map property file on";
    private static final String PROPERTY_MAPPING_IO_ERROR = "Error reading property file";
    private static final String PROPERTY_MAPPING_ERROR = "Error mapping property to surface";
    private static final String CLEAN_ERROR = "Error cleaning the molecule";
    private JMSpaceProgressBar progressBar = null;
    private static final int STATE_NORMAL = 1;
    private static final int STATE_MONITOR_DISTANCE = 2;
    private static final int STATE_MONITOR_ANGLE = 3;
    private static final int STATE_MONITOR_DIHEDRAL = 4;
    private static final int STATE_PHARMACOPHORE_POINT = 5;
    private static final int STATE_PHARMACOPHORE_ARROW = 6;
    public static final int STATE_TOOLTIP_DESCRIPTION = 7;
    public static final int STATE_LABEL = 8;
    public static final int STATE_EDIT_LABEL = 9;
    private boolean activeCellIndicator = false;
    private boolean activeElementIndicator = false;
    private boolean pickCell = true;
    private boolean pickActive = false;
    private boolean pickPositionMonitor = false;
    private boolean labelsOnSelection = false;
    private int state = 1;
    private int maxMolCount = 1000;
    private int molCount = 0;
    private boolean multiCell = false;
    private boolean singleCell = false;
    private int imageWidth;
    private int imageHeight;
    private String imageFormat;
    private boolean screenShot = true;
    float rotationAngle = 1.0f;
    private boolean possiblePressInInactive = false;
    private Monitor monitor = null;
    private String labelText = null;
    private CoordinateComponent coordinateSystem = null;
    private UOID id;
    private int cellIdx;
    private int prevMouseX;
    private int prevMouseY;
    private RotationInterface rotationModel = new RotationModel();
    private ZoomModel zoomModel = new ZoomModel();
    private TranslationModel translationModel = new TranslationModel();
    private int clipValue = -60;
    private int popupTrigger = 2;
    private boolean weakeningRotation = false;
    private boolean antialiasDisable = true;
    private boolean rotated = false;
    private MSpaceLogHandler logHandler = new MSpaceLogHandler();
    private boolean log = false;
    private boolean logProcessing = false;

    public MSpaceEventHandler(GraphicScene graphicScene) {
        this.graphicScene = graphicScene;
        if (graphicScene.getCellCount() == 1) {
            this.activeCellIndicator = true;
        }
        this.rotationModel.setSceneSize(graphicScene.getCellLeft(), graphicScene.getCellButtom(), graphicScene.getCellRight(), graphicScene.getCellTop());
        graphicScene.setDropTarget(this);
    }

    public void setPopupMenu(JPopupMenu popup) {
        this.popup = popup;
    }

    public void setMenuBar(JMSpaceMenuBar menubar) {
        this.menubar = menubar;
    }

    public void setToolBar(JMSpaceToolBarIface toolbar) {
        this.toolbar = toolbar;
        this.paletteChooser = toolbar.getPaletteChooser();
        this.isoSpinner = toolbar.getJSpinner();
    }

    public void setSelectionBar(JMSpaceTree tree) {
        this.selectionBar = tree;
        this.selectionBar.setDropTarget(this);
        int opts = 1;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.selectionBar.getDragComponent(), opts, this);
    }

    public void setOptionsdialog(JMSpaceOptionsDialog optionsDialog) {
        this.options = optionsDialog.getOptions();
    }

    public void setProgressBar(JMSpaceProgressBar pb) {
        this.progressBar = pb;
        this.graphicScene.setProgressBar(pb);
    }

    public void handleMyErrors(OutOfMemoryError ome) {
        this.handleMyErrors(ome, MEMORY_ERROR);
    }

    public void handleMyErrors(Throwable t, String shortDescription) {
        if (shortDescription == null) {
            shortDescription = t.getMessage();
        }
        final String msg = shortDescription;
        this.finishOperation();
        this.recordErrorMessage(t);
        t.printStackTrace();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MSpaceEventHandler.this.errorDialog == null) {
                    MSpaceEventHandler.this.errorDialog = new ErrorDialog(MSpaceEventHandler.this.graphicScene, "Error", msg, MSpaceEventHandler.this.errorString.toString(), false);
                } else {
                    MSpaceEventHandler.this.errorDialog.setErrorMessage(msg);
                    MSpaceEventHandler.this.errorDialog.setDetailedErrorMessage(MSpaceEventHandler.this.errorString.toString());
                    if (!MSpaceEventHandler.this.errorDialog.isVisible()) {
                        MSpaceEventHandler.this.errorDialog.setVisible(true);
                    }
                }
            }
        });
    }

    public void handleMyErrors(final String message, final String title, final int type) {
        this.finishOperation();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(MSpaceEventHandler.this.graphicScene, message, title, type);
            }
        });
    }

    private void recordErrorMessage(Throwable t) {
        if (this.errorStringWriter == null) {
            this.errorStringWriter = new PrintWriter(this.errorString);
        }
        t.printStackTrace(this.errorStringWriter);
    }

    private void recordErrorMessage(String s) {
        if (this.errorStringWriter == null) {
            this.errorStringWriter = new PrintWriter(this.errorString);
        }
        this.errorStringWriter.println(s);
    }

    public void setRotationModel(RotationInterface rm) {
        this.rotationModel = rm;
    }

    public boolean isReady() {
        return this.eventQueue.isEmpty();
    }

    public void setWeakeningRotation(boolean flag) {
        this.graphicScene.rotate(0.0, 0.0, 0.0);
        this.weakeningRotation = flag;
    }

    public void setAntialiasDisable(boolean flag) {
        this.antialiasDisable = flag;
    }

    public void setMaxMolCount(int maxMolCount) {
        this.maxMolCount = maxMolCount;
    }

    public void setSingleCellMode(boolean b) {
        this.singleCell = b;
    }

    public void setMultiCellMode(boolean b) {
        this.multiCell = b;
    }

    public ArrayList readPDB(MolInputStream ms) throws Exception {
        try {
            this.startOperation("Reading macromolecule...");
            ArrayList<MacroMoleculeComponent> components = new ArrayList<MacroMoleculeComponent>();
            if (this.molCount >= this.maxMolCount) {
                if (this.graphicScene.isVerbose()) {
                    System.out.println("Too many input molecules, the limit is rowCount * columnCount");
                }
            } else {
                this.setProgress(0);
                ++this.molCount;
                PDBReader pr = new PDBReader();
                pr.setInput(ms);
                pr.setFixBondTypes(true);
                pr.setHydrogenize(39);
                this.setProgress(5);
                MacroMolecule m = pr.read();
                this.setProgress(30);
                components.add(this.setMacroMolecule(m));
                this.setProgress(99);
                this.refresh();
            }
            this.finishOperation();
            this.graphicScene.measureFrameRate();
            return components;
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error reading macromolecule.");
            throw e;
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome);
            throw ome;
        }
    }

    public ArrayList readMol(MolInputStream ms) throws Exception {
        try {
            Molecule mol;
            this.startOperation("Reading molecule...");
            ArrayList<MoleculeComponent> components = new ArrayList<MoleculeComponent>();
            MolImporter mi = ms.getFormat().equals("cube") || ms.getFormat().equals("gzip") ? new MolImporter(ms, "V") : new MolImporter(ms);
            int i = 0;
            boolean multicell = false;
            while ((mol = mi.read()) != null) {
                if (this.molCount >= this.maxMolCount) {
                    if (!this.graphicScene.isVerbose()) break;
                    System.out.println("Too many input molecules, the limit is rowCount * columnCount");
                    break;
                }
                ++this.molCount;
                if (!this.singleCell && !this.multiCell && i == 1) {
                    this.finishOperation();
                    Object[] options = new Object[]{"No", "Yes"};
                    int n = JOptionPane.showOptionDialog(this.graphicScene, "The file contains more than 1 molecule. Do you wish to load them to different cells?", "Load multiple molecules", 0, 3, null, options, options[1]);
                    this.startOperation("Reading molecule...");
                    if (n != 0) {
                        multicell = true;
                    }
                }
                if (this.multiCell || i > 0 && multicell) {
                    this.graphicScene.createNewCell();
                }
                MoleculeComponent mc = this.setMolecule(mol);
                components.add(mc);
                ++i;
            }
            this.finishOperation();
            this.graphicScene.measureFrameRate();
            return components;
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error reading molecule");
            throw e;
        }
    }

    public ArrayList readMoleculeFile(String fileName) throws Exception {
        String f = fileName.toLowerCase();
        if (f.endsWith(".pdb") || f.indexOf(".pdb.") > 0) {
            return this.readPDB(MSpaceEasy.getMolInputStream(fileName));
        }
        return this.readMol(MSpaceEasy.getMolInputStream(fileName));
    }

    public void readPropertyFile(String propertyFileName) {
        this.startOperation("Reading property file...");
        String s = propertyFileName.toLowerCase();
        boolean mapped = false;
        try {
            if (s.endsWith(".cub") || s.endsWith(".cube") || s.endsWith(".cub.gz") || s.endsWith(".cube.gz")) {
                mapped = this.readGaussianProperty(MSpaceEasy.getMolInputStream(propertyFileName));
            } else if (s.endsWith(".phi80")) {
                mapped = this.readCharmmProperty(MSpaceEasy.getInputStream(propertyFileName));
            }
            if (!mapped) {
                this.handleMyErrors(PROPERTY_MAPPING_CONDITION_ERROR, "Warning", 2);
            }
        }
        catch (IOException e) {
            this.handleMyErrors(e, PROPERTY_MAPPING_IO_ERROR);
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
        catch (Throwable t) {
            this.handleMyErrors(t, PROPERTY_MAPPING_ERROR);
        }
        this.checkPaletteChooser();
        this.finishOperation();
    }

    public boolean readCharmmProperty(InputStream is) throws Exception {
        GraphicCell cell = this.graphicScene.getActiveCell();
        MolecularSurfaceComponent msc = null;
        MoleculeIterators.MoleculeInterface mif = null;
        GraphicComponent parent = null;
        for (int ci = 0; ci < cell.getComponentCount(); ++ci) {
            GraphicComponent gci = cell.getComponent(ci);
            if (!gci.isVisible() || !(gci instanceof MolecularSurfaceComponent)) continue;
            msc = (MolecularSurfaceComponent)cell.getComponent(ci);
            break;
        }
        if (msc == null) {
            if (cell.getComponentCount() == 0) {
                return false;
            }
            GraphicComponent gci = cell.getComponent(0);
            if (gci instanceof MacroMoleculeComponent) {
                parent = gci;
                MacroMoleculeComponent.MoleculeVisualizer mv = ((MacroMoleculeComponent)gci).getComponent(0);
                if (mv instanceof MoleculeIterators.MoleculeInterface) {
                    mif = (MoleculeIterators.MoleculeInterface)((Object)mv);
                }
            }
            if (mif == null) {
                return false;
            }
            this.graphicScene.setDrawProperty("Surface.IsoValue", "1");
        }
        CharmmGridImport cgi = new CharmmGridImport(is);
        cgi.setProgressBar(this.progressBar);
        VolumetricData vd = new VolumetricData();
        cgi.readVolumetricData(vd);
        Grid grid = new Grid(vd);
        if (msc == null) {
            float v = Float.parseFloat(this.graphicScene.getDrawProperty("Surface.IsoValue"));
            msc = new MolecularSurfaceComponent(mif, vd, v);
            msc.setName("Imported isosurface (+)");
            msc.setDrawProperty("Surface.Color", "#0000ff");
            this.addComponent((GraphicComponent)msc, true, parent, true);
            MolecularSurfaceComponent msc2 = new MolecularSurfaceComponent(mif, vd, -v);
            msc2.setName("Imported isosurface (-)");
            msc2.setDrawProperty("Surface.Color", "#ff0000");
            this.addComponent((GraphicComponent)msc2, true, parent, true);
            this.updateIsoSpinner();
        } else {
            this.startOperation(SURFACE_COLOR_PROGRESS);
            msc.mapPropertyToSurface(grid);
        }
        GridComponent gc = new GridComponent(msc, grid);
        gc.setName("Property Grid");
        gc.associate(msc);
        this.addComponent((GraphicComponent)gc, true, msc, false);
        gc.setVisible(false);
        return true;
    }

    public boolean readGaussianProperty(MolInputStream ms) throws Exception {
        MRecordImporter cimport = new MRecordImporter(ms, null);
        cimport.setProgressMonitor(new JMSpaceProgressMonitor(this.progressBar));
        GraphicCell cell = this.graphicScene.getActiveCell();
        MolecularSurfaceComponent msc = null;
        MDocument doc = null;
        while ((doc = cimport.readDoc()) != null) {
            VolumetricData vd = (VolumetricData)doc.getMainMoleculeGraph().properties().get(VDATA_PROPKEY);
            if (vd == null) continue;
            if (this.graphicScene.isVerbose()) {
                System.out.println("Volumetric Data found.");
            }
            for (int ci = 0; ci < cell.getComponentCount(); ++ci) {
                if (!(cell.getComponent(ci) instanceof MolecularSurfaceComponent)) continue;
                msc = (MolecularSurfaceComponent)cell.getComponent(ci);
                msc.mapPropertyToSurface(vd);
            }
        }
        return msc != null;
    }

    public void createLabels(String type) {
        this.log("createLabels " + type);
        GraphicCell cell = this.graphicScene.getActiveCell();
        if (cell == null) {
            for (int i = 0; i < this.graphicScene.getCellCount(); ++i) {
                cell = this.graphicScene.getCell(i);
                for (int ci = 0; ci < cell.getComponentCount(); ++ci) {
                    this.createLabel(cell.getComponent(ci), type);
                }
            }
            return;
        }
        for (int ci = 0; ci < cell.getComponentCount(); ++ci) {
            this.createLabel(cell.getComponent(ci), type);
        }
    }

    public void createLabel(GraphicComponent gc, String type) {
        try {
            boolean labelOnHeavyAtoms = Boolean.parseBoolean(this.graphicScene.getDrawProperty("Label.OnlyOnHeavyAtoms"));
            ComponentElement[] ce = gc.getLabelInformation(type, labelOnHeavyAtoms);
            if (ce == null) {
                return;
            }
            for (int i = 0; i < ce.length; ++i) {
                Label label = new Label();
                label.selectItem(ce[i]);
                label.setText(ce[i].getDescription());
                label.setBorderColorMode(3);
                if (ce[i].getColor() != null) {
                    label.setBackgroundColor(ce[i].getColor());
                    label.setForegroundColor(Color.black);
                }
                gc.associate(label);
                label.setRelativeXCoordinate(this.graphicScene.getCellLeft());
                label.setRelativeYCoordinate(this.graphicScene.getCellButtom());
                this.graphicScene.addComponent(label);
            }
        }
        catch (Exception e) {
            this.handleMyErrors(e, LABEL_ERROR);
        }
    }

    public void createExtraAtomLabels(MoleculeComponent mc) {
        this.createLabel(mc, "extraatomlabel");
    }

    public Label[] createAtomLabels(MoleculeComponent mc, ArrayList l, int precision) {
        try {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(precision);
            Molecule mol = mc.getMolecule();
            Label[] ret = new Label[mol.getAtomCount()];
            boolean labelOnHeavyAtoms = Boolean.parseBoolean(this.graphicScene.getDrawProperty("Label.OnlyOnHeavyAtoms"));
            for (int i = 0; i < mol.getAtomCount() && i != l.size(); ++i) {
                MolAtom atom = mol.getAtom(i);
                if (atom.getAtno() <= 1 && labelOnHeavyAtoms) continue;
                Label label = new Label();
                label.selectItem(new ComponentElement((GraphicComponent)mc, 2, i));
                if (precision != -1) {
                    label.setText(df.format(l.get(i)));
                } else {
                    label.setText(l.get(i).toString());
                }
                mc.associate(label);
                label.setRelativeXCoordinate(this.graphicScene.getCellLeft());
                label.setRelativeYCoordinate(this.graphicScene.getCellButtom());
                label.setDrawProperty("Label.Draw2D", "false");
                this.graphicScene.addComponent(label);
                ret[i] = label;
            }
            return ret;
        }
        catch (Exception e) {
            this.handleMyErrors(e, LABEL_ERROR);
            return null;
        }
    }

    public Label[] createAtomLabels(MoleculeComponent mc, ArrayList l) {
        return this.createAtomLabels(mc, l, -1);
    }

    public Label createLabel(String text, float[] position) {
        try {
            Label label = new Label();
            if (position.length == 2) {
                label.setPosition(position[0], position[1]);
            } else if (position.length == 3) {
                label.setPosition(position[0], position[1], position[2]);
            }
            label.setText(text);
            label.setRelativeXCoordinate(this.graphicScene.getCellLeft());
            label.setRelativeYCoordinate(this.graphicScene.getCellButtom());
            this.graphicScene.addComponent(label);
            return label;
        }
        catch (Exception e) {
            this.handleMyErrors(e, LABEL_ERROR);
            return null;
        }
    }

    public MoleculeComponent setMolecule(Molecule mol) {
        try {
            this.startOperation(CLEAN_PROGRESS);
            if (mol.getDim() != 3) {
                mol.clean(3, "");
            }
            mol.aromatize();
            mol.addExplicitHydrogens(0);
            this.finishOperation();
            return this.setMoleculeT(mol, true);
        }
        catch (Exception e) {
            this.handleMyErrors(e, CLEAN_ERROR);
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
        this.finishOperation();
        this.refresh();
        return null;
    }

    public MoleculeComponent setMoleculeWithoutChange(Molecule mol, boolean reset) {
        try {
            this.startOperation(PROGRESS);
            MoleculeComponent mc = this.setMoleculeT(mol, reset);
            this.finishOperation();
            this.refresh();
            return mc;
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error setting molecule");
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
        return null;
    }

    private DefaultMutableTreeNode addComponent(GraphicComponent gc, boolean addToSelectionBar, DefaultMutableTreeNode parent, boolean shouldBeVisible) throws Exception {
        this.graphicScene.addComponent(gc);
        if (addToSelectionBar && this.selectionBar != null) {
            return this.selectionBar.addObject(parent, gc, shouldBeVisible);
        }
        return null;
    }

    public DefaultMutableTreeNode addComponent(GraphicComponent gc, boolean addToSelectionBar, GraphicComponent parent, boolean shouldBeVisible) throws Exception {
        DefaultMutableTreeNode p = null;
        if (addToSelectionBar && this.selectionBar != null) {
            p = parent == null ? this.selectionBar.getRootNode() : this.selectionBar.getNode(parent);
        }
        return this.addComponent(gc, addToSelectionBar, p, shouldBeVisible);
    }

    public void showCoordinateSystem(boolean b) {
        try {
            if (this.coordinateSystem == null) {
                this.coordinateSystem = this.graphicScene.addCoordinateSystem(this.graphicScene.getActiveCellIndex());
                this.graphicScene.addComponent(this.createCoordinateLabel("X", 20.0f, 0.0f, 0.0f, this.coordinateSystem));
                this.graphicScene.addComponent(this.createCoordinateLabel("Y", 0.0f, 20.0f, 0.0f, this.coordinateSystem));
                this.graphicScene.addComponent(this.createCoordinateLabel("Z", 0.0f, 0.0f, 20.0f, this.coordinateSystem));
            }
            this.coordinateSystem.setVisible(b);
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error Showing Coordinate System");
        }
    }

    private Label createCoordinateLabel(String text, float x, float y, float z, GraphicComponent cs) {
        Label label = new Label();
        label.selectItem(cs);
        label.setPosition(x, y, z);
        label.setText(text);
        label.setBorderColorMode(0);
        label.setBackgroundColor(Color.black);
        label.setForegroundColor(Color.white);
        label.ignoreDrawProperties(true);
        return label;
    }

    private MoleculeComponent setMoleculeT(Molecule mol, boolean reset) throws Exception {
        if (mol == null) {
            return null;
        }
        MoleculeComponent mc = new MoleculeComponent(mol);
        mc.modifiesOrigin = reset;
        if (this.graphicScene.isVerbose()) {
            System.out.println("The Molecule has " + mol.getAtomCount() + " nodes.");
        }
        DefaultMutableTreeNode node = this.addComponent((GraphicComponent)mc, true, (GraphicComponent)null, true);
        VolumetricData vd = (VolumetricData)mol.properties().get(VDATA_PROPKEY);
        if (vd != null) {
            MolecularSurfaceComponent msc = new MolecularSurfaceComponent(mc, vd);
            msc.setName("Imported Gaussian cube surface");
            this.addComponent((GraphicComponent)msc, true, node, true);
            boolean containsNegative = false;
            for (int i = 0; i < vd.grid.length; ++i) {
                block1: for (int j = 0; j < vd.grid[i].length; ++j) {
                    for (int k = 0; k < vd.grid[i][j].length; ++k) {
                        if (!(vd.grid[i][j][k] < 0.0f)) continue;
                        containsNegative = true;
                        continue block1;
                    }
                }
            }
            if (containsNegative) {
                MolecularSurfaceComponent msc2 = new MolecularSurfaceComponent(mc, vd, -1.0f * msc.getSurfaceThreshold());
                msc2.setName("Imported Gaussian cube surface (-)");
                this.addComponent((GraphicComponent)msc2, true, node, true);
            }
            this.updateIsoSpinner();
        }
        return mc;
    }

    private MacroMoleculeComponent setMacroMolecule(MacroMolecule m) throws Exception {
        MacroMoleculeComponent mmc = new MacroMoleculeComponent(m);
        this.graphicScene.addComponent(mmc);
        if (m != null && this.graphicScene.isVerbose()) {
            System.out.println("The MacroMolecule has " + m.getAtomCount() + " nodes.");
        }
        if (this.selectionBar != null) {
            this.putMMCNode(mmc);
        }
        return mmc;
    }

    private Object getMClipboardMol() throws SecurityException {
        return ClipboardHandler.getObjectFromClipboard();
    }

    private void putMolToClipboard(Molecule m) throws Throwable {
        ClipboardHandler.putMoleculeToClipboard(m, null);
    }

    private void putMolToClipboard(ArrayList mols) throws Throwable {
        Molecule mol = new Molecule();
        for (int i = 0; i < mols.size(); ++i) {
            mol.fuse(((Molecule)mols.get(i)).cloneMolecule());
        }
        ClipboardHandler.putMoleculeToClipboard(mol, null);
    }

    public void paste(Object o) {
        try {
            if (o instanceof Molecule) {
                this.setMolecule((Molecule)o);
            } else if (o instanceof MacroMolecule) {
                this.setMacroMolecule((MacroMolecule)o);
            }
            this.graphicScene.resetView();
            this.refresh();
        }
        catch (Exception ex) {
            this.handleMyErrors(ex, "Error pasting object");
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
    }

    public void paste() {
        this.paste(this.getMClipboardMol());
    }

    public void copy() {
        try {
            ArrayList molecules = this.getSelectedMolecules();
            if (molecules.size() > 0) {
                this.putMolToClipboard(molecules);
            } else {
                this.handleMyErrors(COPY_CONDITION_ERROR, "Warning", 2);
            }
        }
        catch (Throwable t) {
            this.handleMyErrors(t, "Error copying object");
        }
    }

    public void cut() {
        try {
            if (this.graphicScene.getActiveCell() == null) {
                return;
            }
            Iterator i = this.graphicScene.getActiveCell().getComponentIterator();
            while (i.hasNext()) {
                GraphicComponent gc = (GraphicComponent)i.next();
                Molecule m = this.getSelectedMolecule(gc);
                if (m == null || !gc.isSelected()) continue;
                this.putMolToClipboard(m.cloneMolecule());
                this.graphicScene.removeComponent(gc);
                this.updateSelectionBar(gc);
                return;
            }
            this.handleMyErrors(CUT_CONDITION_ERROR, "Warning", 2);
        }
        catch (Throwable t) {
            this.handleMyErrors(t, "Error cutting object");
        }
    }

    public ArrayList getSelectedMolecules() {
        ArrayList molecules = new ArrayList();
        if (this.graphicScene.getActiveCell() == null) {
            for (int i = 0; i < this.graphicScene.getCellCount(); ++i) {
                molecules.addAll(this.getSelectedMolecules(this.graphicScene.getCell(i)));
            }
        }
        molecules.addAll(this.getSelectedMolecules(this.graphicScene.getActiveCell()));
        return molecules;
    }

    private ArrayList getSelectedMolecules(GraphicCell cell) {
        ArrayList<Molecule> retMols = new ArrayList<Molecule>();
        Iterator i = cell.getComponentIterator();
        while (i.hasNext()) {
            GraphicComponent gc = (GraphicComponent)i.next();
            if (gc instanceof MoleculeComponent && gc.isSelected()) {
                retMols.add(((MoleculeComponent)gc).getMolecule());
                continue;
            }
            if (!(gc instanceof MacroMoleculeComponent)) continue;
            if (gc.isSelected()) {
                retMols.add(((MacroMoleculeComponent)gc).getMolecule());
                continue;
            }
            Iterator<MacroMoleculeComponent.MoleculeVisualizer> mi = ((MacroMoleculeComponent)gc).getComponentIterator();
            while (mi.hasNext()) {
                MacroMoleculeComponent.MoleculeVisualizer mv = mi.next();
                if (mv instanceof MoleculeComponent && mv.isSelected()) {
                    retMols.add(((MoleculeComponent)mv).getMolecule());
                    continue;
                }
                if (!(mv instanceof PolymerVisualizer) || !mv.isSelected()) continue;
                retMols.add(((PolymerVisualizer)mv).toMolecule());
            }
        }
        return retMols;
    }

    public Molecule getSelectedMolecule(GraphicComponent gc) {
        if (gc instanceof MoleculeComponent && gc.isSelected()) {
            return ((MoleculeComponent)gc).getMolecule();
        }
        if (gc instanceof MacroMoleculeComponent && gc.isSelected()) {
            return ((MacroMoleculeComponent)gc).getMolecule();
        }
        return null;
    }

    public void startOperation(String s) {
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(3));
        if (s != null) {
            if (this.progressBar != null) {
                this.progressBar.setMessage(s);
                this.progressBar.start();
            }
            if (s.equals(SURFACE_PROGRESS) || s.equals(SURFACE_COLOR_PROGRESS)) {
                this.graphicScene.paintImmediately(this.graphicScene.getBounds());
                if (this.toolbar != null) {
                    this.toolbar.paintImmediately(this.toolbar.getBounds());
                }
                if (this.selectionBar != null) {
                    this.selectionBar.paintImmediately(this.selectionBar.getBounds());
                }
                if (this.menubar != null) {
                    this.menubar.paintImmediately(this.menubar.getBounds());
                }
            }
        }
    }

    private void setProgress(int p) {
        if (this.progressBar != null) {
            this.progressBar.setProgress(p);
        }
    }

    public void finishOperation() {
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(0));
        if (this.progressBar != null) {
            this.progressBar.stop();
        }
    }

    public void refresh() {
        if (this.graphicScene.isGLInitialized()) {
            this.graphicScene.refresh();
        }
    }

    public void resetView() {
        this.log(new Event("Reset", "View"));
        this.graphicScene.resetView();
        this.refresh();
    }

    public void zoomToPocket() {
        GraphicCell cell = this.graphicScene.getActiveCell();
        if (cell == null) {
            return;
        }
        this.log("ZoomToPocket");
        Iterator ci = cell.getComponentIterator();
        while (ci.hasNext()) {
            GraphicComponent gc = (GraphicComponent)ci.next();
            if (!(gc instanceof MacroMoleculeComponent)) continue;
            Iterator<MacroMoleculeComponent.MoleculeVisualizer> mvi = ((MacroMoleculeComponent)gc).getComponentIterator();
            while (mvi.hasNext()) {
                MacroMoleculeComponent.MoleculeVisualizer mv = mvi.next();
                if (!(mv instanceof MoleculeComponent)) continue;
                BoundingBox bb = new BoundingBox();
                bb.setWithCondition(mv.getBoundingBox());
                bb.extend(2.0f);
                cell.selectComponentElementsInside(bb);
            }
        }
        this.zoomToPocket(cell);
    }

    public void zoomToPocket(MoleculeComponent mc) {
        GraphicCell cell = this.graphicScene.getActiveCell();
        if (cell == null) {
            return;
        }
        UOID uoid = mc.getId();
        this.log("ZoomToPocket " + uoid.getCellIndex() + " " + uoid.getComponentIndex() + " " + uoid.getComponentPartIndex());
        BoundingBox bb = new BoundingBox();
        bb.setWithCondition(mc.getBoundingBox());
        bb.extend(2.0f);
        cell.selectComponentElementsInside(bb);
        this.zoomToPocket(cell);
    }

    private void zoomToPocket(GraphicCell cell) {
        Iterator ci = cell.getComponentIterator();
        while (ci.hasNext()) {
            GraphicComponent gc = (GraphicComponent)ci.next();
            if (!(gc instanceof MacroMoleculeComponent)) continue;
            Iterator<MacroMoleculeComponent.MoleculeVisualizer> mvi = ((MacroMoleculeComponent)gc).getComponentIterator();
            while (mvi.hasNext()) {
                MacroMoleculeComponent.MoleculeVisualizer mv = mvi.next();
                if (!(mv instanceof PolymerVisualizer)) continue;
                ((PolymerVisualizer)mv).extendSelectionToResidues();
            }
            break block0;
        }
        this.graphicScene.hideUnselectedComponents();
        this.graphicScene.resetView();
        this.graphicScene.clearSelection(cell.getIndex());
    }

    private static String pharmaTypeToLabel(int i1) {
        try {
            NodeColor nc = NodeColor.create(AlignmentProperties.ColoringScheme.PHARMACOPHORE);
            Field[] fields = Pharmacophore3D.class.getFields();
            Pharmacophore3D p = new Pharmacophore3D();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!nc.isSameType(i1, field.getInt(p))) continue;
                return field.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String dreidingTypeToString(int colorID) {
        String ret = "";
        if (colorID - 1 <= 61) {
            ret = Dreiding.getDreidingAtomTypeLabel(colorID - 1);
        } else if (colorID == Pharmacophore3D.ALIPHATIC_RINGCENTER) {
            ret = "ALIPHATIC_RINGCENTER";
        } else if (colorID == Pharmacophore3D.AROMATIC_RINGCENTER) {
            ret = "AROMATIC_RINGCENTER";
        }
        return ret;
    }

    private float[] getVolumeColor(AlignmentProperties.ColoringScheme scheme, int colorID) {
        if (scheme == AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES) {
            return Colors.dreidingTypeToColor(colorID);
        }
        if (scheme == AlignmentProperties.ColoringScheme.PHARMACOPHORE) {
            return Colors.pharmaTypeToColor(colorID);
        }
        if (scheme == AlignmentProperties.ColoringScheme.ATOM_TYPES) {
            return Colors.getCPKColor(colorID);
        }
        return Colors.fallbackColoring(colorID);
    }

    private String getVolumeLabel(AlignmentProperties.ColoringScheme scheme, int colorID) {
        if (scheme == AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES) {
            return MSpaceEventHandler.dreidingTypeToString(colorID);
        }
        if (scheme == AlignmentProperties.ColoringScheme.PHARMACOPHORE) {
            return MSpaceEventHandler.pharmaTypeToLabel(colorID);
        }
        if (scheme == AlignmentProperties.ColoringScheme.ATOM_TYPES) {
            return PeriodicSystem.getName(colorID);
        }
        if (scheme == AlignmentProperties.ColoringScheme.SAME) {
            return "Shape only";
        }
        return Integer.toString(colorID);
    }

    private void addSurfaceComponent(MoleculeComponent mc, MolecularSurfaceComponent msc) throws Exception {
        if (mc.getMacroMoleculeComponent() != null) {
            mc.getMacroMoleculeComponent().associate(msc);
        } else if (mc instanceof GraphicComponent) {
            mc.associate(msc);
        }
        if (mc.getMacroMoleculeComponent() != null) {
            this.addComponent((GraphicComponent)msc, true, mc.getMacroMoleculeComponent(), true);
        } else {
            this.addComponent((GraphicComponent)msc, true, mc, true);
        }
    }

    private void computeShape(MoleculeComponent mc, AlignmentProperties.ColoringScheme cScheme, float bin, float scale, float margin, float iso) throws AlignmentException, Exception {
        AlignmentMoleculeFactory amf = new AlignmentMoleculeFactory();
        amf.setNodeType(AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_FAST);
        amf.setColor(cScheme);
        Molecule m = mc.getMolecule();
        AlignmentMolecule am = amf.generate(0, m, false, false);
        this.computeShape(mc, am, cScheme, bin, scale, margin, iso);
    }

    void computeShape(MoleculeComponent mc, AlignmentMolecule am, AlignmentProperties.ColoringScheme cScheme, float bin, float scale, float margin, float iso) throws AlignmentException, Exception {
        Visualizable visualizer = am.getVisualizable();
        if (visualizer == null) {
            return;
        }
        visualizer.setBin(bin);
        visualizer.setScaleVis(scale);
        visualizer.setMargin(margin);
        int[] t = visualizer.getDifferentTypes();
        this.isoSpinner.setValue(Float.valueOf(iso));
        for (int i = 0; i < t.length; ++i) {
            if (NodeColor.isAliphaticRingCenter(t[i]) || NodeColor.isAromaticRingCenter(t[i])) continue;
            VolumetricData v = visualizer.volData(t[i]);
            MolecularSurfaceComponent msc = new MolecularSurfaceComponent(mc, v);
            String label = this.getVolumeLabel(cScheme, t[i]);
            int colorID = t[i];
            if (cScheme == AlignmentProperties.ColoringScheme.SAME) {
                colorID = am.getMolID();
            }
            float[] c = this.getVolumeColor(cScheme, colorID);
            msc.setColor(c[0], c[1], c[2]);
            msc.setName(label);
            this.addSurfaceComponent(mc, msc);
        }
    }

    public void computeShapeOverlap(AlignmentForMSpace.AlignmentResultMoleculeComponent mc, float bin, float scale, float margin, float iso) throws AlignmentException, Exception {
        Collection<AlignmentMolecule> molecules = mc.getMolecules();
        if (molecules.size() > 2) {
            this.graphicScene.getEventHandler().handleMyErrors("Cannot handle more than two molecule.", "Volume creation error", 0);
            return;
        }
        AlignmentMolecule[] molArray = new AlignmentMolecule[molecules.size()];
        molecules.toArray(molArray);
        AlignmentProperties.ColoringScheme cScheme = mc.getColoringScheme();
        for (int i = 0; i < molArray.length; ++i) {
            MoleculeComponent mc1 = new MoleculeComponent(molArray[i].getMoleculeOrig());
            this.addComponent((GraphicComponent)mc1, true, mc, false);
            this.computeShape(mc1, molArray[i], cScheme, bin, scale, margin, iso);
        }
        VolumeOverlapGrid v = new VolumeOverlapGrid(molArray[0], molArray[1]);
        this.isoSpinner.setValue(Float.valueOf(iso));
        v.setBin(bin);
        v.setScaleVis(scale);
        v.setMargin(margin);
        v.update();
        VolumeOverlapGrid.TypePairIterator it = v.getIterator();
        it.reset();
        while (it.hasNext()) {
            int[] p = it.next();
            if (NodeColor.isAliphaticRingCenter(p[0]) || NodeColor.isAromaticRingCenter(p[0]) || NodeColor.isAliphaticRingCenter(p[1]) || NodeColor.isAromaticRingCenter(p[1])) continue;
            VolumetricData vol = v.volData(p[0], p[1]);
            MolecularSurfaceComponent msc = new MolecularSurfaceComponent(mc, vol);
            String label = this.getVolumeLabel(cScheme, p[0]);
            int colorID = p[0];
            if (cScheme == AlignmentProperties.ColoringScheme.SAME) {
                colorID = molArray.length;
            }
            float[] c = this.getVolumeColor(cScheme, colorID);
            msc.setColor(c[0], c[1], c[2]);
            msc.setName(label);
            this.addSurfaceComponent(mc, msc);
        }
    }

    public void computeShape(MacroMoleculeComponent.MoleculeVisualizer mv, String type) throws AlignmentException, Exception {
        this.startOperation(SURFACE_PROGRESS);
        this.isoSpinner.setEnabled(true);
        float bin = DrawableFactory.GetSettingsProvider().GetVolDataBin();
        float scale = DrawableFactory.GetSettingsProvider().GetVolDataScale();
        float margin = DrawableFactory.GetSettingsProvider().GetVolDataMargin();
        float iso = DrawableFactory.GetSettingsProvider().GetIsoPropForVolData();
        AlignmentProperties.ColoringScheme cScheme = type.equals(AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES.toString()) ? AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES : (type.equals(AlignmentProperties.ColoringScheme.ATOM_TYPES.toString()) ? AlignmentProperties.ColoringScheme.ATOM_TYPES : (type.equals(AlignmentProperties.ColoringScheme.SAME.toString()) ? AlignmentProperties.ColoringScheme.SAME : (type.equals(AlignmentProperties.ColoringScheme.PHARMACOPHORE.toString()) ? AlignmentProperties.ColoringScheme.PHARMACOPHORE : AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES)));
        if (mv instanceof AlignmentForMSpace.AlignmentResultMoleculeComponent) {
            AlignmentForMSpace.AlignmentResultMoleculeComponent mc = (AlignmentForMSpace.AlignmentResultMoleculeComponent)mv;
            this.computeShapeOverlap(mc, bin, scale, margin, iso);
        } else {
            this.computeShape((MoleculeComponent)mv, cScheme, bin, scale, margin, iso);
        }
        this.finishOperation();
    }

    public MolecularSurfaceComponent computeSurface(String surfaceType) {
        this.startOperation(SURFACE_PROGRESS);
        MolecularSurfaceComponent object = this.computeSurfaceT(surfaceType);
        this.checkPaletteChooser();
        this.finishOperation();
        return object;
    }

    public MolecularSurfaceComponent computeSurface(MacroMoleculeComponent.MoleculeVisualizer mv, String surfaceType) {
        this.startOperation(SURFACE_PROGRESS);
        MolecularSurfaceComponent object = this.computeSurfaceT(mv, surfaceType);
        this.checkPaletteChooser();
        this.finishOperation();
        return object;
    }

    private MolecularSurfaceComponent computeSurfaceT(String surfaceType) {
        try {
            int ci;
            GraphicCell cell = this.graphicScene.getActiveCell();
            if (cell == null) {
                this.finishOperation();
                return null;
            }
            ArrayList<MacroMoleculeComponent.MoleculeVisualizer> polymers = new ArrayList<MacroMoleculeComponent.MoleculeVisualizer>();
            String name = "";
            int molcount = 0;
            MoleculeComponent mc = null;
            for (ci = 0; ci < cell.getComponentCount(); ++ci) {
                if (cell.getComponent(ci) instanceof MoleculeComponent) {
                    ++molcount;
                    mc = (MoleculeComponent)cell.getComponent(ci);
                    continue;
                }
                if (!(cell.getComponent(ci) instanceof MacroMoleculeComponent)) continue;
                int visiblepolymers = 0;
                Iterator<MacroMoleculeComponent.MoleculeVisualizer> mmcci = ((MacroMoleculeComponent)cell.getComponent(ci)).getComponentIterator();
                while (mmcci.hasNext()) {
                    MacroMoleculeComponent.MoleculeVisualizer mv = mmcci.next();
                    if (mv instanceof PolymerVisualizer && mv.isVisible()) {
                        ++visiblepolymers;
                        break;
                    }
                    if (!(mv instanceof MoleculeComponent) || !mv.isVisible()) continue;
                    mc = (MoleculeComponent)mv;
                    ++molcount;
                }
                if (visiblepolymers <= 0) continue;
                mc = null;
                ++molcount;
            }
            if (molcount == 1 && mc != null) {
                return this.computeSurfaceT(mc, surfaceType);
            }
            for (ci = 0; ci < cell.getComponentCount(); ++ci) {
                GraphicComponent gc = cell.getComponent(ci);
                if (!(gc instanceof MacroMoleculeComponent)) continue;
                polymers.clear();
                int polymerCount = 0;
                MacroMoleculeComponent mmc = (MacroMoleculeComponent)gc;
                for (int i = 0; i < mmc.getComponents().size(); ++i) {
                    MacroMoleculeComponent.MoleculeVisualizer comp = mmc.getComponents().get(i);
                    if (!(comp instanceof PolymerVisualizer) || !((PolymerVisualizer)comp).isVisible()) continue;
                    polymers.add(comp);
                    name = name + ((PolymerVisualizer)comp).getName() + ", ";
                    ++polymerCount;
                }
                if (polymerCount == 0) continue;
                if (name.length() > 2) {
                    name = name.substring(0, name.length() - 2);
                }
                MolecularSurfaceComponent msc = null;
                msc = new MolecularSurfaceComponent(polymers);
                msc.setProgressBar(this.progressBar);
                msc.setDrawProperty("Quality", this.graphicScene.getDrawProperty("Quality"));
                msc.setDrawProperty("Surface.ProbeRadius", this.graphicScene.getDrawProperty("Surface.ProbeRadius"));
                msc.setDrawProperty("Surface.Simplification", this.graphicScene.getDrawProperty("Surface.Simplification"));
                msc.setDrawProperty("Surface.AutoResolution", this.graphicScene.getDrawProperty("Surface.AutoResolution"));
                msc.setDrawProperty("Surface.Resolution", this.graphicScene.getDrawProperty("Surface.Resolution"));
                msc.setSurfaceType(surfaceType);
                msc.setName(surfaceType + " surface of " + name);
                gc.associate(msc);
                this.addComponent((GraphicComponent)msc, true, gc, true);
                return msc;
            }
        }
        catch (Exception e) {
            this.handleMyErrors(e, SURFACE_ERROR);
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
        return null;
    }

    public JMSpaceProgressBar getProgressBar() {
        return this.progressBar;
    }

    private MolecularSurfaceComponent computeSurfaceT(MacroMoleculeComponent.MoleculeVisualizer mv, String surfaceType) {
        try {
            ArrayList<MacroMoleculeComponent.MoleculeVisualizer> molArray = new ArrayList<MacroMoleculeComponent.MoleculeVisualizer>();
            molArray.add(mv);
            MolecularSurfaceComponent msc = null;
            msc = new MolecularSurfaceComponent(molArray);
            msc.setProgressBar(this.progressBar);
            msc.setDrawProperty("Quality", this.graphicScene.getDrawProperty("Quality"));
            msc.setDrawProperty("Surface.ProbeRadius", this.graphicScene.getDrawProperty("Surface.ProbeRadius"));
            msc.setDrawProperty("Surface.Simplification", this.graphicScene.getDrawProperty("Surface.Simplification"));
            msc.setDrawProperty("Surface.AutoResolution", this.graphicScene.getDrawProperty("Surface.AutoResolution"));
            msc.setDrawProperty("Surface.Resolution", this.graphicScene.getDrawProperty("Surface.Resolution"));
            msc.setSurfaceType(surfaceType);
            if (mv.getMacroMoleculeComponent() != null) {
                mv.getMacroMoleculeComponent().associate(msc);
            } else if (mv instanceof GraphicComponent) {
                ((GraphicComponent)((Object)mv)).associate(msc);
            }
            msc.setName(surfaceType + " surface of " + mv.getName());
            if (mv.getMacroMoleculeComponent() != null) {
                this.addComponent((GraphicComponent)msc, true, mv.getMacroMoleculeComponent(), true);
            } else {
                this.addComponent((GraphicComponent)msc, true, (MoleculeComponent)mv, true);
            }
            return msc;
        }
        catch (Exception e) {
            this.handleMyErrors(e, SURFACE_ERROR);
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
        return null;
    }

    public void surfaceSimplification(MolecularSurfaceComponent msc) {
        this.startOperation(SURFACE_PROGRESS);
        try {
            msc.setProgressBar(this.progressBar);
            msc.surfaceSimplification();
            this.refresh();
            this.finishOperation();
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error during surface simplification");
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
    }

    private boolean coloringSurface(UsableObject uo, Event evt) {
        try {
            this.startOperation(SURFACE_COLOR_PROGRESS);
            if (uo == null) {
                this.graphicScene.setDrawProperty(evt.getEventID(), evt.getEventValue(), evt.getEventRange());
            } else {
                uo.setDrawProperty(evt.getEventID(), evt.getEventValue());
            }
            this.checkPaletteChooser();
            this.finishOperation();
            this.refresh();
            return true;
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error during surface coloring");
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
        return false;
    }

    void checkPaletteChooser() {
        if (this.paletteChooser == null) {
            return;
        }
        boolean shouldBeEnabled = false;
        block0: for (int i = 0; i < this.graphicScene.getCellCount(); ++i) {
            Iterator ci = this.graphicScene.getCell(i).getComponentIterator();
            while (ci.hasNext()) {
                Object component = ci.next();
                if (!(component instanceof MolecularSurfaceComponent) || !((MolecularSurfaceComponent)component).isColorMapperEnabled()) continue;
                shouldBeEnabled = true;
                continue block0;
            }
        }
        if (shouldBeEnabled && !this.paletteChooser.isEnabled()) {
            this.paletteChooser.setEnabled(true);
        } else if (!shouldBeEnabled && this.paletteChooser.isEnabled()) {
            this.paletteChooser.setEnabled(false);
        }
        if (shouldBeEnabled) {
            this.updateMappedPropertyValues();
        }
    }

    public void updateIsoSpinner() {
        if (this.isoSpinner == null) {
            return;
        }
        boolean shouldBeEnabled = false;
        block0: for (int i = 0; i < this.graphicScene.getCellCount(); ++i) {
            Iterator ci = this.graphicScene.getCell(i).getComponentIterator();
            while (ci.hasNext()) {
                Object component = ci.next();
                if (!(component instanceof MolecularSurfaceComponent) || ((MolecularSurfaceComponent)component).getSurfaceType() != 5) continue;
                shouldBeEnabled = true;
                continue block0;
            }
        }
        if (shouldBeEnabled && !this.isoSpinner.isEnabled()) {
            this.isoSpinner.setEnabled(true);
        } else if (!shouldBeEnabled && this.isoSpinner.isEnabled()) {
            this.isoSpinner.setEnabled(false);
        }
    }

    public void changePalette(int palette) {
        if (this.graphicScene.getGraphicComponentCount() == 0) {
            return;
        }
        for (int i = 0; i < this.graphicScene.getCellCount(); ++i) {
            GraphicCell cell = this.graphicScene.getCell(i);
            Iterator ci = cell.getComponentIterator();
            while (ci.hasNext()) {
                GraphicComponent gc = (GraphicComponent)ci.next();
                if (!(gc instanceof MolecularSurfaceComponent)) continue;
                ((MolecularSurfaceComponent)gc).setPalette(palette);
            }
        }
        this.refresh();
    }

    private void updateMappedPropertyValues() {
        if (this.paletteChooser == null) {
            return;
        }
        double min = 0.0;
        double max = 0.0;
        int i = 0;
        GraphicCell cell = this.graphicScene.getActiveCell();
        Iterator ci = cell.getComponentIterator();
        while (ci.hasNext()) {
            GraphicComponent gc = (GraphicComponent)ci.next();
            if (!(gc instanceof MolecularSurfaceComponent)) continue;
            double minep = ((MolecularSurfaceComponent)gc).getMinimumMappedValue();
            double maxep = ((MolecularSurfaceComponent)gc).getMaximumMappedValue();
            if (i == 0) {
                min = minep;
                max = maxep;
            } else {
                if (min > minep) {
                    min = minep;
                }
                if (max < maxep) {
                    max = maxep;
                }
            }
            ++i;
        }
        this.paletteChooser.setMinimum(min);
        this.paletteChooser.setMaximum(max);
    }

    public void showSecondaryStructure() {
        try {
            GraphicCell cell = this.graphicScene.getActiveCell();
            if (cell != null) {
                for (int ci = 0; ci < cell.getComponentCount(); ++ci) {
                    if (!(cell.getComponent(ci) instanceof MacroMoleculeComponent)) continue;
                    SecondaryStructureComponent ssc = new SecondaryStructureComponent((MacroMoleculeComponent)cell.getComponent(ci));
                    ssc.setName("Secondary structure");
                    cell.getComponent(ci).associate(ssc);
                    this.addComponent((GraphicComponent)ssc, true, cell.getComponent(ci), true);
                }
            }
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error showing secondary structure");
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
    }

    public void showSecondaryStructure(String type) {
        try {
            GraphicCell cell = this.graphicScene.getActiveCell();
            if (cell != null) {
                for (int ci = 0; ci < cell.getComponentCount(); ++ci) {
                    if (!(cell.getComponent(ci) instanceof MacroMoleculeComponent)) continue;
                    SecondaryStructureComponent ssc = new SecondaryStructureComponent((MacroMoleculeComponent)cell.getComponent(ci));
                    ssc.setName("Secondary structure");
                    cell.getComponent(ci).associate(ssc);
                    this.addComponent((GraphicComponent)ssc, true, cell.getComponent(ci), true);
                    ssc.setDrawProperty("SecondaryStructure.DrawType", type);
                }
            }
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error showing secondary structure");
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
    }

    public UsableObject getUsableObject(UOID id) {
        GraphicComponent gc = this.graphicScene.getGraphicComponent(id);
        if (id.getComponentPartIndex() == -1) {
            return gc;
        }
        return gc.getUsableObject(id);
    }

    public void clearSelectionBar() {
        if (this.selectionBar != null) {
            this.selectionBar.clear();
        }
    }

    public void updateSelectionBar(GraphicComponent gc) {
        if (this.selectionBar == null) {
            return;
        }
        for (int i = 0; i < this.selectionBar.getRootNode().getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.selectionBar.getRootNode().getChildAt(i);
            UsableObject uo = (UsableObject)child.getUserObject();
            if (uo.getGraphicComponent() != gc) continue;
            this.selectionBar.removeNode(child);
        }
    }

    public void updateSelectionBar() {
        if (this.selectionBar == null) {
            return;
        }
        for (int i = 0; i < this.selectionBar.getRootNode().getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.selectionBar.getRootNode().getChildAt(i);
            UsableObject uo = (UsableObject)child.getUserObject();
            if (uo.isGraphicComponent() && !this.graphicScene.containsComponent(uo.getGraphicComponent())) {
                this.selectionBar.removeNode(child);
                --i;
            }
            if (child.getChildCount() <= 0) continue;
            for (int j = 0; j < child.getChildCount(); ++j) {
                DefaultMutableTreeNode c = (DefaultMutableTreeNode)child.getChildAt(j);
                UsableObject cuo = (UsableObject)c.getUserObject();
                if (!cuo.isGraphicComponent() || this.graphicScene.containsComponent(cuo.getGraphicComponent())) continue;
                this.selectionBar.removeNode(c);
                --j;
            }
        }
    }

    public void selectionOccured(DefaultMutableTreeNode node) {
        UsableObject uo = (UsableObject)node.getUserObject();
        this.graphicScene.activateContainerCell(uo.getGraphicComponent());
        this.refresh();
    }

    public boolean iconClicked(DefaultMutableTreeNode node) {
        UsableObject uo;
        uo.setVisible(!(uo = (UsableObject)node.getUserObject()).isVisible());
        this.registerEvent("setVisible", "" + uo.isVisible(), uo);
        this.refresh();
        return uo.isVisible();
    }

    public void iconDragged(DefaultMutableTreeNode node, boolean state) {
        UsableObject uo = (UsableObject)node.getUserObject();
        if (uo.isVisible() != state) {
            uo.setVisible(state);
        }
        this.registerEvent("setVisible", "" + uo.isVisible(), uo);
    }

    public void clearHighLighting(DefaultMutableTreeNode node, boolean needsRefresh) {
    }

    private void putMMCNode(MacroMoleculeComponent mmc) {
        DefaultMutableTreeNode subtree = new DefaultMutableTreeNode(mmc);
        Iterator<MacroMoleculeComponent.MoleculeVisualizer> ci = mmc.getComponentIterator();
        while (ci.hasNext()) {
            MacroMoleculeComponent.MoleculeVisualizer mmv = ci.next();
            if (!(mmv instanceof UsableObject)) continue;
            subtree.add(new DefaultMutableTreeNode(mmv));
        }
        this.selectionBar.addSubTreeToParent(subtree);
    }

    private void refreshSelectionBar() {
        if (this.selectionBar == null) {
            return;
        }
        this.selectionBar.refreshTree();
    }

    public void sceneSizeChanged() {
        this.rotationModel.setSceneSize(this.graphicScene.getCellLeft(), this.graphicScene.getViewportHeight() - this.graphicScene.getCellTop(), this.graphicScene.getCellWidth(), this.graphicScene.getCellHeight());
        this.translationModel.setSceneSize(this.graphicScene.getCellWidth(), this.graphicScene.getCellHeight());
    }

    private boolean requiresFrameRateMeasure(Event evt) {
        String id = evt.getEventID();
        if (id.equalsIgnoreCase("hide")) {
            return true;
        }
        if (id.equalsIgnoreCase("show")) {
            return true;
        }
        if (id.equalsIgnoreCase("close")) {
            return true;
        }
        if (id.equalsIgnoreCase("quality")) {
            return true;
        }
        if (id.endsWith("DrawType")) {
            return true;
        }
        return id.equalsIgnoreCase("depthcue");
    }

    private void log(Event evt) {
        if (this.log) {
            try {
                this.logHandler.record(evt);
            }
            catch (Exception e) {
                this.handleMyErrors(e, "Error during event log");
            }
        }
    }

    private void log(String s) {
        if (this.log) {
            try {
                this.logHandler.record(s);
            }
            catch (Exception e) {
                this.handleMyErrors(e, "Error during event log");
            }
        }
    }

    private void logMonitor(String type, Monitor monitor) {
        if (!this.log) {
            return;
        }
        String s = "" + type;
        ComponentElement[] elements = monitor.getSelectedElements();
        s = s + " " + elements.length;
        for (int i = 0; i < elements.length; ++i) {
            ComponentElement ce = elements[i];
            UOID gcID = ce.getComponent().getId();
            s = s + " " + gcID.getCellIndex() + " " + gcID.getComponentIndex();
            s = s + " " + ce.getComponentPartId() + " " + ce.getElementType() + " " + ce.getElementIndex();
        }
        this.log(s);
    }

    private void logPharmacophorePoint(PharmacophorePoint pp) {
        if (!this.log) {
            return;
        }
        String s = "PharmacophorePoint ";
        String types = "";
        int typeCount = 0;
        if (pp.isAcceptor()) {
            types = types + " Acceptor";
            ++typeCount;
        }
        if (pp.isDonor()) {
            types = types + " Donor";
            ++typeCount;
        }
        if (pp.isAnionic()) {
            types = types + " Anionic";
            ++typeCount;
        }
        if (pp.isCationic()) {
            types = types + " Cationic";
            ++typeCount;
        }
        if (pp.isAromatic()) {
            types = types + " Aromatic";
            ++typeCount;
        }
        if (pp.isExcluded()) {
            types = types + " Excluded";
            ++typeCount;
        }
        if (pp.isHydrophobic()) {
            types = types + " Hydrophobic";
            ++typeCount;
        }
        s = s + typeCount;
        s = s + types;
        float[] c = new float[3];
        pp.getCoordinates(null, c);
        s = s + " " + c[0] + " " + c[1] + " " + c[2];
        this.log(s);
    }

    public void registerEvent(String eventID, String eventValue, UsableObject uo) {
        UOID id = uo.getId();
        this.log(eventID + " " + eventValue + " " + id.getCellIndex() + " " + id.getComponentIndex() + " " + id.getComponentPartIndex());
    }

    public boolean processNextEvent() {
        Event evt = this.getEventFromQueue();
        if (evt == null) {
            return false;
        }
        if (evt.getEventID().equals("Animate")) {
            this.graphicScene.rotate(0.0, this.rotationAngle, 0.0);
            return true;
        }
        this.log(evt);
        if (evt.getEventID().startsWith("mouse")) {
            return this.processMouseEvent(evt);
        }
        this.startOperation(null);
        if (evt.getEventRange() == 3) {
            return this.processComponentEvent(evt);
        }
        if (evt.getEventID().equals("ExportImage")) {
            return this.saveImage(evt.getEventValue());
        }
        if (evt.getEventID().equalsIgnoreCase("SynchronousMode")) {
            this.graphicScene.setSynchronousMode(Boolean.valueOf(evt.getEventValue()));
        } else if (evt.getEventID().equalsIgnoreCase("Background.Color")) {
            this.graphicScene.setBackgroundColor(Color.decode(evt.getEventValue()));
        } else if (evt.getEventID().equalsIgnoreCase("Background.Transparent")) {
            this.graphicScene.setTransparentBackground(Boolean.valueOf(evt.getEventValue()));
        } else if (evt.getEventID().equalsIgnoreCase("Background.Smooth")) {
            this.graphicScene.setSmoothBackground(Boolean.valueOf(evt.getEventValue()));
        } else if (evt.getEventID().equalsIgnoreCase("Reset")) {
            if (evt.getEventValue().equals("View") || evt.getEventValue().equals("Active")) {
                this.graphicScene.resetView();
            } else if (evt.getEventValue().equals("All")) {
                this.graphicScene.resetAll();
            }
        } else if (evt.getEventID().equalsIgnoreCase("Layout")) {
            try {
                if (evt.getEventValue().equalsIgnoreCase("Add row")) {
                    this.graphicScene.setSceneSize(this.graphicScene.getRowCount() + 1, this.graphicScene.getColumnCount());
                }
                if (evt.getEventValue().equalsIgnoreCase("Add column")) {
                    this.graphicScene.setSceneSize(this.graphicScene.getRowCount(), this.graphicScene.getColumnCount() + 1);
                }
                if (evt.getEventValue().equalsIgnoreCase("Delete row")) {
                    this.graphicScene.setSceneSize(this.graphicScene.getRowCount() - 1, this.graphicScene.getColumnCount());
                }
                this.graphicScene.setSceneSize(this.graphicScene.getRowCount(), this.graphicScene.getColumnCount() - 1);
            }
            catch (Exception e) {
                this.handleMyErrors(e, "Error changing layout");
                return false;
            }
        } else if (evt.getEventID().equalsIgnoreCase("ShowSurface")) {
            this.computeSurface(evt.getEventValue());
        } else if (evt.getEventID().equalsIgnoreCase("ShowSecondaryStructure")) {
            this.showSecondaryStructure(evt.getEventValue());
        } else {
            if (evt.getEventID().equals("Surface.Palette")) {
                if (this.paletteChooser != null) {
                    this.paletteChooser.setPalette(ColorPaletteUtil.getBuiltInPaletteId(evt.getEventValue()));
                }
            } else if (evt.getEventID().equals("Surface.ColorType")) {
                return this.coloringSurface(null, evt);
            }
            try {
                String dc;
                if (evt.getEventID().startsWith("Colors.")) {
                    this.setColors(evt.getEventID(), evt.getEventValue());
                }
                this.graphicScene.setDrawProperty(evt.getEventID(), evt.getEventValue(), evt.getEventRange());
                if (evt.getEventID().endsWith(".Color") || evt.getEventID().endsWith(".ColorType")) {
                    this.refreshSelectionBar();
                }
                if (evt.getEventID().startsWith("Depthcue.") && ((dc = this.graphicScene.getDrawProperty("Depthcue")) == null || dc.equalsIgnoreCase("false"))) {
                    this.graphicScene.setDrawProperty("Depthcue", "true");
                    if (this.menubar != null) {
                        this.menubar.setDepthcue(true);
                    }
                }
            }
            catch (Exception e) {
                this.handleMyErrors(e, "Error setting draw property: " + evt.getEventID() + ", " + evt.getEventValue());
                return false;
            }
            catch (OutOfMemoryError ome) {
                this.handleMyErrors(ome, MEMORY_ERROR);
                return false;
            }
            if (this.requiresFrameRateMeasure(evt)) {
                this.graphicScene.measureFrameRate();
            }
        }
        this.finishOperation();
        return true;
    }

    private boolean processComponentEvent(Event evt) {
        try {
            UsableObject uo = (UsableObject)evt.getComponent();
            if (evt.getEventID().equals("ShowSurface")) {
                this.computeSurface((MacroMoleculeComponent.MoleculeVisualizer)((Object)uo), evt.getEventValue());
            } else {
                if (evt.getEventID().equals("Surface.ColorType")) {
                    return this.coloringSurface(uo, evt);
                }
                uo.setDrawProperty(evt.getEventID(), evt.getEventValue());
            }
            if (evt.getEventID().endsWith(".Color") || evt.getEventID().endsWith(".ColorType")) {
                this.refreshSelectionBar();
            }
            if (this.requiresFrameRateMeasure(evt)) {
                this.graphicScene.measureFrameRate();
            }
            this.finishOperation();
            return true;
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error caused by setting " + evt.getEventID() + ", " + evt.getEventValue());
            return false;
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
            return false;
        }
    }

    private boolean processMouseEvent(Event evt) {
        if (evt.getEventID().equalsIgnoreCase("mouseDragged")) {
            MouseEvent mevt = (MouseEvent)evt.getEvent();
            this.processDrag(mevt);
            return true;
        }
        if (evt.getEventID().equalsIgnoreCase("mousePressed")) {
            MouseEvent mevt = (MouseEvent)evt.getEvent();
            if (this.graphicScene.isAntialiasEnabled() && this.antialiasDisable) {
                this.graphicScene.setAntialias(false);
                if (this.menubar != null) {
                    this.menubar.setAntialias(false);
                }
            }
            this.id = this.graphicScene.locateObject(mevt.getX(), mevt.getY(), Label.class);
            if (this.id != null && this.id.getComponentIndex() != -1) {
                this.graphicScene.clearSelection(this.id.getCellIndex());
                this.state = 8;
                this.graphicScene.getGraphicComponent(this.id).select();
            }
            if (this.translationModel.isTranslationEvent(mevt)) {
                this.translationModel.setMousePressEvent(mevt);
            } else if (this.zoomModel.isZoomEvent(mevt)) {
                this.zoomModel.setMousePressEvent(mevt);
            } else if (this.rotationModel.isRotationPressEvent(mevt)) {
                if (this.graphicScene.getCellCount() > 1 || !this.rotationModel.isInitialized()) {
                    this.rotationModel.setSceneSize(this.graphicScene.getCellLeft(), this.graphicScene.getViewportHeight() - this.graphicScene.getCellTop(), this.graphicScene.getCellWidth(), this.graphicScene.getCellHeight());
                }
                this.rotationModel.setMousePressEvent(mevt);
            }
            this.possiblePressInInactive = true;
            this.prevMouseX = mevt.getX();
            this.prevMouseY = mevt.getY();
            return true;
        }
        if (evt.getEventID().equalsIgnoreCase("mouseReleased")) {
            if (this.state == 8 && this.graphicScene.getGraphicComponent(this.id) instanceof Label) {
                if (((Label)this.graphicScene.getGraphicComponent(this.id)).getComponent() instanceof Monitor) {
                    this.graphicScene.getGraphicComponent(this.id).unSelect();
                }
                this.id = null;
                this.state = 1;
            }
            this.graphicScene.setMotionMode(1);
            if (this.weakeningRotation && this.rotated) {
                this.graphicScene.rotateWeakening();
                this.rotated = false;
            }
            this.possiblePressInInactive = false;
            return true;
        }
        if (evt.getEventID().equalsIgnoreCase("mouseClicked")) {
            MouseEvent mevt = (MouseEvent)evt.getEvent();
            if (this.isPopupTrigger(mevt)) {
                this.showPopup(evt);
                return false;
            }
            this.setPreConditions(mevt);
            if ((mevt.getModifiers() & 0x10) != 0) {
                this.processLeftClick(mevt);
            } else if ((mevt.getModifiers() & 8) != 0) {
                this.processMiddleClick(mevt);
            }
            if (this.selectionBar != null) {
                this.selectionBar.refreshTree();
            }
            return true;
        }
        if (evt.getEventID().equalsIgnoreCase("mouseWheelMoved")) {
            MouseWheelEvent mevt = (MouseWheelEvent)evt.getEvent();
            int notches = -mevt.getWheelRotation();
            if ((mevt.getModifiersEx() & 0x80) == 0) {
                notches *= 5;
            }
            if (this.toolbar != null) {
                this.toolbar.setNearClipValue(notches);
            } else {
                this.clipValue += notches;
                this.graphicScene.processEvent("Clipping.Near", "" + this.clipValue);
                this.refresh();
            }
            return true;
        }
        if (this.graphicScene.isVerbose()) {
            System.out.println("Unknown mouse event: " + evt.getEventID() + ", " + evt.getEventValue());
        }
        return false;
    }

    public void measure(String type, boolean flag) {
        if (type.equalsIgnoreCase("Off")) {
            this.state = 1;
        } else if (type.equalsIgnoreCase("Distance")) {
            if (!flag) {
                this.state = 1;
            } else {
                this.state = 2;
                if (this.toolbar != null) {
                    this.toolbar.controlOff();
                }
                this.graphicScene.clearSelection(this.cellIdx);
                this.activeElementIndicator = false;
            }
        } else if (type.equalsIgnoreCase("Angle")) {
            if (!flag) {
                this.state = 1;
            } else {
                this.state = 3;
                if (this.toolbar != null) {
                    this.toolbar.controlOff();
                }
                this.graphicScene.clearSelection(this.cellIdx);
                this.activeElementIndicator = false;
            }
        } else if (type.equalsIgnoreCase("Dihedral")) {
            if (!flag) {
                this.state = 1;
            } else {
                this.state = 4;
                if (this.toolbar != null) {
                    this.toolbar.controlOff();
                }
                this.graphicScene.clearSelection(this.cellIdx);
                this.activeElementIndicator = false;
            }
        }
    }

    public void placePharmacophorePoint(boolean flag) {
        if (!flag) {
            this.state = 1;
            return;
        }
        this.state = 5;
        if (this.toolbar != null) {
            this.toolbar.controlOff();
        }
        this.graphicScene.clearSelection(this.cellIdx);
        this.activeElementIndicator = false;
    }

    public void placePharmacophoreArrow(boolean flag) {
        if (!flag) {
            this.state = 1;
            return;
        }
        this.state = 6;
        if (this.toolbar != null) {
            this.toolbar.controlOff();
        }
        this.graphicScene.clearSelection(this.cellIdx);
        this.activeElementIndicator = false;
    }

    public void control(String type, boolean flag) {
        if (this.monitor != null && this.monitor instanceof PositionMonitor) {
            this.inactivateMonitor();
        }
        if (!flag) {
            return;
        }
        GraphicComponent gc = this.graphicScene.getControllableObject(type);
        if (gc == null) {
            return;
        }
        if (type.equalsIgnoreCase("Shift")) {
            this.monitor = new PositionMonitor();
            ((PositionMonitor)this.monitor).selectItem(gc);
            ((PositionMonitor)this.monitor).setControl(new GlobalLocationControl(this.monitor));
            gc.associate(this.monitor);
        } else if (type.equalsIgnoreCase("Rotate")) {
            this.monitor = new PositionMonitor();
            ((PositionMonitor)this.monitor).selectItem(gc);
            ((PositionMonitor)this.monitor).setControl(new GlobalOrientationControl(this.monitor));
            gc.associate(this.monitor);
        } else if (type.equalsIgnoreCase("Resize")) {
            this.monitor = new PositionMonitor();
            ((PositionMonitor)this.monitor).selectItem(gc);
            ((PositionMonitor)this.monitor).setControl(new ResizeControl(this.monitor));
            gc.associate(this.monitor);
        }
        try {
            this.graphicScene.addComponent(this.monitor);
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error creating control object");
        }
    }

    public void setShowLabelsOnSelection(boolean b) {
        this.labelsOnSelection = b;
    }

    private void showPopup(Event e) {
        if (this.popup == null) {
            return;
        }
        MouseEvent mevt = (MouseEvent)e.getEvent();
        this.cellIdx = this.graphicScene.locateCell(mevt.getX(), mevt.getY());
        if (!this.graphicScene.isActiveCell(this.cellIdx)) {
            this.activeCellIndicator = true;
            this.graphicScene.setActiveCell(this.cellIdx);
        }
        this.popup.show(mevt.getComponent(), mevt.getX(), mevt.getY());
    }

    public void putEventToQueue(Event e) {
        this.eventQueue.add(e);
    }

    private Event getEventFromQueue() {
        return (Event)this.eventQueue.getFirst();
    }

    public int getEventCount() {
        return this.eventQueue.size();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Event msevt = new Event(e, "mouseClicked", "");
        this.eventQueue.add(msevt);
        this.graphicScene.refresh();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Event msevt = new Event(e, "mousePressed", "");
        this.eventQueue.add(msevt);
        this.graphicScene.refresh();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Event msevt = new Event(e, "mouseReleased", "");
        this.eventQueue.add(msevt);
        this.graphicScene.refresh();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Event msevt = new Event(e, "mouseDragged", "");
        this.eventQueue.add(msevt);
        this.graphicScene.refresh();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Event msevt = new Event(e, "mouseWheelMoved", "");
        this.eventQueue.add(msevt);
        this.graphicScene.refresh();
    }

    private void setPreConditions(MouseEvent mevt) {
        boolean flag = false;
        if (this.state == 1 && this.monitor != null && this.monitor instanceof PositionMonitor) {
            boolean bl = flag = ((PositionMonitor)this.monitor).locateObject(mevt.getX(), this.graphicScene.getHeight() - mevt.getY()) == ((PositionMonitor)this.monitor).pickedIndicator();
        }
        if (flag && (mevt.getModifiers() & 0x10) != 0) {
            PositionMonitor pmonitor = (PositionMonitor)this.monitor;
            Control control = pmonitor.getControl();
            if (control instanceof GlobalLocationControl) {
                pmonitor.setControl(new LocalLocationControl(this.monitor));
            } else if (control instanceof LocalLocationControl) {
                pmonitor.setControl(new GlobalLocationControl(this.monitor));
            } else if (control instanceof GlobalOrientationControl) {
                pmonitor.setControl(new LocalOrientationControl(this.monitor));
            } else if (control instanceof LocalOrientationControl) {
                pmonitor.setControl(new GlobalOrientationControl(this.monitor));
            }
            this.pickCell = false;
            this.pickPositionMonitor = true;
            return;
        }
        this.id = this.graphicScene.locateObject(mevt.getX(), mevt.getY());
        this.cellIdx = this.id.getCellIndex();
        if (this.id.getComponentIndex() == -1) {
            if (!this.activeElementIndicator) {
                this.activeElementIndicator = this.graphicScene.hasSelectedComponentElement();
            }
            this.pickCell = true;
            this.pickActive = this.graphicScene.isActiveCell(this.cellIdx);
        } else {
            this.pickCell = false;
            this.activeElementIndicator = true;
        }
    }

    private void processLeftClick(MouseEvent mevt) {
        if (this.state == 1 && this.pickCell && !this.pickActive) {
            this.activeCellIndicator = true;
            this.graphicScene.setActiveCell(this.cellIdx);
        } else if (this.state == 1 && this.pickCell && this.pickActive && !this.activeElementIndicator) {
            if (this.graphicScene.getCellCount() > 1) {
                this.activeCellIndicator = false;
                this.graphicScene.deactivateActiveCell();
            }
        } else if (this.state == 1 && this.pickCell && this.pickActive && this.activeElementIndicator) {
            if ((mevt.getModifiers() & 1) == 0 && (mevt.getModifiers() & 2) == 0) {
                this.graphicScene.clearSelection(this.cellIdx);
                this.activeElementIndicator = false;
            }
            this.inactivateMonitor();
        } else if (this.state == 1 && !this.pickCell) {
            if (this.pickPositionMonitor) {
                this.pickPositionMonitor = false;
                return;
            }
            this.inactivateMonitor();
            if (mevt.getClickCount() == 2) {
                if (this.graphicScene.getGraphicComponent(this.id) instanceof Label) {
                    this.state = 9;
                    this.labelText = null;
                    this.monitor = (Label)this.graphicScene.getGraphicComponent(this.id);
                }
                return;
            }
            if (this.labelsOnSelection && !(this.monitor instanceof PositionMonitor) && !(this.graphicScene.getGraphicComponent(this.id) instanceof Label)) {
                Label label = new Label();
                label.selectItem(this.graphicScene.getGraphicComponent(this.id).getComponentElement());
                label.setRelativeXCoordinate(this.graphicScene.getCellLeft());
                label.setRelativeYCoordinate(this.graphicScene.getCellButtom());
                try {
                    this.graphicScene.addComponent(label);
                }
                catch (Exception e) {
                    this.handleMyErrors(e, LABEL_ERROR);
                }
                this.graphicScene.getGraphicComponent(this.id).associate(label);
            }
            if ((mevt.getModifiers() & 1) != 0) {
                this.graphicScene.extendSelection(this.id);
            } else if ((mevt.getModifiers() & 2) != 0) {
                this.graphicScene.invertSelection(this.id);
            } else {
                this.graphicScene.exclusiveSelection(this.id);
            }
            if (this.graphicScene.componentBecameSelected(this.id.getCellIndex()) && this.graphicScene.getGraphicComponent(this.id) instanceof DihedralMonitor) {
                this.monitor = (DihedralMonitor)this.graphicScene.getGraphicComponent(this.id);
            }
        } else if (this.state != 1 && this.pickCell && !this.pickActive) {
            this.graphicScene.clearSelection(this.cellIdx);
            this.activeCellIndicator = true;
            this.graphicScene.setActiveCell(this.cellIdx);
        } else if (this.state == 2 && !this.pickCell) {
            if (this.activeCellIndicator) {
                if (this.monitor == null || this.monitor.isFull()) {
                    this.monitor = new DistanceMonitor();
                }
                this.monitor.selectItem(this.graphicScene.getGraphicComponent(this.id).getComponentElement());
                this.graphicScene.getGraphicComponent(this.id).associate(this.monitor);
                this.graphicScene.extendSelection(this.id);
                if (this.monitor.isFull()) {
                    try {
                        this.graphicScene.addComponent(this.monitor);
                        this.attachLabel();
                        this.logMonitor("DistanceMonitor", this.monitor);
                    }
                    catch (Exception e) {
                        this.handleMyErrors(e, "Error creating monitor object");
                    }
                    this.graphicScene.clearSelection(this.cellIdx);
                    ((DistanceMonitor)this.monitor).measurement();
                    this.state = 1;
                    if (this.toolbar != null) {
                        this.toolbar.measureOff();
                    }
                }
            }
        } else if (this.state == 3 && !this.pickCell) {
            if (this.activeCellIndicator) {
                if (this.monitor == null || this.monitor.isFull()) {
                    this.monitor = new AngleMonitor();
                }
                this.monitor.selectItem(this.graphicScene.getGraphicComponent(this.id).getComponentElement());
                this.graphicScene.getGraphicComponent(this.id).associate(this.monitor);
                this.graphicScene.extendSelection(this.id);
                if (this.monitor.isFull()) {
                    try {
                        this.graphicScene.addComponent(this.monitor);
                        this.attachLabel();
                        this.logMonitor("AngleMonitor", this.monitor);
                    }
                    catch (Exception e) {
                        this.handleMyErrors(e, "Error creating monitor object");
                    }
                    this.graphicScene.clearSelection(this.cellIdx);
                    ((AngleMonitor)this.monitor).measurement();
                    this.state = 1;
                    if (this.toolbar != null) {
                        this.toolbar.measureOff();
                    }
                }
            }
        } else if (this.state == 4 && !this.pickCell) {
            if (this.activeCellIndicator) {
                if (this.monitor == null || this.monitor.isFull()) {
                    this.monitor = new DihedralMonitor();
                }
                this.monitor.selectItem(this.graphicScene.getGraphicComponent(this.id).getComponentElement());
                this.graphicScene.getGraphicComponent(this.id).associate(this.monitor);
                this.graphicScene.extendSelection(this.id);
                if (this.monitor.isFull()) {
                    try {
                        this.graphicScene.addComponent(this.monitor);
                        this.attachLabel();
                        this.logMonitor("DihedralMonitor", this.monitor);
                    }
                    catch (Exception e) {
                        this.handleMyErrors(e, "Error creating monitor object");
                    }
                    this.graphicScene.clearSelection(this.cellIdx);
                    ((DihedralMonitor)this.monitor).measurement();
                    this.state = 1;
                    if (this.toolbar != null) {
                        this.toolbar.measureOff();
                    }
                }
            }
        } else if (this.state == 5 && !this.pickCell) {
            if (this.activeCellIndicator) {
                ComponentElement ce = this.graphicScene.getGraphicComponent(this.id).getComponentElement();
                PharmacophorePoint ph = new PharmacophorePoint(ce);
                MoleculeIterators.AtomPropertyInterface prop = null;
                boolean ligand = true;
                if (ce.getComponent() instanceof MoleculeComponent) {
                    prop = ((MoleculeComponent)ce.getComponent()).getAtomProperty();
                } else if (ce.getComponent() instanceof MacroMoleculeComponent) {
                    MacroMoleculeComponent.MoleculeVisualizer mmv = ((MacroMoleculeComponent)ce.getComponent()).getComponent(ce.getComponentPartId());
                    if (mmv instanceof MoleculeComponent && ce.getElementType() == 2) {
                        prop = ((MoleculeComponent)mmv).getAtomProperty();
                    } else if (mmv instanceof PolymerVisualizer && ce.getElementType() == 2) {
                        prop = ((PolymerVisualizer)mmv).getAtomProperty();
                        ligand = false;
                    }
                }
                int atno = 0;
                if (prop != null) {
                    atno = prop.getType(ce.getElementIndex());
                }
                if (!ligand) {
                    ph.setExcluded(true);
                } else if (atno == 6) {
                    ph.setHydrophobic(true);
                } else if (atno == 7) {
                    ph.setDonor(true);
                } else if (atno == 8) {
                    ph.setAcceptor(true);
                }
                try {
                    this.logPharmacophorePoint(ph);
                    this.graphicScene.addComponent(ph);
                }
                catch (Exception e) {
                    this.handleMyErrors(e, "Error creating pharmacophore point");
                }
                if (this.selectionBar != null) {
                    this.selectionBar.addObject(this.selectionBar.getRootNode(), ph, true);
                }
                this.state = 1;
                if (this.toolbar != null) {
                    this.toolbar.measureOff();
                }
            }
        } else if (this.state == 6 && !this.pickCell) {
            if (this.activeCellIndicator) {
                ComponentElement ce = this.graphicScene.getGraphicComponent(this.id).getComponentElement();
                PharmacophoreArrow ph = new PharmacophoreArrow(ce);
                try {
                    this.graphicScene.addComponent(ph);
                }
                catch (Exception e) {
                    this.handleMyErrors(e, "Error creating pharmacophore arrow");
                }
                if (this.selectionBar != null) {
                    this.selectionBar.addObject(this.selectionBar.getRootNode(), ph, true);
                }
                this.state = 1;
                if (this.toolbar != null) {
                    this.toolbar.measureOff();
                }
            }
        } else if (this.state == 8) {
            this.graphicScene.getGraphicComponent(this.id).select();
        }
    }

    private void attachLabel() throws Exception {
        Label label = new Label();
        this.monitor.select();
        label.selectItem(this.monitor);
        label.setRelativeXCoordinate(this.graphicScene.getCellLeft());
        label.setRelativeYCoordinate(this.graphicScene.getCellButtom());
        this.monitor.unSelect();
        this.graphicScene.addComponent(label);
        this.monitor.associate(label);
        if (this.monitor instanceof MeasurementMonitor) {
            ((MeasurementMonitor)this.monitor).setLabel(label);
        }
    }

    void inactivateMonitor() {
        if (this.monitor == null) {
            return;
        }
        if (this.monitor instanceof PositionMonitor) {
            this.graphicScene.removeComponent(this.monitor);
            if (this.toolbar != null) {
                this.toolbar.controlOff();
            }
            this.monitor = null;
        }
    }

    private void processMiddleClick(MouseEvent mevt) {
        if (!this.pickCell) {
            this.graphicScene.setTransformationCenter(this.id);
            if (this.monitor != null && this.monitor instanceof PositionMonitor) {
                Control c = ((PositionMonitor)this.monitor).getControl();
                if (c instanceof LocalOrientationControl) {
                    ((PositionMonitor)this.monitor).setPosition(this.graphicScene.getTransformationCenter());
                } else if (c instanceof GlobalOrientationControl) {
                    ((PositionMonitor)this.monitor).setPosition(this.graphicScene.getTransformationCenter());
                }
            }
        }
    }

    private void processDrag(MouseEvent mevt) {
        int x = mevt.getX();
        int y = mevt.getY();
        this.graphicScene.setMotionMode(2);
        if (this.possiblePressInInactive) {
            this.cellIdx = this.graphicScene.locateCell(mevt.getX(), mevt.getY());
            if (!this.graphicScene.isActiveCell(this.cellIdx)) {
                this.activeCellIndicator = true;
                this.graphicScene.setActiveCell(this.cellIdx);
                this.rotationModel.setSceneSize(this.graphicScene.getCellLeft(), this.graphicScene.getViewportHeight() - this.graphicScene.getCellTop(), this.graphicScene.getCellWidth(), this.graphicScene.getCellHeight());
                if (this.selectionBar != null) {
                    this.selectionBar.refreshTree();
                }
            }
            this.possiblePressInInactive = false;
        }
        int xChanged = x - this.prevMouseX;
        int yChanged = y - this.prevMouseY;
        int yInvertChanged = this.prevMouseY - y;
        if (this.state == 8) {
            ((Label)this.graphicScene.getGraphicComponent(this.id)).shift(xChanged, yInvertChanged);
            this.prevMouseX = x;
            this.prevMouseY = y;
            return;
        }
        if (this.monitor != null) {
            if (this.monitor instanceof PositionMonitor) {
                if ((mevt.getModifiersEx() & 0x80) != 0 && (mevt.getModifiersEx() & 0x40) != 0) {
                    ((PositionMonitor)this.monitor).control(yChanged);
                    this.prevMouseX = x;
                    this.prevMouseY = y;
                    return;
                }
                if ((mevt.getModifiersEx() & 0x80) != 0) {
                    ((PositionMonitor)this.monitor).control(xChanged, yInvertChanged);
                    this.prevMouseX = x;
                    this.prevMouseY = y;
                    return;
                }
            } else if (this.monitor instanceof DihedralMonitor && (mevt.getModifiersEx() & 0x80) != 0) {
                ((DihedralMonitor)this.monitor).control(yChanged);
                this.prevMouseX = x;
                this.prevMouseY = y;
                return;
            }
        }
        if (this.translationModel.isTranslationEvent(mevt)) {
            double[] s = this.translationModel.translate(mevt);
            this.graphicScene.shift(s[0], s[1]);
        } else if (this.zoomModel.isZoomEvent(mevt)) {
            this.graphicScene.zoom(this.zoomModel.zoom(mevt));
        } else if (this.rotationModel.isRotationDragEvent(mevt)) {
            double[] r = this.rotationModel.rotate(mevt);
            this.graphicScene.rotate(r[0], r[1], r[2]);
            this.rotated = true;
        }
        this.prevMouseX = x;
        this.prevMouseY = y;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.logHandler != null && this.logHandler.logProcessorThread != null && e.getKeyCode() == 27) {
            this.stopAnimation();
        }
        if (this.state != 9) {
            return;
        }
        Label label = (Label)this.monitor;
        String text = label.getText();
        if (text == null) {
            label.setText(label.getSelectedItem().getDescription());
            text = label.getText();
        }
        if (this.labelText == null) {
            this.labelText = "" + text;
        }
        if (e.getKeyCode() == 27) {
            if (this.labelText != null) {
                label.setText(this.labelText);
            }
            this.monitor = null;
            this.state = 1;
            this.refresh();
            return;
        }
        if (e.getKeyCode() == 10) {
            this.monitor = null;
            this.state = 1;
            return;
        }
        if (e.getKeyCode() == 8 && text.length() > 0) {
            label.setText(text.substring(0, text.length() - 1));
        } else if (e.getKeyCode() == 40) {
            label.setText(text + "\n");
        } else {
            label.setText(text + e.getKeyChar());
        }
        this.refresh();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean isPopupTrigger(MouseEvent mevt) {
        if (this.popupTrigger == 2) {
            return (mevt.getModifiers() & 4) != 0;
        }
        return (mevt.getModifiers() & 0x10) != 0 && mevt.getClickCount() == 2;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent ev) {
        ev.acceptDrop(ev.getSourceActions());
        Transferable t = ev.getTransferable();
        Object dropMol = ClipboardHandler.getObjectFromTransferable(t);
        if (dropMol != null) {
            this.paste(dropMol);
        } else {
            this.handleMyErrors("Cannot import molecule from this object.", "Drop error", 0);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (this.selectionBar != null) {
            this.selectionBar.drag(this.dragSource, dge, this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    public void startAnimation() {
        try {
            this.logHandler.processTerminateRequired = false;
            this.graphicScene.removeAllComponents();
            this.graphicScene.resetSettings();
            this.graphicScene.resetView();
            this.processLog(new AnimationDemo().getInputStream(), true);
        }
        catch (Exception e) {
            this.handleMyErrors(e, LOG_ERROR);
        }
    }

    public void stopAnimation() {
        System.out.println("TERMINATE LOG PROCESSING");
        System.out.println("Terminate at " + Calendar.getInstance().getTime());
        this.logHandler.processTerminateRequired = true;
    }

    private void deleteAllButMolecules() {
        try {
            this.graphicScene.getActiveCell().removeComponent(SecondaryStructureComponent.class);
            this.graphicScene.getActiveCell().removeComponent(MolecularSurfaceComponent.class);
            this.updateSelectionBar();
        }
        catch (NullPointerException ex) {
            System.out.println("The given cell cannot be accessed (" + ex.getMessage() + ")");
        }
    }

    public void idleRotation(boolean b) {
        if (b) {
            ((RotationModel)this.rotationModel).start();
            ((RotationModel)this.rotationModel).run();
            ((RotationModel)this.rotationModel).setAnimationHandler(this);
        } else {
            ((RotationModel)this.rotationModel).stop();
        }
    }

    public void exportImage(String f) {
        this.imageWidth = this.graphicScene.getWidth();
        this.imageHeight = this.graphicScene.getHeight();
        this.imageFormat = "png";
        this.screenShot = true;
        this.putEventToQueue(new Event("ExportImage", f));
        this.refresh();
    }

    public void exportImage(String f, String format2) {
        this.imageWidth = this.graphicScene.getWidth();
        this.imageHeight = this.graphicScene.getHeight();
        this.imageFormat = format2;
        this.screenShot = true;
        this.putEventToQueue(new Event("ExportImage", f));
        this.refresh();
    }

    public void exportImage(String f, int width, int height, String format2) {
        this.imageWidth = width;
        this.imageHeight = height;
        this.imageFormat = format2.toLowerCase();
        this.screenShot = false;
        this.putEventToQueue(new Event("ExportImage", f));
        this.refresh();
    }

    private boolean saveImage(String fileName) {
        this.startOperation("Exporting image...");
        if (!fileName.endsWith("." + this.imageFormat) && !fileName.endsWith("." + this.imageFormat.toUpperCase())) {
            fileName = fileName + "." + this.imageFormat;
        }
        try {
            if (this.graphicScene.isVerbose()) {
                System.out.println("Image size: " + this.imageWidth + " x " + this.imageHeight);
                System.out.println("Writing image " + fileName);
            }
            File imageFile = new File(fileName);
            File imagedir = new File(fileName.substring(0, fileName.lastIndexOf(File.separatorChar)));
            imagedir.mkdirs();
            if (this.screenShot) {
                File file = this.imageFormat.equals("png") ? imageFile : new File(fileName + ".png");
                BufferedImage screenshot = this.graphicScene.getBufferedImage();
                ImageIO.write((RenderedImage)screenshot, "png", imageFile);
                if (!this.imageFormat.equals("png")) {
                    this.convert(screenshot, this.imageFormat, imageFile);
                    file.delete();
                }
            } else {
                File file;
                if (this.imageFormat.equals("tga")) {
                    file = imageFile;
                } else {
                    String tmpName = fileName.substring(fileName.lastIndexOf(File.separator));
                    file = File.createTempFile(tmpName, ".tga");
                    file.deleteOnExit();
                }
                ByteBuffer buf = null;
                TGAWriter tga = new TGAWriter();
                tga.open(file, this.imageWidth, this.imageHeight, false);
                buf = tga.getImageData();
                int res = this.graphicScene.createImage(buf, this.imageWidth, this.imageHeight);
                switch (res) {
                    case 0: {
                        if (tga != null) {
                            tga.close();
                        }
                        if (this.imageFormat.equals("tga")) break;
                        this.convert(this.getBufferedImage(buf, this.imageWidth, this.imageHeight), this.imageFormat, imageFile);
                        break;
                    }
                    case -1: {
                        JOptionPane.showMessageDialog(null, "Please select a cell to export an image from.");
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(null, "An error occured during export.");
                    }
                }
            }
            this.finishOperation();
            return true;
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error during image export");
            return false;
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
            return false;
        }
    }

    private BufferedImage getBufferedImage(ByteBuffer buf, int w, int h) {
        BufferedImage bufferedImage = new BufferedImage(w, h, 2);
        int[] pixelInts = new int[w * h];
        int p = w * h * 3;
        int i = 0;
        int w3 = w * 3;
        for (int row = 0; row < h; ++row) {
            int q = p -= w3;
            for (int col = 0; col < w; ++col) {
                byte iB = buf.get(q++);
                byte iG = buf.get(q++);
                byte iR = buf.get(q++);
                pixelInts[i++] = 0xFF000000 | (iR & 0xFF) << 16 | (iG & 0xFF) << 8 | iB & 0xFF;
            }
        }
        bufferedImage.setRGB(0, 0, w, h, pixelInts, 0, w);
        return bufferedImage;
    }

    public void convert(BufferedImage bufferedImage, String format2, File outputFile) {
        try {
            if (this.imageFormat.equals("png")) {
                ImageIO.write((RenderedImage)bufferedImage, format2, outputFile);
                return;
            }
            byte[] bytes = null;
            if (this.imageFormat.equals("bmp")) {
                MsbmpExport bmpe = new MsbmpExport();
                bytes = bmpe.doExportImage(bufferedImage, null);
            } else if (this.imageFormat.equals("jpeg") || this.imageFormat.equals("jpg")) {
                JpegExport jpge = new JpegExport();
                jpge.qualityValue = 100;
                bytes = jpge.doExportImage(bufferedImage, null);
            }
            if (bytes == null) {
                return;
            }
            FileOutputStream fout = new FileOutputStream(outputFile);
            fout.write(bytes);
            fout.close();
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error during image conversion");
        }
        catch (OutOfMemoryError ome) {
            this.handleMyErrors(ome, MEMORY_ERROR);
        }
    }

    public void initOptions(JMSpaceOptionsDialog.MSpaceOptions options) {
        options.ligandOptions.init(0.4, 0.1, 0.3, 2.0, 100, 50, true, false, false, false);
        options.proteinOptions.init(0.4, 0.1, 0.15, 2.0, 100, 50, true, false, false, false);
        options.waterOptions.init(0.4f, 0.1, 0.15, 0.5, 100, 50, true, false, false, false);
        options.ionOptions.init(0.4, 0.0, 0.0, 2.0, 0, 0, false, false, false, false);
        options.colorOptions.init(this.graphicScene.getBackgroundColor(), this.graphicScene.isTransparentBackgroundEnabled(), this.graphicScene.isSmoothBackgroundEnabled(), MoleculeComponent.DEFAULT_COLOR, PolymerVisualizer.DEFAULT_COLOR, WaterVisualizer.DEFAULT_COLOR, IonVisualizer.DEFAULT_COLOR, SurfaceComponent.DEFAULT_COLOR, Colors.helixColor, Colors.sheetColor, Colors.turnColor, Colors.coilColor, true);
        options.controlOptions.init(1, this.zoomModel.invertZoom, false, this.weakeningRotation, this.antialiasDisable, this.rotationAngle);
        options.surfaceOptions.init(true, false, 1.4f, 0.55f);
        options.secondaryOptions.init(1.2f, 0.3f, 2.5f, 3.8f, true, 1.2f, 0.4f, 3.8f, true, 0.3f, 0.3f, true, 6);
    }

    public void setOptions() {
        this.setOptions(this.options.ligandOptions, "Ligand");
        this.setOptions(this.options.proteinOptions, "MacroMolecule");
        this.setOptions(this.options.waterOptions, "Water");
        this.setOptions(this.options.ionOptions, "Ion");
        this.setOptions(this.options.colorOptions);
        this.setOptions(this.options.controlOptions);
        this.setOptions(this.options.surfaceOptions);
        this.setOptions(this.options.secondaryOptions);
        this.refresh();
    }

    private void setOptions(JMSpaceOptionsDialog.SurfaceOptions options) {
        if (options.probeRadiusChanged()) {
            this.graphicScene.processEvent("Surface.ProbeRadius", "" + options.getProbeRadius());
        }
        if (options.simplificationChanged()) {
            this.graphicScene.processEvent("Surface.Simplification", "" + options.getSimplificationEnabled());
        }
        if (options.autoResolutionChanged()) {
            this.graphicScene.processEvent("Surface.AutoResolution", "" + options.getAutoResolutionEnabled());
        }
        if (options.gridSizeChanged()) {
            this.graphicScene.processEvent("Surface.Resolution", "" + options.getGridSize());
        }
    }

    private void setOptions(JMSpaceOptionsDialog.ControlOptions options) {
        if (options.rotationControlChanged()) {
            this.rotationModel.setRotationEvent(options.getRotationControl());
        }
        if (options.zoomControlChanged()) {
            this.zoomModel.setZoomEvent(options.getZoomControl());
        }
        if (options.popupControlChanged()) {
            this.popupTrigger = options.getPopupControl();
        }
        if (options.translationControlChanged()) {
            this.translationModel.setTranslationEvent(options.getTranslationControl());
        }
        if (options.invertZoomChanged()) {
            this.zoomModel.setInvertZoom(options.getInvertZoom());
        }
        if (options.drawSphereChanged()) {
            this.graphicScene.processEvent("DrawSphere", "" + options.getDrawSphere());
        }
        if (options.weakeningRotationChanged()) {
            this.setWeakeningRotation(options.getWeakeningRotation());
        }
        if (options.antialiasDisableChanged()) {
            this.setAntialiasDisable(options.getAntialiasDisable());
        }
        if (options.rotationAngleChanged()) {
            this.rotationAngle = options.getRotationAngle();
        }
    }

    private void setColors(String eventID, String eventValue) {
        if (!eventID.startsWith("Colors.")) {
            return;
        }
        if ((eventID = eventID.substring(7)).startsWith("CPK.")) {
            if ((eventID = eventID.substring(4)).equals("H")) {
                this.setColor(Colors.hColor, Color.decode(eventValue));
            }
            if (eventID.equals("C")) {
                this.setColor(Colors.cColor, Color.decode(eventValue));
            }
            if (eventID.equals("N")) {
                this.setColor(Colors.nColor, Color.decode(eventValue));
            }
            if (eventID.equals("O")) {
                this.setColor(Colors.oColor, Color.decode(eventValue));
            }
            if (eventID.equals("S")) {
                this.setColor(Colors.sColor, Color.decode(eventValue));
            }
            if (eventID.equals("P")) {
                this.setColor(Colors.pColor, Color.decode(eventValue));
            }
            if (eventID.equals("Unk")) {
                this.setColor(Colors.unknownAtom, Color.decode(eventValue));
            }
            if (eventID.equals("Sel")) {
                this.setColor(Colors.selected, Color.decode(eventValue));
            }
        } else if (eventID.startsWith("Residue")) {
            if (eventValue.equals("Setor")) {
                Colors.setorColors = true;
            } else if (eventValue.equals("Default")) {
                Colors.setorColors = false;
            }
        } else if (eventID.equals("HelixColor")) {
            this.setColor(Colors.helixColor, Color.decode(eventValue));
        } else if (eventID.equals("SheetColor")) {
            this.setColor(Colors.sheetColor, Color.decode(eventValue));
        } else if (eventID.equals("TurnColor")) {
            this.setColor(Colors.turnColor, Color.decode(eventValue));
        } else if (eventID.equals("CoilColor")) {
            this.setColor(Colors.coilColor, Color.decode(eventValue));
        } else {
            System.out.println("Unknown Color setting: " + eventID + ", " + eventValue);
        }
    }

    private void setOptions(JMSpaceOptionsDialog.ColorOptions options) {
        if (options.backgroundColorChanged()) {
            this.graphicScene.processEvent("Background.Color", Colors.toHexString(options.getBackgroudColor()));
        }
        if (options.backgroundTransparencyChanged()) {
            this.graphicScene.processEvent("Background.Transparent", "" + options.getBackgroudTransparency());
        }
        if (options.smoothBackgroundChanged()) {
            this.graphicScene.processEvent("Background.Smooth", "" + options.getSmoothBackgroud());
        }
        if (options.ligandColorChanged()) {
            this.graphicScene.processEvent("Ligand.Color", Colors.toHexString(options.getLigandColor()));
        }
        if (options.proteinColorChanged()) {
            this.graphicScene.processEvent("MacroMolecule.Color", Colors.toHexString(options.getProteinColor()));
        }
        if (options.waterColorChanged()) {
            this.graphicScene.processEvent("Water.Color", Colors.toHexString(options.getWaterColor()));
        }
        if (options.ionColorChanged()) {
            this.graphicScene.processEvent("Ion.Color", Colors.toHexString(options.getIonColor()));
        }
        if (options.surfaceColorChanged()) {
            this.graphicScene.processEvent("Surface.Color", Colors.toHexString(options.getSurfaceColor()));
        }
        if (options.cpkChanged()) {
            this.graphicScene.processEvent("Colors.CPK.H", Colors.toHexString(options.getHColor()));
            this.graphicScene.processEvent("Colors.CPK.C", Colors.toHexString(options.getCColor()));
            this.graphicScene.processEvent("Colors.CPK.N", Colors.toHexString(options.getNColor()));
            this.graphicScene.processEvent("Colors.CPK.O", Colors.toHexString(options.getOColor()));
            this.graphicScene.processEvent("Colors.CPK.S", Colors.toHexString(options.getSColor()));
            this.graphicScene.processEvent("Colors.CPK.P", Colors.toHexString(options.getPColor()));
        }
        if (options.unknownColorChanged()) {
            this.graphicScene.processEvent("Colors.CPK.Unk", Colors.toHexString(options.getUnknownColor()));
        }
        if (options.selectedColorChanged()) {
            this.graphicScene.processEvent("Colors.CPK.Sel", Colors.toHexString(options.getSelectedColor()));
        }
        if (options.residueColorsChanged()) {
            if (!options.isDefaultResidueColors()) {
                this.graphicScene.processEvent("Colors.ResidueColor", "Setor");
            } else {
                this.graphicScene.processEvent("Colors.ResidueColor", "Default");
            }
        }
        if (options.helixColorChanged()) {
            this.graphicScene.processEvent("Colors.HelixColor", Colors.toHexString(options.getHelixColor()));
        }
        if (options.sheetColorChanged()) {
            this.graphicScene.processEvent("Colors.SheetColor", Colors.toHexString(options.getSheetColor()));
        }
        if (options.turnColorChanged()) {
            this.graphicScene.processEvent("Colors.TurnColor", Colors.toHexString(options.getTurnColor()));
        }
        if (options.coilColorChanged()) {
            this.graphicScene.processEvent("Colors.CoilColor", Colors.toHexString(options.getCoilColor()));
        }
    }

    private void setColor(byte[] oldColor, Color newColor) {
        oldColor[0] = (byte)(newColor.getRed() / 2);
        oldColor[1] = (byte)(newColor.getGreen() / 2);
        oldColor[2] = (byte)(newColor.getBlue() / 2);
    }

    private void setOptions(JMSpaceOptionsDialog.MoleculeOptions options, String mv) {
        if (options.ballRadiusChanged()) {
            this.graphicScene.processEvent(mv + ".BallRadius", "" + options.getBallRadius());
        }
        if (options.bondRadiusChanged()) {
            this.graphicScene.processEvent(mv + ".BondRadius", "" + options.getBondRadius());
        }
        if (options.stickRadiusChanged()) {
            this.graphicScene.processEvent(mv + ".StickRadius", "" + options.getStickRadius());
        }
        if (options.lineWidthChanged()) {
            this.graphicScene.processEvent(mv + ".LineWidth", "" + options.getLineWidth());
        }
        if (options.bondDistanceChanged()) {
            this.graphicScene.processEvent(mv + ".BondDistance", "" + options.getBondDistance());
        }
        if (options.bondWidthChanged()) {
            this.graphicScene.processEvent(mv + ".BondWidth", "" + options.getBondWidth());
        }
        if (options.smoothSticksChanged()) {
            this.graphicScene.processEvent(mv + ".SmoothStickStyle", "" + options.getSmoothSticks());
        }
        if (options.scaledBallsChanged()) {
            this.graphicScene.processEvent(mv + ".ScaledBalls", "" + options.getScaledBalls());
        }
        if (options.displayBondOrderChanged()) {
            this.graphicScene.processEvent(mv + ".DisplayBondOrder", "" + options.getDisplayBondOrder());
        }
        if (options.bondFacingChanged()) {
            this.graphicScene.processEvent(mv + ".BondFacing", "" + options.getBondFacing());
        }
    }

    private void setOptions(JMSpaceOptionsDialog.SecondaryStructureOptions options) {
        if (options.helixWidthChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.HelixWidth", "" + options.getHelixWidth());
        }
        if (options.helixDepthChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.HelixDepth", "" + options.getHelixDepth());
        }
        if (options.helixShiftChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.HelixShift", "" + options.getHelixShift());
        }
        if (options.helixArrowWidthChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.HelixArrowWidth", "" + options.getHelixArrowWidth());
        }
        if (options.helixArrowChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.HelixArrow", "" + options.getHelixArrow());
        }
        if (options.sheetWidthChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.SheetWidth", "" + options.getSheetWidth());
        }
        if (options.sheetDepthChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.SheetDepth", "" + options.getSheetDepth());
        }
        if (options.sheetArrowChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.SheetArrow", "" + options.getSheetArrow());
        }
        if (options.sheetArrowWidthChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.SheetArrowWidth", "" + options.getSheetArrowWidth());
        }
        if (options.coilWidthChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.CoilWidth", "" + options.getCoilWidth());
        }
        if (options.coilDepthChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.CoilDepth", "" + options.getCoilDepth());
        }
        if (options.coilUniformChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.CoilUniform", "" + options.getCoilUniform());
        }
        if (options.threadsChanged()) {
            this.graphicScene.processEvent("SecondaryStructure.Threads", "" + options.getThreads());
        }
    }

    public void startLog() {
        try {
            this.log = this.logHandler.startLog();
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error starting to log");
        }
    }

    public void closeLog() {
        try {
            this.logHandler.closeLog();
            this.log = false;
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error closing log file");
        }
    }

    public void processLog() {
        try {
            this.logHandler.processLog();
        }
        catch (Exception e) {
            this.handleMyErrors(e, "Error processing log file");
        }
    }

    public void logCurrentView() {
        if (this.log) {
            try {
                this.logHandler.recordCurrentView();
            }
            catch (Exception e) {
                this.handleMyErrors(e, "Error recording current view");
            }
        }
    }

    public void processLog(File f) throws FileNotFoundException {
        this.processLog(f, false);
    }

    public void processLog(File f, boolean repeat) throws FileNotFoundException {
        this.processLog(new FileInputStream(f), repeat);
    }

    public void processLog(File f, boolean repeat, boolean haltOnError) throws FileNotFoundException {
        this.processLog(new FileInputStream(f), repeat, haltOnError);
    }

    public void processLog(InputStream is, boolean repeat) {
        this.processLog(is, repeat, true);
    }

    public void processLog(InputStream is, boolean repeat, boolean haltOnError) {
        try {
            this.logProcessing = true;
            this.logHandler.setRepeatEnabled(repeat);
            this.logHandler.setHaltOnError(haltOnError);
            this.logHandler.processLog(is);
            this.updateSelectionBar();
        }
        catch (Exception e) {
            this.logProcessing = false;
            this.handleMyErrors(e, "Error processing log file");
        }
    }

    public boolean isLogProcessingFinished() {
        return !this.logProcessing;
    }

    public class MSpaceLogHandler {
        private InputStream logIs = null;
        private JFileChooser logCreator;
        private JFileChooser logChooser = null;
        BufferedWriter out = null;
        BufferedReader in = null;
        int wait = 0;
        private Thread logProcessorThread = null;
        private boolean processTerminateRequired = false;
        private boolean processRepeatedly = false;
        private boolean verbose = false;
        private boolean recordMouseEvents = true;
        private boolean haltOnError = true;

        MSpaceLogHandler() {
        }

        public void setRepeatEnabled(boolean b) {
            this.processRepeatedly = b;
        }

        public void setHaltOnError(boolean b) {
            this.haltOnError = b;
        }

        protected void finalize() throws Throwable {
            if (this.out != null) {
                this.out.close();
            }
        }

        public void setLogInputStream(InputStream is) {
            this.logIs = is;
        }

        public void processLog() throws Exception {
            int returnVal;
            if (this.logChooser == null) {
                this.logChooser = new JFileChooser();
            }
            if ((returnVal = this.logChooser.showOpenDialog(MSpaceEventHandler.this.graphicScene)) == 0 && this.logChooser.getSelectedFile() != null) {
                this.processLog(this.logChooser.getSelectedFile());
            }
        }

        public void processLog(File f) throws Exception {
            System.out.println("processing " + f.getPath());
            this.processLog(new FileInputStream(f));
        }

        public void processLog(InputStream is) throws Exception {
            this.logIs = is;
            this.logProcessorThread = new MyThread(){

                @Override
                public void run() {
                    try {
                        if (MSpaceLogHandler.this.verbose) {
                            System.out.println("Started at " + Calendar.getInstance().getTime());
                        }
                        MSpaceLogHandler.this.in = new BufferedReader(new InputStreamReader(MSpaceLogHandler.this.logIs));
                        int length = 4096;
                        String line = MSpaceLogHandler.this.in.readLine();
                        if (line == null) {
                            return;
                        }
                        if (!line.equals("MarvinSpace Log File")) {
                            System.out.println("Unrecognized log file");
                            return;
                        }
                        MSpaceLogHandler.this.in.readLine();
                        MSpaceLogHandler.this.in.mark(length);
                        line = MSpaceLogHandler.this.in.readLine();
                        if (line.startsWith("load")) {
                            MSpaceLogHandler.this.processLoadEvent(line.substring(5));
                            MSpaceLogHandler.this.in.mark(length);
                        } else {
                            MSpaceLogHandler.this.in.reset();
                        }
                        if (MSpaceLogHandler.this.processRepeatedly) {
                            while (!MSpaceLogHandler.this.processTerminateRequired) {
                                MSpaceLogHandler.this.process(MSpaceLogHandler.this.in);
                                if (MSpaceLogHandler.this.processTerminateRequired) continue;
                                MSpaceLogHandler.this.in.reset();
                                MSpaceEventHandler.this.deleteAllButMolecules();
                                MSpaceEventHandler.this.graphicScene.resetSettings();
                                MSpaceEventHandler.this.graphicScene.resetView();
                                MSpaceEventHandler.this.graphicScene.showAllComponents();
                            }
                        } else {
                            MSpaceLogHandler.this.process(MSpaceLogHandler.this.in);
                            this.refreshLater();
                        }
                        MSpaceEventHandler.this.logProcessing = false;
                        MSpaceLogHandler.this.in.close();
                    }
                    catch (Exception e) {
                        if (!MSpaceLogHandler.this.haltOnError) {
                            e.printStackTrace();
                            return;
                        }
                        MSpaceEventHandler.this.handleMyErrors(e, MSpaceEventHandler.LOG_ERROR);
                    }
                    catch (OutOfMemoryError ome) {
                        if (!MSpaceLogHandler.this.haltOnError) {
                            ome.printStackTrace();
                            return;
                        }
                        MSpaceEventHandler.this.handleMyErrors("Out of memory. Restarting application may be necessary.", "Animation has been finished", 2);
                        System.out.println("Stopped at " + Calendar.getInstance().getTime());
                    }
                }
            };
            this.logProcessorThread.start();
        }

        private void process(BufferedReader in) throws Exception {
            String line;
            while ((line = in.readLine()) != null) {
                if (this.processTerminateRequired) {
                    return;
                }
                if (this.wait >= 0) {
                    MSpaceEventHandler.this.refresh();
                    if (this.wait > 0) {
                        Thread.sleep(this.wait);
                    }
                }
                if (line.startsWith("--")) {
                    this.processOtherEvent(line.substring(2));
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line);
                String eventID = null;
                String eventValue = null;
                if (st.hasMoreTokens() && (eventID = st.nextToken()).startsWith("mouse") && !eventID.equals("mouseWheelMoved")) {
                    this.processMouseEvent(eventID, st);
                    continue;
                }
                if (st.hasMoreTokens()) {
                    eventValue = st.nextToken();
                }
                if (eventID == null || eventValue == null) continue;
                if (!st.hasMoreTokens()) {
                    this.process(eventID, eventValue);
                    continue;
                }
                String range = st.nextToken();
                if (range.equals("Component")) {
                    int cellIndex = Integer.parseInt(st.nextToken());
                    int compIndex = Integer.parseInt(st.nextToken());
                    this.process(eventID, eventValue, cellIndex, compIndex);
                    continue;
                }
                eventValue = eventValue + " " + range;
                while (st.hasMoreTokens()) {
                    eventValue = eventValue + " " + st.nextToken();
                }
                this.process(eventID, eventValue);
            }
        }

        private boolean startLog() throws Exception {
            int returnVal;
            if (this.logCreator == null) {
                this.logCreator = new JFileChooser();
            }
            if ((returnVal = this.logCreator.showSaveDialog(MSpaceEventHandler.this.graphicScene)) == 0 && this.logCreator.getSelectedFile() != null) {
                int mode;
                File logFile = new File(this.logCreator.getSelectedFile().getPath());
                if (logFile.exists() && (mode = JOptionPane.showConfirmDialog(MSpaceEventHandler.this.graphicScene, "File " + logFile.getName() + " exists. Would you like to append to the existing log file?", "File exists", 0, 2)) == 1) {
                    return false;
                }
                mode = JOptionPane.showConfirmDialog(MSpaceEventHandler.this.graphicScene, "Would you like to log mouse events?", "Log setting", 0, 2);
                this.recordMouseEvents = mode == 0;
                System.out.println("creating " + logFile.getPath());
                this.out = new BufferedWriter(new FileWriter(logFile));
                this.out.write("MarvinSpace Log File");
                this.out.newLine();
                this.out.newLine();
                return true;
            }
            return false;
        }

        private void closeLog() throws Exception {
            if (this.out != null) {
                System.out.println("closing log file");
                this.out.close();
                this.out = null;
            }
            this.logIs = null;
        }

        public void record(Event evt) throws Exception {
            if (evt.getEventID().startsWith("mouse")) {
                if (!this.recordMouseEvents) {
                    return;
                }
                if (this.verbose) {
                    System.out.println("record " + evt.getEventID() + ", " + evt.getEventValue());
                }
                this.recordMouseEvent(evt);
            } else if (evt.getEventRange() == 1) {
                this.out.write(evt.getEventID() + " " + evt.getEventValue());
                if (this.verbose) {
                    System.out.println("record " + evt.getEventID() + ", " + evt.getEventValue());
                }
            } else if (evt.getEventRange() == 3) {
                String w = evt.getEventID() + " " + evt.getEventValue() + " " + evt.getRangeAsString();
                if (!(evt.getComponent() instanceof UsableObject)) {
                    return;
                }
                UsableObject uo = (UsableObject)evt.getComponent();
                UOID id = uo.getId();
                w = w + " " + id.getCellIndex() + " " + id.getComponentIndex();
                if (uo.isGraphicComponent()) {
                    this.out.write(w);
                    if (this.verbose) {
                        System.out.println("record " + w);
                    }
                }
            }
            this.out.newLine();
        }

        public void record(String s) throws Exception {
            this.out.write("--" + s);
            if (this.verbose) {
                System.out.println("record --" + s);
            }
            this.out.newLine();
        }

        public void recordCurrentView() throws Exception {
            GraphicCell ac = MSpaceEventHandler.this.graphicScene.getActiveCell();
            if (ac == null) {
                return;
            }
            this.record("zoomTo " + ac.getCameraZ());
            float[] c = ac.getTransformationCenter();
            this.record("center " + c[0] + " " + c[1] + " " + c[2]);
            float[] rm = ac.getRotateMatrix();
            String rs = "rotateTo";
            for (int i = 0; i < 16; ++i) {
                rs = rs + " " + rm[i];
            }
            double sx = MSpaceEventHandler.this.graphicScene.getShiftX(ac.getId().getCellIndex());
            double sy = MSpaceEventHandler.this.graphicScene.getShiftY(ac.getId().getCellIndex());
            this.record("shiftTo " + sx + " " + sy);
            this.record(rs);
        }

        private void process(String eventID, String eventValue) {
            if (this.verbose) {
                System.out.println("processing " + eventID + " " + eventValue);
            }
            MSpaceEventHandler.this.putEventToQueue(new Event(eventID, eventValue));
        }

        private void process(String eventID, String eventValue, int cellIndex, int componentIndex) {
            GraphicComponent o = MSpaceEventHandler.this.graphicScene.getGraphicComponent(cellIndex, componentIndex);
            if (this.verbose) {
                System.out.println("processing " + eventID + " " + eventValue + " " + cellIndex + " " + componentIndex);
            }
            MSpaceEventHandler.this.putEventToQueue(new Event(o, eventID, eventValue));
        }

        private void recordMouseEvent(Event evt) throws Exception {
            MouseEvent mevt = (MouseEvent)evt.getEvent();
            if (MSpaceEventHandler.this.isPopupTrigger(mevt) && evt.getEventID().equals("mouseClicked")) {
                return;
            }
            String mrec = evt.getEventID() + " " + mevt.getModifiers() + " " + mevt.getX() + " " + mevt.getY() + " " + mevt.getClickCount();
            if (this.verbose) {
                System.out.println(mrec);
            }
            this.out.write(mrec);
        }

        private void processMouseEvent(String eventId, StringTokenizer st) {
            int modifiers = Integer.parseInt(st.nextToken());
            int x = Integer.parseInt(st.nextToken());
            int y = Integer.parseInt(st.nextToken());
            int clickCount = Integer.parseInt(st.nextToken());
            MouseEvent me = new MouseEvent(MSpaceEventHandler.this.graphicScene, 0, 0L, modifiers, x, y, clickCount, false);
            MSpaceEventHandler.this.putEventToQueue(new Event(me, eventId, ""));
        }

        private void processLoadEvent(String line) throws Exception {
            try {
                if (this.verbose) {
                    System.out.println("Load " + line);
                }
                if (line.length() == 4) {
                    if (this.verbose) {
                        System.out.println("downloading from http://rcsb.org");
                    }
                    MSpaceEventHandler.this.readPDB(MSpaceEasy.getMolInputStream(MSpaceEasy.getRCSBLink(line, true)));
                } else {
                    MSpaceEventHandler.this.readMoleculeFile(line);
                }
                MSpaceEventHandler.this.graphicScene.resetView();
                MSpaceEventHandler.this.refresh();
            }
            catch (Exception e) {
                System.out.println("========LOAD ERROR==========");
                if (this.haltOnError) {
                    throw e;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MSpaceEventHandler.this.errorDialog.setVisible(false);
                    }
                });
            }
        }

        private void processOtherEvent(String line) throws Exception {
            if (this.verbose) {
                System.out.println(line);
            }
            try {
                StringTokenizer st = new StringTokenizer(line);
                String eventId = st.nextToken();
                if (eventId.equals("select")) {
                    UsableObject uo = this.getUsableObject(st);
                    uo.select();
                } else if (eventId.equals("unSelect")) {
                    UsableObject uo = this.getUsableObject(st);
                    uo.unSelect();
                } else if (eventId.equals("setVisible")) {
                    boolean state = Boolean.valueOf(st.nextToken());
                    UsableObject uo = this.getUsableObject(st);
                    uo.setVisible(state);
                } else if (eventId.equals("ZoomToPocket")) {
                    if (st.hasMoreTokens()) {
                        UsableObject uo = this.getUsableObject(st);
                        if (uo instanceof MoleculeComponent) {
                            MSpaceEventHandler.this.zoomToPocket((MoleculeComponent)uo);
                        }
                    } else {
                        MSpaceEventHandler.this.zoomToPocket();
                    }
                } else if (eventId.equals("DistanceMonitor")) {
                    int itemCount = Integer.parseInt(st.nextToken());
                    this.addMonitor(new DistanceMonitor(), itemCount, st);
                } else if (eventId.equals("AngleMonitor")) {
                    int itemCount = Integer.parseInt(st.nextToken());
                    this.addMonitor(new AngleMonitor(), itemCount, st);
                } else if (eventId.equals("DihedralMonitor")) {
                    int itemCount = Integer.parseInt(st.nextToken());
                    this.addMonitor(new DihedralMonitor(), itemCount, st);
                } else if (eventId.equals("PharmacophorePoint")) {
                    this.addPharmacophorePoint(st);
                    MSpaceEventHandler.this.graphicScene.clearSelection(MSpaceEventHandler.this.cellIdx);
                } else if (eventId.equals("rotate")) {
                    double x = Double.parseDouble(st.nextToken());
                    double y = Double.parseDouble(st.nextToken());
                    double z = Double.parseDouble(st.nextToken());
                    MSpaceEventHandler.this.graphicScene.rotate(x, y, z);
                } else if (eventId.equals("rotateTo")) {
                    float[] rm = new float[16];
                    for (int i = 0; i < 16; ++i) {
                        rm[i] = (float)Double.parseDouble(st.nextToken());
                    }
                    MSpaceEventHandler.this.graphicScene.rotateTo(rm);
                } else if (eventId.equals("rotateAnimated")) {
                    double x = Double.parseDouble(st.nextToken());
                    double y = Double.parseDouble(st.nextToken());
                    double z = Double.parseDouble(st.nextToken());
                    if (st.hasMoreTokens()) {
                        int n = Integer.parseInt(st.nextToken());
                        MSpaceEventHandler.this.graphicScene.rotateAnimated(x, y, z, n);
                    } else {
                        MSpaceEventHandler.this.graphicScene.rotateAnimated(x, y, z);
                    }
                } else if (eventId.equals("zoom")) {
                    double f = Double.parseDouble(st.nextToken());
                    MSpaceEventHandler.this.graphicScene.zoom(f);
                } else if (eventId.equals("zoomTo")) {
                    double f = Double.parseDouble(st.nextToken());
                    try {
                        double z = f - MSpaceEventHandler.this.graphicScene.getActiveCell().getCameraZ();
                        MSpaceEventHandler.this.graphicScene.zoom(z);
                    }
                    catch (NullPointerException ex) {
                        System.out.println("The given cell cannot be accessed (" + ex.getMessage() + ")");
                    }
                } else if (eventId.equals("zoomAnimated")) {
                    double f = Double.parseDouble(st.nextToken());
                    int n = Integer.parseInt(st.nextToken());
                    MSpaceEventHandler.this.graphicScene.zoomAnimated(f, n);
                } else if (eventId.equals("zoomAnimatedTo")) {
                    double f = Double.parseDouble(st.nextToken());
                    int n = Integer.parseInt(st.nextToken());
                    try {
                        double z = f - MSpaceEventHandler.this.graphicScene.getActiveCell().getCameraZ();
                        MSpaceEventHandler.this.graphicScene.zoomAnimated(z, n * (int)Math.abs(z) / 100);
                    }
                    catch (NullPointerException ex) {
                        System.out.println("The given cell cannot be accessed (" + ex.getMessage() + ")");
                    }
                } else if (eventId.equals("shift")) {
                    double x = Double.parseDouble(st.nextToken());
                    double y = Double.parseDouble(st.nextToken());
                    MSpaceEventHandler.this.graphicScene.shift(x, y);
                } else if (eventId.equals("shiftTo")) {
                    double x = Double.parseDouble(st.nextToken());
                    double y = Double.parseDouble(st.nextToken());
                    try {
                        double sx = x - MSpaceEventHandler.this.graphicScene.getShiftX(MSpaceEventHandler.this.graphicScene.getActiveCellIndex());
                        double sy = y - MSpaceEventHandler.this.graphicScene.getShiftY(MSpaceEventHandler.this.graphicScene.getActiveCellIndex());
                        MSpaceEventHandler.this.graphicScene.shift(sx, sy);
                    }
                    catch (NullPointerException ex) {
                        System.out.println("The given cell cannot be accessed (" + ex.getMessage() + ")");
                    }
                } else if (eventId.equals("shiftAnimated")) {
                    double x = Double.parseDouble(st.nextToken());
                    double y = Double.parseDouble(st.nextToken());
                    int n = Integer.parseInt(st.nextToken());
                    MSpaceEventHandler.this.graphicScene.shiftAnimated(x, y, n);
                } else if (eventId.equals("center")) {
                    float[] c = new float[]{Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken())};
                    MSpaceEventHandler.this.graphicScene.setTransformationCenter(c);
                } else if (eventId.equals("wait")) {
                    this.wait = Integer.parseInt(st.nextToken());
                } else if (eventId.equals("createLabels")) {
                    MSpaceEventHandler.this.createLabels(st.nextToken());
                } else if (eventId.equals("ShowSurface")) {
                    String type = st.nextToken();
                    UsableObject uo = this.getUsableObject(st);
                    if (uo instanceof MacroMoleculeComponent.MoleculeVisualizer) {
                        MSpaceEventHandler.this.computeSurface((MacroMoleculeComponent.MoleculeVisualizer)((Object)uo), type);
                    }
                } else if (eventId.equals("exclusiveDrawing")) {
                    String state = st.nextToken();
                    UsableObject uo = this.getUsableObject(st);
                    if (uo instanceof MolecularSurfaceComponent) {
                        ((MolecularSurfaceComponent)uo).setExclusiveDrawing(Boolean.valueOf(state));
                    }
                }
            }
            catch (IndexOutOfBoundsException ex) {
                System.out.println("The component cannot be accessed (" + ex.getMessage() + ")");
            }
        }

        private void addMonitor(MeasurementMonitor mm, int itemCount, StringTokenizer st) throws Exception {
            for (int i = 0; i < itemCount; ++i) {
                mm.selectItem(this.getComponentElement(st, mm));
            }
            MSpaceEventHandler.this.monitor = mm;
            MSpaceEventHandler.this.graphicScene.addComponent(MSpaceEventHandler.this.monitor);
            MSpaceEventHandler.this.attachLabel();
            mm.refresh();
        }

        private void addPharmacophorePoint(StringTokenizer st) throws Exception {
            PharmacophorePoint ph = new PharmacophorePoint();
            int types = Integer.parseInt(st.nextToken());
            for (int i = 0; i < types; ++i) {
                String type = st.nextToken();
                if (type.equals("Acceptor")) {
                    ph.setAcceptor(true);
                    continue;
                }
                if (type.equals("Donor")) {
                    ph.setDonor(true);
                    continue;
                }
                if (type.equals("Anionic")) {
                    ph.setAnionic(true);
                    continue;
                }
                if (type.equals("Cationic")) {
                    ph.setCationic(true);
                    continue;
                }
                if (type.equals("Aromatic")) {
                    ph.setAromatic(true);
                    continue;
                }
                if (type.equals("Excluded")) {
                    ph.setExcluded(true);
                    continue;
                }
                if (!type.equals("Hydrophobic")) continue;
                ph.setHydrophobic(true);
            }
            float x = Float.parseFloat(st.nextToken());
            float y = Float.parseFloat(st.nextToken());
            float z = Float.parseFloat(st.nextToken());
            ph.setPosition(x, y, z);
            MSpaceEventHandler.this.graphicScene.addComponent(ph);
        }

        private ComponentElement getComponentElement(StringTokenizer st, Monitor monitor) {
            int cellIndex = Integer.parseInt(st.nextToken());
            int componentIndex = Integer.parseInt(st.nextToken());
            int cpId = Integer.parseInt(st.nextToken());
            int cpType = Integer.parseInt(st.nextToken());
            int cIndex = Integer.parseInt(st.nextToken());
            GraphicComponent gc = MSpaceEventHandler.this.graphicScene.getGraphicComponent(cellIndex, componentIndex);
            ComponentElement ce = new ComponentElement(gc, cpId, cpType, cIndex);
            gc.associate(monitor);
            MSpaceEventHandler.this.graphicScene.clearSelection(MSpaceEventHandler.this.cellIdx);
            return ce;
        }

        private UsableObject getUsableObject(StringTokenizer st) {
            int cellIndex = Integer.parseInt(st.nextToken());
            int componentIndex = Integer.parseInt(st.nextToken());
            int cpId = Integer.parseInt(st.nextToken());
            UOID id = new UOID(cellIndex, componentIndex, cpId);
            return MSpaceEventHandler.this.graphicScene.getGraphicComponent(id).getUsableObject(id);
        }
    }

    public class MyThread
    extends Thread {
        public ReturnObject returnObject;
        public Object object;

        public MyThread() {
            super("MarvinSpace thread");
            this.returnObject = new ReturnObject();
            this.object = null;
        }

        public Object getResult() {
            return this.returnObject.get();
        }

        protected void refreshLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MSpaceEventHandler.this.graphicScene.isGLInitialized()) {
                        MSpaceEventHandler.this.graphicScene.refresh();
                    }
                }
            });
        }
    }

    public class ReturnObject {
        private Object object = null;
        private boolean available = false;

        public synchronized void set(Object o) {
            this.available = true;
            this.object = o;
            this.notifyAll();
        }

        public synchronized Object get() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.object;
        }
    }

    public static interface TranslationInterface {
        public boolean isInitialized();

        public void setSceneSize(int var1, int var2);

        public void setMousePressEvent(MouseEvent var1);

        public void setTranslationEvent(int var1);

        public void setTranslationEvent(int var1, boolean var2, int var3);

        public boolean isTranslationEvent(MouseEvent var1);

        public double[] translate(MouseEvent var1);
    }

    public static interface ZoomInterface {
        public void setMousePressEvent(MouseEvent var1);

        public void setZoomEvent(int var1);

        public boolean isZoomEvent(MouseEvent var1);

        public boolean isInvertZoom();

        public void setInvertZoom(boolean var1);

        public double zoom(MouseEvent var1);
    }

    public static interface RotationInterface {
        public boolean isInitialized();

        public void setSceneSize(int var1, int var2, int var3, int var4);

        public boolean isRotationPressEvent(MouseEvent var1);

        public boolean isRotationDragEvent(MouseEvent var1);

        public void setMousePressEvent(MouseEvent var1);

        public void setRotationEvent(int var1);

        public double[] rotate(MouseEvent var1);
    }

    public class TranslationModel
    implements TranslationInterface {
        private boolean initialized = false;
        private double w;
        private double h;
        int translationEvent = 4096;
        int translationKeyEvent = 64;
        int shiftDragging = 1088;
        private boolean translationKeyNecessary = false;
        private int prevMouseX;
        private int prevMouseY;

        @Override
        public void setMousePressEvent(MouseEvent mevt) {
            this.prevMouseX = mevt.getX();
            this.prevMouseY = mevt.getY();
        }

        @Override
        public void setTranslationEvent(int mouseEvt) {
            this.translationEvent = mouseEvt;
            this.translationKeyNecessary = false;
        }

        @Override
        public void setTranslationEvent(int mouseEvt, boolean kevt, int keyEvt) {
            this.translationEvent = mouseEvt;
            if (kevt) {
                this.translationKeyNecessary = true;
                this.translationKeyEvent = keyEvt;
            } else {
                this.translationKeyNecessary = false;
            }
        }

        @Override
        public boolean isTranslationEvent(MouseEvent mevt) {
            if ((mevt.getModifiersEx() & this.shiftDragging) == this.shiftDragging) {
                return true;
            }
            if (!this.translationKeyNecessary) {
                return (mevt.getModifiersEx() & this.translationEvent) != 0;
            }
            return (mevt.getModifiersEx() & this.translationEvent) != 0 && (mevt.getModifiersEx() & this.translationKeyEvent) != 0;
        }

        @Override
        public double[] translate(MouseEvent mevt) {
            double[] s = new double[]{mevt.getX() - this.prevMouseX, this.prevMouseY - mevt.getY()};
            this.prevMouseX = mevt.getX();
            this.prevMouseY = mevt.getY();
            return s;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }

        @Override
        public void setSceneSize(int w, int h) {
            this.w = w;
            this.h = h;
            this.initialized = true;
        }
    }

    public class ZoomModel
    implements ZoomInterface {
        int zoomEvent = 2048;
        int altDragging = 1536;
        boolean invertZoom = false;
        private int prevMouseY;

        @Override
        public boolean isZoomEvent(MouseEvent mevt) {
            return (mevt.getModifiersEx() & this.zoomEvent) != 0 || (mevt.getModifiersEx() & this.altDragging) == this.altDragging;
        }

        @Override
        public void setZoomEvent(int evt) {
            this.zoomEvent = evt;
        }

        @Override
        public void setMousePressEvent(MouseEvent mevt) {
            this.prevMouseY = mevt.getY();
        }

        @Override
        public boolean isInvertZoom() {
            return this.invertZoom;
        }

        @Override
        public void setInvertZoom(boolean b) {
            this.invertZoom = b;
        }

        @Override
        public double zoom(MouseEvent mevt) {
            double z = this.invertZoom ? (double)(this.prevMouseY - mevt.getY()) : (double)(mevt.getY() - this.prevMouseY);
            this.prevMouseY = mevt.getY();
            return z;
        }
    }

    public class RotationModel
    implements RotationInterface,
    Runnable {
        private static final double DEFAULT_SPHERE_RAD_RATIO = 0.8;
        private int x0 = 0;
        private int y0 = 0;
        private int w;
        private int cx;
        private int cy;
        private int r2;
        private int prevMouseX;
        private int prevMouseY;
        private double[] rotate = new double[3];
        private double sphereRadRatio = 0.8;
        private double sphereRadius;
        private boolean initialized = false;
        private boolean intuitive;
        private int rotationEvent = 1024;
        private long prevTime;
        private long currentTime;
        private Thread runnerThread = null;
        private MSpaceEventHandler handler = null;

        RotationModel() {
        }

        RotationModel(int x0, int y0, int w, int h) {
            this.x0 = x0;
            this.y0 = y0;
            this.w = w;
            this.cx = x0 + w / 2;
            this.cy = y0 + h / 2;
            this.sphereRadius = (double)h * this.sphereRadRatio / 2.0;
            this.r2 = (int)(this.sphereRadius * this.sphereRadius);
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }

        @Override
        public void setSceneSize(int x0, int y0, int w, int h) {
            this.x0 = x0;
            this.y0 = y0;
            this.w = w;
            this.cx = x0 + w / 2;
            this.cy = y0 + h / 2;
            this.sphereRadius = (double)h * this.sphereRadRatio / 2.0;
            this.r2 = (int)(this.sphereRadius * this.sphereRadius);
            this.initialized = true;
            this.intuitive = (this.prevMouseX - this.cx) * (this.prevMouseX - this.cx) + (this.prevMouseY - this.cy) * (this.prevMouseY - this.cy) < this.r2;
        }

        @Override
        public boolean isRotationPressEvent(MouseEvent mevt) {
            return (mevt.getModifiersEx() & this.rotationEvent) != 0;
        }

        @Override
        public boolean isRotationDragEvent(MouseEvent mevt) {
            return (mevt.getModifiersEx() & this.rotationEvent) != 0;
        }

        @Override
        public void setMousePressEvent(MouseEvent mevt) {
            this.prevMouseX = mevt.getX();
            this.prevMouseY = mevt.getY();
            this.intuitive = (this.prevMouseX - this.cx) * (this.prevMouseX - this.cx) + (this.prevMouseY - this.cy) * (this.prevMouseY - this.cy) < this.r2;
        }

        @Override
        public double[] rotate(MouseEvent mevt) {
            int x = mevt.getX();
            int y = mevt.getY();
            int xChanged = x - this.prevMouseX;
            int xInvertChanged = this.prevMouseX - x;
            int yChanged = y - this.prevMouseY;
            int yInvertChanged = this.prevMouseY - y;
            if (this.intuitive) {
                this.rotate[0] = yChanged;
                this.rotate[1] = xChanged;
                this.rotate[2] = 0.0;
            } else {
                int xx = x - this.x0;
                int yy = y - this.y0;
                if (xx + yy < this.w) {
                    if (yy > xx) {
                        this.rotate[0] = 0.0;
                        this.rotate[1] = 0.0;
                        this.rotate[2] = yChanged / 2;
                    } else {
                        this.rotate[0] = 0.0;
                        this.rotate[1] = 0.0;
                        this.rotate[2] = xInvertChanged / 2;
                    }
                } else if (yy > xx) {
                    this.rotate[0] = 0.0;
                    this.rotate[1] = 0.0;
                    this.rotate[2] = xChanged / 2;
                } else {
                    this.rotate[0] = 0.0;
                    this.rotate[1] = 0.0;
                    this.rotate[2] = yInvertChanged / 2;
                }
            }
            this.prevMouseX = x;
            this.prevMouseY = y;
            return this.rotate;
        }

        @Override
        public void setRotationEvent(int evt) {
            this.rotationEvent = evt;
        }

        @Override
        public void run() {
            this.currentTime = this.prevTime = System.currentTimeMillis();
            while (Thread.currentThread() == this.runnerThread) {
                this.step();
            }
        }

        public void step() {
            this.currentTime = System.currentTimeMillis();
            int dt = (int)(this.currentTime - this.prevTime);
            if (dt > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.currentTime += (long)dt;
            }
            if (this.handler != null) {
                this.handler.putEventToQueue(new Event("Animate", ""));
                this.handler.refresh();
            }
        }

        public void start() {
            if (this.runnerThread == null) {
                this.runnerThread = new Thread((Runnable)this, "MSpace-Animation");
                this.runnerThread.start();
            }
        }

        public void stop() {
            this.runnerThread = null;
        }

        public void setAnimationHandler(MSpaceEventHandler handler) {
            this.handler = handler;
        }
    }
}

