/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.MSpaceEventHandler;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.gui.JMSpaceToolBarForAlignmentPlugin;
import chemaxon.marvin.space.gui.JMSpaceTree;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class MSpacePluginAlignment
implements CallbackIface {
    JDialog dialog = null;
    private Molecule[] mols;
    MSpaceEasy mspace;
    Color[] colors = new Color[]{Color.BLUE, Color.CYAN, Color.ORANGE, Color.PINK, Color.RED, Color.MAGENTA, Color.GREEN};
    private static int SIZE = 1000;
    private JSplitPane jSplitPane1;
    private transient CallbackIface loadsave = null;
    private MolPanel parent;
    private Molecule mol;
    private double volumeTanimoto = 0.0;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("getMSpaceDialog")) {
            try {
                return this.getMSpaceDialog();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (method.equals("setMolecule")) {
            this.setMolecule((Molecule)arg);
        }
        if (method.equals("setMols")) {
            this.setMols((Molecule[])arg);
        }
        if (method.equals("setParent")) {
            this.setParent((MolPanel)arg);
        }
        if (method.equals("setVolumeTanimoto")) {
            double d = (Double)arg;
            this.setVolumeTanimoto(d);
        }
        return null;
    }

    public void setVolumeTanimoto(double volumeTanimoto) {
        this.volumeTanimoto = volumeTanimoto;
    }

    public void setParent(MolPanel parent) {
        this.parent = parent;
    }

    public void setMols(Molecule[] mols) {
        this.mols = mols;
    }

    private static String getIUPACName(Molecule m, int i) {
        String name = "";
        Molecule tmp = m.cloneMolecule();
        int c = 0;
        while (c < tmp.getAtomCount()) {
            if (tmp.getAtom(c).getAtno() == 130) {
                tmp.removeAtom(c);
                continue;
            }
            ++c;
        }
        try {
            name = tmp.toFormat("name");
        }
        catch (Exception e) {
            name = "Molecule " + i;
            e.printStackTrace();
        }
        return name;
    }

    public void setMolecule(Molecule mol) {
        this.mol = mol;
        this.mols = MolGeom.breakMol(mol);
    }

    private void createDialog(Component parent) {
        Frame pw;
        Dialog pd = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
        this.dialog = pd != null ? new JDialog(pd){

            @Override
            public void dispose() {
                MSpacePluginAlignment.this.mspace.removeAllComponents();
                super.dispose();
            }
        } : ((pw = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent)) != null ? new JDialog(pw){

            @Override
            public void dispose() {
                MSpacePluginAlignment.this.mspace.removeAllComponents();
                super.dispose();
            }
        } : new JDialog(){

            @Override
            public void dispose() {
                MSpacePluginAlignment.this.mspace.removeAllComponents();
                super.dispose();
            }
        });
    }

    public JPanel createSelectionPanel() {
        GraphicScene graphicScene = this.mspace.getGraphicScene();
        JMSpaceTree selectionBar = new JMSpaceTree(graphicScene);
        selectionBar.setMinimumSize(new Dimension(250, 180));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.add(selectionBar);
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setLeftComponent(graphicScene);
        this.jSplitPane1.setRightComponent(rightPanel);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.jSplitPane1, "Center");
        MSpaceEventHandler eventHandler = graphicScene.getEventHandler();
        eventHandler.setSelectionBar(selectionBar);
        mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                final int w = e.getComponent().getWidth();
                final int h = e.getComponent().getHeight();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MSpacePluginAlignment.this.jSplitPane1.setSize(w, h);
                    }
                });
            }
        });
        return mainPanel;
    }

    public JDialog getMSpaceDialog() throws Exception {
        this.mspace = new MSpaceEasy(1, 2, true);
        this.createDialog(null);
        this.dialog.setTitle("3D Alignment");
        this.dialog.getContentPane().add(this.createSelectionPanel());
        this.mspace.setProperty("SynchronousMode", "true");
        this.mspace.setSize(1000, 500);
        JMSpaceToolBarForAlignmentPlugin toolbar = new JMSpaceToolBarForAlignmentPlugin(this.mspace.getGraphicScene(), this.volumeTanimoto);
        this.dialog.getContentPane().add((Component)toolbar, "First");
        this.mspace.getEventHandler().setToolBar(toolbar);
        this.mspace.getGraphicScene().setBackgroundColor(Color.black);
        for (int i = 0; i < this.mols.length; ++i) {
            int col;
            if (this.mols[i].getName() == null || this.mols[i].getName().equals("")) {
                this.mols[i].setName(MSpacePluginAlignment.getIUPACName(this.mols[i], i));
            }
            this.mspace.getGraphicScene().setActiveCell(1);
            MoleculeComponent mc1 = this.mspace.getEventHandler().setMoleculeWithoutChange(this.mols[i], true);
            mc1.setDrawProperty("Ligand.Hydrogens", "false");
            mc1.setDrawProperty("Ligand.DrawType", "Stick");
            mc1.setDrawProperty("Ligand.StickRadius", "0.1");
            mc1.setDrawProperty("ColorType", "Constant");
            this.mspace.getGraphicScene().setActiveCell(0);
            MoleculeComponent mc2 = this.mspace.getEventHandler().setMoleculeWithoutChange(this.mols[i], true);
            mc2.setDrawProperty("Ligand.Hydrogens", "false");
            mc2.setDrawProperty("Ligand.DrawType", "Stick");
            mc2.setDrawProperty("Ligand.StickRadius", "0.1");
            for (col = i; col >= this.colors.length; col -= this.colors.length) {
            }
            mc1.setColor(this.colors[col]);
        }
        this.createMSpacePopupMenu();
        this.mspace.refresh();
        this.dialog.pack();
        return this.dialog;
    }

    private void createMSpacePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.setLightWeightPopupEnabled(false);
        if (this.parent != null) {
            JMenuItem save = new JMenuItem("Transfer back to MarvinSketch");
            popup.add(save);
            save.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MSpacePluginAlignment.this.parent.updateMol(0, MSpacePluginAlignment.this.mol);
                }
            });
        }
        JMenuItem savePic = new JMenuItem("Export to image");
        popup.add(savePic);
        savePic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.err.println("savePic");
                MSpacePluginAlignment.this.saveImageMenuItemActionPerformed();
            }
        });
        this.mspace.callback("addPopupMenu", popup);
    }

    private void saveImageMenuItemActionPerformed() {
        JFileChooser saveImegeFC = new JFileChooser();
        saveImegeFC.setFileFilter(new ImageFilter("jpg"));
        saveImegeFC.setFileFilter(new ImageFilter("bmp"));
        saveImegeFC.setFileFilter(new ImageFilter("png"));
        GraphicScene graphicScene = this.mspace.getGraphicScene();
        int returnVal = saveImegeFC.showSaveDialog(graphicScene);
        graphicScene.setCursor(Cursor.getPredefinedCursor(3));
        if (returnVal == 0 && saveImegeFC.getSelectedFile() != null) {
            String ext = "png";
            if (saveImegeFC.getFileFilter() instanceof ImageFilter) {
                ext = ((ImageFilter)saveImegeFC.getFileFilter()).getExtension();
            }
            if (this.confirmOverwrite(saveImegeFC.getSelectedFile().getPath(), ext) == 1) {
                this.saveImageMenuItemActionPerformed();
            }
            graphicScene.setAntialias(true);
            graphicScene.refresh();
            graphicScene.processEvent("Quality", "High");
            graphicScene.getEventHandler().exportImage(saveImegeFC.getSelectedFile().getPath(), ext);
            graphicScene.setAntialias(false);
        }
        graphicScene.setCursor(Cursor.getPredefinedCursor(0));
    }

    private int confirmOverwrite(String fileName, String format2) {
        File f;
        GraphicScene graphicScene = this.mspace.getGraphicScene();
        if (!fileName.endsWith("." + format2) && !fileName.endsWith("." + format2.toUpperCase())) {
            fileName = fileName + "." + format2;
        }
        if ((f = new File(fileName)).exists()) {
            int mode = JOptionPane.showConfirmDialog(graphicScene, "File " + f.getName() + " exists. Overwrite?", "File exists", 0, 2);
            return mode == 0 ? 0 : 1;
        }
        return 2;
    }

    private class ImageFilter
    extends FileFilter {
        String ext = "png";

        ImageFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equalsIgnoreCase(this.ext);
            }
            return false;
        }

        public String getExtension() {
            return this.ext;
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        @Override
        public String getDescription() {
            return this.ext.toUpperCase() + " Image";
        }
    }
}

