/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.MolecularSurfaceComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.monitor.Label;
import chemaxon.marvin.space.util.Palette;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.ColorPaletteUtil;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class MSpacePluginDisplay
implements CallbackIface {
    String title = "MarvinSpace";
    JDialog dialog = null;
    private ArrayList resultValues;
    private Molecule[] mols;
    private String[] propertyTexts;
    private int precision = 2;
    private String palette = null;
    private boolean displayLabelOnlyOnHeavyAtoms = false;
    private MolecularSurfaceComponent[] surfComponents;
    private ArrayList molecularLabels;
    private Label[][] labels;
    private float[][][] labelColors;
    private LabelColorListener lcl = new LabelColorListener();
    MSpaceEasy mspace;
    boolean install;
    URL codebase;
    boolean verbose = false;

    public MSpacePluginDisplay(boolean install, URL codebase) {
        this.install = install;
        this.codebase = codebase;
    }

    public MSpacePluginDisplay(boolean install, URL codebase, boolean verbose) {
        this.install = install;
        this.codebase = codebase;
        this.verbose = verbose;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.startsWith("get")) {
            return this.get(method, arg);
        }
        if (method.startsWith("set")) {
            this.set(method, arg);
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Molecule[] getMolecules() {
        return this.mols;
    }

    public void setMolecules(Molecule[] mols) {
        this.mols = mols;
    }

    public ArrayList getResultValues() {
        return this.resultValues;
    }

    public void setResultValues(ArrayList resultValues) {
        this.resultValues = new ArrayList(resultValues);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int p) {
        this.precision = p;
    }

    public String getPalette() {
        return this.palette;
    }

    public void setPalette(String palette) {
        this.palette = palette;
    }

    public String[] getPropertyTexts() {
        return this.propertyTexts;
    }

    public void setPropertyTexts(String[] pt) {
        this.propertyTexts = pt;
    }

    public void setDisplayLabelOnlyOnHeavyAtoms(boolean d) {
        this.displayLabelOnlyOnHeavyAtoms = d;
    }

    public Dialog getMSpaceDialog(Component parent) throws Exception {
        return this.getMSpaceDialog(parent, Color.black);
    }

    public Dialog getMSpaceDialog() throws Exception {
        return this.getMSpaceDialog(null, Color.black);
    }

    public JDialog getMSpaceDialog(Color bgcolor) throws Exception {
        return this.getMSpaceDialog(null, bgcolor);
    }

    public JDialog getMSpaceDialog(Component parent, Color bgcolor) throws Exception {
        this.mspace = new MSpaceEasy(this.mols.length, 2, this.install, this.verbose, this.codebase);
        this.createDialog(parent);
        this.dialog.setTitle(this.title);
        this.init(bgcolor);
        this.dialog.pack();
        return this.dialog;
    }

    private void createDialog(Component parent) {
        Frame pw;
        Dialog pd = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
        this.dialog = pd != null ? new JDialog(pd){

            @Override
            public void dispose() {
                MSpacePluginDisplay.this.mspace.removeAllComponents();
                super.dispose();
            }
        } : ((pw = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent)) != null ? new JDialog(pw){

            @Override
            public void dispose() {
                MSpacePluginDisplay.this.mspace.removeAllComponents();
                super.dispose();
            }
        } : new JDialog(){

            @Override
            public void dispose() {
                MSpacePluginDisplay.this.mspace.removeAllComponents();
                super.dispose();
            }
        });
    }

    private void init(Color bgcolor) throws Exception {
        int i;
        this.dialog.setDefaultCloseOperation(2);
        this.mspace.addCanvas(this.dialog.getContentPane());
        this.mspace.setSize(800, 600);
        this.mspace.getGraphicScene().setBackgroundColor(bgcolor);
        this.mspace.getGraphicScene().setDrawProperty("Label.OnlyOnHeavyAtoms", Boolean.toString(this.displayLabelOnlyOnHeavyAtoms));
        this.mspace.setProperty("SynchronousMode", "true");
        this.mspace.setProperty("Label.Draw2D", "true");
        this.mspace.setProperty("Label.BackgroundColor", "#ffffff");
        this.mspace.setProperty("Label.Size", "small");
        MoleculeComponent[] molComponents = new MoleculeComponent[this.mols.length];
        this.surfComponents = new MolecularSurfaceComponent[this.mols.length];
        this.labels = new Label[this.mols.length][];
        this.molecularLabels = new ArrayList();
        for (i = 0; i < this.mols.length; ++i) {
            MoleculeComponent mc = this.mspace.addMoleculeTo(this.mols[i], i * 2);
            this.labels[i] = this.createPluginResultLabels(i, mc);
            molComponents[i] = this.mspace.addMoleculeTo(this.mols[i], i * 2 + 1);
        }
        this.mspace.setProperty("Ligand.Hydrogens", "true");
        this.labelColors = new float[molComponents.length][][];
        for (i = 0; i < molComponents.length; ++i) {
            MolecularSurfaceComponent msc;
            this.surfComponents[i] = msc = this.mspace.computeSurface(molComponents[i]);
            if (msc == null || this.resultValues.size() <= i || ((ArrayList)this.resultValues.get(i)).size() <= 0) continue;
            msc.setPalette(ColorPaletteUtil.getBuiltInPaletteId(this.palette));
            msc.setAtomPropertyList((ArrayList)this.resultValues.get(i));
            msc.setDrawProperty("Surface.ColorType", "AtomProperty");
            this.labelColors[i] = this.colorLabels(this.labels[i], (ArrayList)this.resultValues.get(i), msc.getPalette());
        }
        this.createMSpacePopupMenu();
        this.mspace.refresh();
    }

    private void updateLabelColors() throws Exception {
        for (int i = 0; i < this.surfComponents.length; ++i) {
            MolecularSurfaceComponent msc = this.surfComponents[i];
            if (msc == null || this.resultValues.size() <= i || ((ArrayList)this.resultValues.get(i)).size() <= 0) continue;
            this.labelColors[i] = this.colorLabels(this.labels[i], (ArrayList)this.resultValues.get(i), msc.getPalette());
        }
    }

    private Object get(String method, Object arg) {
        if (method.equals("getMSpaceDialog")) {
            try {
                return this.getMSpaceDialog((Component)arg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (method.equals("getTitle")) {
                return this.getTitle();
            }
            if (method.equals("getMolecules")) {
                return this.getMolecules();
            }
            if (method.equals("getResultValues")) {
                return this.getResultValues();
            }
            if (method.equals("getPrecision")) {
                return new Integer(this.getPrecision());
            }
            if (method.equals("getPalette")) {
                return this.getPalette();
            }
            if (method.equals("getPropertyTexts")) {
                return this.getPropertyTexts();
            }
        }
        return null;
    }

    private void set(String method, Object arg) {
        if (method.equals("setTitle")) {
            this.setTitle((String)arg);
        } else if (method.equals("setMolecules")) {
            this.setMolecules((Molecule[])arg);
        } else if (method.equals("setResultValues")) {
            this.setResultValues((ArrayList)arg);
        } else if (method.equals("setPrecision")) {
            this.setPrecision((Integer)arg);
        } else if (method.equals("setPalette")) {
            this.setPalette((String)arg);
        } else if (method.equals("setPropertyTexts")) {
            this.setPropertyTexts((String[])arg);
        } else if (method.equals("setDisplayLabelOnlyOnHeavyAtoms")) {
            this.setDisplayLabelOnlyOnHeavyAtoms((Boolean)arg);
        }
    }

    private Label[] createPluginResultLabels(int i, MoleculeComponent mc) throws Exception {
        if (this.resultValues == null || this.resultValues.size() <= i) {
            return null;
        }
        Label[] labels = this.mspace.getEventHandler().createAtomLabels(mc, (ArrayList)this.resultValues.get(i), this.precision);
        if (labels == null) {
            return null;
        }
        for (int j = 0; j < labels.length && labels[j] != null; ++j) {
            labels[j].setBorderColorMode(3);
        }
        float[] c = new float[]{10.0f, 20.0f};
        if (this.propertyTexts == null) {
            return labels;
        }
        String text = this.propertyTexts[i];
        if (text == null) {
            return labels;
        }
        Label label = this.mspace.getEventHandler().createLabel(text, c);
        this.molecularLabels.add(label);
        label.ignoreDrawProperties(true);
        label.setBorderColorMode(0);
        label.setBackgroundColor(Color.white);
        label.setForegroundColor(Color.black);
        return labels;
    }

    private float[][] colorLabels(Label[] labels, ArrayList resultValues, Palette palette) throws Exception {
        float[][] labelColors = new float[labels.length][3];
        for (int i = 0; i < labels.length && labels[i] != null; ++i) {
            float[] c = palette.getColor(((Number)resultValues.get(i)).doubleValue());
            labelColors[i] = c;
            this.lcl.color(labels[i], new Color(c[0], c[1], c[2]));
        }
        return labelColors;
    }

    private void createMSpacePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.setLightWeightPopupEnabled(false);
        JMenuItem bestFit = new JMenuItem("Best fit");
        bestFit.setActionCommand("resetAll");
        JMenu label = new JMenu("Label");
        label.getPopupMenu().setLightWeightPopupEnabled(false);
        JCheckBoxMenuItem draw2d = new JCheckBoxMenuItem("Draw2D");
        draw2d.setActionCommand("Label.Draw2D");
        draw2d.setState(true);
        JRadioButtonMenuItem smallMenuItem = new JRadioButtonMenuItem("Small");
        smallMenuItem.setActionCommand("Small");
        smallMenuItem.setSelected(true);
        JRadioButtonMenuItem medMenuItem = new JRadioButtonMenuItem("Medium");
        medMenuItem.setActionCommand("Medium");
        JRadioButtonMenuItem largeMenuItem = new JRadioButtonMenuItem("Large");
        largeMenuItem.setActionCommand("Large");
        JRadioButtonMenuItem whiteMI = new JRadioButtonMenuItem("White");
        whiteMI.setActionCommand("#ffffff");
        whiteMI.setSelected(true);
        JRadioButtonMenuItem blackMI = new JRadioButtonMenuItem("Black");
        blackMI.setActionCommand("#000000");
        JRadioButtonMenuItem monoMI = new JRadioButtonMenuItem("Monochrome");
        monoMI.setActionCommand("Monochrome");
        JRadioButtonMenuItem colorMI = new JRadioButtonMenuItem("Colored Foreground");
        colorMI.setActionCommand("ColoredForeground");
        colorMI.setSelected(true);
        JRadioButtonMenuItem color2MI = new JRadioButtonMenuItem("Colored Background");
        color2MI.setActionCommand("ColoredBackground");
        JMenu mol = new JMenu("Molecule");
        mol.getPopupMenu().setLightWeightPopupEnabled(false);
        JRadioButtonMenuItem wireMenuItem = new JRadioButtonMenuItem("Wire");
        wireMenuItem.setActionCommand("Wire");
        JRadioButtonMenuItem ballMenuItem = new JRadioButtonMenuItem("Ball");
        ballMenuItem.setActionCommand("Ball");
        JRadioButtonMenuItem stickMenuItem = new JRadioButtonMenuItem("Stick");
        stickMenuItem.setActionCommand("Stick");
        JRadioButtonMenuItem ballAndWireMenuItem = new JRadioButtonMenuItem("Ball and wire");
        ballAndWireMenuItem.setActionCommand("BallAndWire");
        JRadioButtonMenuItem ballAndStickMenuItem = new JRadioButtonMenuItem("Ball and stick");
        ballAndStickMenuItem.setSelected(true);
        ballAndStickMenuItem.setActionCommand("BallAndStick");
        JRadioButtonMenuItem spacefillMenuItem = new JRadioButtonMenuItem("Spacefill");
        spacefillMenuItem.setActionCommand("Spacefill");
        JCheckBoxMenuItem hyd = new JCheckBoxMenuItem("Hydrogens");
        hyd.setActionCommand("Ligand.Hydrogens");
        hyd.setState(true);
        JMenu surface = new JMenu("Surface");
        surface.getPopupMenu().setLightWeightPopupEnabled(false);
        JRadioButtonMenuItem dottedMenuItem = new JRadioButtonMenuItem("Dot");
        dottedMenuItem.setActionCommand("Dot");
        JRadioButtonMenuItem meshMenuItem = new JRadioButtonMenuItem("Mesh");
        meshMenuItem.setActionCommand("Mesh");
        JRadioButtonMenuItem filledMenuItem = new JRadioButtonMenuItem("Solid");
        filledMenuItem.setActionCommand("Solid");
        filledMenuItem.setSelected(true);
        JRadioButtonMenuItem transparentMenuItem = new JRadioButtonMenuItem("Transparent");
        transparentMenuItem.setActionCommand("Transparent");
        JMenu palettePanel = new JMenu("Palette");
        ActionListener palal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSpacePluginDisplay.this.mspace.setProperty("Surface.Palette", e.getActionCommand());
                MSpacePluginDisplay.this.mspace.refresh();
                try {
                    MSpacePluginDisplay.this.updateLabelColors();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        palettePanel.getPopupMenu().setLightWeightPopupEnabled(false);
        String[] palettes = ColorPaletteUtil.getBuiltInPalettes();
        ButtonGroup palbg = new ButtonGroup();
        for (int i = 0; i < palettes.length; ++i) {
            JRadioButtonMenuItem pali = new JRadioButtonMenuItem(palettes[i]);
            if (palettes[i].equals(this.palette)) {
                pali.setSelected(true);
            }
            pali.setActionCommand(palettes[i]);
            palbg.add(pali);
            palettePanel.add(pali);
            pali.addActionListener(palal);
        }
        JMenu background = new JMenu("Background");
        background.getPopupMenu().setLightWeightPopupEnabled(false);
        JRadioButtonMenuItem white = new JRadioButtonMenuItem("White");
        white.setActionCommand("#ffffff");
        JRadioButtonMenuItem black = new JRadioButtonMenuItem("Black", true);
        black.setActionCommand("#000000");
        JCheckBoxMenuItem cs = new JCheckBoxMenuItem("Coordinate System", false);
        ButtonGroup modebg = new ButtonGroup();
        modebg.add(wireMenuItem);
        modebg.add(ballMenuItem);
        modebg.add(stickMenuItem);
        modebg.add(ballAndWireMenuItem);
        modebg.add(ballAndStickMenuItem);
        modebg.add(spacefillMenuItem);
        ButtonGroup bgbg = new ButtonGroup();
        bgbg.add(white);
        bgbg.add(black);
        ButtonGroup colorbg = new ButtonGroup();
        colorbg.add(monoMI);
        colorbg.add(colorMI);
        colorbg.add(color2MI);
        ButtonGroup lcbg = new ButtonGroup();
        lcbg.add(whiteMI);
        lcbg.add(blackMI);
        ButtonGroup labelsizebg = new ButtonGroup();
        labelsizebg.add(smallMenuItem);
        labelsizebg.add(medMenuItem);
        labelsizebg.add(largeMenuItem);
        ButtonGroup surfacebg = new ButtonGroup();
        surfacebg.add(dottedMenuItem);
        surfacebg.add(meshMenuItem);
        surfacebg.add(filledMenuItem);
        surfacebg.add(transparentMenuItem);
        popup.add(bestFit);
        popup.addSeparator();
        popup.add(mol);
        mol.add(wireMenuItem);
        mol.add(ballMenuItem);
        mol.add(stickMenuItem);
        mol.add(ballAndWireMenuItem);
        mol.add(ballAndStickMenuItem);
        mol.add(spacefillMenuItem);
        mol.add(hyd);
        popup.add(surface);
        surface.add(dottedMenuItem);
        surface.add(meshMenuItem);
        surface.add(filledMenuItem);
        surface.add(transparentMenuItem);
        popup.add(palettePanel);
        popup.add(label);
        label.add(draw2d);
        label.addSeparator();
        label.add(smallMenuItem);
        label.add(medMenuItem);
        label.add(largeMenuItem);
        label.addSeparator();
        label.add(whiteMI);
        label.add(blackMI);
        label.addSeparator();
        label.add(monoMI);
        label.add(colorMI);
        label.add(color2MI);
        popup.add(background);
        background.add(white);
        background.add(black);
        popup.addSeparator();
        popup.add(cs);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSpacePluginDisplay.this.mspace.callback(e.getActionCommand(), null);
            }
        };
        ActionListener chbal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem chb = (JCheckBoxMenuItem)e.getSource();
                MSpacePluginDisplay.this.mspace.setProperty(e.getActionCommand(), "" + chb.getState());
            }
        };
        bestFit.addActionListener(al);
        hyd.addActionListener(chbal);
        draw2d.addActionListener(chbal);
        this.addActionListener(wireMenuItem, "Ligand.DrawType", this.mspace);
        this.addActionListener(ballMenuItem, "Ligand.DrawType", this.mspace);
        this.addActionListener(stickMenuItem, "Ligand.DrawType", this.mspace);
        this.addActionListener(ballAndWireMenuItem, "Ligand.DrawType", this.mspace);
        this.addActionListener(ballAndStickMenuItem, "Ligand.DrawType", this.mspace);
        this.addActionListener(spacefillMenuItem, "Ligand.DrawType", this.mspace);
        this.addActionListener(smallMenuItem, "Label.Size", this.mspace);
        this.addActionListener(medMenuItem, "Label.Size", this.mspace);
        this.addActionListener(largeMenuItem, "Label.Size", this.mspace);
        this.addActionListener(dottedMenuItem, "Surface.DrawType", this.mspace);
        this.addActionListener(meshMenuItem, "Surface.DrawType", this.mspace);
        this.addActionListener(filledMenuItem, "Surface.DrawType", this.mspace);
        this.addActionListener(transparentMenuItem, "Surface.DrawType", this.mspace);
        this.addActionListener(white, "Background.Color", this.mspace);
        this.addActionListener(black, "Background.Color", this.mspace);
        this.mspace.callback("addPopupMenu", popup);
        whiteMI.addActionListener(this.lcl);
        blackMI.addActionListener(this.lcl);
        monoMI.addActionListener(this.lcl);
        colorMI.addActionListener(this.lcl);
        color2MI.addActionListener(this.lcl);
        cs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCheckBoxMenuItem jcb = (JCheckBoxMenuItem)evt.getSource();
                MSpacePluginDisplay.this.mspace.getEventHandler().showCoordinateSystem(jcb.getState());
            }
        });
    }

    private void addActionListener(AbstractButton b, final String property, final CallbackIface mspace) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mspace.callback("setProperty", new String[]{property, e.getActionCommand()});
            }
        });
    }

    public class LabelColorListener
    implements ActionListener {
        private String whiteString = "#ffffff";
        private String blackString = "#000000";
        private boolean baseColorWhite = true;
        private boolean invertColors = false;
        private boolean monochrome = false;

        public void register(AbstractButton b) {
            b.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Monochrome")) {
                this.monochrome = true;
                this.invertColors = false;
                this.monochromeLabels();
            } else if (e.getActionCommand().equals("ColoredBackground")) {
                this.monochrome = false;
                this.invertColors = true;
                this.colorLabels();
            } else if (e.getActionCommand().equals("ColoredForeground")) {
                this.monochrome = false;
                this.invertColors = false;
                this.colorLabels();
            } else if (e.getActionCommand().equals(this.whiteString)) {
                this.baseColorWhite = true;
                if (this.monochrome) {
                    this.monochromeLabels();
                } else {
                    this.colorLabels();
                }
                this.colorMolecularLabels();
            } else if (e.getActionCommand().equals(this.blackString)) {
                this.baseColorWhite = false;
                if (this.monochrome) {
                    this.monochromeLabels();
                } else {
                    this.colorLabels();
                }
                this.colorMolecularLabels();
            }
        }

        public void color(Label label, Color c) {
            if (this.invertColors) {
                label.setBackgroundColor(c);
            } else {
                label.setForegroundColor(c);
            }
        }

        public void color(Label label, float[] c) {
            if (this.invertColors) {
                label.setBackgroundColor(new Color(c[0], c[1], c[2]));
            } else {
                label.setForegroundColor(new Color(c[0], c[1], c[2]));
            }
        }

        public void setLabelProperty(String property) {
            if (this.invertColors) {
                MSpacePluginDisplay.this.mspace.setProperty("Label.ForegroundColor", property);
            } else {
                MSpacePluginDisplay.this.mspace.setProperty("Label.BackgroundColor", property);
            }
        }

        private void setBackground(Color c) {
            for (int i = 0; i < MSpacePluginDisplay.this.labels.length; ++i) {
                for (int j = 0; j < MSpacePluginDisplay.this.labels[i].length; ++j) {
                    MSpacePluginDisplay.this.labels[i][j].setBackgroundColor(c);
                }
            }
        }

        private void setForeground(Color c) {
            for (int i = 0; i < MSpacePluginDisplay.this.labels.length; ++i) {
                for (int j = 0; j < MSpacePluginDisplay.this.labels[i].length; ++j) {
                    MSpacePluginDisplay.this.labels[i][j].setForegroundColor(c);
                }
            }
        }

        private void monochromeLabels() {
            if (this.baseColorWhite) {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            } else {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            }
        }

        private void setColor(Label label, Color c) {
            if (this.invertColors) {
                label.setBackgroundColor(c);
                if (this.baseColorWhite) {
                    label.setForegroundColor(Color.white);
                } else {
                    label.setForegroundColor(Color.black);
                }
            } else {
                label.setForegroundColor(c);
                if (this.baseColorWhite) {
                    label.setBackgroundColor(Color.white);
                } else {
                    label.setBackgroundColor(Color.black);
                }
            }
        }

        private void colorLabels() {
            for (int i = 0; i < MSpacePluginDisplay.this.labels.length; ++i) {
                for (int j = 0; j < MSpacePluginDisplay.this.labels[i].length; ++j) {
                    float[] col = MSpacePluginDisplay.this.labelColors[i][j];
                    this.setColor(MSpacePluginDisplay.this.labels[i][j], new Color(col[0], col[1], col[2]));
                }
            }
        }

        private void colorMolecularLabels() {
            for (int i = 0; i < MSpacePluginDisplay.this.molecularLabels.size(); ++i) {
                Label label = (Label)MSpacePluginDisplay.this.molecularLabels.get(i);
                if (this.baseColorWhite) {
                    label.setBackgroundColor(Color.white);
                    label.setForegroundColor(Color.black);
                    continue;
                }
                label.setBackgroundColor(Color.black);
                label.setForegroundColor(Color.white);
            }
        }
    }
}

