/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.IonVisualizer;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.ProgressBarInterface;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.WaterVisualizer;
import chemaxon.marvin.space.util.Palette;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeIterators;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class MacroMoleculeComponent
extends GraphicComponent {
    protected static final int COMPONENT_TYPE_ATOM = 2;
    protected static final int COMPONENT_TYPE_BOND = 3;
    protected static final int COMPONENT_TYPE_MOLECULE = 4;
    protected static final int COMPONENT_TYPE_RESIDUE = 5;
    protected boolean initialised = false;
    private MacroMolecule macroMolecule = null;
    private ArrayList<MoleculeVisualizer> components = null;
    public static final int RAINBOW_MODE = 11;
    public static final int B_FACTOR_MODE = 12;
    private static byte[][] rainbow = new byte[][]{Colors.blue, Colors.cyan, Colors.green, Colors.yellow, Colors.red};
    Palette rainbowPalette = new Palette(0.0, 1.0);
    Palette bfactorPalette = new Palette(0.0, 1.0);
    ProgressBarInterface progressBar = null;

    protected MacroMoleculeComponent() {
    }

    public MacroMoleculeComponent(MacroMolecule mol) {
        this.macroMolecule = mol;
        this.initComponents();
        this.setBoundingBox();
        String name = this.macroMolecule.getName();
        if (name == null || name.length() == 0) {
            name = "Unknown";
        }
        this.setName(name);
    }

    @Override
    public void onRemoveGraphicComponent() {
        super.onRemoveGraphicComponent();
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).onRemove();
        }
    }

    @Override
    public void setProgressBar(ProgressBarInterface progressBar) {
        this.progressBar = progressBar;
    }

    public Molecule getMolecule() {
        Molecule m = new Molecule();
        this.macroMolecule.toMolecule(m);
        return m;
    }

    public MacroMolecule getMacroMolecule() {
        return this.macroMolecule;
    }

    @Override
    public void draw() {
        if (this.gl == null || this.macroMolecule == null) {
            return;
        }
        if (!this.initialised) {
            this.initialised = this.initDraw();
        }
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).draw();
        }
    }

    @Override
    public boolean has2DPart() {
        return false;
    }

    @Override
    public void draw2DPart() {
    }

    @Override
    public boolean hasTransparentPart() {
        return true;
    }

    @Override
    public void drawTransparentPart() {
        for (int i = 0; i < this.components.size(); ++i) {
            MoleculeVisualizer mv = this.components.get(i);
            if (!mv.hasTransparentPart()) continue;
            mv.drawTransparentPart();
        }
    }

    private void initComponents() {
        this.components = new ArrayList();
        int chn = 0;
        int calphaIndex = 0;
        float minBFactor = 100.0f;
        float maxBFactor = 0.0f;
        MacroMolecule.ComponentIterator ci = this.macroMolecule.getIterator();
        while (ci.hasNext()) {
            MacroMolecule.Component c = ci.next();
            if (c instanceof MacroMolecule.Polymer) {
                MoleculeIterators.AtomPropertyInterface props = c.getAtomProperty();
                MoleculeIterators.AtomIteratorInterface ai = c.getAtomIterator(true);
                ai.reset();
                while (ai.hasNext()) {
                    float bf = props.getBFactor(ai.current());
                    if (maxBFactor < bf) {
                        maxBFactor = bf;
                    }
                    if (minBFactor > bf) {
                        minBFactor = bf;
                    }
                    ai.next();
                }
                PolymerVisualizer pv = new PolymerVisualizer((MacroMolecule.Polymer)c, this);
                pv.setChainNumber(chn++);
                pv.setBFactorPalette(this.bfactorPalette);
                if (c instanceof MacroMolecule.Protein && ((MacroMolecule.Protein)c).getCAlphaAtomIterator().getCount() > 1) {
                    pv.setRainbowPalette(calphaIndex, this.rainbowPalette);
                    calphaIndex += ((MacroMolecule.Protein)c).getCAlphaAtomIterator().getCount();
                }
                this.components.add(pv);
                continue;
            }
            if (!(c instanceof MacroMolecule.HeteroComponent)) continue;
            MacroMolecule.HeteroComponent hc = (MacroMolecule.HeteroComponent)c;
            if (hc.isLigand()) {
                this.components.add(new MoleculeComponent(hc, this));
                continue;
            }
            if (hc instanceof MacroMolecule.Water) {
                this.components.add(new WaterVisualizer(hc, this));
                continue;
            }
            if (!hc.isIon()) continue;
            this.components.add(new IonVisualizer(hc, this));
        }
        Enumeration<?> e = this.drawProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.setVisualizerProperty(key, this.drawProperties.getProperty(key));
        }
        this.rainbowPalette.clear();
        this.rainbowPalette.putColors(rainbow);
        this.rainbowPalette.setMax(calphaIndex);
        this.bfactorPalette.clear();
        this.bfactorPalette.putColors(new byte[][]{Colors.blue, Colors.cyan, Colors.green, Colors.yellow});
        this.bfactorPalette.setMin(minBFactor);
        this.bfactorPalette.setMax(maxBFactor);
    }

    public Palette getRainbowPalette() {
        return this.rainbowPalette;
    }

    public Palette getBFactorPalette() {
        return this.bfactorPalette;
    }

    public Iterator<MoleculeVisualizer> getComponentIterator() {
        return this.components.iterator();
    }

    public ArrayList<MoleculeVisualizer> getComponents() {
        return this.components;
    }

    public MoleculeVisualizer getComponent(int cIdx) {
        return this.components.get(cIdx);
    }

    @Override
    public void setGL(GL gl, GLU glu) {
        this.gl = gl;
        this.glu = glu;
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).setGL(gl, glu);
        }
    }

    void setBoundingBox() {
        float e = 2.0f;
        this.boundingBox.clear();
        for (int i = 0; i < this.components.size(); ++i) {
            if (!this.components.get(i).isVisible() || !(this.components.get(i) instanceof MoleculeIterators.MoleculeInterface)) continue;
            this.setBoundingBox(this.components.get(i), (MoleculeIterators.MoleculeInterface)((Object)this.components.get(i)));
        }
        this.boundingBox.setMin(this.boundingBox.minx() - e, this.boundingBox.miny() - e, this.boundingBox.minz() - e);
        this.boundingBox.setMax(this.boundingBox.maxx() + e, this.boundingBox.maxy() + e, this.boundingBox.maxz() + e);
        this.boundingBox.ready();
    }

    private void setBoundingBox(MoleculeVisualizer mv, MoleculeIterators.MoleculeInterface c) {
        MoleculeIterators.AtomIteratorInterface ai = c.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if (mv.isAtomVisible(ai.current()) && !mv.isAtomFaded(ai.current())) {
                this.boundingBox.setWithCondition(ai.getX(), ai.getY(), ai.getZ());
            }
            ai.next();
        }
    }

    private boolean initDraw() {
        try {
            if (this.progressBar != null) {
                this.progressBar.setMessage("Initialize Component Rendering...");
                this.progressBar.setProgress(0);
                this.progressBar.start();
            }
            float step = (float)this.components.size() / 100.0f;
            int si = 0;
            int i = 0;
            while (i < this.components.size()) {
                this.components.get(i).initDraw();
                if (this.progressBar != null) {
                    this.progressBar.setProgress((int)((float)si * step));
                }
                ++i;
                ++si;
            }
            if (this.progressBar != null) {
                this.progressBar.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.progressBar != null) {
                this.progressBar.stop();
            }
            return false;
        }
        return true;
    }

    @Override
    protected void drawSelection(int mode) {
        this.drawAtomSelection(mode);
    }

    private void drawAtomSelection(int mode) {
        this.gl.glDisable(2896);
        this.gl.glDisable(2884);
        this.gl.glColor3d(1.0, 1.0, 1.0);
        for (int i = 0; i < this.components.size(); ++i) {
            MoleculeVisualizer c = this.components.get(i);
            if (!c.isVisible()) continue;
            if (mode == 7170) {
                this.gl.glPushName(i);
            }
            c.drawAtomSelection(mode);
            if (mode != 7170) continue;
            this.gl.glPopName();
        }
        this.gl.glEnable(2884);
        this.gl.glEnable(2896);
    }

    @Override
    public void getCoordinates(ComponentElement element, float[] c) {
        if (element.getElementType() == 1 && this.boundingBox != null) {
            float[] bc = this.boundingBox.getBoundingCenter();
            c[0] = bc[0];
            c[1] = bc[1];
            c[2] = bc[2];
            return;
        }
        MoleculeVisualizer mmv = this.components.get(element.getComponentPartId());
        if (element.getElementType() == 4) {
            float[] cbc = mmv.getBoundingBox().getBoundingCenter();
            c[0] = cbc[0];
            c[1] = cbc[1];
            c[2] = cbc[2];
            return;
        }
        if (element.getElementType() == 2 && mmv instanceof MoleculeIterators.MoleculeInterface) {
            c[0] = ((MoleculeIterators.MoleculeInterface)((Object)mmv)).getAtomProperty().getX(element.getElementIndex());
            c[1] = ((MoleculeIterators.MoleculeInterface)((Object)mmv)).getAtomProperty().getY(element.getElementIndex());
            c[2] = ((MoleculeIterators.MoleculeInterface)((Object)mmv)).getAtomProperty().getZ(element.getElementIndex());
        }
    }

    @Override
    public ComponentElement getComponentElement() {
        if (this.active) {
            this.pickedItem = new ComponentElement((GraphicComponent)this, 1, 0);
        } else {
            for (int i = 0; i < this.components.size(); ++i) {
                if (!this.components.get(i).isSelected()) continue;
                this.pickedItem = new ComponentElement((GraphicComponent)this, i, 4, 0);
                break;
            }
        }
        return this.pickedItem;
    }

    public ComponentElement getComponentElement(MoleculeVisualizer mv) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i) != mv) continue;
            return new ComponentElement((GraphicComponent)this, i, 4, 0);
        }
        return null;
    }

    public UOID getUsableObjectId(MoleculeVisualizer mv) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i) != mv) continue;
            return new UOID(this.uoid.getCellIndex(), this.uoid.getComponentIndex(), i);
        }
        return null;
    }

    @Override
    public UsableObject getUsableObject(UOID id) {
        if (id.getComponentPartIndex() == -1) {
            return this;
        }
        return (UsableObject)((Object)this.components.get(id.getComponentPartIndex()));
    }

    @Override
    public String getDescription(ComponentElement element) {
        if (element.getElementType() == 1) {
            return this.name;
        }
        MoleculeVisualizer mmv = this.components.get(element.getComponentPartId());
        return mmv.getDescription(element);
    }

    @Override
    public ComponentElement[] getLabelInformation(String labelType) {
        ArrayList<ComponentElement> ce = new ArrayList<ComponentElement>();
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentElement[] cei = this.components.get(i).getLabelInformation(labelType);
            ce.addAll(Arrays.asList(cei));
        }
        return ce.toArray(new ComponentElement[0]);
    }

    @Override
    public boolean isVisible() {
        for (int i = 0; i < this.components.size(); ++i) {
            if (!this.components.get(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible(ComponentElement element) {
        if (element.isComponentPart()) {
            return this.getComponent(element.getComponentPartId()).isVisible();
        }
        return this.visible;
    }

    @Override
    public void setVisible(boolean state) {
        super.setVisible(state);
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).setVisible(state);
        }
        this.setBoundingBox();
    }

    @Override
    public void showFaded() {
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).showFaded();
        }
        this.setBoundingBox();
    }

    @Override
    public void hideSelected() {
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).hideSelected();
        }
        this.setBoundingBox();
    }

    @Override
    public void hideUnselected() {
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).hideUnselected();
        }
        this.setBoundingBox();
    }

    @Override
    public void fadeSelected() {
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).fadeSelected();
        }
        this.setBoundingBox();
    }

    @Override
    public void fadeUnselected() {
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).fadeUnselected();
        }
        this.setBoundingBox();
    }

    @Override
    public void exclusiveSelection() {
        MoleculeVisualizer mmv;
        if (this.pickedItem == null) {
            return;
        }
        this.unSelect();
        if (this.pickedItem.getElementType() == 2 && (mmv = this.components.get(this.pickedItem.getComponentPartId())) instanceof MoleculeIterators.MoleculeInterface) {
            mmv.selectAtom(this.pickedItem.getElementIndex());
        }
        this.pickedItem = null;
    }

    @Override
    public void extendSelection() {
        MoleculeVisualizer mmv;
        if (this.pickedItem == null) {
            return;
        }
        if (this.isSelected(this.pickedItem)) {
            return;
        }
        if (this.pickedItem.getElementType() == 2 && (mmv = this.components.get(this.pickedItem.getComponentPartId())) instanceof MoleculeIterators.MoleculeInterface) {
            mmv.selectAtom(this.pickedItem.getElementIndex());
        }
        this.pickedItem = null;
    }

    @Override
    public void invertSelection() {
        MoleculeVisualizer mmv;
        if (this.pickedItem == null) {
            return;
        }
        if (this.pickedItem.getElementType() == 2 && (mmv = this.components.get(this.pickedItem.getComponentPartId())) instanceof MoleculeIterators.MoleculeInterface) {
            int i = this.pickedItem.getElementIndex();
            if (mmv.isSelectedAtom(i)) {
                mmv.unSelectAtom(i);
            } else {
                mmv.selectAtom(i);
            }
        }
        this.pickedItem = null;
    }

    @Override
    public void select() {
        super.select();
        for (int c = 0; c < this.components.size(); ++c) {
            MoleculeVisualizer mmv = this.components.get(c);
            if (!(mmv instanceof MoleculeIterators.MoleculeInterface)) continue;
            mmv.select();
        }
    }

    @Override
    public void unSelect() {
        super.unSelect();
        for (int c = 0; c < this.components.size(); ++c) {
            MoleculeVisualizer mmv = this.components.get(c);
            if (!(mmv instanceof MoleculeIterators.MoleculeInterface)) continue;
            mmv.unSelect();
        }
    }

    @Override
    public void selectComponentElementsInside(BoundingBox bb) {
        for (int c = 0; c < this.components.size(); ++c) {
            MoleculeVisualizer mmv = this.components.get(c);
            if (!(mmv instanceof MoleculeIterators.MoleculeInterface)) continue;
            mmv.selectComponentElementsInside(bb);
        }
    }

    @Override
    public boolean hasSelectedElements() {
        for (int c = 0; c < this.components.size(); ++c) {
            MoleculeVisualizer mmv = this.components.get(c);
            if (!(mmv instanceof MoleculeIterators.MoleculeInterface) || mmv.selectedAtomCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected double touchObject(int hits) {
        int offset = 0;
        this.pickedItem = null;
        float[] modelview = new float[16];
        this.gl.glGetFloatv(2982, modelview, 0);
        double[] maxZ = new double[]{-1.0};
        for (int i = 0; i < hits; ++i) {
            int names = this.selectBuf.get(offset);
            float z1 = (float)this.selectBuf.get(++offset) / 2.1474836E9f;
            float z2 = (float)this.selectBuf.get(++offset) / 2.1474836E9f;
            int cIdx = this.selectBuf.get(++offset);
            this.processAtomHit(cIdx, ++offset, maxZ, modelview);
            ++offset;
        }
        if (this.pickedItem != null) {
            // empty if block
        }
        return maxZ[0];
    }

    private void processAtomHit(int cIdx, int offset, double[] maxZ, float[] modelview) {
        MoleculeVisualizer c = this.components.get(cIdx);
        if (!(c instanceof MoleculeIterators.MoleculeInterface)) {
            return;
        }
        float x = ((MoleculeIterators.MoleculeInterface)((Object)c)).getAtomProperty().getX(this.selectBuf.get(offset));
        float y = ((MoleculeIterators.MoleculeInterface)((Object)c)).getAtomProperty().getY(this.selectBuf.get(offset));
        float z = ((MoleculeIterators.MoleculeInterface)((Object)c)).getAtomProperty().getZ(this.selectBuf.get(offset));
        int aIdx = GeomCalc.newVector(x, y, z);
        GeomCalc.multVectorWithMatrix(aIdx, modelview);
        if (maxZ[0] == -1.0) {
            maxZ[0] = GeomCalc.getZ(aIdx);
            this.pickedItem = new ComponentElement((GraphicComponent)this, cIdx, 2, this.selectBuf.get(offset));
        } else if ((double)GeomCalc.getZ(aIdx) > maxZ[0]) {
            maxZ[0] = GeomCalc.getZ(aIdx);
            this.pickedItem = new ComponentElement((GraphicComponent)this, cIdx, 2, this.selectBuf.get(offset));
        }
        GeomCalc.deleteVector(aIdx);
    }

    @Override
    public boolean isControllable(String type) {
        for (int c = 0; c < this.components.size(); ++c) {
            MoleculeVisualizer mv = this.components.get(c);
            if (!(mv instanceof MoleculeComponent) || !((MoleculeComponent)mv).isControllable(type)) continue;
            this.pickedItem = new ComponentElement((GraphicComponent)this, c, 1, 0);
            return true;
        }
        return false;
    }

    @Override
    public void translate(float[] vector) {
        for (int c = 0; c < this.components.size(); ++c) {
            MoleculeVisualizer mv = this.components.get(c);
            if (!(mv instanceof MoleculeComponent) || !mv.isSelected()) continue;
            ((MoleculeComponent)mv).translate(vector);
            this.notifyCoordinateChange();
            return;
        }
    }

    @Override
    public void rotate(float[] vector, float[] center) {
        for (int c = 0; c < this.components.size(); ++c) {
            MoleculeVisualizer mv = this.components.get(c);
            if (!(mv instanceof MoleculeComponent) || !mv.isSelected()) continue;
            ((MoleculeComponent)mv).rotate(vector, center);
            this.notifyCoordinateChange();
            return;
        }
    }

    private void setVisualizerProperty(String propertyName, String propertyValue) {
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).setDrawProperty(propertyName, propertyValue);
        }
    }

    private void setVisualizerProperty(String propertyName, String propertyValue, Class visualizerClass) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i).getClass() != visualizerClass) continue;
            this.components.get(i).setDrawProperty(propertyName, propertyValue);
        }
    }

    private void setVisualizerProperty(String propertyName, String propertyValue, MoleculeVisualizer mmv) {
        mmv.setDrawProperty(propertyName, propertyValue);
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) {
        this.storeDrawProperty(propertyName, propertyValue);
        if (propertyName.equals("DrawType")) {
            this.setVisualizerProperty(propertyName, propertyValue);
        } else if (propertyName.equals("ColorType")) {
            this.setVisualizerProperty(propertyName, propertyValue);
        } else if (propertyName.equals("Quality")) {
            this.setVisualizerProperty(propertyName, propertyValue);
        } else if (propertyName.equals("CarbonColorStyle")) {
            this.setVisualizerProperty(propertyName, propertyValue);
        } else if (propertyName.equals("ResidueColors")) {
            this.setVisualizerProperty(propertyName, propertyValue, PolymerVisualizer.class);
        } else if (propertyName.startsWith("Colors.")) {
            this.setVisualizerProperty(propertyName, propertyValue);
        } else if (propertyName.startsWith("MacroMolecule.")) {
            this.setVisualizerProperty(propertyName, propertyValue, PolymerVisualizer.class);
        } else if (propertyName.startsWith("Ligand.")) {
            this.setVisualizerProperty(propertyName, propertyValue, MoleculeComponent.class);
        } else if (propertyName.startsWith("Water.")) {
            this.setVisualizerProperty(propertyName, propertyValue, WaterVisualizer.class);
        } else if (propertyName.startsWith("Ion.")) {
            this.setVisualizerProperty(propertyName, propertyValue, IonVisualizer.class);
        }
    }

    public void setDrawProperty(String propertyName, String propertyValue, MoleculeVisualizer mmv) {
        if (propertyName.endsWith("DrawType")) {
            this.setVisualizerProperty(propertyName, propertyValue, mmv);
        } else if (propertyName.endsWith("ColorType")) {
            this.setVisualizerProperty(propertyName, propertyValue, mmv);
        } else if (propertyName.equals("Quality")) {
            this.setVisualizerProperty(propertyName, propertyValue, mmv);
        }
    }

    public static interface MoleculeVisualizer {
        public MacroMoleculeComponent getMacroMoleculeComponent();

        public void onRemove();

        public String getName();

        public void initDraw();

        public boolean hasTransparentPart();

        public void drawTransparentPart();

        public void draw();

        public void selectAtom(int var1);

        public void unSelectAtom(int var1);

        public boolean isSelectedAtom(int var1);

        public int selectedAtomCount();

        public String getDescription(ComponentElement var1);

        public ComponentElement[] getLabelInformation(String var1);

        public boolean isSelected();

        public void select();

        public void unSelect();

        public void selectComponentElementsInside(BoundingBox var1);

        public void drawAtomSelection(int var1);

        public void setGL(GL var1, GLU var2);

        public boolean isVisible();

        public void setVisible(boolean var1);

        public boolean isAtomVisible(int var1);

        public boolean isAtomFaded(int var1);

        public int getVisibleAtomCount();

        public void showFaded();

        public void hideSelected();

        public void hideUnselected();

        public void fadeSelected();

        public void fadeUnselected();

        public boolean isHighlighted();

        public void setHighlighted(boolean var1);

        public Color getColor();

        public int getColorType();

        public BoundingBox getBoundingBox();

        public String getDrawProperty(String var1);

        public void setDrawProperty(String var1, String var2);
    }
}

