/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.AtomProperty;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.VisibleMolecule;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeIterators;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class MoleculeComponent
extends GraphicComponent
implements MoleculeIterators.MoleculeInterface,
MacroMoleculeComponent.MoleculeVisualizer,
UsableObject {
    protected static final int DRAW_TYPE_WIRE = 2;
    protected static final int DRAW_TYPE_BALL = 3;
    protected static final int DRAW_TYPE_STICK = 4;
    protected static final int DRAW_TYPE_BALL_AND_WIRE = 5;
    protected static final int DRAW_TYPE_BALL_AND_STICK = 6;
    protected static final int DRAW_TYPE_SPACEFILL = 7;
    protected static final int BOND_DRAW_TYPE_BOND = 1;
    protected static final int BOND_DRAW_TYPE_STICK = 2;
    protected static final int BOND_DRAW_TYPE_WIRE = 3;
    protected static final double DEFAULT_BALL_RADIUS = 0.4;
    protected static final double DEFAULT_BOND_RADIUS = 0.1;
    protected static final double DEFAULT_STICK_RADIUS = 0.3;
    protected static final double DEFAULT_LINE_WIDTH = 2.0;
    protected static final int DEFAULT_BOND_DISTANCE = 100;
    protected static final int DEFAULT_BOND_WIDTH = 50;
    protected static final boolean SMOOTH_STICKS = false;
    protected static final boolean BOND_FACING = false;
    protected static final boolean SCALED_BALLS = false;
    protected static final boolean DISPLAY_BOND_ORDER = true;
    protected static final int DEFAULT_H_BALL_PRECISION = 4;
    protected static final int DEFAULT_H_SPACEFILL_PRECISION = 5;
    protected static final int DEFAULT_H_JOINT_PRECISION = 4;
    protected static final int DEFAULT_H_BOND_SLICE_PRECISION = 10;
    protected static final int DEFAULT_H_STICK_SLICE_PRECISION = 22;
    protected static final int DEFAULT_M_BALL_PRECISION = 3;
    protected static final int DEFAULT_M_SPACEFILL_PRECISION = 4;
    protected static final int DEFAULT_M_JOINT_PRECISION = 3;
    protected static final int DEFAULT_M_BOND_SLICE_PRECISION = 8;
    protected static final int DEFAULT_M_STICK_SLICE_PRECISION = 18;
    protected static final int DEFAULT_L_BALL_PRECISION = 2;
    protected static final int DEFAULT_L_SPACEFILL_PRECISION = 3;
    protected static final int DEFAULT_L_JOINT_PRECISION = 2;
    protected static final int DEFAULT_L_BOND_SLICE_PRECISION = 6;
    protected static final int DEFAULT_L_STICK_SLICE_PRECISION = 14;
    protected static final int COMPONENT_TYPE_ATOM = 2;
    protected static final int COMPONENT_TYPE_BOND = 3;
    protected static final int COMPONENT_TYPE_MOLECULE = 4;
    protected static final Color DEFAULT_COLOR = new Color(255, 240, 80);
    public static final int[] elementList = new int[]{0, 1, 6, 7, 8, 9, 11, 12, 15, 16, 17, 19, 20, 26, 29, 30, 35, 53};
    public static final int LONE_PAIR_TYPE = 130;
    protected static HashMap drawTypes = new HashMap();
    protected Molecule mol;
    protected MacroMoleculeComponent mmc;
    protected MacroMolecule.HeteroComponent hc;
    protected int drawType;
    protected boolean drawHydrogens;
    private boolean drawLonePairs;
    protected double ballRadius;
    protected double bondRadius;
    protected double stickRadius;
    protected double lineWidth;
    protected int bondDistance;
    protected int bondWidth;
    protected boolean smoothStickColoring;
    protected boolean bondFacing;
    protected boolean scaledBalls;
    protected boolean displayBondOrder;
    protected int ballPrecision;
    protected int spacefillPrecision;
    protected int bondSlicePrecision;
    protected int stickSlicePrecision;
    protected int jointPrecision;
    protected int colorType;
    protected boolean[] selectedAtoms;
    protected boolean selectionBeforeInit;
    protected Color color;
    VisibleMolecule visibleMolecule;
    MoleculeIterators.MoleculeAtomIterator atoms;
    MoleculeIterators.MoleculeAtomIterator atomsWithH;
    MoleculeIterators.MoleculeBondIterator bonds;
    MoleculeIterators.MoleculeBondIterator bondsWithH;
    AtomProperty.MoleculeAtomProperty atomProps;

    protected MoleculeComponent() {
        drawTypes.put("Wire", new Integer(2));
        drawTypes.put("Ball", new Integer(3));
        drawTypes.put("Stick", new Integer(4));
        drawTypes.put("BallAndWire", new Integer(5));
        drawTypes.put("WireAndBall", new Integer(5));
        drawTypes.put("BallAndStick", new Integer(6));
        drawTypes.put("StickAndBall", new Integer(6));
        drawTypes.put("Spacefill", new Integer(7));
        this.mol = null;
        this.mmc = null;
        this.hc = null;
        this.drawType = 6;
        this.drawHydrogens = false;
        this.drawLonePairs = true;
        this.ballRadius = 0.4;
        this.bondRadius = 0.1;
        this.stickRadius = 0.3;
        this.lineWidth = 2.0;
        this.bondDistance = 100;
        this.bondWidth = 50;
        this.smoothStickColoring = false;
        this.bondFacing = false;
        this.scaledBalls = false;
        this.displayBondOrder = true;
        this.ballPrecision = 3;
        this.spacefillPrecision = 4;
        this.bondSlicePrecision = 8;
        this.stickSlicePrecision = 18;
        this.jointPrecision = 3;
        this.colorType = 1;
        this.selectedAtoms = null;
        this.selectionBeforeInit = false;
        this.color = DEFAULT_COLOR;
        this.visibleMolecule = null;
        this.atoms = new MoleculeIterators().getMoleculeAtomIterator();
        this.atomsWithH = new MoleculeIterators().getMoleculeAtomIterator();
        this.bonds = new MoleculeIterators().getMoleculeBondIterator();
        this.bondsWithH = new MoleculeIterators().getMoleculeBondIterator();
        this.atomProps = new AtomProperty().getAtomProperty();
    }

    public MoleculeComponent(Molecule mol) {
        drawTypes.put("Wire", new Integer(2));
        drawTypes.put("Ball", new Integer(3));
        drawTypes.put("Stick", new Integer(4));
        drawTypes.put("BallAndWire", new Integer(5));
        drawTypes.put("WireAndBall", new Integer(5));
        drawTypes.put("BallAndStick", new Integer(6));
        drawTypes.put("StickAndBall", new Integer(6));
        drawTypes.put("Spacefill", new Integer(7));
        this.mol = null;
        this.mmc = null;
        this.hc = null;
        this.drawType = 6;
        this.drawHydrogens = false;
        this.drawLonePairs = true;
        this.ballRadius = 0.4;
        this.bondRadius = 0.1;
        this.stickRadius = 0.3;
        this.lineWidth = 2.0;
        this.bondDistance = 100;
        this.bondWidth = 50;
        this.smoothStickColoring = false;
        this.bondFacing = false;
        this.scaledBalls = false;
        this.displayBondOrder = true;
        this.ballPrecision = 3;
        this.spacefillPrecision = 4;
        this.bondSlicePrecision = 8;
        this.stickSlicePrecision = 18;
        this.jointPrecision = 3;
        this.colorType = 1;
        this.selectedAtoms = null;
        this.selectionBeforeInit = false;
        this.color = DEFAULT_COLOR;
        this.visibleMolecule = null;
        this.atoms = new MoleculeIterators().getMoleculeAtomIterator();
        this.atomsWithH = new MoleculeIterators().getMoleculeAtomIterator();
        this.bonds = new MoleculeIterators().getMoleculeBondIterator();
        this.bondsWithH = new MoleculeIterators().getMoleculeBondIterator();
        this.atomProps = new AtomProperty().getAtomProperty();
        this.setMolecule(mol);
    }

    public MoleculeComponent(MacroMolecule.HeteroComponent hc, MacroMoleculeComponent mmc) {
        drawTypes.put("Wire", new Integer(2));
        drawTypes.put("Ball", new Integer(3));
        drawTypes.put("Stick", new Integer(4));
        drawTypes.put("BallAndWire", new Integer(5));
        drawTypes.put("WireAndBall", new Integer(5));
        drawTypes.put("BallAndStick", new Integer(6));
        drawTypes.put("StickAndBall", new Integer(6));
        drawTypes.put("Spacefill", new Integer(7));
        this.mol = null;
        this.mmc = null;
        this.hc = null;
        this.drawType = 6;
        this.drawHydrogens = false;
        this.drawLonePairs = true;
        this.ballRadius = 0.4;
        this.bondRadius = 0.1;
        this.stickRadius = 0.3;
        this.lineWidth = 2.0;
        this.bondDistance = 100;
        this.bondWidth = 50;
        this.smoothStickColoring = false;
        this.bondFacing = false;
        this.scaledBalls = false;
        this.displayBondOrder = true;
        this.ballPrecision = 3;
        this.spacefillPrecision = 4;
        this.bondSlicePrecision = 8;
        this.stickSlicePrecision = 18;
        this.jointPrecision = 3;
        this.colorType = 1;
        this.selectedAtoms = null;
        this.selectionBeforeInit = false;
        this.color = DEFAULT_COLOR;
        this.visibleMolecule = null;
        this.atoms = new MoleculeIterators().getMoleculeAtomIterator();
        this.atomsWithH = new MoleculeIterators().getMoleculeAtomIterator();
        this.bonds = new MoleculeIterators().getMoleculeBondIterator();
        this.bondsWithH = new MoleculeIterators().getMoleculeBondIterator();
        this.atomProps = new AtomProperty().getAtomProperty();
        this.mmc = mmc;
        this.hc = hc;
        this.setMolecule(hc.getMolecule());
    }

    @Override
    public void onRemoveGraphicComponent() {
        super.onRemoveGraphicComponent();
        if (this.visibleMolecule != null) {
            this.visibleMolecule.onRemove();
            this.visibleMolecule = null;
        }
        this.mmc = null;
        this.mol = null;
        this.hc = null;
        this.selectedAtoms = null;
    }

    @Override
    public void onRemove() {
        this.onRemoveGraphicComponent();
    }

    @Override
    public boolean isGraphicComponent() {
        return this.mmc == null;
    }

    @Override
    public GraphicComponent getGraphicComponent() {
        if (this.isGraphicComponent()) {
            return this;
        }
        return this.mmc;
    }

    @Override
    public UOID getId() {
        if (this.mmc != null && this.uoid == null) {
            this.uoid = this.mmc.getUsableObjectId(this);
        }
        return this.uoid;
    }

    public void setMacroMoleculeComponent(MacroMoleculeComponent mmc) {
        this.mmc = mmc;
    }

    public boolean isMacromoleculePart() {
        return this.mmc != null;
    }

    @Override
    public MacroMoleculeComponent getMacroMoleculeComponent() {
        return this.mmc;
    }

    @Override
    public void setGL(GL gl, GLU glu) {
        this.gl = gl;
        this.glu = glu;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.colorTypeChanged();
        }
    }

    @Override
    public void setColor(float r, float g, float b) {
        this.color = new Color(r, g, b);
        if (this.visibleMolecule != null) {
            this.visibleMolecule.colorTypeChanged();
        }
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    public void setMolecule(Molecule mol) {
        this.mol = mol;
        this.atoms.setMolecule(mol, false);
        this.bonds.setMolecule(mol, false);
        this.atomProps.setMolecule(mol);
        this.atomsWithH.setMolecule(mol, true);
        this.bondsWithH.setMolecule(mol, true);
        this.selectedAtoms = new boolean[this.atomsWithH.getMaxIndex() + 1];
        this.setBoundingBox();
        String name = mol.getName();
        if (name == null || name.length() == 0) {
            name = "Ligand";
        }
        this.setName(name);
    }

    @Override
    public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean enumerateHydrogens) {
        return enumerateHydrogens ? this.atomsWithH : this.atoms;
    }

    @Override
    public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
        return this.atomProps;
    }

    @Override
    public MoleculeIterators.BondIteratorInterface getBondIterator(boolean enumerateHydrogens) {
        return enumerateHydrogens ? this.bondsWithH : this.bonds;
    }

    @Override
    public int getAtomCount(boolean enumerateHydrogens) {
        return enumerateHydrogens ? this.atomsWithH.getCount() : this.atoms.getCount();
    }

    @Override
    public int getBondCount(boolean enumerateHydrogens) {
        return enumerateHydrogens ? this.bondsWithH.getCount() : this.bonds.getCount();
    }

    @Override
    public void translate(float[] v) {
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            MolAtom ma = this.mol.getAtom(i);
            ma.setX(ma.getX() + (double)v[0]);
            ma.setY(ma.getY() + (double)v[1]);
            ma.setZ(ma.getZ() + (double)v[2]);
        }
        super.translate(v);
        this.visibleMolecule.coordinatesChanged();
    }

    @Override
    public void rotate(float[] v, float[] center) {
        double sinx = Math.sin(v[0]);
        double siny = Math.sin(v[1]);
        double sinz = Math.sin(v[2]);
        double cosx = Math.cos(v[0]);
        double cosy = Math.cos(v[1]);
        double cosz = Math.cos(v[2]);
        int centerV = GeomCalc.newVector(center);
        int n = GeomCalc.newVector();
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            MolAtom ma = this.mol.getAtom(i);
            GeomCalc.setVector(n, (float)ma.getX(), (float)ma.getY(), (float)ma.getZ());
            GeomCalc.decrease(n, centerV);
            GeomCalc.rotateX(n, sinx, cosx);
            GeomCalc.rotateY(n, siny, cosy);
            GeomCalc.rotateZ(n, sinz, cosz);
            GeomCalc.increase(n, centerV);
            ma.setX(GeomCalc.getX(n));
            ma.setY(GeomCalc.getY(n));
            ma.setZ(GeomCalc.getZ(n));
        }
        this.setBoundingBox();
        GeomCalc.deleteVector(n);
        GeomCalc.deleteVector(centerV);
        this.visibleMolecule.coordinatesChanged();
        this.notifyCoordinateChange();
    }

    public void torsion(double angle, float[] axis, float[] center, int[] atomArray) {
        float[] glrotm = new float[16];
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glRotated(angle, (double)axis[0], (double)axis[1], (double)axis[2]);
        this.gl.glGetFloatv(2982, glrotm, 0);
        this.gl.glPopMatrix();
        int centerV = GeomCalc.newVector(center);
        int n = GeomCalc.newVector();
        for (int i = 0; i < atomArray.length; ++i) {
            MolAtom ma = this.mol.getAtom(atomArray[i]);
            GeomCalc.setVector(n, (float)ma.getX(), (float)ma.getY(), (float)ma.getZ());
            GeomCalc.decrease(n, centerV);
            GeomCalc.multVectorWithMatrix(n, glrotm);
            GeomCalc.increase(n, centerV);
            ma.setX(GeomCalc.getX(n));
            ma.setY(GeomCalc.getY(n));
            ma.setZ(GeomCalc.getZ(n));
        }
        GeomCalc.deleteVector(n);
        GeomCalc.deleteVector(centerV);
        this.setBoundingBox();
        this.visibleMolecule.coordinatesChanged();
        this.notifyCoordinateChange();
    }

    @Override
    public boolean isControllable(String type) {
        if (!this.active) {
            return false;
        }
        if (type.equalsIgnoreCase("Shift")) {
            return true;
        }
        return type.equalsIgnoreCase("Rotate");
    }

    protected void setBoundingBox() {
        float e = 2.0f;
        if (this.mol.getAtomCount() == 0) {
            return;
        }
        this.boundingBox.clear();
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.isAtomVisible(this.atomsWithH.current())) {
                this.boundingBox.setWithCondition(this.atomsWithH.getX(), this.atomsWithH.getY(), this.atomsWithH.getZ());
            }
            this.atomsWithH.next();
        }
        this.boundingBox.setMin(this.boundingBox.minx() - e, this.boundingBox.miny() - e, this.boundingBox.minz() - e);
        this.boundingBox.setMax(this.boundingBox.maxx() + e, this.boundingBox.maxy() + e, this.boundingBox.maxz() + e);
        this.boundingBox.ready();
    }

    @Override
    public void initDraw() {
        if (this.visibleMolecule == null) {
            this.visibleMolecule = new VisibleMolecule(this.gl, this.glu, this);
            this.setValues();
            this.visibleMolecule.init();
            if (this.selectionBeforeInit) {
                for (int i = 0; i < this.selectedAtoms.length; ++i) {
                    if (!this.selectedAtoms[i]) continue;
                    this.visibleMolecule.selectAtom(i);
                }
            }
        }
    }

    private void setValues() {
        this.visibleMolecule.drawHydrogens = this.drawHydrogens;
        this.visibleMolecule.drawLonePairs = this.drawLonePairs;
        this.visibleMolecule.quality = this.renderingQuality;
        this.visibleMolecule.oldStyleStickColoring = !this.smoothStickColoring;
        this.visibleMolecule.bondFacing = this.bondFacing;
        this.visibleMolecule.scaledBalls = this.scaledBalls;
        this.visibleMolecule.displayBondOrder = this.displayBondOrder;
        this.visibleMolecule.colorType = this.colorType;
        this.visibleMolecule.drawType = this.drawType;
        this.visibleMolecule.ballRadius = this.ballRadius;
        this.visibleMolecule.bondRadius = this.bondRadius;
        this.visibleMolecule.stickRadius = this.stickRadius;
        this.visibleMolecule.lineWidth = this.lineWidth;
        this.visibleMolecule.bondDistance = this.bondDistance;
        this.visibleMolecule.bondWidth = this.bondWidth;
        this.visibleMolecule.jointRadius = this.stickRadius - 0.005;
        this.visibleMolecule.ballPrecision = this.ballPrecision;
        this.visibleMolecule.spacefillPrecision = this.spacefillPrecision;
        this.visibleMolecule.bondSlicePrecision = this.bondSlicePrecision;
        this.visibleMolecule.stickSlicePrecision = this.stickSlicePrecision;
        this.visibleMolecule.jointPrecision = this.jointPrecision;
    }

    @Override
    public void draw() {
        int errorCode;
        String errorString;
        if (this.gl == null || this.mol == null || !this.visible) {
            return;
        }
        this.initDraw();
        if (this.visibleMolecule != null) {
            this.visibleMolecule.draw();
        }
        if ((errorString = this.glu.gluErrorString(errorCode = this.gl.glGetError())) != null && !errorString.equals("no error")) {
            System.out.println("Draw:  >>>  " + errorString + "  <<<  ");
        }
    }

    @Override
    public void drawTransparentPart() {
        int errorCode;
        String errorString;
        if (this.gl == null || this.mol == null || !this.visible) {
            return;
        }
        this.initDraw();
        if (this.gl.glIsList(this.visibleMolecule.getDisplayList2D())) {
            this.gl.glCallList(this.visibleMolecule.getDisplayList2D());
        }
        if ((errorString = this.glu.gluErrorString(errorCode = this.gl.glGetError())) != null && !errorString.equals("no error")) {
            System.out.println("Draw Transparent:  >>>  " + errorString + "  <<<  ");
        }
    }

    @Override
    public ComponentElement getComponentElement() {
        if (this.mmc != null) {
            return this.mmc.getComponentElement(this);
        }
        if (this.active || this.isSelected()) {
            this.pickedItem = new ComponentElement((GraphicComponent)this, 1, 0);
            this.pickedItem.setDescription(this.getName());
        }
        return this.pickedItem;
    }

    @Override
    public void getCoordinates(ComponentElement element, float[] c) {
        this.getDescription(element);
        switch (element.getElementType()) {
            case 2: {
                MolAtom mola = this.mol.getAtom(element.getElementIndex());
                c[0] = (float)mola.getX();
                c[1] = (float)mola.getY();
                c[2] = (float)mola.getZ();
            }
        }
        super.getCoordinates(element, c);
    }

    @Override
    public String getDescription(ComponentElement element) {
        if (element.getElementType() == 2) {
            return this.getAtomLabel(element.getElementIndex());
        }
        return this.getName();
    }

    private String getAtomLabel(int i) {
        if (this.hc != null) {
            return this.hc.getAtomLabel(i);
        }
        if (this.mol.getAtom(i).getAliasstr() != null) {
            return this.mol.getAtom(i).getAliasstr();
        }
        String name = this.mol.getAtom(i).getSymbol();
        if (this.mol.getAtom(i).getExtraLabel() != null) {
            name = name + " " + this.mol.getAtom(i).getExtraLabel();
        }
        return name;
    }

    public boolean isLigand() {
        if (this.hc != null) {
            return this.hc.isLigand();
        }
        return false;
    }

    @Override
    public ComponentElement[] getLabelInformation(String labeltype, boolean onlyOnHeavyAtoms) {
        if (labeltype.equalsIgnoreCase("atom")) {
            ComponentElement[] ce = new ComponentElement[this.getAtomCount(true)];
            int i = 0;
            ComponentElement cethis = null;
            if (this.mmc != null) {
                cethis = this.mmc.getComponentElement(this);
            }
            this.atomsWithH.reset();
            while (this.atomsWithH.hasNext()) {
                if (this.isAtomVisible(this.atomsWithH.current()) && (this.mol.getAtom(this.atomsWithH.current()).getAtno() != 1 || !onlyOnHeavyAtoms)) {
                    ce[i] = this.mmc != null ? new ComponentElement(cethis.getComponent(), cethis.getComponentPartId(), 2, this.atomsWithH.current()) : new ComponentElement((GraphicComponent)this, 2, this.atomsWithH.current());
                    ce[i].setDescription(this.getAtomLabel(this.atomsWithH.current()));
                    ++i;
                }
                this.atomsWithH.next();
            }
            ComponentElement[] ret = new ComponentElement[i];
            System.arraycopy(ce, 0, ret, 0, i);
            return ret;
        }
        if (labeltype.equalsIgnoreCase("extraatomlabel")) {
            ComponentElement[] ce = new ComponentElement[this.getAtomCount(true)];
            int i = 0;
            this.atomsWithH.reset();
            while (this.atomsWithH.hasNext()) {
                ce[i] = new ComponentElement((GraphicComponent)this, 2, this.atomsWithH.current());
                if (this.mol.getAtom(i).getExtraLabel() != null) {
                    ce[i].setDescription(this.mol.getAtom(i).getExtraLabel());
                } else {
                    ce[i].setDescription(" ");
                }
                this.atomsWithH.next();
                ++i;
            }
            return ce;
        }
        if (labeltype.equalsIgnoreCase("molecule")) {
            if (this.mmc != null) {
                return new ComponentElement[]{this.mmc.getComponentElement(this)};
            }
            return new ComponentElement[]{new ComponentElement((GraphicComponent)this, 1, 0)};
        }
        return new ComponentElement[0];
    }

    @Override
    public ComponentElement[] getLabelInformation(String labeltype) {
        return this.getLabelInformation(labeltype, false);
    }

    @Override
    public boolean isSelectedAtom(int atomIndex) {
        return this.visibleMolecule == null ? this.selectedAtoms[atomIndex] : this.visibleMolecule.isSelectedAtom(atomIndex);
    }

    public MolAtom getSelectedAtom(int i) {
        if (this.hc != null) {
            return null;
        }
        return this.mol.getAtom(i);
    }

    public boolean[] getAtomSelections() {
        return this.visibleMolecule == null ? this.selectedAtoms : this.visibleMolecule.selectedAtoms;
    }

    @Override
    public void selectAtom(int i) {
        if (this.visibleMolecule != null) {
            this.visibleMolecule.selectAtom(i);
        } else {
            this.selectedAtoms[i] = true;
            this.selectionBeforeInit = true;
        }
    }

    @Override
    public void unSelectAtom(int i) {
        if (this.visibleMolecule != null) {
            this.visibleMolecule.unSelectAtom(i);
        } else {
            this.selectedAtoms[i] = false;
        }
    }

    public void selectAllAtoms() {
        if (this.visibleMolecule != null) {
            this.atomsWithH.reset();
            while (this.atomsWithH.hasNext()) {
                if (this.isAtomVisible(this.atomsWithH.current())) {
                    this.visibleMolecule.selectAtom(this.atomsWithH.current());
                }
                this.atomsWithH.next();
            }
        } else {
            Arrays.fill(this.selectedAtoms, true);
            this.selectionBeforeInit = true;
        }
    }

    public void unSelectAllAtoms() {
        if (this.visibleMolecule != null) {
            for (int i = 0; i < this.getAtomCount(true); ++i) {
                if (this.visibleMolecule.selectedAtomCount() == 0) {
                    return;
                }
                this.visibleMolecule.unSelectAtom(i);
            }
        } else {
            Arrays.fill(this.selectedAtoms, false);
        }
    }

    @Override
    public void setVisible(boolean v) {
        if (v && this.getVisibleAtomCount() < this.getAtomCount(this.drawHydrogens)) {
            this.atomsWithH.reset();
            while (this.atomsWithH.hasNext()) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), this.visibleMolecule.drawType);
                this.atomsWithH.next();
            }
        }
        this.visible = v;
        this.setBoundingBox();
        if (this.mmc != null) {
            this.mmc.setBoundingBox();
        } else if (v) {
            this.notifyVisibility();
        } else {
            this.notifyInvisibility();
        }
    }

    @Override
    public void showFaded() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.isAtomFaded(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), this.visibleMolecule.drawType);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void hideSelected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.unSelectAtom(this.atomsWithH.current());
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -1);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void hideUnselected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (!this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -1);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void fadeSelected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.unSelectAtom(this.atomsWithH.current());
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -2);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void fadeUnselected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.isAtomVisible(this.atomsWithH.current()) && !this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -2);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public boolean isHighlighted() {
        return this.visibleMolecule.isHighlighted();
    }

    @Override
    public void setHighlighted(boolean v) {
        this.visibleMolecule.setHighlighted(v);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public boolean isVisible(ComponentElement item) {
        if (!this.visible) {
            return false;
        }
        switch (item.getElementType()) {
            case 2: {
                return this.isAtomVisible(item.getElementIndex());
            }
        }
        return this.visible;
    }

    @Override
    public boolean isAtomVisible(int i) {
        if (!this.visible) {
            return false;
        }
        if (this.visibleMolecule == null) {
            return true;
        }
        return this.visibleMolecule.isAtomVisible(i);
    }

    @Override
    public boolean isAtomFaded(int i) {
        if (this.visibleMolecule == null) {
            return false;
        }
        return this.visibleMolecule.isAtomFaded(i);
    }

    @Override
    public int getVisibleAtomCount() {
        if (!this.visible) {
            return 0;
        }
        if (this.visibleMolecule == null) {
            return this.getAtomCount(true);
        }
        int c = 0;
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isAtomVisible(this.atomsWithH.current())) {
                ++c;
            }
            this.atomsWithH.next();
        }
        return c;
    }

    @Override
    public boolean hasTransparentPart() {
        return this.visibleMolecule != null && (this.visibleMolecule.drawType == 2 || this.visibleMolecule.drawType == 5);
    }

    @Override
    public void select() {
        super.select();
        this.selectAllAtoms();
    }

    @Override
    public void unSelect() {
        super.unSelect();
        this.pickedItem = null;
        this.unSelectAllAtoms();
    }

    @Override
    public void selectComponentElementsInside(BoundingBox bb) {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (bb.contains(this.atomsWithH.getX(), this.atomsWithH.getY(), this.atomsWithH.getZ())) {
                this.visibleMolecule.selectAtom(this.atomsWithH.current());
            }
            this.atomsWithH.next();
        }
    }

    @Override
    public boolean isSelected(ComponentElement item) {
        if (item.getElementType() == 1) {
            return this.isSelected();
        }
        if (item.getElementType() == 2) {
            return this.visibleMolecule.isSelectedAtom(item.getElementIndex());
        }
        return false;
    }

    @Override
    public boolean isSelected() {
        return this.getVisibleAtomCount() <= this.visibleMolecule.selectedAtomCount() && this.visibleMolecule.selectedAtomCount() > 0;
    }

    @Override
    public boolean hasSelectedElements() {
        if (this.visibleMolecule != null) {
            return this.visibleMolecule.selectedAtomCount() > 0;
        }
        for (int i = 0; i < this.selectedAtoms.length; ++i) {
            if (!this.selectedAtoms[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int selectedAtomCount() {
        return this.visibleMolecule.selectedAtomCount();
    }

    @Override
    public void exclusiveSelection() {
        if (this.pickedItem == null) {
            return;
        }
        if (this.pickedItem.getElementType() == 2) {
            for (int i = 0; i < this.getAtomCount(true) && this.visibleMolecule.selectedAtomCount() != 0; ++i) {
                this.unSelectAtom(i);
            }
            this.selectAtom(this.pickedItem.getElementIndex());
        }
        this.pickedItem = null;
    }

    @Override
    public void extendSelection() {
        if (this.pickedItem == null) {
            return;
        }
        if (this.isSelected(this.pickedItem)) {
            return;
        }
        if (this.pickedItem.getElementType() == 2) {
            this.selectAtom(this.pickedItem.getElementIndex());
        }
        this.pickedItem = null;
    }

    @Override
    public void invertSelection() {
        if (this.pickedItem == null) {
            return;
        }
        int i = this.pickedItem.getElementIndex();
        this.pickedItem = null;
        if (this.visibleMolecule.isSelectedAtom(i)) {
            this.unSelectAtom(i);
        } else {
            this.selectAtom(i);
        }
    }

    @Override
    protected void drawSelection(int mode) {
        int errorCode;
        String errorString;
        if (mode == 7170) {
            this.gl.glPushName(1);
        }
        this.drawAtomSelection(mode);
        if (mode == 7170) {
            this.gl.glPopName();
        }
        if ((errorString = this.glu.gluErrorString(errorCode = this.gl.glGetError())) != null && !errorString.equals("no error")) {
            System.out.println("DrawSelection:  >>>  " + errorString + "  <<<  ");
        }
    }

    @Override
    public void drawAtomSelection(int mode) {
        if (this.visibleMolecule != null) {
            int matrix = this.mmc == null ? this.irm : this.mmc.irm;
            this.visibleMolecule.drawAtomSelection(mode, matrix);
        }
    }

    @Override
    protected void pickObject(int offset, double[] maxZ, float[] modelview) {
        float x = this.atomProps.getX(this.selectBuf.get(offset));
        float y = this.atomProps.getY(this.selectBuf.get(offset));
        float z = this.atomProps.getZ(this.selectBuf.get(offset));
        int aIdx = GeomCalc.newVector(x, y, z);
        GeomCalc.multVectorWithMatrix(aIdx, modelview);
        if (maxZ[0] == -1.0) {
            this.pickedItem = new ComponentElement((GraphicComponent)this, 2, this.selectBuf.get(offset));
            this.pickedItem.setDescription(this.getAtomLabel(this.selectBuf.get(offset)));
            if (this.isVisible(this.pickedItem)) {
                maxZ[0] = GeomCalc.getZ(aIdx);
            }
        } else if ((double)GeomCalc.getZ(aIdx) > maxZ[0]) {
            this.pickedItem = new ComponentElement((GraphicComponent)this, 2, this.selectBuf.get(offset));
            this.pickedItem.setDescription(this.getAtomLabel(this.selectBuf.get(offset)));
            if (this.isVisible(this.pickedItem)) {
                maxZ[0] = GeomCalc.getZ(aIdx);
            }
        }
        GeomCalc.deleteVector(aIdx);
    }

    private void setDrawType(String drawType) {
        try {
            this.drawType = (Integer)drawTypes.get(drawType);
        }
        catch (Exception e) {
            System.out.println("Unexpected type of draw: " + drawType);
        }
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawType = this.drawType;
            this.visibleMolecule.drawTypeChanged();
        }
    }

    @Override
    public int getColorType() {
        return this.colorType;
    }

    private void setColorType(String propertyValue) {
        this.colorType = propertyValue.equals("CPK") ? 1 : 2;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.colorType = this.colorType;
            this.visibleMolecule.colorTypeChanged();
        }
    }

    private void setQuality(int quality) {
        if (this.renderingQuality == quality) {
            return;
        }
        this.renderingQuality = quality;
        if (this.renderingQuality == 2) {
            this.ballPrecision = 3;
            this.spacefillPrecision = 4;
            this.jointPrecision = 3;
            this.stickSlicePrecision = 18;
            this.bondSlicePrecision = 8;
        } else if (this.renderingQuality == 3) {
            this.ballPrecision = 4;
            this.spacefillPrecision = 5;
            this.jointPrecision = 4;
            this.stickSlicePrecision = 22;
            this.bondSlicePrecision = 10;
        } else if (this.renderingQuality == 1) {
            this.ballPrecision = 2;
            this.spacefillPrecision = 3;
            this.jointPrecision = 2;
            this.stickSlicePrecision = 14;
            this.bondSlicePrecision = 6;
        }
        if (this.visibleMolecule != null) {
            this.setValues();
            this.visibleMolecule.qualityChanged();
        }
    }

    private void setQuality(String quality) {
        if (quality.equalsIgnoreCase("medium") && this.renderingQuality != 2) {
            this.setQuality(2);
        } else if (quality.equalsIgnoreCase("high") && this.renderingQuality != 3) {
            this.setQuality(3);
        } else if (quality.equalsIgnoreCase("low") && this.renderingQuality != 1) {
            this.setQuality(1);
        }
    }

    private void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.lineWidth = lineWidth;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setBallRadius(double radius) {
        this.ballRadius = radius;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.ballRadius = this.ballRadius;
            this.visibleMolecule.needRecreateOneBall = true;
        }
    }

    private void setBondRadius(double radius) {
        this.bondRadius = radius;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondRadius = this.bondRadius;
            this.visibleMolecule.needRecreateOneBond = true;
            this.visibleMolecule.needRecreateOneAromaticRing = true;
            this.visibleMolecule.needRecreateAromaticRings = true;
            if (this.smoothStickColoring) {
                this.visibleMolecule.needRecreateBonds = true;
                this.visibleMolecule.needRecreateSticks = true;
            }
        }
    }

    private void setStickRadius(double radius) {
        this.stickRadius = radius;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.stickRadius = this.stickRadius;
            this.visibleMolecule.jointRadius = this.stickRadius - 0.005;
            this.visibleMolecule.needRecreateOneStick = true;
            this.visibleMolecule.needRecreateOneJoint = true;
            if (this.smoothStickColoring) {
                this.visibleMolecule.needRecreateBonds = true;
                this.visibleMolecule.needRecreateSticks = true;
            }
        }
    }

    private void setBondDistance(int bondDistance) {
        this.bondDistance = bondDistance;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondDistance = bondDistance;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setBondWidth(int bondWidth) {
        this.bondWidth = bondWidth;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondWidth = bondWidth;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void showHydrogens(boolean flag) {
        if (this.drawHydrogens == flag) {
            return;
        }
        this.drawHydrogens = flag;
        if (this.visibleMolecule != null) {
            if (flag && this.visibleMolecule.selectedAtomCount() == this.getAtomCount(false)) {
                this.selectAllAtoms();
            }
            this.visibleMolecule.drawHydrogens = flag;
            this.visibleMolecule.showHydrogensChanged();
        }
    }

    private void showLonePairs(boolean flag) {
        if (this.drawLonePairs == flag) {
            return;
        }
        this.drawLonePairs = flag;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawLonePairs = flag;
            this.visibleMolecule.showHydrogensChanged();
        }
    }

    private void setSmoothStickStyle(boolean style) {
        this.smoothStickColoring = style;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.oldStyleStickColoring = !this.smoothStickColoring;
            this.visibleMolecule.stickStyleChanged();
        }
    }

    private void setBondFacing(boolean facing) {
        this.bondFacing = facing;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondFacing = facing;
            this.visibleMolecule.needRecreateDynamicDrawables = true;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateGlobalBonds = true;
            this.visibleMolecule.needRecreateWire = true;
            this.visibleMolecule.needRecreateDisplayList = true;
        }
    }

    private void setScaledBalls(boolean b) {
        this.scaledBalls = b;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.scaledBalls = this.scaledBalls;
            this.visibleMolecule.needRecreateBalls = true;
        }
    }

    private void setDisplayBondOrder(boolean b) {
        this.displayBondOrder = b;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.displayBondOrder = this.displayBondOrder;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) {
        if (propertyName.equals("Quality")) {
            this.setDrawProperty("Ligand.Quality", propertyValue);
            return;
        }
        if (propertyName.equals("DrawType")) {
            this.setDrawProperty("Ligand.DrawType", propertyValue);
            return;
        }
        if (propertyName.equals("ColorType")) {
            this.setDrawProperty("Ligand.ColorType", propertyValue);
            return;
        }
        if (propertyName.startsWith("Colors.")) {
            this.storeDrawProperty(propertyName, propertyValue);
            if (this.visibleMolecule != null) {
                this.visibleMolecule.colorTypeChanged();
            }
            return;
        }
        if (!propertyName.startsWith("Ligand")) {
            return;
        }
        this.storeDrawProperty(propertyName, propertyValue);
        if (propertyName.equals("Ligand.DrawType")) {
            this.setDrawType(propertyValue);
        } else if (propertyName.equals("Ligand.Hydrogens")) {
            this.showHydrogens(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Ligand.LonePairs")) {
            this.showLonePairs(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Ligand.ColorType")) {
            this.setColorType(propertyValue);
        } else if (propertyName.equals("Ligand.Quality")) {
            this.setQuality(propertyValue);
        } else if (propertyName.equals("Ligand.BallRadius")) {
            this.setBallRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("Ligand.BondRadius")) {
            this.setBondRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("Ligand.StickRadius")) {
            this.setStickRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("Ligand.LineWidth")) {
            this.setLineWidth(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("Ligand.BondDistance")) {
            this.setBondDistance(Integer.parseInt(propertyValue));
        } else if (propertyName.equals("Ligand.BondWidth")) {
            this.setBondWidth(Integer.parseInt(propertyValue));
        } else if (propertyName.equals("Ligand.SmoothStickStyle")) {
            this.setSmoothStickStyle(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Ligand.BondFacing")) {
            this.setBondFacing(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Ligand.ScaledBalls")) {
            this.setScaledBalls(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Ligand.DisplayBondOrder")) {
            this.setDisplayBondOrder(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Ligand.Color")) {
            this.setColor(Color.decode(propertyValue));
        } else if (propertyName.equals("Ligand.Visible")) {
            this.setVisible(Boolean.valueOf(propertyValue));
        } else {
            System.out.println("Undefined draw property: " + propertyName + ", " + propertyValue);
        }
    }
}

