/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.VisibleMolecule;
import chemaxon.marvin.space.util.Palette;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeIterators;
import java.awt.Color;
import java.util.HashMap;
import java.util.Properties;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class PolymerVisualizer
implements MoleculeIterators.MoleculeInterface,
MacroMoleculeComponent.MoleculeVisualizer,
UsableObject {
    protected static final int DEFAULT_H_BALL_PRECISION = 3;
    protected static final int DEFAULT_H_SPACEFILL_PRECISION = 3;
    protected static final int DEFAULT_H_JOINT_PRECISION = 3;
    private static final int DEFAULT_H_BOND_SLICE_PRECISION = 8;
    private static final int DEFAULT_H_STICK_SLICE_PRECISION = 12;
    protected static final int DEFAULT_M_BALL_PRECISION = 2;
    protected static final int DEFAULT_M_SPACEFILL_PRECISION = 3;
    protected static final int DEFAULT_M_JOINT_PRECISION = 2;
    private static final int DEFAULT_M_BOND_SLICE_PRECISION = 6;
    private static final int DEFAULT_M_STICK_SLICE_PRECISION = 8;
    protected static final int DEFAULT_L_BALL_PRECISION = 2;
    protected static final int DEFAULT_L_SPACEFILL_PRECISION = 2;
    protected static final int DEFAULT_L_JOINT_PRECISION = 1;
    protected static final int DEFAULT_L_BOND_SLICE_PRECISION = 4;
    protected static final int DEFAULT_L_STICK_SLICE_PRECISION = 6;
    protected static final double DEFAULT_BALL_RADIUS = 0.4;
    protected static final double DEFAULT_BOND_RADIUS = 0.1;
    protected static final double DEFAULT_STICK_RADIUS = 0.15;
    protected static final double DEFAULT_LINE_WIDTH = 2.0;
    protected static final int DEFAULT_BOND_DISTANCE = 100;
    protected static final int DEFAULT_BOND_WIDTH = 50;
    protected static final boolean SMOOTH_STICKS = false;
    protected static final boolean SCALED_BALLS = false;
    protected static final boolean DISPLAY_BOND_ORDER = true;
    protected static final Color DEFAULT_COLOR = new Color(190, 190, 190);
    public static final int DRAW_TYPE_WIRE = 2;
    public static final int DRAW_TYPE_BALL = 3;
    public static final int DRAW_TYPE_STICK = 4;
    public static final int DRAW_TYPE_BALL_AND_WIRE = 5;
    public static final int DRAW_TYPE_BALL_AND_STICK = 6;
    public static final int DRAW_TYPE_SPACEFILL = 7;
    protected static HashMap drawTypes = new HashMap();
    protected Properties drawProperties;
    MacroMolecule.Polymer poly;
    private int chainNo;
    private UOID uoid;
    MacroMoleculeComponent mmc;
    GL gl;
    GLU glu;
    protected BoundingBox boundingBox;
    protected String name;
    private boolean drawHydrogens;
    private boolean drawLonePairs;
    private int drawType;
    private int colorType;
    private int quality;
    protected int ballPrecision;
    protected int spacefillPrecision;
    protected int bondSlicePrecision;
    protected int stickSlicePrecision;
    protected int jointPrecision;
    protected double ballRadius;
    protected double bondRadius;
    protected double stickRadius;
    protected double lineWidth;
    protected int bondDistance;
    protected int bondWidth;
    protected boolean oldStyleStickColoring;
    protected boolean scaledBalls;
    protected boolean displayBondOrder;
    private boolean visible;
    VisibleMolecule visibleMolecule;
    private Color color;
    private MoleculeIterators.AtomIteratorInterface atoms;
    private MoleculeIterators.AtomIteratorInterface atomsWithH;
    private MoleculeIterators.BondIteratorInterface bonds;
    private MoleculeIterators.BondIteratorInterface bondsWithH;
    private MoleculeIterators.AtomPropertyInterface atomProps;
    private Palette rainbowPalette;
    private int startIndex;
    private Palette bfactorPalette;
    private int atomCount;
    private int atomCountWithH;
    private int bondCount;
    private int bondCountWithH;

    public PolymerVisualizer(MacroMolecule.Polymer poly, MacroMoleculeComponent mmc) {
        drawTypes.put("Wire", new Integer(2));
        drawTypes.put("Ball", new Integer(3));
        drawTypes.put("Stick", new Integer(4));
        drawTypes.put("BallAndWire", new Integer(5));
        drawTypes.put("WireAndBall", new Integer(5));
        drawTypes.put("BallAndStick", new Integer(6));
        drawTypes.put("StickAndBall", new Integer(6));
        drawTypes.put("Spacefill", new Integer(7));
        this.drawProperties = new Properties();
        this.poly = null;
        this.uoid = null;
        this.mmc = null;
        this.gl = null;
        this.glu = null;
        this.boundingBox = new BoundingBox();
        this.drawHydrogens = false;
        this.drawLonePairs = true;
        this.drawType = 2;
        this.colorType = 1;
        this.quality = 2;
        this.ballPrecision = 2;
        this.spacefillPrecision = 3;
        this.bondSlicePrecision = 6;
        this.stickSlicePrecision = 8;
        this.jointPrecision = 2;
        this.ballRadius = 0.4;
        this.bondRadius = 0.1;
        this.stickRadius = 0.15;
        this.lineWidth = 2.0;
        this.bondDistance = 100;
        this.bondWidth = 50;
        this.oldStyleStickColoring = true;
        this.scaledBalls = false;
        this.displayBondOrder = true;
        this.visible = true;
        this.visibleMolecule = null;
        this.color = DEFAULT_COLOR;
        this.atoms = null;
        this.atomsWithH = null;
        this.bonds = null;
        this.bondsWithH = null;
        this.atomProps = null;
        this.rainbowPalette = null;
        this.startIndex = 0;
        this.bfactorPalette = null;
        this.atomCount = 0;
        this.atomCountWithH = 0;
        this.bondCount = 0;
        this.bondCountWithH = 0;
        this.poly = poly;
        this.mmc = mmc;
        this.atoms = poly.getAtomIterator(false);
        this.atomsWithH = poly.getAtomIterator(true);
        this.bonds = poly.getBondIterator(false);
        this.bondsWithH = poly.getBondIterator(true);
        this.atomProps = poly.getAtomProperty();
        this.atomCount = this.atoms.getCount();
        this.atomCountWithH = this.atomsWithH.getCount();
        this.bondCount = this.bonds.getCount();
        this.bondCountWithH = this.bondsWithH.getCount();
        this.setBoundingBox();
        this.drawType = mmc.drawType;
        String name = poly.getName();
        if (name == null || name.length() == 0) {
            name = "Polymer";
        }
        this.setName(name);
    }

    @Override
    public void onRemove() {
        if (this.visibleMolecule != null) {
            this.visibleMolecule.onRemove();
        }
        this.poly = null;
        this.mmc = null;
        this.atomProps = null;
        this.visibleMolecule = null;
    }

    @Override
    public UOID getId() {
        if (this.uoid == null) {
            this.uoid = this.mmc.getUsableObjectId(this);
        }
        return this.uoid;
    }

    @Override
    public boolean isGraphicComponent() {
        return false;
    }

    @Override
    public GraphicComponent getGraphicComponent() {
        return this.mmc;
    }

    public ComponentElement getComponentElement() {
        return this.mmc.getComponentElement(this);
    }

    @Override
    public MacroMoleculeComponent getMacroMoleculeComponent() {
        return this.mmc;
    }

    public MacroMolecule.Polymer getPolymer() {
        return this.poly;
    }

    public Molecule toMolecule() {
        Molecule mol = new Molecule();
        this.poly.addToMolecule(mol);
        return mol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void setName(String n) {
        this.name = n;
    }

    public int getChainNumber() {
        return this.chainNo;
    }

    public void setChainNumber(int cn) {
        this.chainNo = cn;
    }

    public int getRainbowIndex() {
        return this.startIndex;
    }

    public Palette getRainbowPalette() {
        return this.rainbowPalette;
    }

    public void setRainbowPalette(int startIndex, Palette pal) {
        this.rainbowPalette = pal;
        this.startIndex = startIndex;
    }

    public void setBFactorPalette(Palette pal) {
        this.bfactorPalette = pal;
    }

    private void setBoundingBox() {
        float e = 2.0f;
        MoleculeIterators.AtomIteratorInterface ai = this.getAtomIterator(true);
        this.boundingBox.clear();
        ai.reset();
        while (ai.hasNext()) {
            if (this.isAtomVisible(ai.current())) {
                this.boundingBox.setWithCondition(ai.getX(), ai.getY(), ai.getZ());
            }
            ai.next();
        }
        if (this.boundingBox.maxx() - this.boundingBox.minx() > 0.0f) {
            this.boundingBox.setMin(this.boundingBox.minx() - e, this.boundingBox.miny() - e, this.boundingBox.minz() - e);
            this.boundingBox.setMax(this.boundingBox.maxx() + e, this.boundingBox.maxy() + e, this.boundingBox.maxz() + e);
        }
        this.boundingBox.ready();
    }

    @Override
    public void setGL(GL gl, GLU glu) {
        this.gl = gl;
        this.glu = glu;
    }

    @Override
    public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean enumerateHydrogens) {
        return enumerateHydrogens ? this.atomsWithH : this.atoms;
    }

    @Override
    public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
        return this.atomProps;
    }

    @Override
    public MoleculeIterators.BondIteratorInterface getBondIterator(boolean enumerateHydrogens) {
        return enumerateHydrogens ? this.bondsWithH : this.bonds;
    }

    @Override
    public int getAtomCount(boolean enumerateHydrogens) {
        return enumerateHydrogens ? this.atomCountWithH : this.atomCount;
    }

    @Override
    public int getBondCount(boolean enumerateHydrogens) {
        return enumerateHydrogens ? this.bondCountWithH : this.bondCount;
    }

    public MacroMolecule.Protein.TurnIterator getTurnIterator() {
        if (this.poly instanceof MacroMolecule.Protein) {
            return ((MacroMolecule.Protein)this.poly).getTurnIterator();
        }
        return null;
    }

    public MacroMolecule.Protein.HelixIterator getHelixIterator() {
        if (this.poly instanceof MacroMolecule.Protein) {
            return ((MacroMolecule.Protein)this.poly).getHelixIterator();
        }
        return null;
    }

    public MacroMolecule.Protein.SheetIterator getSheetIterator() {
        if (this.poly instanceof MacroMolecule.Protein) {
            return ((MacroMolecule.Protein)this.poly).getSheetIterator();
        }
        return null;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public void draw() {
        if (this.gl == null) {
            return;
        }
        if (!this.visible) {
            return;
        }
        this.gl.glCallList(this.visibleMolecule.getDisplayList());
    }

    @Override
    public boolean hasTransparentPart() {
        return this.visibleMolecule != null && (this.visibleMolecule.drawType == 2 || this.visibleMolecule.drawType == 5);
    }

    @Override
    public void drawTransparentPart() {
        if (this.gl == null || !this.visible) {
            return;
        }
        if (this.visibleMolecule == null) {
            this.visibleMolecule = new VisibleMolecule(this.gl, this.glu, this);
            this.setValues();
        }
        if (this.gl.glIsList(this.visibleMolecule.getDisplayList2D())) {
            int dl = this.visibleMolecule.getDisplayList2D();
            this.gl.glCallList(dl);
        }
    }

    public void drawSelection() {
    }

    @Override
    public void selectAtom(int i) {
        this.visibleMolecule.selectAtom(i);
    }

    @Override
    public void unSelectAtom(int i) {
        this.visibleMolecule.unSelectAtom(i);
    }

    @Override
    public boolean isSelectedAtom(int i) {
        return this.visibleMolecule.isSelectedAtom(i);
    }

    @Override
    public int selectedAtomCount() {
        return this.visibleMolecule.selectedAtomCount();
    }

    @Override
    public String getDescription(ComponentElement ce) {
        if (ce.getElementType() == 2) {
            return this.atomProps.getLabel(ce.getElementIndex());
        }
        return this.getName();
    }

    @Override
    public ComponentElement[] getLabelInformation(String labelType) {
        if (labelType.equalsIgnoreCase("atom")) {
            ComponentElement[] ce = new ComponentElement[this.getAtomCount(true)];
            int i = 0;
            ComponentElement cethis = this.mmc.getComponentElement(this);
            this.atomsWithH.reset();
            while (this.atomsWithH.hasNext()) {
                if (this.isAtomVisible(this.atomsWithH.current())) {
                    ce[i] = new ComponentElement(cethis.getComponent(), cethis.getComponentPartId(), 2, this.atomsWithH.current());
                    ce[i].setDescription(this.getDescription(ce[i]));
                    ++i;
                }
                this.atomsWithH.next();
            }
            ComponentElement[] ret = new ComponentElement[i];
            System.arraycopy(ce, 0, ret, 0, i);
            return ret;
        }
        if (labelType.equalsIgnoreCase("molecule")) {
            if (this.isVisible()) {
                return new ComponentElement[]{this.mmc.getComponentElement(this)};
            }
        } else {
            if (labelType.equalsIgnoreCase("residue") && this.poly instanceof MacroMolecule.Protein) {
                MacroMolecule.Protein.CAlphaAtomIterator catoms = ((MacroMolecule.Protein)this.poly).getCAlphaAtomIterator();
                ComponentElement[] ce = new ComponentElement[catoms.getCount()];
                int i = 0;
                ComponentElement cethis = this.mmc.getComponentElement(this);
                catoms.reset();
                while (catoms.hasNext()) {
                    if (this.isAtomVisible(catoms.current())) {
                        ce[i] = new ComponentElement(cethis.getComponent(), cethis.getComponentPartId(), 2, catoms.current());
                        byte[] c = null;
                        c = Colors.getResidueByteColor(this.atomProps.getResidueTypeId(catoms.current()));
                        ce[i].setColor(new Color(c[0] * 2, c[1] * 2, c[2] * 2));
                        ce[i].setDescription(catoms.getResidueAtomLabel().substring(3));
                        ++i;
                    }
                    catoms.next();
                }
                ComponentElement[] ret = new ComponentElement[i];
                System.arraycopy(ce, 0, ret, 0, i);
                return ret;
            }
            if (labelType.equalsIgnoreCase("residue") && this.poly instanceof MacroMolecule.NucleicAcid) {
                MacroMolecule.NucleicAcid.BackboneAtomIterator batoms = ((MacroMolecule.NucleicAcid)this.poly).getBackboneAtomIterator();
                ComponentElement[] ce = new ComponentElement[batoms.getCount()];
                int i = 0;
                ComponentElement cethis = this.mmc.getComponentElement(this);
                batoms.reset();
                while (batoms.hasNext()) {
                    if (this.isAtomVisible(batoms.current())) {
                        ce[i] = new ComponentElement(cethis.getComponent(), cethis.getComponentPartId(), 2, batoms.current());
                        byte[] c = null;
                        c = Colors.getResidueByteColor(this.atomProps.getResidueTypeId(batoms.current()));
                        ce[i].setColor(new Color(c[0] * 2, c[1] * 2, c[2] * 2));
                        ce[i].setDescription(batoms.getResidueAtomLabel().substring(2));
                        ++i;
                    }
                    batoms.next();
                }
                ComponentElement[] ret = new ComponentElement[i];
                System.arraycopy(ce, 0, ret, 0, i);
                return ret;
            }
        }
        return new ComponentElement[0];
    }

    @Override
    public boolean isSelected() {
        return this.getVisibleAtomCount() == this.visibleMolecule.selectedAtomCount() && this.visibleMolecule.selectedAtomCount() > 0;
    }

    @Override
    public void select() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.isAtomVisible(this.atomsWithH.current())) {
                this.visibleMolecule.selectAtom(this.atomsWithH.current());
            }
            this.atomsWithH.next();
        }
    }

    @Override
    public void unSelect() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            this.visibleMolecule.unSelectAtom(this.atomsWithH.current());
            this.atomsWithH.next();
        }
    }

    @Override
    public void selectComponentElementsInside(BoundingBox bb) {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (bb.contains(this.atomsWithH.getX(), this.atomsWithH.getY(), this.atomsWithH.getZ()) && this.isAtomVisible(this.atomsWithH.current())) {
                this.visibleMolecule.selectAtom(this.atomsWithH.current());
            }
            this.atomsWithH.next();
        }
    }

    public void extendSelectionToResidues() {
        boolean[] atomSelection = new boolean[this.visibleMolecule.selectedAtoms.length];
        System.arraycopy(this.visibleMolecule.selectedAtoms, 0, atomSelection, 0, this.visibleMolecule.selectedAtoms.length);
        MacroMolecule.Polymer.AtomIterator pai = (MacroMolecule.Polymer.AtomIterator)this.atoms;
        pai.reset();
        while (pai.hasNext()) {
            if (atomSelection[pai.current()]) {
                int sqn = pai.getSeqNo();
                MoleculeIterators.AtomIteratorInterface res = this.poly.getAtomIterator(sqn, sqn);
                res.reset();
                while (res.hasNext()) {
                    this.visibleMolecule.setAtomDrawType(res.current(), this.visibleMolecule.drawType);
                    this.selectAtom(res.current());
                    res.next();
                }
            }
            pai.next();
        }
    }

    @Override
    public void drawAtomSelection(int mode) {
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawAtomSelection(mode, this.mmc.irm);
        }
    }

    @Override
    public void initDraw() {
        if (this.visibleMolecule == null) {
            this.visibleMolecule = new VisibleMolecule(this.gl, this.glu, this);
            this.setValues();
            this.visibleMolecule.rainbowPalette = this.rainbowPalette;
            this.visibleMolecule.startIndex = this.startIndex;
            this.visibleMolecule.bfactorPalette = this.bfactorPalette;
        }
        this.visibleMolecule.init();
    }

    protected void setValues() {
        this.visibleMolecule.drawHydrogens = this.drawHydrogens;
        this.visibleMolecule.drawLonePairs = this.drawLonePairs;
        this.visibleMolecule.quality = this.quality;
        this.visibleMolecule.colorType = this.colorType;
        this.visibleMolecule.drawType = this.drawType;
        this.visibleMolecule.ballRadius = this.ballRadius;
        this.visibleMolecule.bondRadius = this.bondRadius;
        this.visibleMolecule.stickRadius = this.stickRadius;
        this.visibleMolecule.lineWidth = this.lineWidth;
        this.visibleMolecule.jointRadius = this.stickRadius - 0.005;
        this.visibleMolecule.oldStyleStickColoring = this.oldStyleStickColoring;
        this.visibleMolecule.scaledBalls = this.scaledBalls;
        this.visibleMolecule.displayBondOrder = this.displayBondOrder;
        this.visibleMolecule.bondDistance = this.bondDistance;
        this.visibleMolecule.bondWidth = this.bondWidth;
        this.visibleMolecule.ballPrecision = this.ballPrecision;
        this.visibleMolecule.spacefillPrecision = this.spacefillPrecision;
        this.visibleMolecule.bondSlicePrecision = this.bondSlicePrecision;
        this.visibleMolecule.stickSlicePrecision = this.stickSlicePrecision;
        this.visibleMolecule.jointPrecision = this.jointPrecision;
    }

    @Override
    public Color getColor() {
        if (this.colorType == 4) {
            byte[] c = Colors.getChainColor(this.chainNo);
            return new Color(c[0] * 2, c[1] * 2, c[2] * 2);
        }
        return this.color;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isAtomVisible(int i) {
        if (!this.visible) {
            return false;
        }
        if (this.visibleMolecule == null) {
            return true;
        }
        return this.visibleMolecule.isAtomVisible(i);
    }

    @Override
    public boolean isAtomFaded(int i) {
        if (this.visibleMolecule == null) {
            return false;
        }
        return this.visibleMolecule.isAtomFaded(i);
    }

    @Override
    public int getVisibleAtomCount() {
        if (!this.visible) {
            return 0;
        }
        if (this.visibleMolecule == null) {
            return this.getAtomCount(true);
        }
        int c = 0;
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isAtomVisible(this.atomsWithH.current())) {
                ++c;
            }
            this.atomsWithH.next();
        }
        return c;
    }

    @Override
    public void setVisible(boolean v) {
        if (this.visible && this.visibleMolecule != null) {
            this.atomsWithH.reset();
            while (this.atomsWithH.hasNext()) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), this.visibleMolecule.drawType);
                this.atomsWithH.next();
            }
            this.setBoundingBox();
        }
        if (this.visible == v) {
            return;
        }
        this.visible = v;
        this.mmc.setBoundingBox();
    }

    @Override
    public void showFaded() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.isAtomFaded(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), this.visibleMolecule.drawType);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void hideSelected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.unSelectAtom(this.atomsWithH.current());
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -1);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void hideUnselected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (!this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -1);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void fadeSelected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.unSelectAtom(this.atomsWithH.current());
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -2);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void fadeUnselected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isAtomVisible(this.atomsWithH.current()) && !this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -2);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public boolean isHighlighted() {
        return this.visibleMolecule.isHighlighted();
    }

    @Override
    public void setHighlighted(boolean v) {
        this.visibleMolecule.setHighlighted(v);
    }

    private void setDrawType(String drawType) {
        int dt = -1;
        try {
            dt = (Integer)drawTypes.get(drawType);
        }
        catch (Exception e) {
            System.out.println("Unexpected type of draw: " + drawType);
        }
        if (this.drawType == dt || dt == -1) {
            return;
        }
        this.drawType = dt;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawType = this.drawType;
            this.visibleMolecule.drawTypeChanged();
        }
    }

    private void setQuality(String propertyValue) {
        if (propertyValue.equalsIgnoreCase("medium") && this.quality != 2) {
            this.setQuality(2);
        } else if (propertyValue.equalsIgnoreCase("high") && this.quality != 3) {
            this.setQuality(3);
        } else if (propertyValue.equalsIgnoreCase("low") && this.quality != 1) {
            this.setQuality(1);
        }
    }

    private void setQuality(int quality) {
        if (this.quality == quality) {
            return;
        }
        this.quality = quality;
        if (quality == 2) {
            this.ballPrecision = 2;
            this.spacefillPrecision = 3;
            this.jointPrecision = 2;
            this.stickSlicePrecision = 8;
            this.bondSlicePrecision = 6;
        } else if (quality == 3) {
            this.ballPrecision = 3;
            this.spacefillPrecision = 3;
            this.jointPrecision = 3;
            this.stickSlicePrecision = 12;
            this.bondSlicePrecision = 8;
        } else if (quality == 1) {
            this.ballPrecision = 2;
            this.spacefillPrecision = 2;
            this.jointPrecision = 1;
            this.stickSlicePrecision = 6;
            this.bondSlicePrecision = 4;
        }
        if (this.visibleMolecule != null) {
            this.setValues();
            this.visibleMolecule.qualityChanged();
        }
    }

    private void showHydrogens(boolean flag) {
        if (this.drawHydrogens == flag) {
            return;
        }
        this.drawHydrogens = flag;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawHydrogens = flag;
            this.visibleMolecule.showHydrogensChanged();
        }
    }

    private void showLonePairs(boolean flag) {
        if (this.drawLonePairs == flag) {
            return;
        }
        this.drawLonePairs = flag;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawLonePairs = flag;
            this.visibleMolecule.showHydrogensChanged();
        }
    }

    @Override
    public int getColorType() {
        return this.colorType;
    }

    private void setColorType(String propertyValue) {
        int ct = -1;
        ct = propertyValue.equals("CPK") ? 1 : (propertyValue.equals("Residue") ? 3 : (propertyValue.equals("Chain") ? 4 : (propertyValue.equals("SecondaryStructure") ? 5 : (propertyValue.equals("Rainbow") ? 11 : (propertyValue.equals("B-factor") ? 12 : 2)))));
        if (this.colorType == ct || ct == -1) {
            return;
        }
        this.colorType = ct;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.colorType = this.colorType;
            this.visibleMolecule.colorTypeChanged();
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.colorTypeChanged();
        }
    }

    private void setBallRadius(double radius) {
        this.ballRadius = radius;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.ballRadius = this.ballRadius;
            this.visibleMolecule.needRecreateOneBall = true;
        }
    }

    private void setBondRadius(double radius) {
        this.bondRadius = radius;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondRadius = this.bondRadius;
            this.visibleMolecule.needRecreateOneBond = true;
            if (!this.oldStyleStickColoring) {
                this.visibleMolecule.needRecreateBonds = true;
                this.visibleMolecule.needRecreateSticks = true;
            }
        }
    }

    private void setStickRadius(double radius) {
        this.stickRadius = radius;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.stickRadius = this.stickRadius;
            this.visibleMolecule.jointRadius = this.stickRadius - 0.005;
            this.visibleMolecule.needRecreateOneStick = true;
            this.visibleMolecule.needRecreateOneJoint = true;
            if (!this.oldStyleStickColoring) {
                this.visibleMolecule.needRecreateBonds = true;
                this.visibleMolecule.needRecreateSticks = true;
            }
        }
    }

    private void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.lineWidth = lineWidth;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setBondDistance(int bondDistance) {
        this.bondDistance = bondDistance;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondDistance = bondDistance;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setBondWidth(int bondWidth) {
        this.bondWidth = bondWidth;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondWidth = bondWidth;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setSmoothStickStyle(boolean style) {
        boolean bl = this.oldStyleStickColoring = !style;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.oldStyleStickColoring = this.oldStyleStickColoring;
            this.visibleMolecule.stickStyleChanged();
        }
    }

    private void setScaledBalls(boolean b) {
        this.scaledBalls = b;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.scaledBalls = this.scaledBalls;
            this.visibleMolecule.needRecreateBalls = true;
        }
    }

    private void setDisplayBondOrder(boolean b) {
        this.displayBondOrder = b;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.displayBondOrder = this.displayBondOrder;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    @Override
    public String getDrawProperty(String propertyName) {
        return this.drawProperties.getProperty(propertyName);
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) {
        if (propertyName.equals("Quality")) {
            this.setDrawProperty("MacroMolecule.Quality", propertyValue);
            this.drawProperties.setProperty(propertyName, propertyValue);
            return;
        }
        if (propertyName.startsWith("Colors.")) {
            if (this.visibleMolecule != null) {
                this.visibleMolecule.colorTypeChanged();
            }
            return;
        }
        if (!propertyName.startsWith("MacroMolecule")) {
            return;
        }
        this.drawProperties.setProperty(propertyName, propertyValue);
        if (propertyName.equals("MacroMolecule.DrawType")) {
            this.setDrawType(propertyValue);
        } else if (propertyName.equals("MacroMolecule.Quality")) {
            this.setQuality(propertyValue);
        } else if (propertyName.equals("MacroMolecule.Hydrogens")) {
            this.showHydrogens(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("MacroMolecule.LonePairs")) {
            this.showLonePairs(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("MacroMolecule.ColorType")) {
            this.setColorType(propertyValue);
        } else if (propertyName.equals("MacroMolecule.Color")) {
            this.setColor(Color.decode(propertyValue));
        } else if (propertyName.equals("MacroMolecule.BallRadius")) {
            this.setBallRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("MacroMolecule.BondRadius")) {
            this.setBondRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("MacroMolecule.StickRadius")) {
            this.setStickRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("MacroMolecule.LineWidth")) {
            this.setLineWidth(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("MacroMolecule.BondDistance")) {
            this.setBondDistance(Integer.parseInt(propertyValue));
        } else if (propertyName.equals("MacroMolecule.BondWidth")) {
            this.setBondWidth(Integer.parseInt(propertyValue));
        } else if (propertyName.equals("MacroMolecule.SmoothStickStyle")) {
            this.setSmoothStickStyle(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("MacroMolecule.ScaledBalls")) {
            this.setScaledBalls(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("MacroMolecule.DisplayBondOrder")) {
            this.setDisplayBondOrder(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("MacroMolecule.Visible")) {
            this.setVisible(Boolean.valueOf(propertyValue));
        }
    }
}

