/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;

public class RibbonBSpline {
    static float[] BSmat = new float[]{-0.16666667f, 0.5f, -0.5f, 0.16666667f, 0.5f, -1.0f, 0.5f, 0.0f, -0.5f, 0.0f, 0.5f, 0.0f, 0.16666667f, 0.6666667f, 0.16666667f, 0.0f};
    static float[] BSmata = new float[]{-1.0f, 1.75f, -0.9166667f, 0.16666667f, 3.0f, -4.5f, 1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    static float[] BSmatb = new float[]{-0.25f, 0.5833333f, -0.5f, 0.16666667f, 0.75f, -1.25f, 0.5f, 0.0f, -0.75f, 0.25f, 0.5f, 0.0f, 0.25f, 0.5833333f, 0.16666667f, 0.0f};
    static float[] BSmaty = new float[]{-0.16666667f, 0.5f, -0.5833333f, 0.25f, 0.5f, -1.0f, 0.5f, 0.0f, -0.5f, 0.0f, 0.5f, 0.0f, 0.16666667f, 0.6666667f, 0.16666667f, 0.0f};
    static float[] BSmatz = new float[]{-0.16666667f, 0.9166667f, -1.75f, 1.0f, 0.5f, -1.25f, 0.75f, 0.0f, -0.5f, -0.25f, 0.75f, 0.0f, 0.16666667f, 0.5833333f, 0.25f, 0.0f};
    static float[] Fprec = new float[]{6.0f, 0.0f, 0.0f, 0.0f, 6.0f, 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    static float[] geom = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    static boolean FIRST_POINT;
    static float[] M;
    static float[] bsmat;
    static float[] bsmata;
    static float[] bsmatb;
    static float[] bsmaty;
    static float[] bsmatz;
    static float[] fprec;

    static void makePrecession(int n) {
        for (int i = 0; i < 16; ++i) {
            RibbonBSpline.fprec[i] = Fprec[i];
        }
        fprec[0] = fprec[0] / (float)(n * n * n);
        fprec[4] = fprec[4] / (float)(n * n * n);
        fprec[8] = fprec[8] / (float)(n * n * n);
        fprec[5] = fprec[5] / (float)(n * n);
        fprec[9] = fprec[9] / (float)(n * n);
        fprec[10] = fprec[10] / (float)n;
    }

    static void makeGeom(int[] x) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                RibbonBSpline.geom[i * 4 + j] = GeomCalc.get(x[i], j);
            }
        }
    }

    static int foreDif(int n, int[] g) {
        int np = 0;
        if (FIRST_POINT) {
            g[np] = GeomCalc.newVector(M[12] / M[15], M[13] / M[15], M[14] / M[15]);
            ++np;
        }
        for (int k = 0; k < n; ++k) {
            for (int i = 3; i > 0; --i) {
                for (int j = 0; j < 4; ++j) {
                    int n2 = i * 4 + j;
                    M[n2] = M[n2] + M[(i - 1) * 4 + j];
                }
            }
            g[np] = GeomCalc.newVector(M[12] / M[15], M[13] / M[15], M[14] / M[15]);
            ++np;
        }
        return np;
    }

    static void bsSetup(int sampling) {
        RibbonBSpline.makePrecession(sampling);
        GeomCalc.multMatrix(fprec, BSmat, bsmat);
        GeomCalc.multMatrix(fprec, BSmata, bsmata);
        GeomCalc.multMatrix(fprec, BSmatb, bsmatb);
        GeomCalc.multMatrix(fprec, BSmaty, bsmaty);
        GeomCalc.multMatrix(fprec, BSmatz, bsmatz);
    }

    static void bsLine(int[] x, int sampling, int[] g) {
        FIRST_POINT = false;
        FIRST_POINT = true;
        RibbonBSpline.makeGeom(x);
        GeomCalc.multMatrix(bsmat, geom, M);
        RibbonBSpline.foreDif(sampling, g);
    }

    static {
        M = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        bsmat = new float[16];
        bsmata = new float[16];
        bsmatb = new float[16];
        bsmaty = new float[16];
        bsmatz = new float[16];
        fprec = new float[16];
    }
}

