/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.RibbonVisualizer;
import chemaxon.marvin.space.UsableObject;
import chemaxon.struc.MacroMolecule;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class SecondaryStructureComponent
extends GraphicComponent
implements UsableObject {
    ArrayList rvisualizers = new ArrayList();
    protected Color color = new Color(255, 255, 255);

    public SecondaryStructureComponent(MacroMoleculeComponent mmc) {
        int calphaIndex = 0;
        Iterator<MacroMoleculeComponent.MoleculeVisualizer> i = mmc.getComponentIterator();
        while (i.hasNext()) {
            RibbonVisualizer rv;
            MacroMoleculeComponent.MoleculeVisualizer mv = i.next();
            if (!(mv instanceof PolymerVisualizer) || !mv.isVisible()) continue;
            MacroMolecule.Polymer p = ((PolymerVisualizer)mv).getPolymer();
            if (p instanceof MacroMolecule.Protein && ((MacroMolecule.Protein)p).getCAlphaAtomIterator().getCount() > 1) {
                rv = new RibbonVisualizer((MacroMolecule.Protein)p, this);
                this.rvisualizers.add(rv);
                rv.setChainNumber(((PolymerVisualizer)mv).getChainNumber());
                rv.setRainbowPalette(calphaIndex, mmc.getRainbowPalette());
                rv.setBFactorPalette(mmc.getBFactorPalette());
                calphaIndex += ((MacroMolecule.Protein)p).getCAlphaAtomIterator().getCount();
                this.boundingBox.setWithCondition(mv.getBoundingBox());
                continue;
            }
            if (!(p instanceof MacroMolecule.NucleicAcid) || ((MacroMolecule.NucleicAcid)p).getBackboneAtomIterator().getCount() <= 1) continue;
            rv = new RibbonVisualizer((MacroMolecule.NucleicAcid)p, this);
            this.rvisualizers.add(rv);
            rv.setChainNumber(((PolymerVisualizer)mv).getChainNumber());
            rv.setRainbowPalette(calphaIndex, mmc.getRainbowPalette());
            rv.setBFactorPalette(mmc.getBFactorPalette());
            calphaIndex += ((MacroMolecule.NucleicAcid)p).getBackboneAtomIterator().getCount();
            this.boundingBox.setWithCondition(mv.getBoundingBox());
        }
        this.boundingBox.ready();
    }

    @Override
    public void onRemoveGraphicComponent() {
        super.onRemoveGraphicComponent();
        Iterator i = this.rvisualizers.iterator();
        while (i.hasNext()) {
            ((RibbonVisualizer)i.next()).onRemove();
        }
        this.rvisualizers.clear();
        this.color = null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public ComponentElement[] getLabelInformation(String labelType) {
        ArrayList<ComponentElement> ce = new ArrayList<ComponentElement>();
        for (int i = 0; i < this.rvisualizers.size(); ++i) {
            ComponentElement[] cei = ((RibbonVisualizer)this.rvisualizers.get(i)).getLabelInformation(labelType);
            ce.addAll(Arrays.asList(cei));
        }
        return ce.toArray(new ComponentElement[0]);
    }

    @Override
    public void setGL(GL gl, GLU glu) {
        this.gl = gl;
        for (RibbonVisualizer rv : this.rvisualizers) {
            rv.setGL(gl, glu);
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        for (RibbonVisualizer rv : this.rvisualizers) {
            rv.draw();
        }
    }

    @Override
    public double locateObject(int x, int y) {
        return -1.0;
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) throws Exception {
        if (propertyName.equals("Quality")) {
            this.setDrawProperty("SecondaryStructure.Quality", propertyValue);
            return;
        }
        if (propertyName.startsWith("Colors.")) {
            Iterator i = this.rvisualizers.iterator();
            while (i.hasNext()) {
                ((RibbonVisualizer)i.next()).refresh();
            }
        }
        if (!propertyName.startsWith("SecondaryStructure")) {
            return;
        }
        this.storeDrawProperty(propertyName, propertyValue);
        if (propertyName.equalsIgnoreCase("SecondaryStructure.DrawType")) {
            if (propertyValue.equalsIgnoreCase("Wire")) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setDrawType(1);
                }
            } else if (propertyValue.equalsIgnoreCase("Trace")) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setDrawType(2);
                }
            } else if (propertyValue.equalsIgnoreCase("Tube")) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setDrawType(3);
                }
            } else if (propertyValue.equalsIgnoreCase("PipeAndPlank")) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setDrawType(4);
                }
            } else if (propertyValue.equalsIgnoreCase("RibbonLines")) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setDrawType(5);
                }
            } else if (propertyValue.equalsIgnoreCase("Ribbon")) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setDrawType(6);
                }
            } else if (propertyValue.equalsIgnoreCase("CartoonSquare")) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setDrawType(7);
                }
            } else if (propertyValue.equalsIgnoreCase("Cartoon")) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setDrawType(8);
                }
            }
        } else if (propertyName.equalsIgnoreCase("SecondaryStructure.ColorType")) {
            int colorType = -1;
            if (propertyValue.equalsIgnoreCase("Constant")) {
                colorType = 2;
            } else if (propertyValue.equalsIgnoreCase("Chain")) {
                colorType = 4;
            } else if (propertyValue.equalsIgnoreCase("Residue")) {
                colorType = 3;
            } else if (propertyValue.equalsIgnoreCase("SecondaryStructure")) {
                colorType = 5;
            } else if (propertyValue.equalsIgnoreCase("Rainbow")) {
                colorType = 11;
            } else if (propertyValue.equalsIgnoreCase("B-factor")) {
                colorType = 12;
            }
            if (colorType != -1) {
                for (RibbonVisualizer rv : this.rvisualizers) {
                    rv.setColorType(colorType);
                }
            }
        } else if (propertyName.equals("SecondaryStructure.Color")) {
            this.color = Color.decode(propertyValue);
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setConstantColor((byte)(this.color.getRed() / 2), (byte)(this.color.getGreen() / 2), (byte)(this.color.getBlue() / 2));
            }
        } else if (propertyName.equals("SecondaryStructure.Quality")) {
            int quality = -1;
            if (propertyValue.equalsIgnoreCase("medium")) {
                quality = 2;
            } else if (propertyValue.equalsIgnoreCase("high")) {
                quality = 3;
            } else if (propertyValue.equalsIgnoreCase("low")) {
                quality = 1;
            }
            if (quality == -1 || quality == this.renderingQuality) {
                return;
            }
            this.renderingQuality = quality;
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setQuality(quality);
            }
        } else if (propertyName.equals("SecondaryStructure.HelixWidth")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setHelixWidth(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.HelixDepth")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setHelixDepth(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.HelixShift")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setHelixShift(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.HelixArrow")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setHelixArrow(Boolean.valueOf(propertyValue));
            }
        } else if (propertyName.equals("SecondaryStructure.HelixArrowWidth")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setHelixArrowWidth(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.SheetWidth")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setSheetWidth(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.SheetDepth")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setSheetDepth(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.SheetArrow")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setSheetArrow(Boolean.valueOf(propertyValue));
            }
        } else if (propertyName.equals("SecondaryStructure.SheetArrowWidth")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setSheetArrowWidth(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.CoilWidth")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setCoilWidth(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.CoilDepth")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setCoilDepth(Float.valueOf(propertyValue).floatValue());
            }
        } else if (propertyName.equals("SecondaryStructure.CoilUniform")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setCoilUniform(Boolean.valueOf(propertyValue));
            }
        } else if (propertyName.equals("SecondaryStructure.Threads")) {
            for (RibbonVisualizer rv : this.rvisualizers) {
                rv.setThreads(Integer.valueOf(propertyValue));
            }
        } else if (propertyName.equals("SecondaryStructure.Visible")) {
            this.setVisible(Boolean.valueOf(propertyValue));
        } else {
            System.out.println("Undefined draw property: " + propertyName + ", " + propertyValue);
        }
    }
}

