/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.GraphicComponent;
import com.sun.opengl.util.BufferUtil;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class SurfaceComponent
extends GraphicComponent {
    public static final int DOTTED_TYPE = 1;
    public static final int MESH_TYPE = 2;
    public static final int FILLED_TYPE = 3;
    public static final int TRANSPARENT_TYPE = 4;
    protected static final Color DEFAULT_COLOR = new Color(204, 204, 204);
    private FloatBuffer vertices;
    private FloatBuffer normals;
    private ByteBuffer colors;
    private ByteBuffer trcolors;
    private boolean constantColoring = true;
    private int[] primitives;
    private int primitivePointer = 0;
    private int vertexCount = 0;
    private int primitiveCount = 0;
    private int primitiveType = 4;
    private int primitiveNodeCount = 3;
    private boolean drawWithDisplayList = false;
    private boolean rawDisplayListIsGenerated = false;
    private int rawDisplayList = 0;
    private boolean dotListIsGenerated = false;
    private int dotList = 0;
    private boolean indicesStartWithZero = false;
    private boolean clippingEnabled = false;
    private boolean exclusiveDrawing = false;
    private byte[] exclusiveColor = Colors.lightgray;
    protected Color color = DEFAULT_COLOR;
    protected byte[] color3 = new byte[]{102, 102, 102};
    private static float[] specular = new float[]{0.393548f, 0.271906f, 0.166721f, 1.0f};
    private static float shininess = 2.0f;

    public SurfaceComponent(int vertexCount) {
        this.modifiesOrigin = false;
        this.vertexCount = vertexCount;
        this.drawType = 3;
        this.allocate();
    }

    public SurfaceComponent(int vertexCount, int primitiveCount) {
        this.modifiesOrigin = false;
        this.vertexCount = vertexCount;
        this.primitiveCount = primitiveCount;
        this.drawType = 3;
        this.allocate();
    }

    public SurfaceComponent(int vertexCount, int primitiveCount, int primitiveType, int primitiveNodeCount) {
        this.modifiesOrigin = false;
        this.vertexCount = vertexCount;
        this.primitiveCount = primitiveCount;
        this.primitiveType = primitiveType;
        this.primitiveNodeCount = primitiveNodeCount;
        this.drawType = 3;
        this.allocate();
    }

    @Override
    public void onRemoveGraphicComponent() {
        super.onRemoveGraphicComponent();
        if (this.dotListIsGenerated) {
            this.gl.glDeleteLists(this.dotList, 1);
        }
        this.vertices.clear();
        if (this.normals != null) {
            this.normals.clear();
        }
        this.colors.clear();
        this.trcolors.clear();
        this.vertices = null;
        this.normals = null;
        this.colors = null;
        this.trcolors = null;
        this.primitives = null;
    }

    public void setDrawing(boolean b) {
        this.drawWithDisplayList = b;
    }

    public void setDrawingPrimitiveType(int primitiveType) {
        this.primitiveType = primitiveType;
    }

    public void setDrawingPrimitiveType(int primitiveType, int primitiveNodeCount) {
        this.primitiveType = primitiveType;
        this.primitiveNodeCount = primitiveNodeCount;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public float getVertexX(int i) {
        return this.vertices.get(i * 3);
    }

    public float getVertexY(int i) {
        return this.vertices.get(i * 3 + 1);
    }

    public float getVertexZ(int i) {
        return this.vertices.get(i * 3 + 2);
    }

    public int putVertex(float vx, float vy, float vz) {
        int pos = this.vertices.position() / 3;
        this.vertices.put(vx);
        this.vertices.put(vy);
        this.vertices.put(vz);
        return pos;
    }

    public int putVertex(float[] v) {
        int pos = this.vertices.position() / 3;
        this.vertices.put(v);
        return pos;
    }

    public int getNormal(int i) {
        return GeomCalc.newVector(this.normals.get(i * 3), this.normals.get(i * 3 + 1), this.normals.get(i * 3 + 2));
    }

    void setNormal(int i, int n) {
        this.normals.put(i * 3, GeomCalc.getX(n));
        this.normals.put(i * 3 + 1, GeomCalc.getY(n));
        this.normals.put(i * 3 + 2, GeomCalc.getZ(n));
    }

    public void putNormal(float nx, float ny, float nz) {
        if (this.normals == null) {
            this.manuallySetNormals(true);
        }
        this.normals.put(nx);
        this.normals.put(ny);
        this.normals.put(nz);
    }

    public void putNormal(float[] n) {
        if (this.normals == null) {
            this.manuallySetNormals(true);
        }
        this.normals.put(n);
    }

    public void putColorComponent(byte c) {
        this.colors.put(c);
        this.trcolors.put(c);
    }

    public void putColor(byte[] c) {
        this.colors.put(c[0]);
        this.colors.put(c[1]);
        this.colors.put(c[2]);
        this.colors.put((byte)127);
        this.trcolors.put(c[0]);
        this.trcolors.put(c[1]);
        this.trcolors.put(c[2]);
        this.trcolors.put((byte)63);
    }

    public int[] getPrimitives() {
        return this.primitives;
    }

    public int putTriangle(int x, int y, int z) {
        if (!(this.indicesStartWithZero || x != 0 && y != 0 && z != 0)) {
            this.indicesStartWithZero = true;
        }
        this.primitives[this.primitivePointer++] = x;
        this.primitives[this.primitivePointer++] = y;
        this.primitives[this.primitivePointer++] = z;
        return this.primitivePointer / 3 - 1;
    }

    public void putPolygon(int[] polygon) {
        for (int i = 0; i < this.primitiveNodeCount; ++i) {
            this.primitives[this.primitivePointer++] = polygon[i];
        }
    }

    public void manuallySetNormals(boolean flag) {
        if (flag) {
            this.normals = BufferUtil.newFloatBuffer((int)(this.vertexCount * 3));
        } else {
            this.setNormals();
        }
    }

    public byte[] getColor3() {
        return this.color3;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
        this.color3[0] = (byte)(c.getRed() / 2);
        this.color3[1] = (byte)(c.getGreen() / 2);
        this.color3[2] = (byte)(c.getBlue() / 2);
    }

    public void setExclusiveColor(byte[] exclusiveColor) {
        this.exclusiveColor = exclusiveColor;
    }

    public void setExclusiveDrawing(boolean b) {
        this.exclusiveDrawing = b;
    }

    private void dot() {
        if (!this.dotListIsGenerated) {
            this.generateDotList();
            this.dotListIsGenerated = true;
        }
        this.gl.glDisable(2896);
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!this.constantColoring) {
                byte c0 = this.colors.get(i * 4);
                byte c1 = this.colors.get(i * 4 + 1);
                byte c2 = this.colors.get(i * 4 + 2);
                if (this.exclusiveDrawing && c0 == this.exclusiveColor[0] && c1 == this.exclusiveColor[1] && c2 == this.exclusiveColor[2]) continue;
                this.gl.glColor3b(c0, c1, c2);
            }
            this.gl.glPushMatrix();
            this.gl.glTranslated((double)this.vertices.get(i * 3), (double)this.vertices.get(i * 3 + 1), (double)this.vertices.get(i * 3 + 2));
            this.gl.glMultMatrixf(GeomCalc.getMatrix(this.irm), 0);
            this.gl.glCallList(this.dotList);
            this.gl.glPopMatrix();
        }
        this.gl.glEnable(2896);
    }

    private void generateDotList() {
        if (this.dotList == 0) {
            this.dotList = this.gl.glGenLists(1);
        }
        double e = 0.04;
        double sqrt2p2 = Math.sqrt(2.0) / 2.0;
        double s = sqrt2p2 * e;
        this.gl.glNewList(this.dotList, 4864);
        this.gl.glBegin(6);
        this.gl.glVertex3d(0.0, 0.0, 0.0);
        this.gl.glVertex3d(-e, 0.0, 0.0);
        this.gl.glVertex3d(-s, -s, 0.0);
        this.gl.glVertex3d(0.0, -e, 0.0);
        this.gl.glVertex3d(s, -s, 0.0);
        this.gl.glVertex3d(e, 0.0, 0.0);
        this.gl.glVertex3d(s, s, 0.0);
        this.gl.glVertex3d(0.0, e, 0.0);
        this.gl.glVertex3d(-s, s, 0.0);
        this.gl.glVertex3d(-e, 0.0, 0.0);
        this.gl.glEnd();
        this.gl.glEndList();
    }

    private void mesh() {
        this.gl.glEnable(3042);
        this.gl.glDepthMask(false);
        this.gl.glPolygonMode(1032, 6913);
        this.gl.glLineWidth(1.0f);
        this.filled();
        this.gl.glDisable(3042);
        this.gl.glDepthMask(true);
        this.gl.glPolygonMode(1032, 6914);
    }

    private void filled() {
        if (this.exclusiveDrawing) {
            this.drawNonColored();
        } else if (this.primitiveCount > 0) {
            this.indexedDraw();
        } else {
            this.directDraw();
        }
    }

    private void transparent() {
        this.gl.glEnable(3042);
        this.gl.glDepthMask(false);
        this.gl.glEnable(2884);
        this.gl.glCullFace(1029);
        this.filled();
        this.gl.glDisable(3042);
        this.gl.glDepthMask(true);
    }

    private void normals() {
        this.gl.glDisable(2896);
        this.gl.glColor3bv(Colors.red, 0);
        this.gl.glBegin(1);
        for (int i = 0; i < this.vertexCount; ++i) {
            this.gl.glVertex3f(this.vertices.get(i * 3), this.vertices.get(i * 3 + 1), this.vertices.get(i * 3 + 2));
            this.gl.glVertex3f(this.vertices.get(i * 3) + this.normals.get(i * 3), this.vertices.get(i * 3 + 1) + this.normals.get(i * 3 + 1), this.vertices.get(i * 3 + 2) + this.normals.get(i * 3 + 2));
        }
        this.gl.glEnd();
        this.gl.glEnable(2896);
    }

    private void directDraw() {
        this.gl.glDrawArrays(this.primitiveType, 0, this.vertexCount);
    }

    private void indexedDraw() {
        this.gl.glDrawElements(this.primitiveType, this.primitiveNodeCount * this.primitiveCount, 5125, (Buffer)IntBuffer.wrap(this.primitives));
    }

    private void drawNonColored() {
        this.gl.glBegin(this.primitiveType);
        for (int i = 0; i < this.primitiveCount; ++i) {
            int j;
            boolean draw = true;
            if (!this.constantColoring) {
                for (j = 0; j < this.primitiveNodeCount; ++j) {
                    int vi = this.primitives[i * this.primitiveNodeCount + j];
                    if (this.colors.get(vi * 4) != this.exclusiveColor[0] || this.colors.get(vi * 4 + 1) != this.exclusiveColor[1] || this.colors.get(vi * 4 + 2) != this.exclusiveColor[2]) continue;
                    draw = false;
                    break;
                }
            }
            if (!draw) continue;
            for (j = 0; j < this.primitiveNodeCount; ++j) {
                this.gl.glArrayElement(this.primitives[i * this.primitiveNodeCount + j]);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTransparentPart() {
        if (!this.visible || this.gl == null || this.vertexCount == 0) {
            return;
        }
        if (this.drawWithDisplayList) {
            this.drawRawSurface();
            return;
        }
        this.drawSurface();
    }

    @Override
    public void draw() {
        if (!this.visible || this.gl == null || this.vertexCount == 0) {
            return;
        }
        if (this.drawType == 2 || this.drawType == 4) {
            return;
        }
        if (this.drawWithDisplayList) {
            this.drawRawSurface();
            return;
        }
        this.drawSurface();
    }

    protected void drawSurface() {
        this.gl.glDisable(2884);
        if (this.drawType == 2 || this.drawType == 4) {
            this.gl.glColor4f((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, 0.5f);
        } else {
            this.gl.glColor3f((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f);
        }
        this.tidyIndices();
        this.gl.glVertexPointer(3, 5126, 0, this.vertices.position(0));
        if (this.normals == null) {
            this.manuallySetNormals(false);
        }
        this.gl.glNormalPointer(5126, 0, this.normals.position(0));
        if (!this.constantColoring) {
            this.gl.glEnableClientState(32886);
            if (this.drawType == 2 || this.drawType == 4) {
                this.gl.glColorPointer(4, 5120, 0, this.trcolors.position(0));
            } else {
                this.gl.glColorPointer(4, 5120, 0, this.colors.position(0));
            }
        }
        if (this.clippingEnabled) {
            this.setClippingPlanes();
            this.gl.glEnable(12288);
            this.gl.glEnable(12289);
            this.gl.glEnable(12290);
            this.gl.glEnable(12291);
            this.gl.glEnable(12292);
            this.gl.glEnable(12293);
        }
        if (this.drawType == 1) {
            this.dot();
        } else if (this.drawType == 2) {
            this.mesh();
        } else if (this.drawType == 4) {
            this.transparent();
        } else if (this.drawType == 3) {
            this.filled();
        }
        if (!this.constantColoring) {
            this.gl.glDisableClientState(32886);
        }
        this.gl.glEnable(2884);
        if (this.clippingEnabled) {
            this.gl.glDisable(12288);
            this.gl.glDisable(12289);
            this.gl.glDisable(12290);
            this.gl.glDisable(12291);
            this.gl.glDisable(12292);
            this.gl.glDisable(12293);
        }
    }

    protected void drawRawSurface() {
        if (!this.rawDisplayListIsGenerated) {
            this.generateRawDisplayList();
            this.rawDisplayListIsGenerated = true;
        }
        this.gl.glDisable(2884);
        if (this.drawType == 2 || this.drawType == 4) {
            this.gl.glColor4f((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, 0.5f);
        } else {
            this.gl.glColor3f((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f);
        }
        this.tidyIndices();
        if (this.normals == null) {
            this.manuallySetNormals(false);
        }
        if (this.clippingEnabled) {
            this.setClippingPlanes();
            this.gl.glEnable(12288);
            this.gl.glEnable(12289);
            this.gl.glEnable(12290);
            this.gl.glEnable(12291);
            this.gl.glEnable(12292);
            this.gl.glEnable(12293);
        }
        if (this.drawType != 3) {
            this.gl.glEnable(3042);
            this.gl.glDisable(2929);
        }
        if (this.drawType == 2) {
            this.gl.glPolygonMode(1032, 6913);
        }
        if (this.drawType == 1) {
            this.dot();
        } else {
            this.gl.glCallList(this.rawDisplayList);
        }
        if (this.drawType == 2) {
            this.gl.glPolygonMode(1032, 6914);
        }
        if (this.drawType != 3) {
            this.gl.glDisable(3042);
            this.gl.glEnable(2929);
        }
        this.gl.glEnable(2884);
        if (this.clippingEnabled) {
            this.gl.glDisable(12288);
            this.gl.glDisable(12289);
            this.gl.glDisable(12290);
            this.gl.glDisable(12291);
            this.gl.glDisable(12292);
            this.gl.glDisable(12293);
        }
    }

    protected void generateRawDisplayList() {
        if (this.rawDisplayList == 0) {
            this.rawDisplayList = this.gl.glGenLists(1);
        }
        this.gl.glNewList(this.rawDisplayList, 4864);
        if (this.primitiveCount > 0) {
            this.gl.glBegin(this.primitiveType);
            for (int t = 0; t < this.primitiveCount; ++t) {
                int vi;
                int j;
                boolean draw = true;
                if (!this.constantColoring) {
                    if (this.exclusiveDrawing) {
                        for (j = 0; j < this.primitiveNodeCount; ++j) {
                            vi = this.primitives[t * this.primitiveNodeCount + j];
                            if (this.colors.get(vi * 4) != this.exclusiveColor[0] || this.colors.get(vi * 4 + 1) != this.exclusiveColor[1] || this.colors.get(vi * 4 + 2) != this.exclusiveColor[2]) continue;
                            draw = false;
                            break;
                        }
                    }
                    if (!draw) continue;
                    for (j = 0; j < this.primitiveNodeCount; ++j) {
                        vi = this.primitives[t * this.primitiveNodeCount + j];
                        this.gl.glColor3b(this.colors.get(vi * 4), this.colors.get(vi * 4 + 1), this.colors.get(vi * 4 + 2));
                        this.gl.glNormal3f(this.normals.get(vi * 3), this.normals.get(vi * 3 + 1), this.normals.get(vi * 3 + 2));
                        this.gl.glVertex3f(this.vertices.get(vi * 3), this.vertices.get(vi * 3 + 1), this.vertices.get(vi * 3 + 2));
                    }
                    continue;
                }
                for (j = 0; j < this.primitiveNodeCount; ++j) {
                    vi = this.primitives[t * this.primitiveNodeCount + j];
                    this.gl.glNormal3f(this.normals.get(vi * 3), this.normals.get(vi * 3 + 1), this.normals.get(vi * 3 + 2));
                    this.gl.glVertex3f(this.vertices.get(vi * 3), this.vertices.get(vi * 3 + 1), this.vertices.get(vi * 3 + 2));
                }
            }
            this.gl.glEnd();
        } else {
            this.gl.glBegin(this.primitiveType);
            for (int vi = 0; vi < this.vertexCount; ++vi) {
                if (!this.constantColoring) {
                    byte c0 = this.colors.get(vi * 4);
                    byte c1 = this.colors.get(vi * 4 + 1);
                    byte c2 = this.colors.get(vi * 4 + 2);
                    if (this.exclusiveDrawing && c0 == this.exclusiveColor[0] && c1 == this.exclusiveColor[1] && c2 == this.exclusiveColor[2]) continue;
                    this.gl.glColor3b(c0, c1, c2);
                }
                this.gl.glNormal3f(this.normals.get(vi * 3), this.normals.get(vi * 3 + 1), this.normals.get(vi * 3 + 2));
                this.gl.glVertex3f(this.vertices.get(vi * 3), this.vertices.get(vi * 3 + 1), this.vertices.get(vi * 3 + 2));
            }
            this.gl.glEnd();
        }
        this.gl.glEndList();
    }

    @Override
    protected void drawSelection(int mode) {
    }

    private void allocate() {
        this.vertices = BufferUtil.newFloatBuffer((int)(this.vertexCount * 3));
        this.colors = ByteBuffer.allocateDirect(this.vertexCount * 4);
        this.trcolors = ByteBuffer.allocateDirect(this.vertexCount * 4);
        if (this.primitiveCount > 0) {
            this.primitives = new int[this.primitiveCount * this.primitiveNodeCount];
        }
    }

    private void tidyIndices() {
        if (!this.indicesStartWithZero) {
            int i = 0;
            while (i < this.primitiveCount) {
                int n = i++;
                this.primitives[n] = this.primitives[n] - 1;
            }
            this.indicesStartWithZero = true;
        }
    }

    private void setNormals() {
        this.normals = BufferUtil.newFloatBuffer((int)(this.primitiveCount * 3));
        for (int i = 0; i < this.primitiveCount; ++i) {
            int i1 = this.primitives[i * 3];
            int i2 = this.primitives[i * 3 + 1];
            int i3 = this.primitives[i * 3 + 2];
            float dx = this.vertices.get(i2) - this.vertices.get(i1);
            float dy = this.vertices.get(i2 + 1) - this.vertices.get(i1 + 1);
            float dz = this.vertices.get(i2 + 2) - this.vertices.get(i1 + 2);
            float ex = this.vertices.get(i3) - this.vertices.get(i1);
            float ey = this.vertices.get(i3 + 1) - this.vertices.get(i1 + 1);
            float ez = this.vertices.get(i3 + 2) - this.vertices.get(i1 + 2);
            int n = GeomCalc.newVector(dx * ey - dy * ex, dz * ex - dx * ez, dy * ez - dz * ey);
            GeomCalc.normalize(n);
            this.putNormal(GeomCalc.getX(n), GeomCalc.getY(n), GeomCalc.getZ(n));
            GeomCalc.deleteVector(n);
        }
    }

    public void coloring(boolean c) {
        this.constantColoring = !c;
        this.rawDisplayListIsGenerated = false;
        if (c && this.colors != null) {
            this.colors = BufferUtil.newByteBuffer((int)(this.vertexCount * 4));
            this.trcolors = BufferUtil.newByteBuffer((int)(this.vertexCount * 4));
        }
    }

    public void setDrawType(String type) {
        if (type.equals("Off")) {
            this.visible = false;
        } else {
            this.drawType = type.equals("Dot") ? 1 : (type.equals("Mesh") ? 2 : (type.equals("Solid") ? 3 : 4));
        }
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) {
        if (propertyName.equals("Surface.DrawType")) {
            this.setDrawType(propertyValue);
        }
    }

    @Override
    public boolean hasTransparentPart() {
        return this.drawType == 2 || this.drawType == 4;
    }

    public int getDrawType() {
        return this.drawType;
    }

    public boolean isClipped() {
        return this.clippingEnabled;
    }

    public void clipSurface(BoundingBox bb) {
        this.boundingBox.clear();
        this.boundingBox.setWithCondition(bb);
        this.clippingEnabled = true;
    }

    private void setClippingPlanes() {
        this.gl.glClipPlane(12288, new double[]{1.0, 0.0, 0.0, -this.boundingBox.minx()}, 0);
        this.gl.glClipPlane(12289, new double[]{0.0, 1.0, 0.0, -this.boundingBox.miny()}, 0);
        this.gl.glClipPlane(12290, new double[]{0.0, 0.0, 1.0, -this.boundingBox.minz()}, 0);
        this.gl.glClipPlane(12291, new double[]{-1.0, 0.0, 0.0, this.boundingBox.maxx()}, 0);
        this.gl.glClipPlane(12292, new double[]{0.0, -1.0, 0.0, this.boundingBox.maxy()}, 0);
        this.gl.glClipPlane(12293, new double[]{0.0, 0.0, -1.0, this.boundingBox.maxz()}, 0);
    }
}

