/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.VisibleMolecule;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MoleculeIterators;
import java.awt.Color;
import java.util.HashMap;
import java.util.Properties;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class WaterVisualizer
implements MoleculeIterators.MoleculeInterface,
MacroMoleculeComponent.MoleculeVisualizer,
UsableObject {
    protected static final int DEFAULT_H_BALL_PRECISION = 4;
    protected static final int DEFAULT_H_SPACEFILL_PRECISION = 4;
    protected static final int DEFAULT_H_BOND_SLICE_PRECISION = 8;
    protected static final int DEFAULT_H_JOINT_PRECISION = 4;
    protected static final int DEFAULT_H_STICK_SLICE_PRECISION = 14;
    protected static final int DEFAULT_M_BALL_PRECISION = 3;
    protected static final int DEFAULT_M_SPACEFILL_PRECISION = 3;
    protected static final int DEFAULT_M_BOND_SLICE_PRECISION = 6;
    protected static final int DEFAULT_M_JOINT_PRECISION = 3;
    protected static final int DEFAULT_M_STICK_SLICE_PRECISION = 12;
    protected static final int DEFAULT_L_BALL_PRECISION = 2;
    protected static final int DEFAULT_L_SPACEFILL_PRECISION = 2;
    protected static final int DEFAULT_L_BOND_SLICE_PRECISION = 4;
    protected static final int DEFAULT_L_JOINT_PRECISION = 2;
    protected static final int DEFAULT_L_STICK_SLICE_PRECISION = 10;
    public static final float DEFAULT_BALL_RADIUS = 0.4f;
    protected static final double DEFAULT_LINE_WIDTH = 0.5;
    protected static final double DEFAULT_BOND_RADIUS = 0.1;
    protected static final double DEFAULT_STICK_RADIUS = 0.15;
    protected static final int DEFAULT_BOND_DISTANCE = 100;
    protected static final int DEFAULT_BOND_WIDTH = 50;
    protected static final boolean SMOOTH_STICKS = false;
    protected static final boolean SCALED_BALLS = false;
    protected static final boolean DISPLAY_BOND_ORDER = true;
    protected static final Color DEFAULT_COLOR = new Color(255, 0, 0);
    public static final int HIDDEN = -1;
    public static final int FADED = -2;
    public static final int DRAW_TYPE_WIRE = 2;
    public static final int DRAW_TYPE_BALL = 3;
    public static final int DRAW_TYPE_STICK = 4;
    public static final int DRAW_TYPE_BALL_AND_WIRE = 5;
    public static final int DRAW_TYPE_BALL_AND_STICK = 6;
    public static final int DRAW_TYPE_SPACEFILL = 7;
    protected static HashMap drawTypes = new HashMap();
    protected Properties drawProperties;
    MacroMolecule.HeteroComponent water;
    MacroMoleculeComponent mmc;
    GL gl;
    GLU glu;
    protected String name;
    protected UOID uoid;
    protected BoundingBox boundingBox;
    private boolean drawHydrogens;
    private boolean drawLonePairs;
    private int colorType;
    private int drawType;
    private int quality;
    protected float ballRadius;
    protected double bondRadius;
    protected double stickRadius;
    protected double lineWidth;
    protected int bondDistance;
    protected int bondWidth;
    protected boolean smoothStickColoring;
    protected boolean scaledBalls;
    protected boolean displayBondOrder;
    protected int ballPrecision;
    protected int spacefillPrecision;
    protected int bondSlicePrecision;
    protected int stickSlicePrecision;
    protected int jointPrecision;
    VisibleMolecule visibleMolecule;
    private boolean visible;
    protected int atomCount;
    protected int bondCount;
    protected int maxIndex;
    private MoleculeIterators.AtomIteratorInterface atoms;
    private MoleculeIterators.AtomIteratorInterface atomsWithH;
    private MoleculeIterators.BondIteratorInterface bonds;
    private MoleculeIterators.BondIteratorInterface bondsWithH;
    MoleculeIterators.AtomPropertyInterface atomProps;
    protected Color color;

    public WaterVisualizer(MacroMolecule.HeteroComponent hc, MacroMoleculeComponent mmc) {
        drawTypes.put("Wire", new Integer(2));
        drawTypes.put("Ball", new Integer(3));
        drawTypes.put("Stick", new Integer(4));
        drawTypes.put("BallAndWire", new Integer(5));
        drawTypes.put("WireAndBall", new Integer(5));
        drawTypes.put("BallAndStick", new Integer(6));
        drawTypes.put("StickAndBall", new Integer(6));
        drawTypes.put("Spacefill", new Integer(7));
        this.drawProperties = new Properties();
        this.water = null;
        this.mmc = null;
        this.gl = null;
        this.glu = null;
        this.uoid = null;
        this.boundingBox = new BoundingBox();
        this.drawHydrogens = true;
        this.drawLonePairs = false;
        this.colorType = 1;
        this.drawType = 2;
        this.quality = 2;
        this.ballRadius = 0.4f;
        this.bondRadius = 0.1;
        this.stickRadius = 0.15;
        this.lineWidth = 0.5;
        this.bondDistance = 100;
        this.bondWidth = 50;
        this.smoothStickColoring = false;
        this.scaledBalls = false;
        this.displayBondOrder = true;
        this.ballPrecision = 3;
        this.spacefillPrecision = 3;
        this.bondSlicePrecision = 6;
        this.stickSlicePrecision = 12;
        this.jointPrecision = 3;
        this.visibleMolecule = null;
        this.visible = true;
        this.atoms = null;
        this.atomsWithH = null;
        this.bonds = null;
        this.bondsWithH = null;
        this.atomProps = null;
        this.color = DEFAULT_COLOR;
        this.water = hc;
        this.mmc = mmc;
        this.atoms = this.water.getAtomIterator(false);
        this.atomsWithH = this.water.getAtomIterator(true);
        this.bonds = this.water.getBondIterator(false);
        this.bondsWithH = this.water.getBondIterator(true);
        this.atomProps = this.water.getAtomProperty();
        this.maxIndex = this.water.getAtomIterator(true).getMaxIndex();
        this.atomCount = this.atoms.getCount();
        this.bondCount = this.bonds.getCount();
        this.setBoundingBox();
        String name = this.water.getName();
        if (name == null || name.length() == 0) {
            name = "Water";
        }
        this.setName(name);
    }

    @Override
    public void onRemove() {
        this.visibleMolecule.onRemove();
        this.water = null;
        this.mmc = null;
        this.atomProps = null;
        this.visibleMolecule = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void setName(String n) {
        this.name = n;
    }

    private void setBoundingBox() {
        float e = 2.0f;
        this.atoms.reset();
        while (this.atoms.hasNext()) {
            this.boundingBox.setWithCondition(this.atoms.getX(), this.atoms.getY(), this.atoms.getZ());
            this.atoms.next();
        }
        this.boundingBox.setMin(this.boundingBox.minx() - e, this.boundingBox.miny() - e, this.boundingBox.minz() - e);
        this.boundingBox.setMax(this.boundingBox.maxx() + e, this.boundingBox.maxy() + e, this.boundingBox.maxz() + e);
        this.boundingBox.ready();
    }

    @Override
    public UOID getId() {
        if (this.uoid == null) {
            this.uoid = this.mmc.getUsableObjectId(this);
        }
        return this.uoid;
    }

    @Override
    public boolean isGraphicComponent() {
        return false;
    }

    @Override
    public GraphicComponent getGraphicComponent() {
        return this.mmc;
    }

    public ComponentElement getComponentElement() {
        return this.mmc.getComponentElement(this);
    }

    @Override
    public MacroMoleculeComponent getMacroMoleculeComponent() {
        return this.mmc;
    }

    @Override
    public void setGL(GL gl, GLU glu) {
        this.gl = gl;
        this.glu = glu;
    }

    @Override
    public boolean hasTransparentPart() {
        return this.visibleMolecule != null && (this.visibleMolecule.drawType == 2 || this.visibleMolecule.drawType == 5);
    }

    @Override
    public void drawTransparentPart() {
        if (!this.visible || this.gl == null) {
            return;
        }
        if (this.visibleMolecule == null) {
            this.visibleMolecule = new VisibleMolecule(this.gl, this.glu, this);
            this.setValues();
        }
        if (this.gl.glIsList(this.visibleMolecule.getDisplayList2D())) {
            int dl = this.visibleMolecule.getDisplayList2D();
            this.gl.glCallList(dl);
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.gl.glCallList(this.visibleMolecule.getDisplayList());
    }

    @Override
    public void initDraw() {
        if (this.visibleMolecule == null) {
            this.visibleMolecule = new VisibleMolecule(this.gl, this.glu, this);
            this.setValues();
        }
        this.visibleMolecule.init();
    }

    protected void setValues() {
        this.visibleMolecule.drawHydrogens = this.drawHydrogens;
        this.visibleMolecule.drawLonePairs = this.drawLonePairs;
        this.visibleMolecule.quality = this.quality;
        this.visibleMolecule.colorType = this.colorType;
        this.visibleMolecule.drawType = this.drawType;
        this.visibleMolecule.ballRadius = this.ballRadius;
        this.visibleMolecule.bondRadius = this.bondRadius;
        this.visibleMolecule.stickRadius = this.stickRadius;
        this.visibleMolecule.lineWidth = this.lineWidth;
        this.visibleMolecule.jointRadius = this.stickRadius - 0.005;
        this.visibleMolecule.oldStyleStickColoring = !this.smoothStickColoring;
        this.visibleMolecule.scaledBalls = this.scaledBalls;
        this.visibleMolecule.displayBondOrder = this.displayBondOrder;
        this.visibleMolecule.bondDistance = this.bondDistance;
        this.visibleMolecule.bondWidth = this.bondWidth;
        this.visibleMolecule.ballPrecision = this.ballPrecision;
        this.visibleMolecule.spacefillPrecision = this.spacefillPrecision;
        this.visibleMolecule.bondSlicePrecision = this.bondSlicePrecision;
        this.visibleMolecule.stickSlicePrecision = this.stickSlicePrecision;
        this.visibleMolecule.jointPrecision = this.jointPrecision;
    }

    @Override
    public boolean isSelectedAtom(int i) {
        return this.visibleMolecule.isSelectedAtom(i);
    }

    @Override
    public void select() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.isAtomVisible(this.atomsWithH.current())) {
                this.visibleMolecule.selectAtom(this.atomsWithH.current());
            }
            this.atomsWithH.next();
        }
    }

    @Override
    public void selectComponentElementsInside(BoundingBox bb) {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (bb.contains(this.atomsWithH.getX(), this.atomsWithH.getY(), this.atomsWithH.getZ()) && this.isAtomVisible(this.atomsWithH.current())) {
                this.visibleMolecule.selectAtom(this.atomsWithH.current());
            }
            this.atomsWithH.next();
        }
    }

    @Override
    public void selectAtom(int i) {
        this.visibleMolecule.selectAtom(i);
    }

    @Override
    public void unSelectAtom(int i) {
        this.visibleMolecule.unSelectAtom(i);
    }

    @Override
    public int selectedAtomCount() {
        return this.visibleMolecule.selectedAtomCount();
    }

    @Override
    public String getDescription(ComponentElement ce) {
        if (ce.getElementType() == 2) {
            return this.water.getAtomLabel(ce.getElementIndex());
        }
        return this.water.getName();
    }

    @Override
    public ComponentElement[] getLabelInformation(String labelType) {
        if (labelType.equalsIgnoreCase("molecule")) {
            return new ComponentElement[]{this.mmc.getComponentElement(this)};
        }
        return new ComponentElement[0];
    }

    @Override
    public boolean isSelected() {
        return this.getVisibleAtomCount() == this.visibleMolecule.selectedAtomCount() && this.visibleMolecule.selectedAtomCount() > 0;
    }

    @Override
    public void unSelect() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            this.visibleMolecule.unSelectAtom(this.atomsWithH.current());
            this.atomsWithH.next();
        }
    }

    @Override
    public void drawAtomSelection(int mode) {
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawAtomSelection(mode, this.mmc.irm);
        }
    }

    @Override
    public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean enumerateHydrogens) {
        return this.water.getAtomIterator(enumerateHydrogens);
    }

    @Override
    public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
        return this.atomProps;
    }

    @Override
    public MoleculeIterators.BondIteratorInterface getBondIterator(boolean enumerateHydrogens) {
        return this.water.getBondIterator(enumerateHydrogens);
    }

    @Override
    public int getAtomCount(boolean enumerateHydrogens) {
        return this.getAtomIterator(enumerateHydrogens).getCount();
    }

    @Override
    public int getBondCount(boolean enumerateHydrogens) {
        return this.getBondIterator(enumerateHydrogens).getCount();
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isAtomVisible(int i) {
        if (!this.visible) {
            return false;
        }
        if (this.visibleMolecule == null) {
            return true;
        }
        return this.visibleMolecule.isAtomVisible(i);
    }

    @Override
    public int getVisibleAtomCount() {
        if (!this.visible) {
            return 0;
        }
        if (this.visibleMolecule == null) {
            return this.getAtomCount(true);
        }
        int c = 0;
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isAtomVisible(this.atomsWithH.current())) {
                ++c;
            }
            this.atomsWithH.next();
        }
        return c;
    }

    @Override
    public void setVisible(boolean v) {
        if (this.visible && this.visibleMolecule != null) {
            this.atomsWithH.reset();
            while (this.atomsWithH.hasNext()) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), this.visibleMolecule.drawType);
                this.atomsWithH.next();
            }
            this.setBoundingBox();
        }
        if (this.visible == v) {
            return;
        }
        this.visible = v;
        this.mmc.setBoundingBox();
    }

    @Override
    public void showFaded() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.isAtomFaded(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), this.visibleMolecule.drawType);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void hideSelected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.unSelectAtom(this.atomsWithH.current());
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -1);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void hideUnselected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (!this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -1);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void fadeSelected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.unSelectAtom(this.atomsWithH.current());
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -2);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public void fadeUnselected() {
        this.atomsWithH.reset();
        while (this.atomsWithH.hasNext()) {
            if (this.visibleMolecule.isAtomVisible(this.atomsWithH.current()) && !this.visibleMolecule.isSelectedAtom(this.atomsWithH.current())) {
                this.visibleMolecule.setAtomDrawType(this.atomsWithH.current(), -2);
            }
            this.atomsWithH.next();
        }
        this.setBoundingBox();
    }

    @Override
    public boolean isAtomFaded(int i) {
        if (this.visibleMolecule == null) {
            return false;
        }
        return this.visibleMolecule.isAtomFaded(i);
    }

    @Override
    public boolean isHighlighted() {
        return this.visibleMolecule.isHighlighted();
    }

    @Override
    public void setHighlighted(boolean v) {
        this.visibleMolecule.setHighlighted(v);
    }

    @Override
    public int getColorType() {
        return this.colorType;
    }

    private void setDrawType(String drawType) {
        int dt = -1;
        try {
            dt = (Integer)drawTypes.get(drawType);
        }
        catch (Exception e) {
            System.out.println("Unexpected type of draw: " + drawType);
        }
        if (this.drawType == dt || dt == -1) {
            return;
        }
        this.drawType = dt;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawType = this.drawType;
            this.visibleMolecule.drawTypeChanged();
        }
    }

    private void setQuality(String propertyName) {
        if (propertyName.equalsIgnoreCase("medium") && this.quality != 2) {
            this.setQuality(2);
        } else if (propertyName.equalsIgnoreCase("high") && this.quality != 3) {
            this.setQuality(3);
        } else if (propertyName.equalsIgnoreCase("low") && this.quality != 1) {
            this.setQuality(1);
        }
    }

    private void setQuality(int quality) {
        if (this.quality == quality) {
            return;
        }
        this.quality = quality;
        if (quality == 3) {
            this.ballPrecision = 4;
            this.spacefillPrecision = 4;
            this.jointPrecision = 4;
            this.stickSlicePrecision = 14;
            this.bondSlicePrecision = 8;
        } else if (quality == 2) {
            this.ballPrecision = 3;
            this.spacefillPrecision = 3;
            this.jointPrecision = 3;
            this.stickSlicePrecision = 12;
            this.bondSlicePrecision = 6;
        } else if (quality == 1) {
            this.ballPrecision = 2;
            this.spacefillPrecision = 2;
            this.jointPrecision = 2;
            this.stickSlicePrecision = 10;
            this.bondSlicePrecision = 4;
        }
        if (this.visibleMolecule != null) {
            this.setValues();
            this.visibleMolecule.qualityChanged();
        }
    }

    private void showHydrogens(boolean flag) {
        if (this.drawHydrogens == flag) {
            return;
        }
        this.drawHydrogens = flag;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawHydrogens = flag;
            this.visibleMolecule.showHydrogensChanged();
        }
    }

    private void showLonePairs(boolean flag) {
        if (this.drawLonePairs == flag) {
            return;
        }
        this.drawLonePairs = flag;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.drawLonePairs = flag;
            this.visibleMolecule.showHydrogensChanged();
        }
    }

    private void setColorType(String propertyValue) {
        int ct = -1;
        if (propertyValue.equals("CPK")) {
            ct = 1;
        } else if (propertyValue.equals("Constant")) {
            ct = 2;
        }
        if (this.colorType == ct || ct == -1) {
            return;
        }
        this.colorType = ct;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.colorType = this.colorType;
            this.visibleMolecule.colorTypeChanged();
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.colorTypeChanged();
        }
    }

    private void setSpacefillRadius(float r) {
    }

    private void setBallRadius(float r) {
        this.ballRadius = r;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.ballRadius = this.ballRadius;
            this.visibleMolecule.needRecreateOneBall = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setBondRadius(double radius) {
        this.bondRadius = radius;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondRadius = this.bondRadius;
            this.visibleMolecule.needRecreateOneBond = true;
            if (this.smoothStickColoring) {
                this.visibleMolecule.needRecreateBonds = true;
                this.visibleMolecule.needRecreateSticks = true;
            }
        }
    }

    private void setLineWidth(float l) {
        this.lineWidth = l;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.lineWidth = this.lineWidth;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setStickRadius(double radius) {
        this.stickRadius = radius;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.stickRadius = this.stickRadius;
            this.visibleMolecule.jointRadius = this.stickRadius - 0.005;
            this.visibleMolecule.needRecreateOneStick = true;
            this.visibleMolecule.needRecreateOneJoint = true;
            if (this.smoothStickColoring) {
                this.visibleMolecule.needRecreateBonds = true;
                this.visibleMolecule.needRecreateSticks = true;
            }
        }
    }

    private void setBondDistance(int bondDistance) {
        this.bondDistance = bondDistance;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondDistance = bondDistance;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setBondWidth(int bondWidth) {
        this.bondWidth = bondWidth;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.bondWidth = bondWidth;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    private void setSmoothStickStyle(boolean style) {
        this.smoothStickColoring = style;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.oldStyleStickColoring = !this.smoothStickColoring;
            this.visibleMolecule.stickStyleChanged();
        }
    }

    private void setScaledBalls(boolean b) {
        this.scaledBalls = b;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.scaledBalls = this.scaledBalls;
            this.visibleMolecule.needRecreateBalls = true;
        }
    }

    private void setDisplayBondOrder(boolean b) {
        this.displayBondOrder = b;
        if (this.visibleMolecule != null) {
            this.visibleMolecule.displayBondOrder = this.displayBondOrder;
            this.visibleMolecule.needRecreateBonds = true;
            this.visibleMolecule.needRecreateWire = true;
        }
    }

    @Override
    public String getDrawProperty(String propertyName) {
        return this.drawProperties.getProperty(propertyName);
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) {
        if (propertyName.equals("Quality")) {
            this.setDrawProperty("Water.Quality", propertyValue);
            return;
        }
        if (propertyName.startsWith("Colors.CPK") && this.visibleMolecule != null) {
            this.visibleMolecule.colorTypeChanged();
        }
        if (!propertyName.startsWith("Water")) {
            return;
        }
        this.drawProperties.setProperty(propertyName, propertyValue);
        if (propertyName.equals("Water.DrawType")) {
            this.setDrawType(propertyValue);
        } else if (propertyName.equals("Water.Hydrogens")) {
            this.showHydrogens(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Water.LonePairs")) {
            this.showLonePairs(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Water.Quality")) {
            this.setQuality(propertyValue);
        } else if (propertyName.equals("Water.Color")) {
            this.setColor(Color.decode(propertyValue));
        } else if (propertyName.equals("Water.ColorType")) {
            this.setColorType(propertyValue);
        } else if (propertyName.equals("Water.BallRadius")) {
            this.setBallRadius(Float.valueOf(propertyValue).floatValue());
        } else if (propertyName.equals("Water.BondRadius")) {
            this.setBondRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("Water.StickRadius")) {
            this.setStickRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("Water.LineWidth")) {
            this.setLineWidth(Float.valueOf(propertyValue).floatValue());
        } else if (propertyName.equals("Water.BondDistance")) {
            this.setBondDistance(Integer.parseInt(propertyValue));
        } else if (propertyName.equals("Water.BondWidth")) {
            this.setBondWidth(Integer.parseInt(propertyValue));
        } else if (propertyName.equals("Water.SmoothStickStyle")) {
            this.setSmoothStickStyle(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Water.ScaledBalls")) {
            this.setScaledBalls(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Water.DisplayBondOrder")) {
            this.setDisplayBondOrder(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Water.Visible")) {
            this.setVisible(Boolean.valueOf(propertyValue));
        }
    }
}

