/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.DrawableException;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.Transform;
import chemaxon.marvin.space.drawing.VectorUtil;
import chemaxon.marvin.space.drawing.iface.IDrawable;

public class Bond
implements IDrawable {
    protected IDrawable _drawable;

    public Bond(int drawType, int bondType, float[] startPos, float[] endPos, byte[] color1, byte[] color2) throws DrawableException {
        IDrawable drawable = DrawableFactory.Get().CreateBond(drawType, bondType, color1, color2);
        double[] e = new double[]{endPos[0] - startPos[0], endPos[1] - startPos[1], endPos[2] - startPos[2]};
        double d = Math.sqrt(e[0] * e[0] + e[1] * e[1] + e[2] * e[2]);
        e[0] = e[0] / d;
        e[1] = e[1] / d;
        e[2] = e[2] / d;
        double[] eCyl = new double[]{0.0, 0.0, 1.0};
        double angle = VectorUtil.RadToDeg(VectorUtil.DotRad(e, eCyl));
        double[] n = VectorUtil.Cross(e, eCyl);
        Transform transform = new Transform(drawable);
        transform.getTransform().setRot((float)n[0], (float)n[1], (float)n[2], (float)(-angle));
        transform.getTransform().setPos(startPos[0], startPos[1], startPos[2]);
        transform.getTransform().setScale(1.0f, 1.0f, (float)d);
        this._drawable = DrawableFactory.Get().CreateStaticDrawable(transform);
        this.init();
    }

    @Override
    public void cleanup() {
        this._drawable.cleanup();
    }

    @Override
    public void draw() {
        this._drawable.draw();
    }

    @Override
    public void init() {
        this._drawable.init();
    }

    @Override
    public void select(boolean select) {
        this._drawable.select(select);
    }

    @Override
    public void setColor(byte[] color) {
        this._drawable.setColor(color);
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return IDrawable.DrawType.STATIC;
    }

    @Override
    public int getVertexCount() {
        return this._drawable.getVertexCount();
    }
}

