/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.DrawableCollection;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.marvin.space.drawing.iface.ISettingsProvider;
import chemaxon.struc.MoleculeIterators;
import java.util.ArrayList;
import java.util.Arrays;

public class Bonds
implements IDrawable {
    protected static final int HIDDEN = -1;
    protected static final int FADED = -2;
    protected static final int LONE_PAIR_TYPE = 130;
    protected IDrawable _drawable;
    protected ArrayList<IDrawable> _dynamicDrawables;

    public Bonds(ArrayList<IDrawable> dynamicDrawables, int drawType, int[] atomDrawTypes, MoleculeIterators.MoleculeInterface molecule) throws Exception {
        this._dynamicDrawables = dynamicDrawables;
        ISettingsProvider sp = DrawableFactory.GetSettingsProvider();
        MoleculeIterators.BondIteratorInterface bi = molecule.getBondIterator(sp.GetDrawHydrogens());
        MoleculeIterators.AtomIteratorInterface atomsWithH = molecule.getAtomIterator(true);
        MoleculeIterators.BondIteratorInterface bondsWithH = molecule.getBondIterator(true);
        boolean[] lonelyAtoms = new boolean[atomsWithH.getMaxIndex()];
        Arrays.fill(lonelyAtoms, true);
        ArrayList<IDrawable> bonds = new ArrayList<IDrawable>(bi.getCount() << 1);
        bi.reset();
        while (bi.hasNext()) {
            if (atomDrawTypes[bi.getAtomIndex(1)] != -1 && atomDrawTypes[bi.getAtomIndex(2)] != -1 && (sp.GetDrawHydrogens() || bi.getAtomType(1) != 1 && bi.getAtomType(2) != 1) && (sp.GetDrawLonePairs() || bi.getAtomType(1) != 130 && bi.getAtomType(2) != 130)) {
                IDrawable bond;
                float[] pos2;
                float[] pos1 = new float[]{bi.getX(1), bi.getY(1), bi.getZ(1)};
                byte[] color = DrawableFactory.GetSettingsProvider().getColor(molecule, bi, 1);
                if (!sp.drawBondOnePiece(bi) && !sp.SmoothStickColoring()) {
                    float[] pos3 = new float[]{bi.getX(2), bi.getY(2), bi.getZ(2)};
                    pos2 = new float[]{(pos3[0] + pos1[0]) / 2.0f, (pos3[1] + pos1[1]) / 2.0f, (pos3[2] + pos1[2]) / 2.0f};
                    bond = DrawableFactory.Get().CreateBond(drawType, bi.getBondType(), pos1, pos2, color, color);
                    if (bond.getDrawType() == IDrawable.DrawType.STATIC) {
                        bonds.add(bond);
                    } else {
                        this._dynamicDrawables.add(bond);
                    }
                    color = DrawableFactory.GetSettingsProvider().getColor(molecule, bi, 2);
                    bond = DrawableFactory.Get().CreateBond(drawType, bi.getBondType(), pos2, pos3, color, color);
                    if (bond.getDrawType() == IDrawable.DrawType.STATIC) {
                        bonds.add(bond);
                    } else {
                        this._dynamicDrawables.add(bond);
                    }
                } else {
                    byte[] secondaryColor = DrawableFactory.GetSettingsProvider().getColor(molecule, bi, 2);
                    pos2 = new float[]{bi.getX(2), bi.getY(2), bi.getZ(2)};
                    bond = DrawableFactory.Get().CreateBond(drawType, bi.getBondType(), pos1, pos2, color, secondaryColor);
                    if (bond.getDrawType() == IDrawable.DrawType.STATIC) {
                        bonds.add(bond);
                    } else {
                        this._dynamicDrawables.add(bond);
                    }
                }
            }
            bi.next();
        }
        this._drawable = new DrawableCollection(bonds);
        this.init();
    }

    @Override
    public void cleanup() {
        this._drawable.cleanup();
    }

    @Override
    public void select(boolean select) {
        this._drawable.select(select);
    }

    @Override
    public void setColor(byte[] color) {
    }

    @Override
    public void init() {
        this._drawable.init();
    }

    @Override
    public void draw() {
        this._drawable.draw();
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return this._drawable.getDrawType();
    }

    @Override
    public int getVertexCount() {
        return this._drawable.getVertexCount();
    }
}

