/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.VisibleMolecule;
import chemaxon.marvin.space.drawing.iface.ISettingsProvider;
import chemaxon.marvin.space.util.Palette;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MoleculeIterators;
import java.awt.Color;

public class DefaultSettingsProvider
implements ISettingsProvider {
    VisibleMolecule _visibleMolecule;

    public DefaultSettingsProvider(VisibleMolecule visibleMolecule) {
        this._visibleMolecule = visibleMolecule;
    }

    private MoleculeIterators.MoleculeInterface GetMoleculeInterface() {
        return this._visibleMolecule.molecule;
    }

    @Override
    public float GetBondRadius() {
        return (float)this._visibleMolecule.bondRadius;
    }

    @Override
    public float GetJointRadius() {
        return (float)this._visibleMolecule.jointRadius;
    }

    @Override
    public float GetDoubleBondRadius() {
        return this.GetBondRadius() / 2.0f;
    }

    @Override
    public float GetStickRadius() {
        return (float)this._visibleMolecule.stickRadius;
    }

    @Override
    public float GetLineWidth() {
        return (float)this._visibleMolecule.lineWidth;
    }

    @Override
    public float GetSelectedLineWidth() {
        return this.GetLineWidth() + 1.0f;
    }

    @Override
    public int GetBondDistance() {
        return this._visibleMolecule.bondDistance;
    }

    @Override
    public float GetIsoPropForVolData() {
        return 0.8f;
    }

    @Override
    public float GetVolDataScale() {
        return 2.0f;
    }

    @Override
    public float GetVolDataMargin() {
        return 2.0f;
    }

    @Override
    public float GetVolDataBin() {
        return 0.28f;
    }

    @Override
    public boolean SmoothStickColoring() {
        return !this._visibleMolecule.oldStyleStickColoring;
    }

    @Override
    public float[] GetBondShifting(int bondNo, int bondType, int drawType) {
        float bw = (float)this.GetBondDistance() * this.GetBondRadius() / 100.0f;
        if (bondType == 2) {
            switch (bondNo) {
                case 1: {
                    return new float[]{-bw, 0.0f, 0.0f};
                }
                case 2: {
                    return new float[]{bw, 0.0f, 0.0f};
                }
            }
        } else if (bondType == 3) {
            if (this.OrthogonalBonds()) {
                switch (bondNo) {
                    case 1: {
                        return new float[]{-bw * 1.5f, 0.0f, 0.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, 0.0f, 0.0f};
                    }
                    case 3: {
                        return new float[]{bw * 1.5f, 0.0f, 0.0f};
                    }
                }
            } else {
                switch (bondNo) {
                    case 1: {
                        return new float[]{-bw, -bw, 0.0f};
                    }
                    case 2: {
                        return new float[]{bw, -bw, 0.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, bw, 0.0f};
                    }
                }
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public int GetBondWidth() {
        return this._visibleMolecule.bondWidth;
    }

    @Override
    public int GetColorType() {
        return this._visibleMolecule.colorType;
    }

    @Override
    public float GetBallRadius() {
        return (float)this._visibleMolecule.ballRadius;
    }

    @Override
    public int GetBallPrecision() {
        return this._visibleMolecule.ballPrecision;
    }

    @Override
    public int GetSpacefillPrecision() {
        return this._visibleMolecule.spacefillPrecision;
    }

    @Override
    public int GetBondSlicePrecision() {
        return this._visibleMolecule.bondSlicePrecision;
    }

    @Override
    public int GetStickSlicePrecision() {
        return this._visibleMolecule.stickSlicePrecision;
    }

    @Override
    public int GetJointPrecision() {
        return this._visibleMolecule.jointPrecision;
    }

    @Override
    public float GetDefaultInset() {
        return 0.1f;
    }

    @Override
    public float GetARingInset() {
        return this.GetDefaultInset();
    }

    @Override
    public float GetARingR1() {
        return this.GetBondRadius();
    }

    @Override
    public float GetARingDefaultR2() {
        return 1.0f;
    }

    public Palette GetFactorPalette() {
        return this._visibleMolecule.bfactorPalette;
    }

    @Override
    public boolean GetDrawHydrogens() {
        return this._visibleMolecule.drawHydrogens;
    }

    @Override
    public boolean GetDrawLonePairs() {
        return this._visibleMolecule.drawLonePairs;
    }

    @Override
    public boolean GetScaledBalls() {
        return this._visibleMolecule.scaledBalls;
    }

    @Override
    public boolean OrthogonalBonds() {
        return this._visibleMolecule.bondFacing;
    }

    private MoleculeIterators.AtomPropertyInterface GetAtomPropertyInterface() {
        return this._visibleMolecule.props;
    }

    @Override
    public byte[] getConstantColor() {
        return this.getConstantColor(this.GetMoleculeInterface());
    }

    @Override
    public byte[] getConstantColor(MoleculeIterators.MoleculeInterface molecule) {
        if (this.GetColorType() == 2) {
            Color color = ((MacroMoleculeComponent.MoleculeVisualizer)((Object)molecule)).getColor();
            byte[] ret = new byte[]{(byte)(color.getRed() / 2), (byte)(color.getGreen() / 2), (byte)(color.getBlue() / 2)};
            return ret;
        }
        return Colors.silver;
    }

    @Override
    public byte[] getColor(MoleculeIterators.BondIteratorInterface bi, int which) {
        return this.getColor(this.GetMoleculeInterface(), bi, which);
    }

    @Override
    public byte[] getColor(MoleculeIterators.MoleculeInterface molecule, MoleculeIterators.BondIteratorInterface bi, int which) {
        if (this.GetColorType() == 1) {
            return Colors.getCPKByteColor(bi.getAtomType(which));
        }
        if (this.GetColorType() == 3) {
            if (!(bi instanceof MacroMolecule.Polymer.BondIterator)) {
                Color color = ((MacroMoleculeComponent.MoleculeVisualizer)((Object)molecule)).getColor();
                byte[] ret = new byte[]{(byte)(color.getRed() / 2), (byte)(color.getGreen() / 2), (byte)(color.getBlue() / 2)};
                return ret;
            }
            MacroMolecule.Polymer.BondIterator bondIterator = (MacroMolecule.Polymer.BondIterator)bi;
            return Colors.getResidueByteColor(bondIterator.getResidueType(which));
        }
        if (this.GetColorType() == 4) {
            int cn = ((PolymerVisualizer)molecule).getChainNumber();
            return Colors.getChainColor(cn);
        }
        if (this.GetColorType() == 5) {
            if (!(bi instanceof MacroMolecule.Polymer.BondIterator)) {
                Color color = ((MacroMoleculeComponent.MoleculeVisualizer)((Object)molecule)).getColor();
                byte[] ret = new byte[]{(byte)(color.getRed() / 2), (byte)(color.getGreen() / 2), (byte)(color.getBlue() / 2)};
                return ret;
            }
            MacroMolecule.Polymer.BondIterator bondIterator = (MacroMolecule.Polymer.BondIterator)bi;
            return Colors.getResidueByteColor(bondIterator.getSecondaryStructureType(which));
        }
        if (this.GetColorType() == 12 && this.GetFactorPalette() != null) {
            float bf = ((PolymerVisualizer)molecule).getAtomProperty().getBFactor(bi.getAtomIndex(which));
            return this.GetFactorPalette().getByteColor(bf);
        }
        return this.getConstantColor(molecule);
    }

    @Override
    public boolean drawBondOnePiece(MoleculeIterators.BondIteratorInterface bi) {
        switch (this.GetColorType()) {
            case 1: {
                return bi.getAtomType(1) == bi.getAtomType(2);
            }
            case 3: {
                return bi.getResidueType(1) == bi.getResidueType(2);
            }
            case 12: {
                return this.GetAtomPropertyInterface().getBFactor(bi.getAtomIndex(1)) == this.GetAtomPropertyInterface().getBFactor(bi.getAtomIndex(2));
            }
        }
        return true;
    }

    @Override
    public byte[] getColor(MoleculeIterators.AtomIteratorInterface ai, MoleculeIterators.MoleculeInterface molecule) {
        if (this._visibleMolecule.isAtomFaded(ai.current())) {
            return Colors.gray;
        }
        if (this.GetColorType() == 1) {
            return Colors.getCPKByteColor(ai.getAtomType());
        }
        if (this.GetColorType() == 3) {
            if (!(ai instanceof MacroMolecule.Polymer.AtomIterator)) {
                Color color = ((MacroMoleculeComponent.MoleculeVisualizer)((Object)molecule)).getColor();
                return new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()};
            }
            MacroMolecule.Polymer.AtomIterator atomIterator = (MacroMolecule.Polymer.AtomIterator)ai;
            return Colors.getResidueByteColor(atomIterator.getResidueType());
        }
        if (this.GetColorType() == 4) {
            int cn = ((PolymerVisualizer)molecule).getChainNumber();
            return Colors.getChainColor(cn);
        }
        if (this.GetColorType() == 5) {
            return Colors.getSecondaryTypeColor(ai.getSecondaryStructureType());
        }
        if (this.GetColorType() == 11 && ai instanceof MacroMolecule.Protein.AtomIterator && this._visibleMolecule.rainbowPalette != null) {
            int i = 0;
            MacroMolecule.Protein protein = (MacroMolecule.Protein)((PolymerVisualizer)molecule).getPolymer();
            MacroMolecule.Protein.CAlphaAtomIterator atoms = protein.getCAlphaAtomIterator();
            ((MacroMolecule.Polymer.AtomIterator)atoms).reset();
            while (((MacroMolecule.Polymer.AtomIterator)atoms).hasNext()) {
                if (atoms.sameResidue(((MacroMolecule.Polymer.AtomIterator)atoms).current(), ai.current())) {
                    return this._visibleMolecule.rainbowPalette.getByteColor(this._visibleMolecule.startIndex + i);
                }
                ((MacroMolecule.Polymer.AtomIterator)atoms).next();
                ++i;
            }
        } else if (this.GetColorType() == 12 && this._visibleMolecule.bfactorPalette != null) {
            float bf = ((PolymerVisualizer)molecule).getAtomProperty().getBFactor(ai.current());
            return this._visibleMolecule.bfactorPalette.getByteColor(bf);
        }
        return Colors.gray;
    }

    @Override
    public byte[] setGetColor(MoleculeIterators.BondIteratorInterface bi, int which, MoleculeIterators.MoleculeInterface molecule) {
        if (this._visibleMolecule.isAtomFaded(bi.getAtomIndex(which))) {
            return Colors.gray;
        }
        if (this.GetColorType() == 1) {
            return Colors.getCPKByteColor(bi.getAtomType(which));
        }
        if (this.GetColorType() == 3) {
            if (!(bi instanceof MacroMolecule.Polymer.BondIterator)) {
                Color color = ((MacroMoleculeComponent.MoleculeVisualizer)((Object)molecule)).getColor();
                return new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()};
            }
            MacroMolecule.Polymer.BondIterator bondIterator = (MacroMolecule.Polymer.BondIterator)bi;
            return Colors.getResidueByteColor(bondIterator.getResidueType(which));
        }
        if (this.GetColorType() == 4) {
            int cn = ((PolymerVisualizer)molecule).getChainNumber();
            return Colors.getChainColor(cn);
        }
        if (this.GetColorType() == 5) {
            return Colors.getSecondaryTypeColor(bi.getSecondaryStructureType(which));
        }
        if (this.GetColorType() == 11 && bi instanceof MacroMolecule.Protein.BondIterator && this._visibleMolecule.rainbowPalette != null) {
            int i = 0;
            MacroMolecule.Protein protein = (MacroMolecule.Protein)((PolymerVisualizer)molecule).getPolymer();
            MacroMolecule.Protein.CAlphaAtomIterator atoms = protein.getCAlphaAtomIterator();
            ((MacroMolecule.Polymer.AtomIterator)atoms).reset();
            while (((MacroMolecule.Polymer.AtomIterator)atoms).hasNext()) {
                if (atoms.sameResidue(((MacroMolecule.Polymer.AtomIterator)atoms).current(), bi.getAtomIndex(1))) {
                    return this._visibleMolecule.rainbowPalette.getByteColor(this._visibleMolecule.startIndex + i);
                }
                ((MacroMolecule.Polymer.AtomIterator)atoms).next();
                ++i;
            }
        } else if (this.GetColorType() == 12 && this._visibleMolecule.bfactorPalette != null) {
            float bf = ((PolymerVisualizer)molecule).getAtomProperty().getBFactor(bi.getAtomIndex(which));
            return this._visibleMolecule.bfactorPalette.getByteColor(bf);
        }
        return Colors.gray;
    }
}

