/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.DrawableException;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.Transform;
import chemaxon.marvin.space.drawing.VectorUtil;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.marvin.space.drawing.iface.ITransform;

public class OrthoBond
implements IDrawable {
    private float[] _e;
    private float[] _n;
    private float[] _bondInvMat;
    private float[] viewVect = new float[]{0.0f, 0.0f, 1.0f};
    protected Transform _drawable;
    protected ITransform _transform;
    protected ITransform _transform2;

    public OrthoBond(int drawType, int bondType, float[] startPos, float[] endPos, byte[] color1, byte[] color2) throws DrawableException {
        IDrawable drawable = DrawableFactory.Get().CreateBond(drawType, bondType, color1, color2);
        this._drawable = new Transform(DrawableFactory.Get().CreateStaticDrawable(drawable));
        this._e = new float[]{endPos[0] - startPos[0], endPos[1] - startPos[1], endPos[2] - startPos[2]};
        double d = VectorUtil.Normalize(this._e);
        float[] eCyl = new float[]{0.0f, 0.0f, 1.0f};
        float angle = VectorUtil.RadToDeg(VectorUtil.DotRad(this._e, eCyl));
        this._n = VectorUtil.Cross(this._e, eCyl);
        VectorUtil.Normalize(this._n);
        this._bondInvMat = VectorUtil.RotAx(this._n, VectorUtil.DegToRad(angle));
        this._transform = DrawableFactory.Get().CreateTransform();
        this._transform.setRot(this._n[0], this._n[1], this._n[2], -angle);
        this._transform.setPos(startPos[0], startPos[1], startPos[2]);
        this._transform.setScale(1.0f, 1.0f, (float)d);
        this._drawable.setColor(color1);
        this._drawable.init();
        this._transform2 = DrawableFactory.Get().CreateTransform();
    }

    private void transform() {
        float[] vm = this._drawable.getTransform().getViewMatrix();
        float[] transformedViewVect = VectorUtil.MatMul(vm, this.viewVect);
        VectorUtil.Normalize(this.viewVect);
        float[] projectedViewVect = VectorUtil.MatMul(this._bondInvMat, transformedViewVect);
        VectorUtil.Normalize(projectedViewVect);
        float dot = (float)VectorUtil.RadToDeg(Math.atan2(projectedViewVect[1], projectedViewVect[0]));
        this._transform2.setRot(this._e[0], this._e[1], this._e[2], dot -= 90.0f);
    }

    @Override
    public void draw() {
        this.transform();
        this._transform.push();
        this._transform.translate();
        this._transform2.rotate();
        this._transform.rotate();
        this._transform.scale();
        this._drawable.draw();
        this._transform.pop();
    }

    @Override
    public void init() {
        this._drawable.init();
    }

    @Override
    public void cleanup() {
        this._drawable.cleanup();
    }

    @Override
    public void select(boolean select) {
        this._drawable.select(select);
    }

    @Override
    public void setColor(byte[] color) {
        this._drawable.setColor(color);
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return IDrawable.DrawType.DYNAMIC;
    }

    @Override
    public int getVertexCount() {
        return this._drawable.getVertexCount();
    }
}

