/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.DrawableException;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.marvin.space.drawing.iface.ITransform;
import chemaxon.marvin.space.drawing.iface.ITransformable;

public class Transform
implements IDrawable,
ITransformable {
    protected ITransform _transform;
    protected IDrawable _drawable;

    public Transform(IDrawable drawable) throws DrawableException {
        this._drawable = drawable;
        this._transform = DrawableFactory.Get().CreateTransform();
    }

    @Override
    public ITransform getTransform() {
        return this._transform;
    }

    private void transform() {
        this._transform.translate();
        this._transform.rotate();
        this._transform.scale();
    }

    @Override
    public void draw() {
        this._transform.push();
        this.transform();
        this._drawable.draw();
        this._transform.pop();
    }

    @Override
    public void init() {
        this._drawable.init();
    }

    @Override
    public void cleanup() {
        this._drawable.cleanup();
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return this._drawable.getDrawType();
    }

    @Override
    public void setColor(byte[] color) {
        this._drawable.setColor(color);
    }

    @Override
    public void select(boolean select) {
        this._drawable.select(select);
    }

    @Override
    public int getVertexCount() {
        return this._drawable.getVertexCount();
    }
}

