/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

public class VectorUtil {
    public static double[] Cross(double[] v1, double[] v2) {
        return new double[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
    }

    public static double[] Mul(double[] v1, double[] v2) {
        return new double[]{v1[0] * v2[0], v1[1] * v2[1], v1[2] * v2[2]};
    }

    public static float[] Cross(float[] v1, float[] v2) {
        return new float[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
    }

    public static float[] Mul(float[] v1, float[] v2) {
        return new float[]{v1[0] * v2[0], v1[1] * v2[1], v1[2] * v2[2]};
    }

    public static double Len(double[] v) {
        return Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static float Len(float[] v) {
        return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static double Normalize(double[] v) {
        double d = VectorUtil.Len(v);
        v[0] = v[0] / d;
        v[1] = v[1] / d;
        v[2] = v[2] / d;
        return d;
    }

    public static double[] Normalize2(double[] v) {
        double d = VectorUtil.Len(v);
        double[] res = new double[]{v[0] / d, v[1] / d, v[2] / d};
        return res;
    }

    public static double Normalize(float[] v) {
        double d = VectorUtil.Len(v);
        v[0] = (float)((double)v[0] / d);
        v[1] = (float)((double)v[1] / d);
        v[2] = (float)((double)v[2] / d);
        return d;
    }

    public static float[] Normalize2(float[] v) {
        double d = VectorUtil.Len(v);
        float[] res = new float[]{(float)((double)v[0] / d), (float)((double)v[1] / d), (float)((double)v[2] / d)};
        return res;
    }

    public static double Dot(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static double DotRad(double[] v1, double[] v2) {
        return Math.acos(VectorUtil.Dot(v1, v2));
    }

    public static float Dot(float[] v1, float[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static float DotRad(float[] v1, float[] v2) {
        return (float)Math.acos(VectorUtil.Dot(v1, v2));
    }

    public static double Distance(float[] p1, float[] p2) {
        return Math.sqrt(p1[0] * p2[0] + p1[1] * p2[1] + p1[2] * p2[2]);
    }

    public static float RadToDeg(float rad) {
        return (float)((double)rad * 180.0 / Math.PI);
    }

    public static double RadToDeg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static float DegToRad(float deg) {
        return (float)((double)deg * Math.PI / 180.0);
    }

    public static double DegToRad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static float[] MatMul(float[] mat, float[] v) {
        float[] res = new float[]{mat[0] * v[0] + mat[1] * v[1] + mat[2] * v[2], mat[4] * v[0] + mat[5] * v[1] + mat[6] * v[2], mat[8] * v[0] + mat[9] * v[1] + mat[10] * v[2]};
        return res;
    }

    public static double[] MatMul(double[] mat, double[] v) {
        double[] res = new double[]{mat[0] * v[0] + mat[1] * v[1] + mat[2] * v[2], mat[4] * v[0] + mat[5] * v[1] + mat[6] * v[2], mat[8] * v[0] + mat[9] * v[1] + mat[10] * v[2]};
        return res;
    }

    public static float[] RotMatX(float a) {
        float[] res = new float[16];
        res[0] = 1.0f;
        res[5] = (float)Math.cos(a);
        res[6] = (float)(-Math.sin(a));
        res[9] = (float)Math.sin(a);
        res[10] = (float)Math.cos(a);
        return res;
    }

    public static float[] RotMatY(float a) {
        float[] res = new float[16];
        res[0] = (float)Math.cos(a);
        res[2] = (float)Math.sin(a);
        res[5] = 1.0f;
        res[9] = (float)(-Math.sin(a));
        res[10] = (float)Math.cos(a);
        return res;
    }

    public static float[] RotMatZ(float a) {
        float[] res = new float[16];
        res[0] = (float)Math.cos(a);
        res[1] = (float)(-Math.sin(a));
        res[4] = (float)Math.sin(a);
        res[5] = (float)Math.cos(a);
        res[10] = 1.0f;
        return res;
    }

    public static float[] MatMulMat(float[] mat1, float[] mat2) {
        float[] res = new float[16];
        res[0] = mat1[0] * mat2[0];
        res[1] = mat1[1] * mat2[1];
        res[2] = mat1[2] * mat2[2];
        res[4] = mat1[4] * mat2[4];
        res[5] = mat1[5] * mat2[5];
        res[6] = mat1[6] * mat2[6];
        res[8] = mat1[8] * mat2[8];
        res[9] = mat1[9] * mat2[9];
        res[10] = mat1[10] * mat2[10];
        return res;
    }

    public static float[] RotMat(float a, float b, float c) {
        float[] res = new float[16];
        res[0] = (float)(Math.cos(b) * Math.cos(c));
        res[1] = (float)(-Math.cos(a) * Math.sin(c) + Math.sin(a) * Math.sin(b) * Math.cos(c));
        res[2] = (float)(Math.sin(a) * Math.sin(b) + Math.cos(a) * Math.sin(b) * Math.cos(c));
        res[4] = (float)(Math.cos(b) * Math.sin(c));
        res[5] = (float)(Math.cos(a) * Math.cos(c) + Math.sin(a) * Math.sin(b) * Math.sin(c));
        res[6] = (float)(-Math.sin(a) * Math.cos(b) + Math.cos(a) * Math.sin(b) * Math.sin(c));
        res[8] = (float)(-Math.sin(b));
        res[9] = (float)(Math.sin(a) * Math.cos(b));
        res[10] = (float)(Math.cos(a) * Math.cos(b));
        return res;
    }

    public static float[] RotAx(float[] v, float a) {
        float[] res = new float[16];
        res[0] = (float)(Math.cos(a) + (double)(v[0] * v[0]) * (1.0 - Math.cos(a)));
        res[1] = (float)((double)(v[0] * v[1]) * (1.0 - Math.cos(a)) - (double)v[2] * Math.sin(a));
        res[2] = (float)((double)(v[0] * v[2]) * (1.0 - Math.cos(a)) + (double)v[1] * Math.sin(a));
        res[4] = (float)((double)(v[1] * v[0]) * (1.0 - Math.cos(a)) + (double)v[2] * Math.sin(a));
        res[5] = (float)(Math.cos(a) + (double)(v[1] * v[1]) * (1.0 - Math.cos(a)));
        res[6] = (float)((double)(v[1] * v[2]) * (1.0 - Math.cos(a)) - (double)v[0] * Math.sin(a));
        res[8] = (float)((double)(v[2] * v[0]) * (1.0 - Math.cos(a)) - (double)v[1] * Math.sin(a));
        res[9] = (float)((double)(v[2] * v[1]) * (1.0 - Math.cos(a)) + (double)v[0] * Math.sin(a));
        res[10] = (float)(Math.cos(a) + (double)(v[2] * v[2]) * (1.0 - Math.cos(a)));
        return res;
    }

    public static double[] RotAx(double[] v, double a) {
        double[] res = new double[16];
        res[0] = Math.cos(a) + v[0] * v[0] * (1.0 - Math.cos(a));
        res[1] = v[0] * v[1] * (1.0 - Math.cos(a)) - v[2] * Math.sin(a);
        res[2] = v[0] * v[2] * (1.0 - Math.cos(a)) + v[1] * Math.sin(a);
        res[4] = v[1] * v[0] * (1.0 - Math.cos(a)) + v[2] * Math.sin(a);
        res[5] = Math.cos(a) + v[1] * v[1] * (1.0 - Math.cos(a));
        res[6] = v[1] * v[2] * (1.0 - Math.cos(a)) - v[0] * Math.sin(a);
        res[8] = v[2] * v[0] * (1.0 - Math.cos(a)) - v[1] * Math.sin(a);
        res[9] = v[2] * v[1] * (1.0 - Math.cos(a)) + v[0] * Math.sin(a);
        res[10] = Math.cos(a) + v[2] * v[2] * (1.0 - Math.cos(a));
        return res;
    }

    public static double[] Transpose(double[] v) {
        double[] res = new double[16];
        res[0] = v[0];
        res[1] = v[4];
        res[2] = v[8];
        res[4] = v[1];
        res[5] = v[5];
        res[6] = v[9];
        res[8] = v[2];
        res[9] = v[6];
        res[10] = v[10];
        res[3] = 1.0 / v[3];
        res[7] = 1.0 / v[7];
        res[11] = 1.0 / v[11];
        res[12] = -v[12];
        res[13] = -v[13];
        res[14] = -res[14];
        return res;
    }

    public static float[] Transpose(float[] v) {
        float[] res = new float[16];
        res[0] = v[0];
        res[1] = v[4];
        res[2] = v[8];
        res[4] = v[1];
        res[5] = v[5];
        res[6] = v[9];
        res[8] = v[2];
        res[9] = v[6];
        res[10] = v[10];
        res[3] = 1.0f / v[3];
        res[7] = 1.0f / v[7];
        res[11] = 1.0f / v[11];
        res[12] = -v[12];
        res[13] = -v[13];
        res[14] = -res[14];
        return res;
    }

    public static float[] VSub(float[] v1, float[] v2) {
        return new float[]{v1[0] - v2[0], v1[1] - v2[1], v1[2] - v2[2]};
    }
}

