/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.BondIterator;
import chemaxon.marvin.space.drawing.DrawableException;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.VectorUtil;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.marvin.space.drawing.iface.ITransform;
import chemaxon.struc.MoleculeIterators;
import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Wire
implements IDrawable {
    IDrawable _drawable;
    protected ArrayList<IDrawable> _dynamicDrawables;

    public Wire(ArrayList<IDrawable> dynamicDrawables, int drawType, int[] atomDrawTypes, MoleculeIterators.MoleculeInterface molecule) throws DrawableException {
        this._dynamicDrawables = dynamicDrawables;
        ArrayList<Float> vArr = new ArrayList<Float>();
        ArrayList<Byte> cArr = new ArrayList<Byte>();
        OrthoWire _orthoWire = new OrthoWire();
        block4: for (BondIterator.BondData bd : new BondIterator(molecule, atomDrawTypes)) {
            switch (bd._bondType) {
                case 3: {
                    float[] shift3 = DrawableFactory.GetSettingsProvider().GetBondShifting(3, bd._bondType, drawType);
                    if (DrawableFactory.GetSettingsProvider().OrthogonalBonds()) {
                        _orthoWire.add(bd._pos1, bd._pos2, shift3, drawType, bd._color1, bd._color2);
                    } else {
                        this.AddVertex(vArr, bd._pos1, bd._pos2, shift3);
                        this.AddColor(cArr, bd._color1);
                        this.AddColor(cArr, bd._color2);
                    }
                }
                case 2: {
                    float[] shift = DrawableFactory.GetSettingsProvider().GetBondShifting(1, bd._bondType, drawType);
                    if (DrawableFactory.GetSettingsProvider().OrthogonalBonds()) {
                        _orthoWire.add(bd._pos1, bd._pos2, shift, drawType, bd._color1, bd._color2);
                    } else {
                        this.AddVertex(vArr, bd._pos1, bd._pos2, shift);
                        this.AddColor(cArr, bd._color1);
                        this.AddColor(cArr, bd._color2);
                    }
                    shift = DrawableFactory.GetSettingsProvider().GetBondShifting(2, bd._bondType, drawType);
                    if (DrawableFactory.GetSettingsProvider().OrthogonalBonds()) {
                        _orthoWire.add(bd._pos1, bd._pos2, shift, drawType, bd._color1, bd._color2);
                        continue block4;
                    }
                    this.AddVertex(vArr, bd._pos1, bd._pos2, shift);
                    this.AddColor(cArr, bd._color1);
                    this.AddColor(cArr, bd._color2);
                    continue block4;
                }
            }
            vArr.add(Float.valueOf(bd._pos1[0]));
            vArr.add(Float.valueOf(bd._pos1[1]));
            vArr.add(Float.valueOf(bd._pos1[2]));
            vArr.add(Float.valueOf(bd._pos2[0]));
            vArr.add(Float.valueOf(bd._pos2[1]));
            vArr.add(Float.valueOf(bd._pos2[2]));
            this.AddColor(cArr, bd._color1);
            this.AddColor(cArr, bd._color2);
        }
        FloatBuffer vertexBuffer = BufferUtil.newFloatBuffer((int)vArr.size());
        vertexBuffer.rewind();
        ByteBuffer colorBuffer = BufferUtil.newByteBuffer((int)vArr.size());
        colorBuffer.rewind();
        for (Float f : vArr) {
            vertexBuffer.put(f.floatValue());
        }
        for (Byte b : cArr) {
            colorBuffer.put(b);
        }
        this._drawable = DrawableFactory.Get().CreateLines(vertexBuffer);
        this._drawable.setColor(new byte[]{127, 0, 127});
        this._drawable = DrawableFactory.Get().CreateColorBuffer(this._drawable, colorBuffer);
        dynamicDrawables.add(_orthoWire);
    }

    private void AddColor(ArrayList<Byte> cArr, byte[] c) {
        cArr.add(c[0]);
        cArr.add(c[1]);
        cArr.add(c[2]);
    }

    private void AddVertex(ArrayList<Float> fArr, float[] pos1, float[] pos2, float[] shift) {
        float[] e = VectorUtil.VSub(pos2, pos1);
        float[] eShift = VectorUtil.Normalize2(shift);
        VectorUtil.Normalize(e);
        float[] axis = VectorUtil.Cross(e, eShift);
        if (Float.isNaN(axis[0]) || VectorUtil.Distance(new float[]{0.0f, 0.0f, 0.0f}, axis) == 0.0) {
            axis[0] = e[1];
            axis[1] = e[2];
            axis[2] = e[0];
        } else {
            VectorUtil.Normalize(axis);
        }
        float[] eShift2 = VectorUtil.Cross(e, axis);
        fArr.add(Float.valueOf(pos1[0] + eShift2[0] * shift[0]));
        fArr.add(Float.valueOf(pos1[1] + eShift2[1] * shift[0]));
        fArr.add(Float.valueOf(pos1[2] + eShift2[2] * shift[0]));
        fArr.add(Float.valueOf(pos2[0] + eShift2[0] * shift[0]));
        fArr.add(Float.valueOf(pos2[1] + eShift2[1] * shift[0]));
        fArr.add(Float.valueOf(pos2[2] + eShift2[2] * shift[0]));
    }

    @Override
    public void cleanup() {
        this._drawable.cleanup();
    }

    @Override
    public void select(boolean select) {
        this._drawable.select(select);
    }

    @Override
    public void setColor(byte[] color) {
        this._drawable.setColor(color);
    }

    @Override
    public void init() {
        this._drawable.init();
    }

    @Override
    public void draw() {
        this._drawable.draw();
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return this._drawable.getDrawType();
    }

    @Override
    public int getVertexCount() {
        return this._drawable.getVertexCount();
    }

    private class OrthoWire
    implements IDrawable {
        private final float[] _viewVect = new float[]{0.0f, 0.0f, 1.0f};
        private float[] _vArr;
        private byte[] _cArr;
        private ArrayList<BondInfo> _bondInfos = new ArrayList();
        private ITransform _transform = DrawableFactory.Get().CreateTransform();

        public void add(float[] pos1, float[] pos2, float[] shift, int bondType, byte[] c1, byte[] c2) {
            this._bondInfos.add(new BondInfo(pos1, pos2, shift, bondType, c1, c2));
        }

        @Override
        public void draw() {
            boolean arraysCreated = false;
            if (this._vArr == null || this._cArr == null || this._vArr.length < this._bondInfos.size()) {
                this._vArr = new float[this._bondInfos.size() * 3 * 2];
                this._cArr = new byte[this._bondInfos.size() * 3 * 2];
                arraysCreated = true;
            }
            float[] vm = this._transform.getViewMatrix();
            float[] transformedViewVect = VectorUtil.MatMul(vm, this._viewVect);
            int i = 0;
            int j = 0;
            for (BondInfo bi : this._bondInfos) {
                float[] shiftDir = VectorUtil.Cross(bi._e, transformedViewVect);
                if (Float.isNaN(shiftDir[0])) {
                    shiftDir[0] = bi._e[1];
                    shiftDir[1] = bi._e[2];
                    shiftDir[2] = bi._e[0];
                } else {
                    VectorUtil.Normalize(shiftDir);
                }
                this._vArr[i++] = bi._pos1[0] + shiftDir[0] * bi._shift[0];
                this._vArr[i++] = bi._pos1[1] + shiftDir[1] * bi._shift[0];
                this._vArr[i++] = bi._pos1[2] + shiftDir[2] * bi._shift[0];
                this._vArr[i++] = bi._pos2[0] + shiftDir[0] * bi._shift[0];
                this._vArr[i++] = bi._pos2[1] + shiftDir[1] * bi._shift[0];
                this._vArr[i++] = bi._pos2[2] + shiftDir[2] * bi._shift[0];
                if (!arraysCreated) continue;
                this._cArr[j++] = bi._color1[0];
                this._cArr[j++] = bi._color1[1];
                this._cArr[j++] = bi._color1[2];
                this._cArr[j++] = bi._color2[0];
                this._cArr[j++] = bi._color2[1];
                this._cArr[j++] = bi._color2[2];
            }
            try {
                Wire.this._drawable = DrawableFactory.Get().CreateLines(this._vArr);
            }
            catch (DrawableException ex) {
                Logger.getLogger(Wire.class.getName()).log(Level.SEVERE, null, ex);
            }
            Wire.this._drawable.setColor(new byte[]{127, 0, 127});
            try {
                Wire.this._drawable = DrawableFactory.Get().CreateColorBuffer(Wire.this._drawable, this._cArr);
            }
            catch (DrawableException ex) {
                Logger.getLogger(Wire.class.getName()).log(Level.SEVERE, null, ex);
            }
            Wire.this._drawable.draw();
        }

        @Override
        public void init() {
        }

        @Override
        public void cleanup() {
            Wire.this._drawable.cleanup();
        }

        @Override
        public IDrawable.DrawType getDrawType() {
            return IDrawable.DrawType.DYNAMIC;
        }

        @Override
        public void setColor(byte[] color) {
            Wire.this._drawable.setColor(color);
        }

        @Override
        public void select(boolean select) {
        }

        @Override
        public int getVertexCount() {
            return Wire.this._drawable.getVertexCount();
        }

        private class BondInfo {
            public float[] _pos1;
            public float[] _pos2;
            public float[] _shift;
            public float[] _e;
            public int _bondType;
            public byte[] _color1;
            public byte[] _color2;

            public BondInfo(float[] pos1, float[] pos2, float[] shift, int bondType, byte[] c) {
                this(pos1, pos2, shift, bondType, c, c);
            }

            public BondInfo(float[] pos1, float[] pos2, float[] shift, int bondType, byte[] c1, byte[] c2) {
                this._pos1 = pos1;
                this._pos2 = pos2;
                this._shift = shift;
                this._bondType = bondType;
                this._color1 = c1;
                this._color2 = c2;
                this._e = VectorUtil.VSub(pos2, pos1);
                VectorUtil.Normalize(this._e);
            }
        }
    }
}

