/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing.geom;

import java.nio.FloatBuffer;

public class Cylinder {
    private final float _r;
    private final float _h;
    private final int _s;
    private final int _seg;
    public static final float R = 1.0f;
    public static final int S = 20;
    public static final float H = 1.0f;
    public static final int SEG = 1;

    public Cylinder() {
        this._r = 1.0f;
        this._s = 20;
        this._h = 1.0f;
        this._seg = 1;
    }

    public Cylinder(float r, float h, int s, int seg) {
        this._r = r;
        this._s = s;
        this._h = h;
        this._seg = seg;
    }

    public float getR() {
        return this._r;
    }

    public int getS() {
        return this._s;
    }

    public int getSeg() {
        return this._seg;
    }

    public float getHeight() {
        return this._h;
    }

    public void createVertex(int u, int v, FloatBuffer vertices, FloatBuffer normals) {
        double ds = Math.PI * 2 / (double)this._s;
        float dx = (float)Math.cos(ds * (double)v);
        float dy = (float)Math.sin(ds * (double)v);
        float x = this._r * dx;
        float y = this._r * dy;
        float z = (float)(u / this._seg) * this._h;
        vertices.put(x);
        vertices.put(y);
        vertices.put(z);
        normals.put(dx);
        normals.put(dy);
        normals.put(0.0f);
    }
}

