/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing.geom;

import java.nio.FloatBuffer;

public class Sphere {
    private float _r;
    private int _t;
    public static final float R = 1.0f;
    public static final int T = 16;

    public Sphere() {
        this._r = 1.0f;
        this._t = 16;
    }

    public Sphere(float r, int t) {
        this._r = r;
        this._t = t;
    }

    public float getR() {
        return this._r;
    }

    public int getT() {
        return this._t;
    }

    public void createVertex(int u, int v, FloatBuffer vertices, FloatBuffer normals) {
        double ds = Math.PI * 2 / (double)this._t;
        double sinU = Math.sin(ds * (double)u);
        double cosV = Math.cos(ds * (double)v);
        double sinV = Math.sin(ds * (double)v);
        double cosU = Math.cos(ds * (double)u);
        double x = (double)this._r * sinU * cosV;
        double y = (double)this._r * sinU * sinV;
        double z = (double)this._r * cosU;
        vertices.put((float)x);
        vertices.put((float)y);
        vertices.put((float)z);
        double d = Math.sqrt(x * x + y * y + z * z);
        normals.put((float)(x / d));
        normals.put((float)(y / d));
        normals.put((float)(z / d));
    }
}

