/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing.geom;

import chemaxon.common.util.GeomCalc;
import java.nio.FloatBuffer;

public class Torus {
    private final float _r1;
    private final float _r2;
    private final int _s1;
    private final int _s2;
    public static final float R1 = 0.1f;
    public static final float R2 = 1.0f;
    public static final int S1 = 10;
    public static final int S2 = 20;

    public Torus() {
        this._r1 = 0.1f;
        this._r2 = 1.0f;
        this._s1 = 10;
        this._s2 = 20;
    }

    public Torus(float r1, float r2, int s1, int s2) {
        this._r1 = r1;
        this._r2 = r2;
        this._s1 = s1;
        this._s2 = s2;
    }

    public final float getR1() {
        return this._r1;
    }

    public final float getR2() {
        return this._r2;
    }

    public final int getS1() {
        return this._s1;
    }

    public final int getS2() {
        return this._s2;
    }

    public void createVertex(int u, int v, FloatBuffer vertices, FloatBuffer normals) {
        double ds1 = Math.PI * 2 / (double)this._s1;
        double ds2 = Math.PI * 2 / (double)this._s2;
        float x = (this._r2 + this._r1 * (float)Math.cos(ds1 * (double)v)) * (float)Math.cos(ds2 * (double)u);
        float y = (this._r2 + this._r1 * (float)Math.cos(ds1 * (double)v)) * (float)Math.sin(ds2 * (double)u);
        float z = this._r1 * (float)Math.sin(ds1 * (double)v);
        vertices.put(x);
        vertices.put(y);
        vertices.put(z);
        int index = GeomCalc.newVector(-((float)Math.cos(ds2 * (double)u)) * (float)Math.cos(ds1 * (double)v), -((float)Math.sin(ds2 * (double)u)) * (float)Math.cos(ds1 * (double)v), -((float)Math.sin(ds1 * (double)v)));
        normals.put(GeomCalc.getX(index));
        normals.put(GeomCalc.getY(index));
        normals.put(GeomCalc.getZ(index));
        GeomCalc.deleteVector(index);
    }
}

