/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing.gl.def;

import chemaxon.marvin.space.drawing.gl.def.GLBase;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;

public class GLColorBuffer
extends GLBase
implements IDrawable {
    private IDrawable _drawable;
    protected ByteBuffer _colorBuffer;

    protected GLColorBuffer(IDrawable drawable) {
        this._drawable = drawable;
    }

    public GLColorBuffer(IDrawable drawable, ByteBuffer colorBuf) {
        this._drawable = drawable;
        this._colorBuffer = colorBuf;
    }

    public GLColorBuffer(IDrawable drawable, byte[] colorBuf) {
        this._drawable = drawable;
        this._colorBuffer = BufferUtil.newByteBuffer((int)colorBuf.length);
        this._colorBuffer.rewind();
        this._colorBuffer.put(colorBuf);
    }

    @Override
    public void draw() {
        if (this._colorBuffer.limit() <= 0) {
            return;
        }
        gl.glEnableClientState(32886);
        gl.glColorPointer(3, 5120, 0, this._colorBuffer.rewind());
        this._drawable.draw();
        gl.glDisableClientState(32886);
    }

    @Override
    public void init() {
    }

    @Override
    public void cleanup() {
        this._drawable.cleanup();
    }

    @Override
    public int getVertexCount() {
        return this._drawable.getVertexCount();
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return IDrawable.DrawType.DYNAMIC;
    }

    @Override
    public void select(boolean select) {
        this._drawable.select(select);
    }
}

