/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing.gl.def;

import chemaxon.marvin.space.drawing.Bond;
import chemaxon.marvin.space.drawing.DrawableCollection;
import chemaxon.marvin.space.drawing.DrawableException;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.OrthoBond;
import chemaxon.marvin.space.drawing.Transform;
import chemaxon.marvin.space.drawing.gl.def.GLBase;
import chemaxon.marvin.space.drawing.gl.def.GLCircle;
import chemaxon.marvin.space.drawing.gl.def.GLColorBuffer;
import chemaxon.marvin.space.drawing.gl.def.GLCylinder;
import chemaxon.marvin.space.drawing.gl.def.GLLine;
import chemaxon.marvin.space.drawing.gl.def.GLList;
import chemaxon.marvin.space.drawing.gl.def.GLTorus;
import chemaxon.marvin.space.drawing.gl.def.GLTransform;
import chemaxon.marvin.space.drawing.gl.def.GLUniformSphere;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.marvin.space.drawing.iface.ITransform;
import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class GLDefaultDrawableFactory
extends DrawableFactory {
    private IDrawable _referenceCylinderStick = null;
    private IDrawable _referenceCylinderBond = null;
    private IDrawable _referenceCylinderDoubleAndTripleBond = null;
    private IDrawable _referenceBall = null;
    private IDrawable _referenceJoint = null;

    @Override
    public IDrawable CreateReferenceCylinderStick() {
        this._referenceCylinderStick = new GLCylinder(GLDefaultDrawableFactory.GetSettingsProvider().GetStickRadius(), 1.0f, GLDefaultDrawableFactory.GetSettingsProvider().GetStickSlicePrecision(), 1);
        return this._referenceCylinderStick;
    }

    public IDrawable GetReferenceCylinderStick() {
        return this._referenceCylinderStick == null ? this.CreateReferenceCylinderStick() : this._referenceCylinderStick;
    }

    @Override
    public IDrawable CreateReferenceCylinderBond() {
        this._referenceCylinderBond = new GLCylinder(GLDefaultDrawableFactory.GetSettingsProvider().GetBondRadius(), 1.0f, GLDefaultDrawableFactory.GetSettingsProvider().GetBondSlicePrecision(), 1);
        return this._referenceCylinderBond;
    }

    public IDrawable GetReferenceCylinderBond() {
        return this._referenceCylinderBond == null ? this.CreateReferenceCylinderBond() : this._referenceCylinderBond;
    }

    @Override
    public IDrawable CreateReferenceCylinderDoubleAndTripleBond() {
        this._referenceCylinderDoubleAndTripleBond = new GLCylinder(GLDefaultDrawableFactory.GetSettingsProvider().GetDoubleBondRadius(), 1.0f, GLDefaultDrawableFactory.GetSettingsProvider().GetBondSlicePrecision(), 1);
        return this._referenceCylinderDoubleAndTripleBond;
    }

    public IDrawable GetReferenceCylinderDoubleAndTripleBond() {
        return this._referenceCylinderDoubleAndTripleBond == null ? this.CreateReferenceCylinderDoubleAndTripleBond() : this._referenceCylinderDoubleAndTripleBond;
    }

    @Override
    public IDrawable CreateBond(int drawType, int bondType, float[] startPos, float[] endPos, byte[] color1, byte[] color2) throws DrawableException {
        return GLDefaultDrawableFactory.GetSettingsProvider().OrthogonalBonds() && bondType != 1 && bondType != 4 ? new OrthoBond(drawType, bondType, startPos, endPos, color1, color2) : new Bond(drawType, bondType, startPos, endPos, color1, color2);
    }

    @Override
    public IDrawable CreateReferenceBall() {
        this._referenceBall = new GLUniformSphere(GLDefaultDrawableFactory.GetSettingsProvider().GetBallRadius(), GLDefaultDrawableFactory.GetSettingsProvider().GetBallPrecision());
        return this._referenceBall;
    }

    @Override
    public IDrawable GetReferenceBall() {
        return this._referenceBall == null ? this.CreateReferenceBall() : this._referenceBall;
    }

    @Override
    public IDrawable CreateReferenceJoint() {
        this._referenceJoint = new GLUniformSphere(GLDefaultDrawableFactory.GetSettingsProvider().GetJointRadius(), GLDefaultDrawableFactory.GetSettingsProvider().GetJointPrecision());
        return this._referenceJoint;
    }

    @Override
    public IDrawable GetReferenceJoint() {
        return this._referenceJoint == null ? this.CreateReferenceJoint() : this._referenceJoint;
    }

    public GLDefaultDrawableFactory(GL gl, GLU glu) {
        GLBase.setGL(gl);
        GLBase.setGLU(glu);
    }

    @Override
    public IDrawable CreateCircle(float r, int s) {
        return new GLCircle(r, s);
    }

    @Override
    public IDrawable CreateCircle(float r) {
        return new GLCircle(r, 20);
    }

    @Override
    public IDrawable CreateLines(FloatBuffer vertices) {
        return new GLLine(vertices);
    }

    @Override
    public IDrawable CreateLines(float[] vertices) {
        return new GLLine(vertices);
    }

    @Override
    public IDrawable CreateTorus(float r1, float r2, int s1, int s2) {
        return new GLTorus(r1, r2, s1, s2);
    }

    @Override
    public IDrawable CreateTorus(float r2) {
        return new GLTorus(GLDefaultDrawableFactory.GetSettingsProvider().GetARingR1(), r2, 10, 20);
    }

    private ByteBuffer CreateCylinderColorBuffer(int vertexCount, byte[] color1, byte[] color2) {
        ByteBuffer colorBuffer = BufferUtil.newByteBuffer((int)(vertexCount * 3));
        for (int i = 0; i < vertexCount >> 1; ++i) {
            colorBuffer.put(color2[0]);
            colorBuffer.put(color2[1]);
            colorBuffer.put(color2[2]);
            colorBuffer.put(color1[0]);
            colorBuffer.put(color1[1]);
            colorBuffer.put(color1[2]);
        }
        colorBuffer.rewind();
        return colorBuffer;
    }

    public IDrawable ColorBufferBond(IDrawable drawable, byte[] color1, byte[] color2) throws DrawableException {
        ByteBuffer colorBuffer = this.CreateCylinderColorBuffer(drawable.getVertexCount(), color1, color2);
        drawable = this.CreateColorBuffer(drawable, colorBuffer);
        return drawable;
    }

    @Override
    public IDrawable CreateBond(int drawType, int bondType, byte[] color1, byte[] color2) throws DrawableException {
        if (drawType == 4) {
            return this.ColorBufferBond(this.GetReferenceCylinderStick(), color1, color2);
        }
        if (drawType == 6) {
            int n = bondType == 3 ? 3 : (bondType == 2 ? 2 : 1);
            ArrayList<IDrawable> bonds = new ArrayList<IDrawable>(n);
            if (bondType == 1 || bondType == 4) {
                return this.ColorBufferBond(this.GetReferenceCylinderBond(), color1, color2);
            }
            for (int i = 0; i < n; ++i) {
                Transform transform = new Transform(this.ColorBufferBond(this.GetReferenceCylinderDoubleAndTripleBond(), color1, color2));
                float[] pos = GLDefaultDrawableFactory.GetSettingsProvider().GetBondShifting(i + 1, n, drawType);
                transform.getTransform().setPos(pos[0], pos[1], pos[2]);
                bonds.add(DrawableFactory.Get().CreateStaticDrawable(transform));
            }
            return new DrawableCollection(bonds);
        }
        return null;
    }

    @Override
    public IDrawable CreateAtom(int drawType) {
        if (drawType == 4) {
            return new GLList(this.GetReferenceJoint());
        }
        return new GLList(this.GetReferenceBall());
    }

    @Override
    public ITransform CreateTransform() {
        return new GLTransform();
    }

    @Override
    public IDrawable CreateStaticDrawable(IDrawable drawable) {
        return drawable;
    }

    @Override
    public IDrawable CreateColorBuffer(IDrawable drawable, ByteBuffer colorBuf) {
        return new GLColorBuffer(drawable, colorBuf);
    }

    @Override
    public IDrawable CreateColorBuffer(IDrawable drawable, byte[] colorBuf) {
        return new GLColorBuffer(drawable, colorBuf);
    }
}

