/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing.gl.def;

import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.gl.def.GLBase;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;

public class GLLine
extends GLBase
implements IDrawable {
    protected FloatBuffer _vertices;
    protected float _lineWidth = DrawableFactory.GetSettingsProvider().GetLineWidth();

    public GLLine(FloatBuffer vertices) {
        this._vertices = vertices;
    }

    protected GLLine() {
    }

    public GLLine(float[] vertices) {
        this._vertices = BufferUtil.newFloatBuffer((int)vertices.length);
        this._vertices.rewind();
        this._vertices.put(vertices);
    }

    public int getElementType() {
        return 1;
    }

    @Override
    public int getVertexCount() {
        return this._vertices.limit() / 3;
    }

    @Override
    public void draw() {
        gl.glPushClientAttrib(-1);
        gl.glEnableClientState(32884);
        gl.glDisableClientState(32885);
        gl.glDisable(2896);
        gl.glEnable(3042);
        gl.glLineWidth(this._lineWidth);
        gl.glVertexPointer(3, 5126, 0, this._vertices.rewind());
        gl.glDrawArrays(this.getElementType(), 0, this.getVertexCount());
        gl.glDisable(3042);
        gl.glEnable(2896);
        gl.glPopClientAttrib();
    }

    @Override
    public void select(boolean select) {
        this._lineWidth = select ? DrawableFactory.GetSettingsProvider().GetSelectedLineWidth() : DrawableFactory.GetSettingsProvider().GetLineWidth();
    }

    @Override
    public void init() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return IDrawable.DrawType.DYNAMIC;
    }
}

