/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gl.shader;

import chemaxon.marvin.space.gl.GLBase;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.swing.SwingUtilities;

public class Program
extends GLBase {
    private final int _po = gl.glCreateProgram();

    public Program(int vso, int fso) throws Exception {
        this.dumpError("Program ctor.", true);
        gl.glAttachShader(this._po, vso);
        gl.glAttachShader(this._po, fso);
        gl.glLinkProgram(this._po);
        this.handleError();
    }

    private void handleError() throws Exception {
        IntBuffer ib = IntBuffer.allocate(1);
        ib.put(0, -1);
        gl.glGetProgramiv(this._po, 35714, ib);
        if (ib.get(0) == 0) {
            gl.glGetProgramiv(this._po, 35714, ib);
            ByteBuffer bb = ByteBuffer.allocate(ib.get(0));
            gl.glGetProgramInfoLog(this._po, ib.get(0), null, bb);
            this.dumpError("Program", bb.toString(), true);
        }
    }

    public int getProgram() {
        return this._po;
    }

    public void use() {
        gl.glUseProgram(this._po);
    }

    protected void finalize() throws Throwable {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                gl.glDeleteProgram(Program.this._po);
            }
        });
        super.finalize();
    }
}

