/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gl.shader;

import chemaxon.marvin.space.gl.GLBase;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.swing.SwingUtilities;

public class Shader
extends GLBase {
    private final int _so;

    public Shader(String[] source, int type) throws Exception {
        this._so = gl.glCreateShader(type);
        this.dumpError("Shader ctor.", true);
        gl.glShaderSource(this._so, source.length, source, null);
        gl.glCompileShader(this._so);
        this.handleError();
    }

    private void handleError() throws Exception {
        IntBuffer ib = IntBuffer.allocate(1);
        ib.put(0, -1);
        gl.glGetShaderiv(this._so, 35713, ib);
        if (ib.get(0) == 0) {
            gl.glGetShaderiv(this._so, 35713, ib);
            ByteBuffer bb = ByteBuffer.allocate(ib.get(0));
            gl.glGetShaderInfoLog(this._so, ib.get(0), null, bb);
            this.dumpError("Shader", bb.toString(), true);
        }
    }

    public int getShader() {
        return this._so;
    }

    protected void finalize() throws Throwable {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                gl.glDeleteShader(Shader.this._so);
            }
        });
        super.finalize();
    }
}

