/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.ProgressBarInterface;
import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;
import java.util.Hashtable;

public class AtomEntries {
    public static final int RADIUS_VDW = 1;
    public static final int RADIUS_VDW_EXTENDED = 2;
    public static final int RADIUS_CONSTANT = 3;
    private int entryRadius = 1;
    private float constantRadius = 2.0f;
    private float atomRadiusExtension = 0.0f;
    private float step = 1.0f;
    private ArrayList molecules;
    private SurfaceComponent surface;
    private int[][] entries;
    private Hashtable vertices;
    private boolean onVisibleOnly = false;
    private ProgressBarInterface progressBar;
    private int startProgress;
    private int progressLength;

    protected void finalize() throws Throwable {
        super.finalize();
        this.molecules = null;
        this.surface = null;
        this.vertices.clear();
        this.vertices = null;
        this.entries = null;
    }

    public void setProgressBar(ProgressBarInterface progressBar, int start, int end) {
        this.progressBar = progressBar;
        this.startProgress = start;
        this.progressLength = end - this.startProgress;
    }

    public void reset() {
        this.entryRadius = 1;
        this.constantRadius = 2.0f;
        this.atomRadiusExtension = 0.0f;
        this.step = 1.0f;
    }

    public void setEntries(ArrayList molecules, SurfaceComponent surface) {
        this.molecules = molecules;
        this.surface = surface;
        this.setEntries();
    }

    public void setEntries(ArrayList molecules, SurfaceComponent surface, float step) {
        this.molecules = molecules;
        this.surface = surface;
        this.step = step;
        this.setEntries();
    }

    public void setEnrtyRadiusMode(int pvs) {
        this.entryRadius = pvs;
    }

    public void setAtomRadiusExtension(float r) {
        this.atomRadiusExtension = r;
    }

    public void setConstantAtomRadius(float r) {
        this.constantRadius = r;
    }

    public int[] getAtomEntries(int i) {
        return this.entries[i];
    }

    private void setEntries() {
        if (this.surface != null) {
            this.setProgress(this.startProgress);
            int pl = this.surface.getVertexCount() / this.progressLength;
            this.entries = new int[this.surface.getVertexCount()][];
            this.vertices = new Hashtable(this.surface.getVertexCount());
            for (int i = 0; i < this.surface.getVertexCount(); ++i) {
                int z;
                int y;
                int x = this.getCellX(this.surface.getVertexX(i));
                EntryKey key = new EntryKey(x, y = this.getCellY(this.surface.getVertexY(i)), z = this.getCellZ(this.surface.getVertexZ(i)));
                if (this.vertices.get(key) == null) {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    list.add(new Integer(i));
                    this.vertices.put(key, list);
                } else {
                    ((ArrayList)this.vertices.get(key)).add(new Integer(i));
                }
                if (i % pl != 0) continue;
                this.setProgress(this.startProgress + i / pl);
            }
            this.fillEntryLists();
        } else {
            System.out.println("Surface must be set in AtomEntries.");
        }
    }

    private void setProgress(int i) {
        if (this.progressBar != null) {
            this.progressBar.setProgress(i);
        }
    }

    private void fillEntryLists() {
        boolean clippedSurface = this.surface.isClipped();
        BoundingBox bb = null;
        if (clippedSurface) {
            bb = this.surface.getBoundingBox();
        }
        for (int i = 0; i < this.molecules.size(); ++i) {
            try {
                MoleculeIterators.MoleculeInterface mi = (MoleculeIterators.MoleculeInterface)this.molecules.get(i);
                MacroMoleculeComponent.MoleculeVisualizer mv = null;
                if (mi instanceof MacroMoleculeComponent.MoleculeVisualizer) {
                    mv = (MacroMoleculeComponent.MoleculeVisualizer)((Object)mi);
                }
                MoleculeIterators.AtomIteratorInterface mai = mi.getAtomIterator(true);
                mai.reset();
                while (mai.hasNext()) {
                    if (!(this.onVisibleOnly && mv != null && !mv.isAtomVisible(mai.current()) || mai.getAtomType() == 130 || clippedSurface && !bb.contains(mai.getX(), mai.getY(), mai.getZ()))) {
                        this.setCurrentEntry(i, mai);
                    }
                    mai.next();
                }
                continue;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
    }

    private void setCurrentEntry(int index, MoleculeIterators.AtomIteratorInterface mai) {
        int cx = this.getCellX(mai.getX());
        int cy = this.getCellY(mai.getY());
        int cz = this.getCellZ(mai.getZ());
        float rad = this.getRadius(mai.getAtomType());
        int r = (int)(1.5 * (double)rad / (double)this.step) + 1;
        int r3 = r * r * r;
        cx -= r;
        cy -= r;
        cz -= r;
        for (int i = 0; i < 2 * r; ++i) {
            for (int j = 0; j < 2 * r; ++j) {
                for (int k = 0; k < 2 * r; ++k) {
                    EntryKey key = new EntryKey(cx + i, cy + j, cz + k);
                    if (this.vertices.get(key) == null) continue;
                    if (i * i + j * j + k * k <= r3) {
                        this.putEntry(key, index, mai.current());
                        continue;
                    }
                    if (!(Math.pow(this.getWorldZ(cz + k) - this.getWorldZ(cz + r), 2.0) + Math.pow(this.getWorldY(cy + j) - this.getWorldY(cy + r), 2.0) + Math.pow(this.getWorldX(cx + i) - this.getWorldX(cx + r), 2.0) <= (double)r3)) continue;
                    this.putEntry(key, index, mai.current());
                }
            }
        }
    }

    private void putEntry(EntryKey key, int index, int entry) {
        Object value = this.vertices.get(key);
        if (value == null) {
            return;
        }
        ArrayList vertices = (ArrayList)value;
        for (int i = 0; i < vertices.size(); ++i) {
            int idx = (Integer)vertices.get(i);
            int[] list = this.entries[idx];
            if (list == null) {
                this.entries[idx] = new int[3];
                this.entries[idx][0] = 1;
                this.entries[idx][1] = index;
                this.entries[idx][2] = entry;
                continue;
            }
            if (list[0] == (list.length - 1) / 2) {
                int[] newList = new int[(list.length - 1) * 2 + 1];
                System.arraycopy(list, 0, newList, 0, list.length);
                this.entries[idx] = newList;
                this.entries[idx][list[0] * 2 + 1] = index;
                this.entries[idx][list[0] * 2 + 2] = entry;
                int[] nArray = this.entries[idx];
                nArray[0] = nArray[0] + 1;
                continue;
            }
            list[list[0] * 2 + 1] = index;
            list[list[0] * 2 + 2] = entry;
            list[0] = list[0] + 1;
        }
    }

    int getCellX(double x) {
        return (int)Math.round(x / (double)this.step);
    }

    int getCellY(double y) {
        return (int)Math.round(y / (double)this.step);
    }

    int getCellZ(double z) {
        return (int)Math.round(z / (double)this.step);
    }

    private float getWorldX(int x) {
        return (float)x * this.step;
    }

    private float getWorldY(int y) {
        return (float)y * this.step;
    }

    private float getWorldZ(int z) {
        return (float)z * this.step;
    }

    float getRadius(int atomType) {
        switch (this.entryRadius) {
            case 1: {
                return (float)PeriodicSystem.getVanDerWaalsRadius(atomType);
            }
            case 2: {
                return (float)PeriodicSystem.getVanDerWaalsRadius(atomType) + this.atomRadiusExtension;
            }
        }
        return this.constantRadius;
    }

    private class EntryKey {
        private int x;
        private int y;
        private int z;

        public EntryKey(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public int hashCode() {
            return (this.x * 31 + this.y) * 31 + this.z;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryKey)) {
                return false;
            }
            EntryKey objKey = (EntryKey)obj;
            return objKey.x == this.x && objKey.y == this.y && objKey.z == this.z;
        }
    }
}

