/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.modules.mprop.VolumetricData;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.ProgressBarInterface;
import chemaxon.marvin.space.grid.Connolly;
import chemaxon.marvin.space.grid.Grid;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import javax.media.opengl.GL;

public class AtomGrid
extends Grid {
    public static final float DEFAULT_THRESHOLD = 0.018f;
    public static final double SQRT2 = 1.414213562373095;
    MoleculeIterators.MoleculeInterface mc = null;
    public float surfaceThreshold = 0.018f;
    public float thresholdPlusEpsilon = 0.02f;
    public float thresholdMinusEpsilon = 0.017f;
    private float[][] atomSpheres = null;
    private float[][] atomSASSpheres = null;
    private float[][] gaussianSpheres = null;
    private double probeRadius = 1.4f;
    ProgressBarInterface progressBar = null;
    int progressStart;
    int progressEnd;

    public AtomGrid(MoleculeIterators.MoleculeInterface mc, BoundingBox bb) {
        super((int)((double)(bb.maxx() - bb.minx()) / 0.1) + 2, (int)((double)(bb.maxy() - bb.miny()) / 0.1) + 2, (int)((double)(bb.maxz() - bb.minz()) / 0.1) + 2);
        this.mc = mc;
        this.setStep(0.1f, 0.1f, 0.1f);
        this.setStart(bb.minx(), bb.miny(), bb.minz());
    }

    public AtomGrid(MoleculeIterators.MoleculeInterface mc, BoundingBox bb, float stepX, float stepY, float stepZ) {
        super((int)((bb.maxx() - bb.minx()) / stepX) + 2, (int)((bb.maxy() - bb.miny()) / stepY) + 2, (int)((bb.maxz() - bb.minz()) / stepZ) + 2);
        this.mc = mc;
        this.setStep(stepX, stepY, stepZ);
        this.setStart(bb.minx(), bb.miny(), bb.minz());
    }

    public AtomGrid(MoleculeIterators.MoleculeInterface mc, BoundingBox bb, float stepX, float stepY, float stepZ, float e) {
        super((int)((bb.maxx() - bb.minx() + 2.0f * e) / stepX) + 2, (int)((bb.maxy() - bb.miny() + 2.0f * e) / stepY) + 2, (int)((bb.maxz() - bb.minz() + 2.0f * e) / stepZ) + 2);
        this.mc = mc;
        this.setStep(stepX, stepY, stepZ);
        this.setStart(bb.minx() - e, bb.miny() - e, bb.minz() - e);
    }

    public AtomGrid(BoundingBox bb, float stepX, float stepY, float stepZ, float probeRadius) {
        super((int)((bb.maxx() - bb.minx() + 4.0f * probeRadius) / stepX) + 2, (int)((bb.maxy() - bb.miny() + 4.0f * probeRadius) / stepY) + 2, (int)((bb.maxz() - bb.minz() + 4.0f * probeRadius) / stepZ) + 2);
        this.probeRadius = probeRadius;
        this.setStep(stepX, stepY, stepZ);
        this.setStart(bb.minx() - 2.0f * probeRadius - stepX, bb.miny() - 2.0f * probeRadius - stepY, bb.minz() - 2.0f * probeRadius - stepZ);
    }

    public AtomGrid(int x, int y, int z) {
        super(x, y, z);
        this.setStep(0.1f, 0.1f, 0.1f);
    }

    public AtomGrid(VolumetricData vd) {
        this.grid = vd.grid;
        this.startX = vd.origo[0];
        this.startY = vd.origo[1];
        this.startZ = vd.origo[2];
        this.stepX = vd.step[0];
        this.stepY = vd.step[1];
        this.stepZ = vd.step[2];
        this.sizeX = vd.size[2];
        this.sizeY = vd.size[1];
        this.sizeZ = vd.size[0];
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.atomSpheres = null;
        this.atomSASSpheres = null;
        this.gaussianSpheres = null;
        this.mc = null;
    }

    public void setProgressBar(ProgressBarInterface PB, int p1, int p2) {
        this.progressBar = PB;
        this.progressStart = p1;
        this.progressEnd = p2;
    }

    public void realloc(BoundingBox bb) {
        this.sizeX = (int)(((double)(bb.maxx() - bb.minx()) + 4.0 * this.probeRadius) / (double)this.stepX) + 2;
        this.sizeY = (int)(((double)(bb.maxy() - bb.miny()) + 4.0 * this.probeRadius) / (double)this.stepY) + 2;
        this.sizeZ = (int)(((double)(bb.maxz() - bb.minz()) + 4.0 * this.probeRadius) / (double)this.stepZ) + 2;
        this.grid = new float[this.sizeZ][this.sizeY][this.sizeX];
        this.startX = (float)((double)bb.minx() - 2.0 * this.probeRadius - (double)this.stepX);
        this.startY = (float)((double)bb.miny() - 2.0 * this.probeRadius - (double)this.stepY);
        this.startZ = (float)((double)bb.minz() - 2.0 * this.probeRadius - (double)this.stepZ);
    }

    public void setMoleculeInterface(MoleculeIterators.MoleculeInterface mc) {
        this.mc = mc;
    }

    public double getProbeRadius() {
        return this.probeRadius;
    }

    public void setProbeRadius(double radius) {
        this.probeRadius = radius;
    }

    public void createGrid(int surfaceType) {
        if (surfaceType == 1) {
            this.createVanDerWaalsGrid(this.progressStart, this.progressEnd);
        } else if (surfaceType == 3) {
            this.createSolventAccessibleGrid();
        } else if (surfaceType == 2) {
            this.createConnollyGrid(this.progressStart, this.progressEnd);
        } else if (surfaceType == 4) {
            this.createGaussianGrid();
        } else {
            System.out.println("Unknown surface type: " + surfaceType);
        }
    }

    private void generateAtomSpheres() {
        this.atomSpheres = new float[MoleculeComponent.elementList.length][];
        for (int i = 0; i < MoleculeComponent.elementList.length; ++i) {
            this.atomSpheres[i] = this.createSphere(PeriodicSystem.getVanDerWaalsRadius(MoleculeComponent.elementList[i]));
        }
    }

    private void generateAtomSASSpheres() {
        this.atomSASSpheres = new float[MoleculeComponent.elementList.length][];
        for (int i = 0; i < MoleculeComponent.elementList.length; ++i) {
            this.atomSASSpheres[i] = this.createSphere(PeriodicSystem.getVanDerWaalsRadius(MoleculeComponent.elementList[i]) + this.probeRadius);
        }
    }

    private void generateGaussianSpheres() {
        this.gaussianSpheres = new float[MoleculeComponent.elementList.length][];
        for (int i = 0; i < MoleculeComponent.elementList.length; ++i) {
            this.gaussianSpheres[i] = this.createGaussianSphere(PeriodicSystem.getVanDerWaalsRadius(MoleculeComponent.elementList[i]));
        }
    }

    public void createGaussianGrid() {
        if (this.gaussianSpheres == null) {
            this.generateGaussianSpheres();
        }
        MoleculeIterators.AtomIteratorInterface ai = this.mc.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            int index = this.getElementSphereIndex(ai.getAtomType());
            double radius = index == 0 ? PeriodicSystem.getVanDerWaalsRadius(0) : PeriodicSystem.getVanDerWaalsRadius(ai.getAtomType());
            if (this.isAtomRelevant(ai.getX(), ai.getY(), ai.getZ(), radius)) {
                this.placeGaussianSphere(ai.getX(), ai.getY(), ai.getZ(), this.gaussianSpheres[index], radius);
            }
            ai.next();
        }
    }

    public void createVanDerWaalsGrid(int p1, int p2) {
        try {
            if (this.atomSpheres == null) {
                this.generateAtomSpheres();
            }
            MoleculeIterators.AtomIteratorInterface ai = this.mc.getAtomIterator(true);
            int pi = 0;
            int p = 0;
            int pl = p2 - p1 == 0 ? 0 : ai.getCount() / (p2 - p1);
            ai.reset();
            while (ai.hasNext()) {
                if (ai.getAtomType() != 130) {
                    int index = this.getElementSphereIndex(ai.getAtomType());
                    double radius = index == 0 ? PeriodicSystem.getVanDerWaalsRadius(0) : PeriodicSystem.getVanDerWaalsRadius(ai.getAtomType());
                    this.placeSphere(ai.getX(), ai.getY(), ai.getZ(), this.atomSpheres[index], radius);
                    if (this.progressBar != null && p >= pl) {
                        this.progressBar.setProgress(p1 + pi);
                        p = 0;
                        ++pi;
                    }
                    ++p;
                }
                ai.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createSolventAccessibleGrid() {
        if (this.atomSASSpheres == null) {
            this.generateAtomSASSpheres();
        }
        MoleculeIterators.AtomIteratorInterface ai = this.mc.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if (ai.getAtomType() != 130) {
                int index = this.getElementSphereIndex(ai.getAtomType());
                double radius = index == 0 ? PeriodicSystem.getVanDerWaalsRadius(0) : PeriodicSystem.getVanDerWaalsRadius(ai.getAtomType());
                this.placeSphere(ai.getX(), ai.getY(), ai.getZ(), this.atomSASSpheres[index], radius + this.probeRadius);
            }
            ai.next();
        }
    }

    public void createConnollyGrid(int p1, int p2) {
        int p3 = (p2 - p1) / 3;
        try {
            this.createVanDerWaalsGrid(p1, p1 + p3);
            Connolly Con = new Connolly(this, this.mc, this.probeRadius);
            Con.calculate();
            this.createVanDerWaalsGrid(p2 - p3, p2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getElementSphereIndex(int atomType) {
        for (int i = 0; i < MoleculeComponent.elementList.length; ++i) {
            if (MoleculeComponent.elementList[i] != atomType) continue;
            return i;
        }
        return 0;
    }

    private void correctBoxCoordinates(int[] cCoords, int r) {
        int n = cCoords[0] < r + 1 ? r + 1 : (cCoords[0] = cCoords[0] > this.sizeX - 1 - r ? this.sizeX - 1 - r : cCoords[0]);
        int n2 = cCoords[1] < r + 1 ? r + 1 : (cCoords[1] = cCoords[1] > this.sizeY - 1 - r ? this.sizeY - 1 - r : cCoords[1]);
        cCoords[2] = cCoords[2] < r + 1 ? r + 1 : (cCoords[2] > this.sizeZ - 1 - r ? this.sizeZ - 1 - r : cCoords[2]);
    }

    private float[] createSphere(double rad) {
        if (this.stepX != this.stepY || this.stepX != this.stepZ || this.stepY != this.stepZ) {
            System.out.println("Error: Creating uniform sphere into a nonuniform grid!");
        }
        int s = (int)Math.ceil(1.5 * rad / (double)this.stepX) + 1;
        int size = 2 * s;
        int rCriterium = (int)Math.ceil(rad / (double)this.stepX) - 3;
        int rC2 = rCriterium * rCriterium;
        int r = (int)Math.ceil(rad / (double)this.stepX) + 3;
        int r2 = r * r;
        double rad2 = rad * rad;
        float[] sphere = new float[size * size * size];
        for (int i = 0; i < s; ++i) {
            int j2;
            int i2 = i * i;
            for (int j = 0; j < s && (j2 = j * j) + i2 <= r2; ++j) {
                for (int k = 0; k < s; ++k) {
                    int d = j2 + i2 + k * k;
                    if (d <= rC2) {
                        this.setCells(sphere, size, s, i, j, k, 0.5f);
                        continue;
                    }
                    double dist = this.distance2(i, j, k);
                    double nr = (double)this.thresholdPlusEpsilon * rad2 / dist;
                    if (!(dist <= rad2 + rad / 2.0 + 1.0)) continue;
                    this.setCells(sphere, size, s, i, j, k, (float)nr);
                }
            }
        }
        return sphere;
    }

    private float[] createGaussianSphere(double rad) {
        int s = (int)Math.ceil(2.0 * rad / (double)this.stepX) + 1;
        int s2 = s * s;
        int size = s * 2;
        float[] sphere = new float[size * size * size];
        for (int i = 0; i < s; ++i) {
            int i2 = i * i;
            for (int j = 0; j < s; ++j) {
                int j2 = j * j;
                if (i2 + j2 > s2) continue;
                for (int k = 0; k < s; ++k) {
                    float nr = 0.0f;
                    if (i2 + j2 + k * k > s2) continue;
                    nr = (float)this.evaluatePotentialFunction(i, j, k, rad);
                    this.setCells(sphere, size, s, i, j, k, nr);
                }
            }
        }
        return sphere;
    }

    private void setCells(float[] grid, int size, int s, int i, int j, int k, float value) {
        grid[(s + i) * size * size + (s + j) * size + s + k] = value;
        grid[(s + i) * size * size + (s + j) * size + s - k] = value;
        grid[(s + i) * size * size + (s - j) * size + s + k] = value;
        grid[(s + i) * size * size + (s - j) * size + s - k] = value;
        grid[(s - i) * size * size + (s + j) * size + s + k] = value;
        grid[(s - i) * size * size + (s + j) * size + s - k] = value;
        grid[(s - i) * size * size + (s - j) * size + s + k] = value;
        grid[(s - i) * size * size + (s - j) * size + s - k] = value;
    }

    private void placeSphere(double x, double y, double z, float[] sphere, double radius) {
        int rx = (int)Math.ceil(1.5 * radius / (double)this.stepX) + 1;
        int ry = (int)Math.ceil(1.5 * radius / (double)this.stepY) + 1;
        int rz = (int)Math.ceil(1.5 * radius / (double)this.stepZ) + 1;
        int[] cCoords = this.getCellCoordinates(x, y, z);
        this.placeSphere(cCoords, sphere, rx, ry, rz);
        if (sphere.length > 8 * rx * ry * rz) {
            System.out.println("Error in Atomgrid, line 402.");
        }
    }

    private void placeSphere(int[] cCoords, float[] sphere, int rx, int ry, int rz) {
        cCoords[0] = cCoords[0] - rx;
        cCoords[1] = cCoords[1] - ry;
        cCoords[2] = cCoords[2] - rz;
        int ir2 = 4 * rx * rx;
        int jr = 2 * ry;
        for (int i = 0; i < 2 * rx; ++i) {
            for (int j = 0; j < 2 * ry; ++j) {
                for (int k = 0; k < 2 * rz; ++k) {
                    float v;
                    int si = i * ir2 + j * jr + k;
                    if (si < 0 || si >= sphere.length || (v = sphere[si]) == 0.0f || !this.isValidIndex(i + cCoords[0], j + cCoords[1], k + cCoords[2]) || !(this.get(i + cCoords[0], j + cCoords[1], k + cCoords[2]) < v)) continue;
                    this.set(i + cCoords[0], j + cCoords[1], k + cCoords[2], v);
                }
            }
        }
    }

    private boolean isValidIndex(int x, int y, int z) {
        return x >= 0 && x < this.sizeX && y >= 0 && y < this.sizeY && z >= 0 && z < this.sizeZ;
    }

    private void placeGaussianSphere(double x, double y, double z, float[] sphere, double radius) {
        int r = (int)Math.ceil(2.0 * radius / (double)this.stepX) + 1;
        int[] cCoords = this.getCellCoordinates(x, y, z);
        this.placeGaussianSphere(cCoords, sphere, r);
        if (sphere.length != 8 * r * r * r) {
            System.out.println("Atomgrid, line 390, " + sphere.length + ", " + r);
        }
    }

    private void placeGaussianSphere(int[] cCoords, float[] sphere, int sphereRadius) {
        cCoords[0] = cCoords[0] - sphereRadius;
        cCoords[1] = cCoords[1] - sphereRadius;
        cCoords[2] = cCoords[2] - sphereRadius;
        int sphereSize = 2 * sphereRadius;
        int sphereSize2 = sphereSize * sphereSize;
        for (int i = 0; i < sphereSize; ++i) {
            for (int j = 0; j < sphereSize; ++j) {
                for (int k = 0; k < sphereSize; ++k) {
                    float v = sphere[i * sphereSize2 + j * sphereSize + k];
                    if (v == 0.0f || !this.isValidIndex(i + cCoords[0], j + cCoords[1], k + cCoords[2])) continue;
                    float oldv = this.get(i + cCoords[0], j + cCoords[1], k + cCoords[2]);
                    this.set(i + cCoords[0], j + cCoords[1], k + cCoords[2], oldv + v);
                }
            }
        }
    }

    private double evaluatePotentialFunction(int i, int j, int k, int c, double rad) {
        double a = 1.0;
        double b = -Math.log(this.surfaceThreshold) / (rad * rad);
        double d = this.distance2(i, j, k, c);
        return a * Math.pow(Math.E, -b * d);
    }

    private double evaluatePotentialFunction(int i, int j, int k, double rad) {
        double a = 1.0;
        double b = -Math.log(this.surfaceThreshold) / (rad * rad);
        double d = this.distance2(i, j, k);
        return a * Math.pow(Math.E, -b * d);
    }

    private double evaluatePotentialFunction2(int i, int j, int k, int c, double rad) {
        double d = this.distance2(i, j, k, c);
        return (double)this.thresholdPlusEpsilon * 1.7 * 1.7 / d;
    }

    private void setBlendingValue(int i, int j, int k, double nr) {
        float[] fArray = this.grid[k][j];
        int n = i;
        fArray[n] = (float)((double)fArray[n] + nr);
    }

    private void setGaussianValues(int c, double rad) {
        int r = (int)(2.0 * rad / (double)this.stepX) + 1;
        int[] cCoords = this.getCellCoordinates(GeomCalc.getX(c), GeomCalc.getY(c), GeomCalc.getZ(c));
        this.correctBoxCoordinates(cCoords, r);
        for (int i = cCoords[0] - r; i <= cCoords[0] + r; ++i) {
            for (int j = cCoords[1] - r; j <= cCoords[1] + r; ++j) {
                if ((i - cCoords[0]) * (i - cCoords[0]) + (j - cCoords[1]) * (j - cCoords[1]) > r * r) continue;
                for (int k = cCoords[2] - r; k <= cCoords[2] + r; ++k) {
                    if ((i - cCoords[0]) * (i - cCoords[0]) + (j - cCoords[1]) * (j - cCoords[1]) + (k - cCoords[2]) * (k - cCoords[2]) > r * r) continue;
                    double nr = this.evaluatePotentialFunction(i, j, k, c, rad);
                    this.setBlendingValue(i, j, k, nr);
                }
            }
        }
    }

    public void drawBoundingBox(GL gl) {
        float[] min = new float[]{this.startX, this.startY, this.startZ};
        float[] max = new float[]{this.startX + (float)this.sizeX * this.stepX, this.startY + (float)this.sizeY * this.stepY, this.startZ + (float)this.sizeZ * this.stepZ};
        gl.glDisable(2896);
        gl.glColor3d(1.0, 1.0, 1.0);
        gl.glBegin(1);
        gl.glVertex3fv(min, 0);
        gl.glVertex3f(min[0], min[1], max[2]);
        gl.glVertex3fv(min, 0);
        gl.glVertex3f(min[0], max[1], min[2]);
        gl.glVertex3fv(min, 0);
        gl.glVertex3f(max[0], min[1], min[2]);
        gl.glVertex3fv(max, 0);
        gl.glVertex3f(max[0], max[1], min[2]);
        gl.glVertex3fv(max, 0);
        gl.glVertex3f(max[0], min[1], max[2]);
        gl.glVertex3fv(max, 0);
        gl.glVertex3f(min[0], max[1], max[2]);
        gl.glVertex3f(min[0], max[1], min[2]);
        gl.glVertex3f(max[0], max[1], min[2]);
        gl.glVertex3f(min[0], max[1], min[2]);
        gl.glVertex3f(min[0], max[1], max[2]);
        gl.glVertex3f(max[0], min[1], min[2]);
        gl.glVertex3f(max[0], max[1], min[2]);
        gl.glVertex3f(max[0], min[1], min[2]);
        gl.glVertex3f(max[0], min[1], max[2]);
        gl.glVertex3f(min[0], min[1], max[2]);
        gl.glVertex3f(max[0], min[1], max[2]);
        gl.glVertex3f(min[0], min[1], max[2]);
        gl.glVertex3f(min[0], max[1], max[2]);
        gl.glEnd();
        gl.glEnable(2896);
    }

    private boolean isAtomRelevant(double x, double y, double z, double r) {
        int i = this.getCellX(x + r);
        int j = this.getCellY(y + r);
        int k = this.getCellZ(z + r);
        if (i < 0 || j < 0 || k < 0) {
            return false;
        }
        i = this.getCellX(x - r);
        j = this.getCellY(y - r);
        k = this.getCellZ(z - r);
        return i < this.sizeX && j < this.sizeY && k < this.sizeZ;
    }
}

