/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.common.util.GeomCalc;
import java.text.NumberFormat;
import javax.media.opengl.GL;

public class ColorGrid {
    private static final String NL = System.getProperty("line.separator");
    protected int start = GeomCalc.newVector(0.0f, 0.0f, 0.0f);
    protected float step = 1.0f;
    protected int sizeX = 0;
    protected int sizeY = 0;
    protected int sizeZ = 0;
    float[][][][] colorGrid;

    public ColorGrid() {
    }

    public ColorGrid(int sx, int sy, int sz) {
        this.colorGrid = new float[sz][sy][sx][3];
        this.sizeX = sx;
        this.sizeY = sy;
        this.sizeZ = sz;
    }

    public void finalize() {
        GeomCalc.deleteVector(this.start);
    }

    public void setSize(int sx, int sy, int sz) {
        this.colorGrid = new float[sz][sy][sx][3];
        this.sizeX = sx;
        this.sizeY = sy;
        this.sizeZ = sz;
    }

    public boolean isBlack(int x, int y, int z) {
        float[] c = this.colorGrid[z][y][x];
        return c[0] == 0.0f && c[1] == 0.0f && c[2] == 0.0f;
    }

    public boolean isGrey(float[] c) {
        return c[0] == c[1] && c[1] == c[2];
    }

    public float[] get(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.sizeX || y >= this.sizeY || z >= this.sizeZ) {
            return null;
        }
        return this.colorGrid[z][y][x];
    }

    public float[] get(double x, double y, double z) {
        int zz = (int)Math.round((z - (double)this.getStartZ()) / (double)this.step);
        int yy = (int)Math.round((y - (double)this.getStartY()) / (double)this.step);
        int xx = (int)Math.round((x - (double)this.getStartX()) / (double)this.step);
        if (xx < 0 || yy < 0 || zz < 0 || xx >= this.sizeX || yy >= this.sizeY || zz >= this.sizeZ) {
            return null;
        }
        return this.colorGrid[zz][yy][xx];
    }

    public float[] getAverage6(double x, double y, double z) {
        int zz = (int)Math.round((z - (double)this.getStartZ()) / (double)this.step);
        int yy = (int)Math.round((y - (double)this.getStartY()) / (double)this.step);
        int xx = (int)Math.round((x - (double)this.getStartX()) / (double)this.step);
        int s = 0;
        float[] c = new float[3];
        if (!this.isBlack(xx, yy, zz)) {
            c[0] = c[0] + this.colorGrid[zz][yy][xx][0];
            c[1] = c[1] + this.colorGrid[zz][yy][xx][1];
            c[2] = c[2] + this.colorGrid[zz][yy][xx][2];
            ++s;
        }
        if (!this.isBlack(xx + 1, yy, zz)) {
            c[0] = c[0] + this.colorGrid[zz][yy][xx + 1][0];
            c[1] = c[1] + this.colorGrid[zz][yy][xx + 1][1];
            c[2] = c[2] + this.colorGrid[zz][yy][xx + 1][2];
            ++s;
        }
        if (!this.isBlack(xx - 1, yy, zz)) {
            c[0] = c[0] + this.colorGrid[zz][yy][xx - 1][0];
            c[1] = c[1] + this.colorGrid[zz][yy][xx - 1][1];
            c[2] = c[2] + this.colorGrid[zz][yy][xx - 1][2];
            ++s;
        }
        if (!this.isBlack(xx, yy + 1, zz)) {
            c[0] = c[0] + this.colorGrid[zz][yy + 1][xx][0];
            c[1] = c[1] + this.colorGrid[zz][yy + 1][xx][1];
            c[2] = c[2] + this.colorGrid[zz][yy + 1][xx][2];
            ++s;
        }
        if (!this.isBlack(xx, yy - 1, zz)) {
            c[0] = c[0] + this.colorGrid[zz][yy - 1][xx][0];
            c[1] = c[1] + this.colorGrid[zz][yy - 1][xx][1];
            c[2] = c[2] + this.colorGrid[zz][yy - 1][xx][2];
            ++s;
        }
        if (!this.isBlack(xx, yy, zz + 1)) {
            c[0] = c[0] + this.colorGrid[zz + 1][yy][xx][0];
            c[1] = c[1] + this.colorGrid[zz + 1][yy][xx][1];
            c[2] = c[2] + this.colorGrid[zz + 1][yy][xx][2];
            ++s;
        }
        if (!this.isBlack(xx, yy, zz - 1)) {
            c[0] = c[0] + this.colorGrid[zz - 1][yy][xx][0];
            c[1] = c[1] + this.colorGrid[zz - 1][yy][xx][1];
            c[2] = c[2] + this.colorGrid[zz - 1][yy][xx][2];
            ++s;
        }
        if (s == 0) {
            return c;
        }
        this.correct(c);
        return c;
    }

    public byte[] getByte(int x, int y, int z) {
        byte[] ret = new byte[3];
        float[] c = this.get(x, y, z);
        ret[0] = (byte)(c[0] * 127.0f);
        ret[1] = (byte)(c[1] * 127.0f);
        ret[2] = (byte)(c[2] * 127.0f);
        return ret;
    }

    public byte[] getByte(double x, double y, double z) {
        byte[] ret = new byte[3];
        float[] c = this.get(x, y, z);
        if (c == null) {
            return null;
        }
        ret[0] = (byte)(c[0] * 127.0f);
        ret[1] = (byte)(c[1] * 127.0f);
        ret[2] = (byte)(c[2] * 127.0f);
        return ret;
    }

    public void set(int x, int y, int z, float[] c) {
        this.colorGrid[z][y][x][0] = c[0];
        this.colorGrid[z][y][x][1] = c[1];
        this.colorGrid[z][y][x][2] = c[2];
    }

    public void correct(float[] c) {
        if (c[0] < 0.0f) {
            c[0] = 0.0f;
        }
        if (c[1] < 0.0f) {
            c[1] = 0.0f;
        }
        if (c[2] < 0.0f) {
            c[2] = 0.0f;
        }
        if (c[0] > 1.0f) {
            c[0] = 1.0f;
        }
        if (c[1] > 1.0f) {
            c[1] = 1.0f;
        }
        if (c[2] > 1.0f) {
            c[2] = 1.0f;
        }
    }

    public void add(int x, int y, int z, float[] c) {
        float[] fArray = this.colorGrid[z][y][x];
        fArray[0] = fArray[0] + c[0];
        float[] fArray2 = this.colorGrid[z][y][x];
        fArray2[1] = fArray2[1] + c[1];
        float[] fArray3 = this.colorGrid[z][y][x];
        fArray3[2] = fArray3[2] + c[2];
        this.correct(this.colorGrid[z][y][x]);
    }

    public void smooth(int x, int y, int z, float[] c) {
        float[] oldc = this.colorGrid[z][y][x];
        float f = oldc[0] > c[0] ? oldc[0] : c[0];
        oldc[0] = f;
        oldc[1] = oldc[1] > c[1] ? oldc[1] : c[1];
        oldc[2] = oldc[2] > c[2] ? oldc[2] : c[2];
    }

    public void blur(int x, int y, int z, float[] c) {
        float[] oldc = this.colorGrid[z][y][x];
        oldc[0] = (oldc[0] + c[0]) / 2.0f;
        oldc[1] = (oldc[1] + c[1]) / 2.0f;
        oldc[2] = (oldc[2] + c[2]) / 2.0f;
    }

    public double[] getCoordinates(int x, int y, int z) {
        double[] ret = new double[]{this.getStartX() + (float)x * this.step, this.getStartY() + (float)y * this.step, this.getStartZ() + (float)z * this.step};
        return ret;
    }

    public void getCoordinates(int x, int y, int z, double[] v) {
        v[0] = this.getStartX() + (float)x * this.step;
        v[1] = this.getStartY() + (float)y * this.step;
        v[2] = this.getStartZ() + (float)z * this.step;
    }

    public int[] getGridCoords(double x, double y, double z) {
        int[] ret = new int[]{(int)Math.round((x - (double)this.getStartX()) / (double)this.step), (int)Math.round((y - (double)this.getStartY()) / (double)this.step), (int)Math.round((z - (double)this.getStartZ()) / (double)this.step)};
        return ret;
    }

    public boolean isInside(double x, double y, double z) {
        int xi = (int)((x - (double)this.getStartX()) / (double)this.step);
        if (xi < 0 || xi > this.sizeX) {
            return false;
        }
        int yi = (int)((y - (double)this.getStartY()) / (double)this.step);
        if (yi < 0 || yi > this.sizeY) {
            return false;
        }
        int zi = (int)((z - (double)this.getStartZ()) / (double)this.step);
        return zi >= 0 && zi <= this.sizeZ;
    }

    public boolean isInside(int c) {
        int xi = (int)((GeomCalc.getX(c) - this.getStartX()) / this.step);
        if (xi < 0 || xi > this.sizeX) {
            return false;
        }
        int yi = (int)((GeomCalc.getY(c) - this.getStartY()) / this.step);
        if (yi < 0 || yi > this.sizeY) {
            return false;
        }
        int zi = (int)((GeomCalc.getZ(c) - this.getStartZ()) / this.step);
        return zi >= 0 && zi <= this.sizeZ;
    }

    public boolean isFullyInside(double x, double y, double z, double r) {
        int ri = (int)(r / (double)this.step);
        int xi = (int)((x - (double)this.getStartX()) / (double)this.step);
        if (xi < ri || xi > this.sizeX - ri) {
            return false;
        }
        int yi = (int)((y - (double)this.getStartY()) / (double)this.step);
        if (yi < ri || yi > this.sizeY - ri) {
            return false;
        }
        int zi = (int)((z - (double)this.getStartZ()) / (double)this.step);
        return zi >= ri && zi <= this.sizeZ - ri;
    }

    public boolean isFullyInside(int c, double r) {
        int ri = (int)(r / (double)this.step);
        int xi = (int)((GeomCalc.getX(c) - this.getStartX()) / this.step);
        if (xi < ri || xi > this.sizeX - ri) {
            return false;
        }
        int yi = (int)((GeomCalc.getY(c) - this.getStartY()) / this.step);
        if (yi < ri || yi > this.sizeY - ri) {
            return false;
        }
        int zi = (int)((GeomCalc.getZ(c) - this.getStartZ()) / this.step);
        return zi >= ri && zi <= this.sizeZ - ri;
    }

    public int getStart() {
        return this.start;
    }

    public float getStartX() {
        return GeomCalc.getX(this.start);
    }

    public float getStartY() {
        return GeomCalc.getY(this.start);
    }

    public float getStartZ() {
        return GeomCalc.getZ(this.start);
    }

    public void setStart(int start) {
        GeomCalc.setVector(this.start, start);
    }

    public void setStart(float x, float y, float z) {
        GeomCalc.setVector(this.start, x, y, z);
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        this.step = step;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String ret = "";
        ret = ret + "Size: " + this.sizeX + ", " + this.sizeY + ", " + this.sizeZ + NL;
        ret = ret + "Step: " + this.step + NL;
        ret = ret + "Start: " + this.getStartX() + ", " + this.getStartY() + ", " + this.getStartZ() + NL;
        return ret;
    }

    public void drawGrid(GL gl) {
        gl.glDisable(2896);
        gl.glPointSize(2.0f);
        gl.glBegin(0);
        for (int k = 0; k < this.sizeZ; ++k) {
            for (int j = this.sizeY - 1; j >= 0; --j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    gl.glColor3fv(this.colorGrid[k][j][i], 0);
                    gl.glVertex3dv(this.getCoordinates(i, j, k), 0);
                }
            }
        }
        gl.glEnd();
        gl.glEnable(2896);
    }

    public void emptyGrid() {
        for (int i = 0; i <= this.sizeZ; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeX; ++k) {
                    this.colorGrid[k][j][i][0] = 0.0f;
                    this.colorGrid[k][j][i][1] = 0.0f;
                    this.colorGrid[k][j][i][2] = 0.0f;
                }
            }
        }
    }

    protected double distance2(int x1, int y1, int z1, int v2) {
        int v1 = GeomCalc.newVector(x1, y1, z1);
        GeomCalc.scale(v1, this.step);
        GeomCalc.increase(v1, this.start);
        double ret = GeomCalc.distance2(v1, v2);
        GeomCalc.deleteVector(v1);
        return ret;
    }

    protected double distance2(int i, int j, int k) {
        int v = GeomCalc.newVector((float)i * this.step, (float)j * this.step, (float)k * this.step);
        double ret = GeomCalc.length2(v);
        GeomCalc.deleteVector(v);
        return ret;
    }
}

