/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.marvin.space.grid.AtomGrid;
import chemaxon.marvin.space.grid.PropertyGrid;
import chemaxon.marvin.space.util.Palette;
import chemaxon.struc.MoleculeIterators;

public class ElectrostaticPotentialGrid
extends PropertyGrid {
    public static final float MAX_DISTANCE_CONSIDERED = 12.0f;
    private float maxDistanceConsidered = 12.0f;
    int nc;
    int pc;

    public ElectrostaticPotentialGrid(AtomGrid parent) {
        super(parent);
        this.setPalette();
    }

    public void setMaxDistanceConsidered(float maxDistanceConsidered) {
        this.maxDistanceConsidered = maxDistanceConsidered;
    }

    public void setMolecule(MoleculeIterators.MoleculeInterface mi) throws Exception {
        MoleculeIterators.AtomIteratorInterface atomIterator = mi.getAtomIterator(true);
        MoleculeIterators.AtomPropertyInterface atomProperty = mi.getAtomProperty();
        int[] cell = new int[3];
        float[] coords = new float[3];
        atomIterator.reset();
        while (atomIterator.hasNext()) {
            atomIterator.getCoords(coords);
            this.getCellCoordinates(coords, cell);
            this.set(cell[0], cell[1], cell[2], atomProperty.getPartialAtomCharge(atomIterator.current()));
            atomIterator.next();
        }
    }

    public void set(float x, float y, float z, float charge) {
    }

    @Override
    public void set(int x, int y, int z, float charge) {
        double e0 = 8.854;
        double resolution = this.getStepX();
        double md2 = this.maxDistanceConsidered * this.maxDistanceConsidered;
        int maxGridDist = (int)Math.ceil((double)this.maxDistanceConsidered / resolution);
        for (int dx = -maxGridDist; dx <= maxGridDist; ++dx) {
            if ((double)(dx * dx) > md2) continue;
            for (int dy = -maxGridDist; dy <= maxGridDist; ++dy) {
                if ((double)(dx * dx + dy * dy) > md2) continue;
                for (int dz = -maxGridDist; dz <= maxGridDist; ++dz) {
                    double dist;
                    double d2 = dx * dx + dy * dy + dz * dz;
                    if (d2 > md2 || (dist = Math.sqrt(d2)) == 0.0) continue;
                    float pot = (float)(0.008987742437988219 * ((double)charge / dist));
                    this.add(x + dx, y + dy, z + dz, pot);
                }
            }
        }
    }

    @Override
    public void setPalette() {
        this.pal = new Palette(-0.5, 0.5, 0.0);
        this.pal.clear();
        this.pal.putColor(Colors.blueF);
        this.pal.putColor(Colors.lightgrayF);
        this.pal.putColor(Colors.redF);
    }

    protected void dump() {
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int x = 0; x < this.sizeX; ++x) {
                    System.out.print(this.grid[z][y][x] + " ");
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public void setNegativeCriterium(double v) {
        this.pal.setLowerCutoff(v);
    }

    public void setPositiveCriterium(double v) {
        this.pal.setUpperCutoff(v);
    }

    @Override
    public void coloringSurface(SurfaceComponent surface) {
        surface.coloring(true);
        for (int i = 0; i < surface.getVertexCount(); ++i) {
            float z;
            float y;
            float x = surface.getVertexX(i);
            double v = this.get(x, y = surface.getVertexY(i), z = surface.getVertexZ(i));
            if (this.pal.inside(v)) {
                surface.putColor(this.pal.getByteColor(v));
                continue;
            }
            surface.putColor(surface.getColor3());
        }
    }
}

