/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.marvin.space.grid.AtomGrid;
import chemaxon.marvin.space.grid.Grid;
import chemaxon.marvin.space.util.Palette;
import javax.media.opengl.GL;

public class PropertyGrid
extends Grid {
    public Palette pal = new Palette();

    public PropertyGrid() {
    }

    public PropertyGrid(AtomGrid parent) {
        super(parent);
    }

    public void add(int x, int y, int z, float value) {
        if (0 <= x && x < this.sizeX && 0 <= y && y < this.sizeY && 0 <= z && z < this.sizeZ) {
            float[] fArray = this.grid[z][y];
            int n = x;
            fArray[n] = fArray[n] + value;
        }
    }

    public float[] getColor(int i, int j, int k) {
        return this.pal.getColor(this.grid[k][j][i]);
    }

    public float[] getColor(double x, double y, double z) {
        int i = (int)Math.round((x - (double)this.getStartX()) / (double)this.stepX);
        int j = (int)Math.round((y - (double)this.getStartY()) / (double)this.stepY);
        int k = (int)Math.round((z - (double)this.getStartZ()) / (double)this.stepZ);
        return this.getColor(i, j, k);
    }

    public void setPalette() {
    }

    public void coloringSurface(SurfaceComponent surface) {
        surface.coloring(true);
        for (int i = 0; i < surface.getVertexCount(); ++i) {
            float z;
            float y;
            float x = surface.getVertexX(i);
            double v = this.get(x, y = surface.getVertexY(i), z = surface.getVertexZ(i));
            if (this.pal.inside(v)) {
                surface.putColor(this.pal.getByteColor(v));
                continue;
            }
            surface.putColor(surface.getColor3());
        }
    }

    public void coloringSurfaceWithAverage(SurfaceComponent surface) {
        surface.coloring(true);
        for (int i = 0; i < surface.getVertexCount(); ++i) {
            float z;
            float y;
            float x = surface.getVertexX(i);
            double v = this.getAverage6(x, y = surface.getVertexY(i), z = surface.getVertexZ(i));
            if (this.pal.inside(v)) {
                surface.putColor(this.pal.getByteColor(v));
                continue;
            }
            surface.putColor(surface.getColor3());
        }
    }

    public void drawGrid(GL gl, Palette pal) {
        gl.glDisable(2896);
        gl.glPointSize(2.0f);
        gl.glBegin(0);
        for (int k = 0; k < this.sizeZ; ++k) {
            for (int j = this.sizeY - 1; j >= 0; --j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    gl.glColor3fv(pal.getColor(this.grid[k][j][i]), 0);
                    gl.glVertex3fv(this.getCoordinates(i, j, k), 0);
                }
            }
        }
        gl.glEnd();
        gl.glEnable(2896);
    }
}

