/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.grid.AtomGrid;
import chemaxon.marvin.space.grid.AtomTypeColorGrid;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MoleculeIterators;
import java.util.ArrayList;

public class SecondaryStructureColorGrid
extends AtomTypeColorGrid {
    private float[][][] ssSpheres = null;

    public SecondaryStructureColorGrid(ArrayList ms, AtomGrid ag, String surfaceType) {
        this.atomGrid = ag;
        this.step = this.atomGrid.getStepX();
        this.start = GeomCalc.newVector(this.atomGrid.getStartX(), this.atomGrid.getStartY(), this.atomGrid.getStartZ());
        this.setSize(this.atomGrid.getSizeX(), this.atomGrid.getSizeY(), this.atomGrid.getSizeZ());
        if (surfaceType.equals("Solvent-accessible") || surfaceType.equals("Gaussian Cube")) {
            this.sas = this.atomGrid.getProbeRadius();
        }
        this.ssSpheres = new float[4][][];
        this.ssSpheres[0] = this.createSphere(2.0 + this.sas, Colors.cyanF);
        this.ssSpheres[1] = this.createSphere(2.0 + this.sas, Colors.redF);
        this.ssSpheres[2] = this.createSphere(2.0 + this.sas, Colors.greenF);
        this.ssSpheres[3] = this.createSphere(2.0 + this.sas, Colors.yellowF);
        for (MoleculeIterators.MoleculeInterface this.mc : ms) {
            this.placeSpheres();
        }
    }

    @Override
    public void finalize() {
    }

    private void placeSpheres() {
        if (!(this.mc instanceof PolymerVisualizer)) {
            return;
        }
        MacroMolecule.Protein.TurnIterator ti = ((PolymerVisualizer)this.mc).getTurnIterator();
        while (ti.hasNext()) {
            MacroMolecule.Protein.Turn t = ti.next();
            MacroMolecule.Protein.CAlphaAtomIterator ci = t.getCAlphaAtomIterator();
            ci.reset();
            while (ci.hasNext()) {
                this.placeSphere(ci.getX(), ci.getY(), ci.getZ(), this.ssSpheres[0], 2.0 + this.sas);
                ci.next();
            }
        }
        MacroMolecule.Protein.HelixIterator hi = ((PolymerVisualizer)this.mc).getHelixIterator();
        while (hi.hasNext()) {
            MacroMolecule.Protein.Helix h = hi.next();
            MacroMolecule.Protein.CAlphaAtomIterator ci = h.getCAlphaAtomIterator();
            ci.reset();
            while (ci.hasNext()) {
                this.placeSphere(ci.getX(), ci.getY(), ci.getZ(), this.ssSpheres[1], 2.0 + this.sas);
                ci.next();
            }
        }
        MacroMolecule.Protein.SheetIterator si = ((PolymerVisualizer)this.mc).getSheetIterator();
        while (si.hasNext()) {
            MacroMolecule.Protein.Sheet s = si.next();
            MacroMolecule.Protein.CAlphaAtomIterator ci = s.getCAlphaAtomIterator();
            ci.reset();
            while (ci.hasNext()) {
                this.placeSphere(ci.getX(), ci.getY(), ci.getZ(), this.ssSpheres[2], 2.0 + this.sas);
                ci.next();
            }
        }
    }
}

