/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.ProgressBarInterface;
import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.marvin.space.grid.AtomEntries;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class WeightedValues {
    public static final int NEAREST_VALUE = 0;
    public static final int SUM_OF_VALUES = 1;
    public static final int MEAN_VALUE = 2;
    public static final int DISTANCE_WEIGHTED = 3;
    public static final int GRID_MAPPING = 0;
    public static final int ATOM_PROPERTY_MAPPING = 1;
    public static final int BUILT_IN_CPK_MAPPING = 2;
    public static final int BUILT_IN_RESIDUE_MAPPING = 3;
    public static final int BUILT_IN_CHAIN_MAPPING = 4;
    public static final int BUILT_IN_SECONDARY_STRUCTURE_MAPPING = 5;
    public static final int BUILT_IN_RAINBOW_MAPPING = 6;
    public static final int NO_DECREASE = 1;
    public static final int DECREASE_LINEAR = 2;
    public static final int DECREASE_SQUARE = 4;
    public static final int DECREASE_RECIPROCAL_SQUARE = 8;
    public static final int DISTANCE_FROM_VDW = 1;
    public static final int DISTANCE_FROM_VDW_EXTENDED = 2;
    public static final int DISTANCE_CONSTANT = 3;
    Method propertyMethod = null;
    Object propertyObject = null;
    AtomEntries entries;
    Object[] sValues;
    Object[][] mValues;
    private boolean singleValues = true;
    private double min;
    private double max;
    private ArrayList molecules;
    private SurfaceComponent surface;
    private int weightMode = 0;
    private int mappingMode = 1;
    private int propertyValueDecreasement = 1;
    private double reciprocalConstant = 0.0;
    private int distanceRadius = 1;
    private float constantRadius = 0.0f;
    private float distanceRadiusExtension = 0.0f;
    private ProgressBarInterface progressBar;
    private int startProgress;
    private int progressLength;

    public void reset() {
        this.propertyMethod = null;
        this.propertyObject = null;
        this.singleValues = true;
        this.weightMode = 0;
        this.mappingMode = 1;
        this.propertyValueDecreasement = 1;
        this.reciprocalConstant = 0.0;
        this.distanceRadius = 1;
        this.constantRadius = 0.0f;
        this.distanceRadiusExtension = 0.0f;
    }

    protected void finalize() throws Throwable {
        this.propertyObject = null;
        this.sValues = null;
        this.mValues = null;
        this.molecules = null;
        this.surface = null;
        this.entries = null;
    }

    public void setProgressBar(ProgressBarInterface progressBar, int start, int end) {
        this.progressBar = progressBar;
        this.startProgress = start;
        this.progressLength = end - this.startProgress;
    }

    public void setWeightMode(int mode) {
        this.weightMode = mode;
    }

    public void setPropertyValueDecreasement(int pvd) {
        this.propertyValueDecreasement = pvd;
    }

    public void setReciprocalConstant(double d) {
        this.reciprocalConstant = d;
    }

    public void setAtomEntries(ArrayList molecules, SurfaceComponent surface, AtomEntries entries) throws Exception {
        this.singleValues = true;
        this.molecules = molecules;
        this.surface = surface;
        this.entries = entries;
        if (this.mappingMode == 0) {
            this.setGridValues();
        } else if (this.weightMode == 3) {
            this.singleValues = false;
            this.setWeightedValues();
        } else {
            this.setSingleValues();
        }
    }

    public boolean singleAtomEntries() {
        return this.singleValues;
    }

    public void setBuiltInPropertyMethod(int mode) throws Exception {
        this.mappingMode = mode;
        switch (mode) {
            case 2: {
                this.setPropertyMethod(MoleculeIterators.AtomPropertyInterface.class.getMethod("getType", Integer.TYPE));
                break;
            }
            case 3: {
                this.setPropertyMethod(MoleculeIterators.AtomPropertyInterface.class.getMethod("getResidueTypeId", Integer.TYPE));
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                this.setPropertyMethod(MoleculeIterators.AtomPropertyInterface.class.getMethod("getSecondaryStructureType", Integer.TYPE));
                break;
            }
            default: {
                System.out.println("Error: Unknown property method setting.");
            }
        }
    }

    public void setPropertyMethod(Method propertyMethod) throws Exception {
        this.propertyMethod = propertyMethod;
    }

    public void setPropertyObject(Object propertyObject, int mappingMode) {
        this.propertyObject = propertyObject;
        this.mappingMode = mappingMode;
    }

    public double getMinimumValue() {
        return this.min;
    }

    public double getMaximumValue() {
        return this.max;
    }

    public void setDistanceRadiusMode(int pvs) {
        this.distanceRadius = pvs;
    }

    public void setDistanceRadiusExtension(float r) {
        this.distanceRadiusExtension = r;
    }

    public void setConstantDistanceRadius(float r) {
        this.constantRadius = r;
    }

    private Object invoke(float x, float y, float z) throws Exception {
        return this.propertyMethod.invoke(this.propertyObject, new Float(x), new Float(y), new Float(z));
    }

    private Object invoke(int i, int j) throws Exception {
        if (this.mappingMode == 1 && this.propertyObject != null) {
            return this.propertyMethod.invoke(this.propertyObject, new Integer(j));
        }
        if (this.mappingMode == 4) {
            MoleculeIterators.MoleculeInterface mi = (MoleculeIterators.MoleculeInterface)this.molecules.get(i);
            if (!(mi instanceof PolymerVisualizer)) {
                return new Integer(0);
            }
            return new Integer(((PolymerVisualizer)mi).getChainNumber());
        }
        if (this.mappingMode == 6) {
            MoleculeIterators.MoleculeInterface mi = (MoleculeIterators.MoleculeInterface)this.molecules.get(i);
            if (!(mi instanceof PolymerVisualizer)) {
                return new Integer(0);
            }
            int aidx = 0;
            MacroMolecule.Protein protein = (MacroMolecule.Protein)((PolymerVisualizer)mi).getPolymer();
            MacroMolecule.Protein.CAlphaAtomIterator atoms = protein.getCAlphaAtomIterator();
            ((MacroMolecule.Polymer.AtomIterator)atoms).reset();
            while (((MacroMolecule.Polymer.AtomIterator)atoms).hasNext()) {
                if (atoms.sameResidue(((MacroMolecule.Polymer.AtomIterator)atoms).current(), j)) {
                    return new Integer(((PolymerVisualizer)mi).getRainbowIndex() + aidx);
                }
                ((MacroMolecule.Polymer.AtomIterator)atoms).next();
                ++aidx;
            }
            return new Integer(0);
        }
        MoleculeIterators.AtomPropertyInterface props = ((MoleculeIterators.MoleculeInterface)this.molecules.get(i)).getAtomProperty();
        return this.propertyMethod.invoke((Object)props, new Integer(j));
    }

    private void setWeightedValues() throws Exception {
        this.setProgress(this.startProgress);
        int pl = this.surface.getVertexCount() / this.progressLength;
        this.mValues = new Object[this.surface.getVertexCount()][];
        for (int i = 0; i < this.surface.getVertexCount(); ++i) {
            float x = this.surface.getVertexX(i);
            float y = this.surface.getVertexY(i);
            float z = this.surface.getVertexZ(i);
            int[] atomEntries = this.entries.getAtomEntries(i);
            if (atomEntries == null) continue;
            int entryCount = atomEntries[0];
            float[] distances = new float[entryCount];
            float dSum = 0.0f;
            for (int j = 0; j < entryCount; ++j) {
                int index = atomEntries[j * 2 + 1];
                int current = atomEntries[j * 2 + 2];
                distances[j] = this.distance(index, current, x, y, z);
                MoleculeIterators.AtomPropertyInterface props = ((MoleculeIterators.MoleculeInterface)this.molecules.get(index)).getAtomProperty();
                int n = j;
                distances[n] = distances[n] - this.getRadius(props.getType(current));
                if (distances[j] < 0.0f) {
                    distances[j] = 1.0E-4f;
                }
                int n2 = j;
                distances[n2] = distances[n2] * distances[j];
                dSum += distances[j];
            }
            float sSum = 0.0f;
            for (int j = 0; j < entryCount; ++j) {
                sSum += dSum / distances[j] / 100.0f;
            }
            Object[] vList = new Object[entryCount * 2];
            for (int j = 0; j < entryCount; ++j) {
                int index = atomEntries[j * 2 + 1];
                int current = atomEntries[j * 2 + 2];
                float s = dSum / (distances[j] * 100.0f * sSum);
                vList[j * 2] = this.invoke(index, current);
                vList[j * 2 + 1] = new Float(s);
                if (this.mappingMode != 1) continue;
                float v = ((Number)vList[j * 2]).floatValue();
                if (i == 0) {
                    this.min = v;
                    this.max = v;
                    continue;
                }
                if ((double)v < this.min) {
                    this.min = v;
                }
                if (!((double)v > this.max)) continue;
                this.max = v;
            }
            this.mValues[i] = vList;
            if (i % pl != 0) continue;
            this.setProgress(this.startProgress + i / pl);
        }
    }

    private void setSingleValues() throws Exception {
        this.sValues = new Object[this.surface.getVertexCount()];
        if (this.weightMode == 0) {
            this.setNearestSingleValues();
        } else if (this.weightMode == 1) {
            this.setSumOfSingleValues();
        } else if (this.weightMode == 2) {
            this.setAverageOfSingleValues();
        } else {
            System.out.println("Error setting values: " + this.weightMode);
        }
    }

    private void setNearestSingleValues() throws Exception {
        int pl = this.surface.getVertexCount() / this.progressLength;
        this.setProgress(this.startProgress);
        for (int i = 0; i < this.surface.getVertexCount(); ++i) {
            float x = this.surface.getVertexX(i);
            float y = this.surface.getVertexY(i);
            float z = this.surface.getVertexZ(i);
            int[] atomEntries = this.entries.getAtomEntries(i);
            if (atomEntries == null) continue;
            int entryCount = atomEntries[0];
            double value = 0.0;
            if (entryCount == 1) {
                int index = atomEntries[1];
                int current = atomEntries[2];
                value = ((Number)this.invoke(index, current)).doubleValue();
            } else {
                int minIndex = -1;
                int minCurrent = -1;
                float minDistance = 0.0f;
                for (int j = 0; j < entryCount; ++j) {
                    int index = atomEntries[j * 2 + 1];
                    int current = atomEntries[j * 2 + 2];
                    float d = this.distance(index, current, x, y, z);
                    if (j == 0) {
                        minIndex = index;
                        minCurrent = current;
                        minDistance = d;
                        continue;
                    }
                    if (!(d < minDistance)) continue;
                    minIndex = index;
                    minCurrent = current;
                    minDistance = d;
                }
                value = ((Number)this.invoke(minIndex, minCurrent)).doubleValue();
            }
            if (i == 0) {
                this.min = value;
                this.max = value;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
            this.sValues[i] = new Double(value);
            if (i % pl != 0) continue;
            this.setProgress(this.startProgress + i / pl);
        }
    }

    private void setSumOfSingleValues() throws Exception {
        int pl = this.surface.getVertexCount() / this.progressLength;
        this.setProgress(this.startProgress);
        for (int i = 0; i < this.surface.getVertexCount(); ++i) {
            float x = this.surface.getVertexX(i);
            float y = this.surface.getVertexY(i);
            float z = this.surface.getVertexZ(i);
            int[] atomEntries = this.entries.getAtomEntries(i);
            if (atomEntries == null) continue;
            int entryCount = atomEntries[0];
            double value = 0.0;
            for (int j = 0; j < entryCount; ++j) {
                int index = atomEntries[j * 2 + 1];
                int current = atomEntries[j * 2 + 2];
                if (index < 0 || current < 0) continue;
                double v = ((Number)this.invoke(index, current)).doubleValue();
                float d = this.distance(index, current, x, y, z);
                value += this.getWeightedValue(v, d);
            }
            if (i == 0) {
                this.min = value;
                this.max = value;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
            this.sValues[i] = new Double(value);
            if (i % pl != 0) continue;
            this.setProgress(this.startProgress + i / pl);
        }
    }

    private void setAverageOfSingleValues() throws Exception {
        int pl = this.surface.getVertexCount() / this.progressLength;
        this.setProgress(this.startProgress);
        for (int i = 0; i < this.surface.getVertexCount(); ++i) {
            float x = this.surface.getVertexX(i);
            float y = this.surface.getVertexY(i);
            float z = this.surface.getVertexZ(i);
            int[] atomEntries = this.entries.getAtomEntries(i);
            if (atomEntries == null) continue;
            int entryCount = atomEntries[0];
            double value = 0.0;
            for (int j = 0; j < entryCount; ++j) {
                int index = atomEntries[j * 2 + 1];
                int current = atomEntries[j * 2 + 2];
                if (index < 0 || current < 0) continue;
                double v = ((Number)this.invoke(index, current)).doubleValue();
                float d = this.distance(index, current, x, y, z);
                value += this.getWeightedValue(v, d);
            }
            value /= (double)entryCount;
            if (i == 0) {
                this.min = value;
                this.max = value;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
            this.sValues[i] = new Double(value);
            if (i % pl != 0) continue;
            this.setProgress(this.startProgress + i / pl);
        }
    }

    private double getWeightedValue(double v, float d) {
        switch (this.propertyValueDecreasement) {
            case 1: {
                return v;
            }
            case 2: {
                return v / (double)d;
            }
            case 4: {
                return v / (double)(d * d);
            }
            case 8: {
                return 1.0 / (Math.PI * 4 * this.reciprocalConstant) * (v / (double)(d * d));
            }
        }
        return v;
    }

    private void setGridValues() throws Exception {
        this.sValues = new Object[this.surface.getVertexCount()];
        this.setProgress(this.startProgress);
        int pl = this.surface.getVertexCount() / this.progressLength;
        for (int i = 0; i < this.surface.getVertexCount(); ++i) {
            float x = this.surface.getVertexX(i);
            float y = this.surface.getVertexY(i);
            float z = this.surface.getVertexZ(i);
            try {
                this.sValues[i] = this.invoke(x, y, z);
            }
            catch (InvocationTargetException ex) {
                this.sValues[i] = new Float(0.0f);
            }
            double value = ((Number)this.sValues[i]).doubleValue();
            if (i == 0) {
                this.min = value;
                this.max = value;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
            if (i % pl != 0) continue;
            this.setProgress(this.startProgress + i / pl);
        }
    }

    private float distance(int index, int current, float x, float y, float z) {
        MoleculeIterators.AtomPropertyInterface props = ((MoleculeIterators.MoleculeInterface)this.molecules.get(index)).getAtomProperty();
        float[] c = new float[]{props.getX(current), props.getY(current), props.getZ(current)};
        return (float)Math.sqrt(Math.pow(c[2] - z, 2.0) + Math.pow(c[1] - y, 2.0) + Math.pow(c[0] - x, 2.0));
    }

    float getRadius(int atomType) {
        switch (this.distanceRadius) {
            case 1: {
                return (float)PeriodicSystem.getVanDerWaalsRadius(atomType);
            }
            case 2: {
                return (float)PeriodicSystem.getVanDerWaalsRadius(atomType) + this.distanceRadiusExtension;
            }
        }
        return this.constantRadius;
    }

    private void setProgress(int i) {
        if (this.progressBar != null) {
            this.progressBar.setProgress(i);
        }
    }
}

