/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.alignment.Alignment;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.struc.Molecule;
import java.util.Collection;

public class AlignmentForMSpace {
    private GraphicScene graphicScene;
    private Alignment al;
    private AlignmentFlexMode afm = AlignmentFlexMode.ALL_RIGID;

    public AlignmentForMSpace(GraphicScene graphicScene) {
        this.graphicScene = graphicScene;
        this.al = new Alignment();
    }

    public void setAlignmentProperties(AlignmentProperties at, AlignmentFlexMode afm) {
        this.al = new Alignment(at);
        this.afm = afm;
    }

    public void align() {
        try {
            System.err.println((Object)this.afm);
            this.al.removeAllConstraints();
            this.al.removeAllMolecules();
            int molCount = 0;
            boolean first = true;
            for (int c = 0; c < this.graphicScene.getCellCount(); ++c) {
                GraphicCell cell = this.graphicScene.getCell(c);
                for (int i = 0; i < cell.getComponentCount(); ++i) {
                    if (!(cell.getComponent(i) instanceof MoleculeComponent) || cell.getComponent(i) instanceof AlignmentResultMoleculeComponent) continue;
                    MoleculeComponent mc = (MoleculeComponent)cell.getComponent(i);
                    Molecule m = mc.getMolecule().cloneMolecule();
                    m.hydrogenize(false);
                    m.aromatize(1);
                    if (m.getAtomCount() > 70) {
                        this.graphicScene.getEventHandler().handleMyErrors("The current alignment protocol is  developped for drug sized molecules only. Proteins and other bigger molecules are not accepted.", "Alignment error", 0);
                        return;
                    }
                    boolean rigid = true;
                    if (this.afm == AlignmentFlexMode.ALL_RIGID) {
                        rigid = true;
                    } else if (this.afm == AlignmentFlexMode.ALL_FLEX) {
                        rigid = false;
                    } else if (this.afm == AlignmentFlexMode.SELECTED_FLEX && mc.isSelected()) {
                        rigid = false;
                    }
                    this.al.addMolecule(m, !rigid, !first);
                    first = false;
                    ++molCount;
                }
            }
            if (molCount < 2 || molCount > 6) {
                this.graphicScene.getEventHandler().handleMyErrors("Molecule count should be between 2 and 6 to align.", "Alignment error", 0);
                return;
            }
            this.al.align();
            String s = "Align by " + this.al.getNodeColor().getLabel();
            if (this.al.getOrientationType() == AlignmentProperties.OrientationType.MCS) {
                s = s + " MCS";
            }
            if (this.afm == AlignmentFlexMode.ALL_RIGID) {
                s = s + " All rigid.";
            } else if (this.afm == AlignmentFlexMode.ALL_FLEX) {
                s = s + " All flexible.";
            } else if (this.afm == AlignmentFlexMode.SELECTED_FLEX) {
                s = s + " Selected is flexible.";
            }
            Molecule result = this.al.getAlignedMoleculesAsFragments();
            result.setName(s);
            AlignmentResultMoleculeComponent mc = new AlignmentResultMoleculeComponent(result, this.al.getMolecules(), this.al.getNodeColor().getScheme());
            if (this.graphicScene.getCellCount() == 1) {
                GraphicCell cell = this.graphicScene.getCell(0);
                for (int i = 0; i < cell.getComponentCount(); ++i) {
                    cell.getComponent(i).setVisible(false);
                }
            } else {
                this.graphicScene.createNewCell();
            }
            this.graphicScene.getEventHandler().addComponent((GraphicComponent)mc, true, (GraphicComponent)null, true);
            this.graphicScene.getEventHandler().resetView();
            this.graphicScene.refresh();
            this.graphicScene.getEventHandler().finishOperation();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.graphicScene.getEventHandler().handleMyErrors(ex.getMessage(), "Alignment error", 0);
        }
    }

    public class AlignmentResultMoleculeComponent
    extends MoleculeComponent {
        private Collection<AlignmentMolecule> molecules;
        private AlignmentProperties.ColoringScheme coloringScheme;

        AlignmentResultMoleculeComponent(Molecule m, Collection<AlignmentMolecule> molecules, AlignmentProperties.ColoringScheme cs) {
            super(m);
            this.molecules = molecules;
            this.coloringScheme = cs;
        }

        public Collection<AlignmentMolecule> getMolecules() {
            return this.molecules;
        }

        public void setModifiesOrigin(boolean modif) {
            this.modifiesOrigin = modif;
        }

        public AlignmentProperties.ColoringScheme getColoringScheme() {
            return this.coloringScheme;
        }
    }

    public static enum AlignmentFlexMode {
        ALL_RIGID,
        ALL_FLEX,
        SELECTED_FLEX;

    }
}

