/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.MoleculeComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JFrame;

public class AtomSelectionExample
extends JFrame {
    MSpaceEasy mspace;
    MoleculeComponent mc = null;

    public static void main(String[] args) {
        new AtomSelectionExample();
    }

    public AtomSelectionExample() {
        this.setDefaultCloseOperation(2);
        this.setSize(500, 500);
        this.setTitle("MarvinSpace Atom Selection Example");
        try {
            this.mspace = new MSpaceEasy(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mspace.setSize(500, 500);
        this.mspace.addCanvas(this.getContentPane());
        try {
            ArrayList<Object> mols = this.mspace.openMolecule("C:/data/mol/1ETR_lig.mol");
            this.mc = (MoleculeComponent)mols.get(0);
            this.mspace.getGraphicScene().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!evt.getPropertyName().equals("selection")) {
                        return;
                    }
                    boolean[] atomSelections = AtomSelectionExample.this.mc.getAtomSelections();
                    for (int i = 0; i < atomSelections.length; ++i) {
                        if (!atomSelections[i]) continue;
                        System.out.println(i + "th atom is selected: " + AtomSelectionExample.this.mc.getSelectedAtom(i).getAtno() + " " + AtomSelectionExample.this.mc.getSelectedAtom(i).getSymbol());
                    }
                    System.out.println("=============");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }
}

