/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.SurfaceColoring;
import chemaxon.marvin.space.gui.MSpaceDialog;
import chemaxon.marvin.util.ColorPaletteUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorMapperTool
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    public static final float FONTSIZE = 9.0f;
    private JSlider lowSlider;
    private JSlider highSlider;
    private JFormattedTextField min;
    private JFormattedTextField max;
    private JFormattedTextField low;
    private JFormattedTextField high;
    private JLabel palette;
    private JLabel minlabel;
    private JLabel maxlabel;
    private JLabel lowlabel;
    private JLabel highlabel;
    private MSpaceDialog paletteDialog = null;
    private JComboBox combo;
    private double minimum = -0.5;
    private double maximum = 0.5;
    private double lowv = 0.0;
    private double highv = 0.0;
    private boolean initialized = false;
    private boolean enabled = true;
    private int currentPalette = 0;
    private GraphicScene graphicScene;

    public ColorMapperTool(GraphicScene graphicScene) {
        this.graphicScene = graphicScene;
        this.create();
        this.createPaletteDialog();
        this.addMouseListener();
    }

    public ColorMapperTool(GraphicScene graphicScene, double minimum, double maximum) {
        this.graphicScene = graphicScene;
        this.minimum = minimum;
        this.maximum = maximum;
        this.create();
        this.createPaletteDialog();
        this.addMouseListener();
    }

    private void create() {
        this.setLayout(new BoxLayout(this, 0));
        Dimension sliderSize = new Dimension(48, 20);
        this.lowSlider = new JSlider(0, 0, 50, 50);
        this.lowSlider.setMaximumSize(sliderSize);
        this.lowSlider.setPreferredSize(sliderSize);
        this.lowSlider.setMinimumSize(sliderSize);
        this.highSlider = new JSlider(0, 0, 50, 0);
        this.highSlider.setMaximumSize(sliderSize);
        this.highSlider.setPreferredSize(sliderSize);
        this.highSlider.setMinimumSize(sliderSize);
        Dimension panelSize = new Dimension(50, 42);
        Dimension textFieldSize = new Dimension(50, 21);
        JPanel minp = new JPanel();
        minp.setLayout(new BoxLayout(minp, 1));
        this.min = new JFormattedTextField();
        this.min.setValue(new Double(this.minimum));
        this.min.setHorizontalAlignment(4);
        this.minlabel = new JLabel("Min");
        this.minlabel.setFont(this.minlabel.getFont().deriveFont(9.0f));
        minp.add(this.minlabel);
        minp.add(this.min);
        JPanel maxp = new JPanel();
        maxp.setLayout(new BoxLayout(maxp, 1));
        this.max = new JFormattedTextField();
        this.max.setValue(new Double(this.maximum));
        this.max.setHorizontalAlignment(4);
        this.maxlabel = new JLabel("Max");
        this.maxlabel.setFont(this.maxlabel.getFont().deriveFont(9.0f));
        maxp.add(this.maxlabel);
        maxp.add(this.max);
        JPanel lowp = new JPanel();
        lowp.setLayout(new BoxLayout(lowp, 1));
        this.low = new JFormattedTextField();
        this.low.setValue(new Double(this.lowv));
        this.low.setHorizontalAlignment(4);
        this.low.addPropertyChangeListener("value", this);
        this.lowlabel = new JLabel("Low");
        this.lowlabel.setFont(this.lowlabel.getFont().deriveFont(9.0f));
        lowp.add(this.lowlabel);
        lowp.add(this.low);
        JPanel highp = new JPanel();
        highp.setLayout(new BoxLayout(highp, 1));
        this.high = new JFormattedTextField();
        this.high.setValue(new Double(this.highv));
        this.high.setHorizontalAlignment(4);
        this.high.addPropertyChangeListener("value", this);
        this.highlabel = new JLabel("High");
        this.highlabel.setFont(this.highlabel.getFont().deriveFont(9.0f));
        highp.add(this.highlabel);
        highp.add(this.high);
        Dimension labelSize = new Dimension(93, 5);
        this.palette = new JLabel();
        this.palette.setIcon(this.drawPalette());
        this.palette.setForeground(Color.BLUE);
        this.palette.setMinimumSize(labelSize);
        this.palette.setMaximumSize(labelSize);
        this.palette.setPreferredSize(labelSize);
        JPanel ppanel = new JPanel();
        ppanel.setLayout(new BoxLayout(ppanel, 0));
        ppanel.add(this.palette);
        ppanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel sliders = new JPanel();
        sliders.setLayout(new BoxLayout(sliders, 0));
        sliders.add(this.lowSlider);
        sliders.add(this.highSlider);
        sliders.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(ppanel);
        panel.add(Box.createVerticalGlue());
        panel.add(sliders);
        this.lowSlider.addChangeListener(this);
        this.highSlider.addChangeListener(this);
        this.min.addPropertyChangeListener("value", this);
        this.max.addPropertyChangeListener("value", this);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(minp);
        mainPanel.add(lowp);
        mainPanel.add(panel);
        mainPanel.add(highp);
        mainPanel.add(maxp);
        this.add(mainPanel);
        Dimension size = new Dimension(300, 40);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.setEnabled(false);
        this.initialized = true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.lowSlider.setEnabled(enabled);
        this.highSlider.setEnabled(enabled);
        this.min.setEnabled(enabled);
        this.max.setEnabled(enabled);
        this.low.setEnabled(enabled);
        this.high.setEnabled(enabled);
        this.minlabel.setEnabled(enabled);
        this.maxlabel.setEnabled(enabled);
        this.lowlabel.setEnabled(enabled);
        this.highlabel.setEnabled(enabled);
        this.palette.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMinimum(double m) {
        this.minimum = m;
        this.min.setValue(new Double(m));
    }

    public void setMaximum(double m) {
        this.maximum = m;
        this.max.setValue(new Double(m));
    }

    public void setPalette(int paletteId) {
        if (this.currentPalette == paletteId) {
            return;
        }
        this.currentPalette = paletteId;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorMapperTool.this.palette.setIcon(ColorMapperTool.this.drawPalette());
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.lowSlider) {
                double b = -this.minimum / 50.0;
                this.lowv = this.minimum + b * (double)this.lowSlider.getValue();
                this.low.setValue(new Double(this.lowv));
                this.graphicScene.processEvent("Palette.Lower", "" + this.lowv);
                this.graphicScene.getEventHandler().refresh();
            } else if (source == this.highSlider) {
                double b = this.maximum / 50.0;
                this.highv = b * (double)this.highSlider.getValue();
                this.high.setValue(new Double(this.highv));
                this.graphicScene.processEvent("Palette.Upper", "" + this.highv);
                this.graphicScene.getEventHandler().refresh();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.min) {
                this.minimum = ((Number)this.min.getValue()).doubleValue();
                if (((Number)this.low.getValue()).doubleValue() < this.minimum) {
                    this.low.setValue(new Double(this.minimum));
                }
                this.graphicScene.processEvent("Palette.Minimum", "" + this.minimum);
                this.graphicScene.getEventHandler().refresh();
            } else if (source == this.max) {
                this.maximum = ((Number)this.max.getValue()).doubleValue();
                if (((Number)this.high.getValue()).doubleValue() > this.maximum) {
                    this.high.setValue(new Double(this.maximum));
                }
                this.graphicScene.processEvent("Palette.Maximum", "" + this.maximum);
                this.graphicScene.getEventHandler().refresh();
            } else if (source == this.low) {
                this.lowv = ((Number)this.low.getValue()).doubleValue();
                double b = -this.minimum / 50.0;
                int newv = (int)((this.lowv - this.minimum) / b);
                this.lowSlider.setValue(newv);
            } else if (source == this.high) {
                this.highv = ((Number)this.high.getValue()).doubleValue();
                double b = this.maximum / 50.0;
                int newv = (int)(this.highv / b);
                this.highSlider.setValue(newv);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ImageIcon drawPalette() {
        ImageIcon icon = new ImageIcon();
        BufferedImage rect = new BufferedImage(93, 10, 2);
        Graphics2D gr = rect.createGraphics();
        gr.setBackground(new Color(0, 0, 0, 0));
        byte[][] colors = SurfaceColoring.getBuiltInPalette(this.currentPalette);
        int rectSize = 94 / (colors.length - 1);
        for (int i = 0; i < colors.length - 1; ++i) {
            GradientPaint gp = new GradientPaint(i * rectSize, 0.0f, this.getAWTColor(colors[i]), (i + 1) * rectSize, 1.0f, this.getAWTColor(colors[i + 1]));
            gr.setPaint(gp);
            if (i == colors.length - 2) {
                gr.fillRect(i * rectSize, 0, 94 - i * rectSize, 10);
                continue;
            }
            gr.fillRect(i * rectSize, 0, rectSize, 10);
        }
        icon.setImage(rect);
        return icon;
    }

    private Color getAWTColor(byte[] c) {
        return new Color(c[0] * 2, c[1] * 2, c[2] * 2);
    }

    private void addMouseListener() {
        this.palette.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ColorMapperTool.this.palette.isEnabled()) {
                    return;
                }
                Rectangle rect = ColorMapperTool.this.palette.getBounds();
                if (rect.contains(e.getX(), e.getY())) {
                    ColorMapperTool.this.paletteDialog.setVisible(true);
                }
            }
        });
        this.palette.setToolTipText("Click to change palette");
    }

    private void createPaletteDialog() {
        this.paletteDialog = new MSpaceDialog(this.graphicScene);
        this.paletteDialog.setTitle("Change palette");
        this.paletteDialog.getContentPane().setLayout(new BoxLayout(this.paletteDialog.getContentPane(), 1));
        JPanel palettePane = new JPanel();
        palettePane.setLayout(new BoxLayout(palettePane, 0));
        this.combo = new JComboBox<String>(ColorPaletteUtil.getBuiltInPalettes());
        this.combo.setSelectedIndex(this.currentPalette);
        palettePane.add(Box.createHorizontalGlue());
        palettePane.add(Box.createRigidArea(new Dimension(50, 0)));
        palettePane.add(this.combo);
        palettePane.add(Box.createRigidArea(new Dimension(50, 0)));
        palettePane.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorMapperTool.this.paletteDialog.setVisible(false);
                ColorMapperTool.this.paletteDialog.dispose();
            }
        });
        JButton setButton = new JButton("Ok");
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorMapperTool.this.currentPalette = ColorPaletteUtil.getBuiltInPaletteId(ColorMapperTool.this.combo.getSelectedItem());
                ColorMapperTool.this.palette.setIcon(ColorMapperTool.this.drawPalette());
                ColorMapperTool.this.graphicScene.processEvent("Surface.Palette", (String)ColorMapperTool.this.combo.getSelectedItem());
                ColorMapperTool.this.graphicScene.refresh();
                ColorMapperTool.this.paletteDialog.setVisible(false);
                ColorMapperTool.this.paletteDialog.dispose();
            }
        });
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorMapperTool.this.currentPalette = ColorPaletteUtil.getBuiltInPaletteId(ColorMapperTool.this.combo.getSelectedItem());
                ColorMapperTool.this.palette.setIcon(ColorMapperTool.this.drawPalette());
                ColorMapperTool.this.graphicScene.processEvent("Surface.Palette", (String)ColorMapperTool.this.combo.getSelectedItem());
                ColorMapperTool.this.graphicScene.refresh();
            }
        });
        this.paletteDialog.getRootPane().setDefaultButton(setButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPane.add(setButton);
        buttonPane.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPane.add(applyButton);
        buttonPane.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        this.paletteDialog.getContentPane().add(Box.createVerticalGlue());
        this.paletteDialog.getContentPane().add(Box.createRigidArea(new Dimension(0, 30)));
        this.paletteDialog.getContentPane().add(palettePane);
        this.paletteDialog.getContentPane().add(Box.createRigidArea(new Dimension(0, 30)));
        this.paletteDialog.getContentPane().add(buttonPane);
        this.paletteDialog.getContentPane().add(Box.createRigidArea(new Dimension(0, 15)));
        this.paletteDialog.getContentPane().add(Box.createVerticalGlue());
        this.paletteDialog.pack();
    }
}

