/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.alignment.PairwiseAlignment;
import chemaxon.marvin.alignment.PairwiseComparison;
import chemaxon.marvin.alignment.PairwiseSimilarity3D;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.gui.DockingForMSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DockDialog
extends JDialog {
    private GraphicScene graphicScene;

    public DockDialog(GraphicScene graphicScene) {
        this.setTitle("Alignment to natural ligand");
        this.setDefaultCloseOperation(2);
        JPanel contentPane = this.initComponents();
        this.setContentPane(contentPane);
        this.graphicScene = graphicScene;
        this.setResizable(false);
        this.setLocationRelativeTo(graphicScene);
        Dimension d = new Dimension(280, 165);
        this.setPreferredSize(d);
        this.setSize(d);
        this.setMinimumSize(d);
        this.pack();
    }

    private JPanel initComponents() {
        JPanel contentPane = new JPanel(new BorderLayout());
        ButtonGroup group = new ButtonGroup();
        final JRadioButton[] radioButtons = new JRadioButton[]{new JRadioButton("Full shape alignment"), new JRadioButton("Systematic atom matching")};
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 3));
        box.setBorder(new TitledBorder("Alignment types"));
        for (int i = 0; i < radioButtons.length; ++i) {
            group.add(radioButtons[i]);
            box.add(radioButtons[i]);
        }
        radioButtons[0].setSelected(true);
        JButton go = new JButton("go");
        go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairwiseComparison p = null;
                if (radioButtons[0].isSelected()) {
                    p = new PairwiseAlignment();
                    p.setCount(2);
                }
                if (radioButtons[1].isSelected()) {
                    p = new PairwiseSimilarity3D();
                }
                DockDialog.this.setVisible(false);
                DockDialog.this.graphicScene.refresh();
                Cursor hourglassCursor = new Cursor(3);
                DockDialog.this.setCursor(hourglassCursor);
                DockingForMSpace dock = new DockingForMSpace(DockDialog.this.graphicScene, p);
                dock.dock();
                DockDialog.this.graphicScene.redraw();
                DockDialog.this.graphicScene.refresh();
                Cursor normalCursor = new Cursor(0);
                DockDialog.this.setCursor(normalCursor);
                DockDialog.this.dispose();
            }
        });
        JButton help = new JButton("help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DockDialog.this, "Usage:\nLoad the protein with the natural ligand and add the molecule to align.\nAlternatively: Load two molecules into the same cell select the one that\nshould kept frozen and highlight the one to align.", "Aligns a molecule on the ligand in the active site.", 1);
            }
        });
        JButton cancel = new JButton("cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockDialog.this.dispose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(cancel);
        buttonPanel.add(new JPanel(new BorderLayout()));
        buttonPanel.add(help);
        buttonPanel.add(new JPanel(new BorderLayout()));
        buttonPanel.add(go);
        contentPane.add((Component)box, "Center");
        contentPane.add((Component)buttonPanel, "South");
        Border padding = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        contentPane.setBorder(padding);
        return contentPane;
    }
}

