/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.PairwiseAlignment;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.gui.AlignmentForMSpace;
import chemaxon.marvin.space.gui.ColorMapperTool;
import chemaxon.marvin.space.gui.DockingForMSpace;
import chemaxon.marvin.space.gui.JMSpaceToolBarIface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gnf.jext.swing.JDualThumbSlider;

public class JMSpaceToolBar
extends JToolBar
implements JMSpaceToolBarIface {
    public static final float FONTSIZE = 9.0f;
    private JToggleButton distanceMonitor;
    private JToggleButton angleMonitor;
    private JToggleButton dihedralMonitor;
    private JToggleButton trControl;
    private JToggleButton rotControl;
    private JToggleButton resizeControl;
    private JToggleButton pharmacophorePoint;
    private JToggleButton pharmacophoreArrow;
    private JButton rigidAlign = this.makeNavigationNormalButton("images/align.png", "Align", "Align all molecules while conformation is preserved", "Align");
    private JButton dockButton = this.makeNavigationNormalButton("images/dock.png", "Dock", "Docking a new ligand by overlaying on an existing.", "Dock");
    public ColorMapperTool paletteChooser;
    private AlignmentForMSpace align;
    private JDualThumbSlider fogSlider;
    private JDualThumbSlider clipSlider;
    public JSpinner isoValue;
    float iv;

    public JMSpaceToolBar(final GraphicScene graphicScene) {
        this.distanceMonitor = this.makeNavigationButton("images/distance.png", "Distance", "Measure distance of two atoms", "Distance");
        this.angleMonitor = this.makeNavigationButton("images/angle.png", "Angle", "Measure angle of three atoms", "Angle");
        this.dihedralMonitor = this.makeNavigationButton("images/dihedral.png", "Dihedral", "Measure dihedral of four atoms", "Dihedral");
        this.pharmacophorePoint = this.makeNavigationButton("images/php.png", "Point", "Place pharmacophore point on a selected atom", "Place PHP");
        this.pharmacophoreArrow = this.makeNavigationButton("images/pha.png", "Arrow", "Place pharmacophore arrow on a selected atom", "Place PHA");
        this.trControl = this.makeNavigationButton("images/move.png", "Shift", "Translate a ligand in the space", "Shift");
        this.rotControl = this.makeNavigationButton("images/rotate.png", "Rotate", "Rotate a ligand in the space", "Rotate");
        this.resizeControl = this.makeNavigationButton("images/resize.png", "Resize", "Resize a resizable object (pharmacophore sphere, arrow)", "Resize");
        Dimension sliderPanelSize = new Dimension(100, 45);
        Dimension sliderSize = new Dimension(90, 10);
        JPanel fog = new JPanel();
        TitledBorder fogborder = BorderFactory.createTitledBorder("Depth cue");
        Font f = fogborder.getTitleFont();
        if (f == null) {
            f = this.getFont();
        }
        fogborder.setTitleFont(f.deriveFont(9.0f));
        fog.setBorder(fogborder);
        fog.setLayout(new BoxLayout(fog, 0));
        fog.setPreferredSize(sliderPanelSize);
        fog.setMaximumSize(sliderPanelSize);
        this.fogSlider = new JDualThumbSlider();
        this.fogSlider.setMinimum(-60);
        this.fogSlider.setMaximum(60);
        this.fogSlider.setMinValue(0);
        this.fogSlider.setMaxValue(40);
        JPanel clip = new JPanel();
        TitledBorder clipborder = BorderFactory.createTitledBorder("Clipping planes");
        f = clipborder.getTitleFont();
        if (f == null) {
            f = this.getFont();
        }
        clipborder.setTitleFont(f.deriveFont(9.0f));
        clip.setBorder(clipborder);
        clip.setLayout(new BoxLayout(clip, 0));
        clip.setPreferredSize(sliderPanelSize);
        clip.setMaximumSize(sliderPanelSize);
        this.clipSlider = new JDualThumbSlider();
        this.clipSlider.setMinimum(-110);
        this.clipSlider.setMaximum(200);
        this.clipSlider.setMinValue(-60);
        this.clipSlider.setMaxValue(150);
        JPanel surface = new JPanel();
        TitledBorder surfaceborder = BorderFactory.createTitledBorder("Isosurface");
        f = surfaceborder.getTitleFont();
        if (f == null) {
            f = this.getFont();
        }
        surfaceborder.setTitleFont(f.deriveFont(9.0f));
        surface.setBorder(surfaceborder);
        surface.setLayout(new BoxLayout(surface, 0));
        surface.setPreferredSize(sliderPanelSize);
        surface.setMaximumSize(sliderPanelSize);
        this.isoValue = new JSpinner(new SpinnerNumberModel(0.025, 0.001, 10.0, 0.005));
        this.isoValue.setMaximumSize(new Dimension(100, 23));
        this.iv = 0.025f;
        this.isoValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                float newValue = ((Number)JMSpaceToolBar.this.isoValue.getValue()).floatValue();
                if (JMSpaceToolBar.this.iv == newValue) {
                    return;
                }
                JMSpaceToolBar.this.iv = newValue;
                graphicScene.processEvent("Surface.IsoValue", "" + newValue);
                graphicScene.getEventHandler().refresh();
            }
        });
        this.isoValue.setEnabled(false);
        surface.add(this.isoValue);
        this.setRollover(true);
        this.add(this.distanceMonitor);
        this.add(this.angleMonitor);
        this.add(this.dihedralMonitor);
        this.add(this.rigidAlign);
        this.add(this.dockButton);
        this.addSeparator();
        this.add(this.trControl);
        this.add(this.rotControl);
        this.add(this.resizeControl);
        this.addSeparator();
        this.add(this.pharmacophorePoint);
        this.add(this.pharmacophoreArrow);
        this.addSeparator();
        fog.add((Component)this.fogSlider);
        fog.setSize(fog.getWidth(), 32);
        this.add(fog);
        clip.add((Component)this.clipSlider);
        clip.setSize(clip.getWidth(), 32);
        this.add(clip);
        this.addSeparator();
        this.add(surface);
        this.addSeparator();
        this.paletteChooser = new ColorMapperTool(graphicScene);
        this.add(this.paletteChooser);
        ActionListener measurementMonitorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JToggleButton b = (JToggleButton)evt.getSource();
                JMSpaceToolBar.this.controlOff();
                JMSpaceToolBar.this.pharmacophoreOff();
                JMSpaceToolBar.this.angleMonitor.setSelected(b == JMSpaceToolBar.this.angleMonitor & b.isSelected());
                JMSpaceToolBar.this.distanceMonitor.setSelected(b == JMSpaceToolBar.this.distanceMonitor & b.isSelected());
                JMSpaceToolBar.this.dihedralMonitor.setSelected(b == JMSpaceToolBar.this.dihedralMonitor & b.isSelected());
                graphicScene.getEventHandler().measure(b.getActionCommand(), b.isSelected());
            }
        };
        ActionListener pharmacophoreActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JToggleButton b = (JToggleButton)evt.getSource();
                JMSpaceToolBar.this.measureOff();
                JMSpaceToolBar.this.controlOff();
                JMSpaceToolBar.this.pharmacophorePoint.setSelected(b == JMSpaceToolBar.this.pharmacophorePoint & b.isSelected());
                JMSpaceToolBar.this.pharmacophoreArrow.setSelected(b == JMSpaceToolBar.this.pharmacophoreArrow & b.isSelected());
                if (b == JMSpaceToolBar.this.pharmacophorePoint) {
                    graphicScene.getEventHandler().placePharmacophorePoint(b.isSelected());
                } else if (b == JMSpaceToolBar.this.pharmacophoreArrow) {
                    graphicScene.getEventHandler().placePharmacophoreArrow(b.isSelected());
                }
            }
        };
        ActionListener controlActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JToggleButton b = (JToggleButton)evt.getSource();
                JMSpaceToolBar.this.measureOff();
                JMSpaceToolBar.this.pharmacophoreOff();
                JMSpaceToolBar.this.trControl.setSelected(b == JMSpaceToolBar.this.trControl && b.isSelected());
                JMSpaceToolBar.this.rotControl.setSelected(b == JMSpaceToolBar.this.rotControl && b.isSelected());
                JMSpaceToolBar.this.resizeControl.setSelected(b == JMSpaceToolBar.this.resizeControl && b.isSelected());
                graphicScene.getEventHandler().control(b.getActionCommand(), b.isSelected());
                graphicScene.getEventHandler().refresh();
            }
        };
        ChangeListener fogChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                graphicScene.processEvent("Depthcue.Near", "" + JMSpaceToolBar.this.fogSlider.getMinValue());
                graphicScene.processEvent("Depthcue.Far", "" + JMSpaceToolBar.this.fogSlider.getMaxValue());
                graphicScene.getEventHandler().refresh();
            }
        };
        PropertyChangeListener fogPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() == null || evt.getNewValue() == null) {
                    return;
                }
                graphicScene.processEvent("Depthcue.Near", "" + JMSpaceToolBar.this.fogSlider.getMinValue());
                graphicScene.processEvent("Depthcue.Far", "" + JMSpaceToolBar.this.fogSlider.getMaxValue());
                graphicScene.getEventHandler().refresh();
            }
        };
        ChangeListener clipChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                graphicScene.processEvent("Clipping.Near", "" + JMSpaceToolBar.this.clipSlider.getMinValue());
                graphicScene.processEvent("Clipping.Far", "" + JMSpaceToolBar.this.clipSlider.getMaxValue());
                graphicScene.getEventHandler().refresh();
            }
        };
        PropertyChangeListener clipPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() == null || evt.getNewValue() == null) {
                    return;
                }
                graphicScene.processEvent("Clipping.Near", "" + JMSpaceToolBar.this.clipSlider.getMinValue());
                graphicScene.processEvent("Clipping.Far", "" + JMSpaceToolBar.this.clipSlider.getMaxValue());
                graphicScene.getEventHandler().refresh();
            }
        };
        this.distanceMonitor.addActionListener(measurementMonitorActionListener);
        this.angleMonitor.addActionListener(measurementMonitorActionListener);
        this.dihedralMonitor.addActionListener(measurementMonitorActionListener);
        this.align = new AlignmentForMSpace(graphicScene);
        this.rigidAlign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMSpaceToolBar.this.align.setAlignmentProperties(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE, AlignmentForMSpace.AlignmentFlexMode.ALL_RIGID);
                JMSpaceToolBar.this.align.align();
                graphicScene.redraw();
                graphicScene.refresh();
            }
        });
        this.dockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairwiseAlignment p = new PairwiseAlignment(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE);
                p.setCount(3);
                DockingForMSpace d = new DockingForMSpace(graphicScene, p);
                d.dock();
            }
        });
        this.pharmacophorePoint.addActionListener(pharmacophoreActionListener);
        this.pharmacophoreArrow.addActionListener(pharmacophoreActionListener);
        this.trControl.addActionListener(controlActionListener);
        this.rotControl.addActionListener(controlActionListener);
        this.resizeControl.addActionListener(controlActionListener);
        this.fogSlider.addChangeListener(fogChangeListener);
        this.fogSlider.addPropertyChangeListener(fogPropertyChangeListener);
        this.clipSlider.addChangeListener(clipChangeListener);
        this.clipSlider.addPropertyChangeListener(clipPropertyChangeListener);
    }

    private float getIsoValue(int n) {
        if (n == 0) {
            return 0.005f;
        }
        if (n < 9) {
            return 0.005f * (float)(n + 1);
        }
        return 0.05f + (float)(n - 9) * 0.01f;
    }

    @Override
    public void measureOff() {
        this.distanceMonitor.setSelected(false);
        this.angleMonitor.setSelected(false);
        this.dihedralMonitor.setSelected(false);
    }

    @Override
    public void controlOff() {
        this.trControl.setSelected(false);
        this.rotControl.setSelected(false);
        this.resizeControl.setSelected(false);
    }

    public void pharmacophoreOff() {
        this.pharmacophorePoint.setSelected(false);
        this.pharmacophoreArrow.setSelected(false);
    }

    @Override
    public void setNearClipValue(int v) {
        this.clipSlider.setMinValue(this.clipSlider.getMinValue() + v);
    }

    protected JToggleButton makeNavigationButton(String imageName, String actionCommand, String toolTipText, String altText) {
        URL imgURL = GraphicScene.class.getResource(imageName);
        JToggleButton button = new JToggleButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        if (imgURL != null) {
            button.setIcon(new ImageIcon(imgURL));
            button.setMargin(new Insets(1, 1, 1, 1));
        } else {
            button.setText(altText);
        }
        return button;
    }

    protected JButton makeNavigationNormalButton(String imageName, String actionCommand, String toolTipText, String altText) {
        URL imgURL = GraphicScene.class.getResource(imageName);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        if (imgURL != null) {
            button.setIcon(new ImageIcon(imgURL));
            button.setMargin(new Insets(1, 1, 1, 1));
        } else {
            button.setText(altText);
        }
        return button;
    }

    @Override
    public ColorMapperTool getPaletteChooser() {
        return this.paletteChooser;
    }

    @Override
    public JSpinner getJSpinner() {
        return this.isoValue;
    }
}

