/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.gui.ColorMapperTool;
import chemaxon.marvin.space.gui.JMSpaceToolBarIface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gnf.jext.swing.JDualThumbSlider;

public class JMSpaceToolBarForAlignmentPlugin
extends JToolBar
implements JMSpaceToolBarIface {
    public static final float FONTSIZE = 9.0f;
    private JToggleButton distanceMonitor = this.makeNavigationButton("images/distance.png", "Distance", "Measure distance of two atoms", "Distance");
    private JToggleButton angleMonitor = this.makeNavigationButton("images/angle.png", "Angle", "Measure angle of three atoms", "Angle");
    private JToggleButton dihedralMonitor = this.makeNavigationButton("images/dihedral.png", "Dihedral", "Measure dihedral of four atoms", "Dihedral");
    private JDualThumbSlider fogSlider;
    private JDualThumbSlider clipSlider;

    public JMSpaceToolBarForAlignmentPlugin(final GraphicScene graphicScene, double volTan) {
        Dimension sliderPanelSize = new Dimension(100, 45);
        Dimension sliderSize = new Dimension(90, 10);
        JPanel fog = new JPanel();
        TitledBorder fogborder = BorderFactory.createTitledBorder("Depth cue");
        Font f = fogborder.getTitleFont();
        if (f == null) {
            f = this.getFont();
        }
        fogborder.setTitleFont(f.deriveFont(9.0f));
        fog.setBorder(fogborder);
        fog.setLayout(new BoxLayout(fog, 0));
        fog.setPreferredSize(sliderPanelSize);
        fog.setMaximumSize(sliderPanelSize);
        this.fogSlider = new JDualThumbSlider();
        this.fogSlider.setMinimum(-60);
        this.fogSlider.setMaximum(60);
        this.fogSlider.setMinValue(0);
        this.fogSlider.setMaxValue(40);
        JPanel clip = new JPanel();
        TitledBorder clipborder = BorderFactory.createTitledBorder("Clipping planes");
        f = clipborder.getTitleFont();
        if (f == null) {
            f = this.getFont();
        }
        clipborder.setTitleFont(f.deriveFont(9.0f));
        clip.setBorder(clipborder);
        clip.setLayout(new BoxLayout(clip, 0));
        clip.setPreferredSize(sliderPanelSize);
        clip.setMaximumSize(sliderPanelSize);
        this.clipSlider = new JDualThumbSlider();
        this.clipSlider.setMinimum(-110);
        this.clipSlider.setMaximum(200);
        this.clipSlider.setMinValue(-60);
        this.clipSlider.setMaxValue(150);
        JPanel surface = new JPanel();
        TitledBorder surfaceborder = BorderFactory.createTitledBorder("3D similarity");
        f = surfaceborder.getTitleFont();
        if (f == null) {
            f = this.getFont();
        }
        surfaceborder.setTitleFont(f.deriveFont(9.0f));
        surface.setBorder(surfaceborder);
        surface.setLayout(new BoxLayout(surface, 0));
        surface.setPreferredSize(sliderPanelSize);
        surface.setMaximumSize(sliderPanelSize);
        DecimalFormat d = new DecimalFormat("0.000");
        JTextField tf = new JTextField(d.format(volTan));
        tf.setEditable(false);
        surface.add(tf);
        this.setRollover(true);
        this.add(this.distanceMonitor);
        this.add(this.angleMonitor);
        this.add(this.dihedralMonitor);
        this.addSeparator();
        fog.add((Component)this.fogSlider);
        fog.setSize(fog.getWidth(), 32);
        this.add(fog);
        clip.add((Component)this.clipSlider);
        clip.setSize(clip.getWidth(), 32);
        this.add(clip);
        this.addSeparator();
        this.add(surface);
        this.addSeparator();
        ActionListener measurementMonitorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JToggleButton b = (JToggleButton)evt.getSource();
                JMSpaceToolBarForAlignmentPlugin.this.angleMonitor.setSelected(b == JMSpaceToolBarForAlignmentPlugin.this.angleMonitor & b.isSelected());
                JMSpaceToolBarForAlignmentPlugin.this.distanceMonitor.setSelected(b == JMSpaceToolBarForAlignmentPlugin.this.distanceMonitor & b.isSelected());
                JMSpaceToolBarForAlignmentPlugin.this.dihedralMonitor.setSelected(b == JMSpaceToolBarForAlignmentPlugin.this.dihedralMonitor & b.isSelected());
                graphicScene.getEventHandler().measure(b.getActionCommand(), b.isSelected());
            }
        };
        ChangeListener fogChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                graphicScene.processEvent("Depthcue.Near", "" + JMSpaceToolBarForAlignmentPlugin.this.fogSlider.getMinValue());
                graphicScene.processEvent("Depthcue.Far", "" + JMSpaceToolBarForAlignmentPlugin.this.fogSlider.getMaxValue());
                graphicScene.getEventHandler().refresh();
            }
        };
        PropertyChangeListener fogPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() == null || evt.getNewValue() == null) {
                    return;
                }
                graphicScene.processEvent("Depthcue.Near", "" + JMSpaceToolBarForAlignmentPlugin.this.fogSlider.getMinValue());
                graphicScene.processEvent("Depthcue.Far", "" + JMSpaceToolBarForAlignmentPlugin.this.fogSlider.getMaxValue());
                graphicScene.getEventHandler().refresh();
            }
        };
        ChangeListener clipChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                graphicScene.processEvent("Clipping.Near", "" + JMSpaceToolBarForAlignmentPlugin.this.clipSlider.getMinValue());
                graphicScene.processEvent("Clipping.Far", "" + JMSpaceToolBarForAlignmentPlugin.this.clipSlider.getMaxValue());
                graphicScene.getEventHandler().refresh();
            }
        };
        PropertyChangeListener clipPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() == null || evt.getNewValue() == null) {
                    return;
                }
                graphicScene.processEvent("Clipping.Near", "" + JMSpaceToolBarForAlignmentPlugin.this.clipSlider.getMinValue());
                graphicScene.processEvent("Clipping.Far", "" + JMSpaceToolBarForAlignmentPlugin.this.clipSlider.getMaxValue());
                graphicScene.getEventHandler().refresh();
            }
        };
        this.distanceMonitor.addActionListener(measurementMonitorActionListener);
        this.angleMonitor.addActionListener(measurementMonitorActionListener);
        this.dihedralMonitor.addActionListener(measurementMonitorActionListener);
        this.fogSlider.addChangeListener(fogChangeListener);
        this.fogSlider.addPropertyChangeListener(fogPropertyChangeListener);
        this.clipSlider.addChangeListener(clipChangeListener);
        this.clipSlider.addPropertyChangeListener(clipPropertyChangeListener);
    }

    private float getIsoValue(int n) {
        if (n == 0) {
            return 0.005f;
        }
        if (n < 9) {
            return 0.005f * (float)(n + 1);
        }
        return 0.05f + (float)(n - 9) * 0.01f;
    }

    @Override
    public void measureOff() {
        this.distanceMonitor.setSelected(false);
        this.angleMonitor.setSelected(false);
        this.dihedralMonitor.setSelected(false);
    }

    @Override
    public void setNearClipValue(int v) {
        this.clipSlider.setMinValue(this.clipSlider.getMinValue() + v);
    }

    protected JToggleButton makeNavigationButton(String imageName, String actionCommand, String toolTipText, String altText) {
        URL imgURL = GraphicScene.class.getResource(imageName);
        JToggleButton button = new JToggleButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        if (imgURL != null) {
            button.setIcon(new ImageIcon(imgURL));
            button.setMargin(new Insets(1, 1, 1, 1));
        } else {
            button.setText(altText);
        }
        return button;
    }

    @Override
    public void controlOff() {
    }

    @Override
    public ColorMapperTool getPaletteChooser() {
        return null;
    }

    @Override
    public JSpinner getJSpinner() {
        return null;
    }
}

