/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.monitor.Label;
import chemaxon.marvin.util.CallbackIface;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class LabelExample
extends JFrame {
    MSpaceEasy mspace;
    Label[] labels = null;

    public static void main(String[] args) {
        LabelExample le = new LabelExample();
    }

    public LabelExample() {
        this.setDefaultCloseOperation(2);
        this.setSize(500, 500);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        try {
            this.mspace = new MSpaceEasy(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mspace.setSize(500, 500);
        this.mspace.addCanvas(this.getContentPane());
        this.labels = new Label[4];
        float[] c = new float[]{50.0f, 50.0f};
        this.labels[0] = this.mspace.getEventHandler().createLabel("First label", c);
        this.labels[0].setBackgroundColor(Color.black);
        this.labels[0].setForegroundColor(Color.white);
        c[1] = c[1] + 50.0f;
        this.labels[1] = this.mspace.getEventHandler().createLabel("Second label", c);
        this.labels[1].setBackgroundColor(Color.white);
        this.labels[1].setForegroundColor(Color.black);
        c[1] = c[1] + 50.0f;
        this.labels[2] = this.mspace.getEventHandler().createLabel("Third label", c);
        this.labels[2].ignoreDrawProperties(true);
        this.labels[2].setBackgroundColor(Color.black);
        this.labels[2].setForegroundColor(Color.white);
        c[1] = c[1] + 50.0f;
        this.labels[3] = this.mspace.getEventHandler().createLabel("Fourth label", c);
        this.labels[3].ignoreDrawProperties(true);
        this.labels[3].setBackgroundColor(Color.white);
        this.labels[3].setForegroundColor(Color.black);
        this.createMSpacePopupMenu();
        this.pack();
    }

    private void createMSpacePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.setLightWeightPopupEnabled(false);
        JMenu label = new JMenu("Label");
        label.getPopupMenu().setLightWeightPopupEnabled(false);
        JCheckBoxMenuItem draw2d = new JCheckBoxMenuItem("Draw2D");
        draw2d.setActionCommand("Label.Draw2D");
        draw2d.setState(true);
        JRadioButtonMenuItem smallMenuItem = new JRadioButtonMenuItem("Small");
        smallMenuItem.setActionCommand("Small");
        smallMenuItem.setSelected(true);
        JRadioButtonMenuItem medMenuItem = new JRadioButtonMenuItem("Medium");
        medMenuItem.setActionCommand("Medium");
        JRadioButtonMenuItem largeMenuItem = new JRadioButtonMenuItem("Large");
        largeMenuItem.setActionCommand("Large");
        JRadioButtonMenuItem whiteMI = new JRadioButtonMenuItem("White");
        whiteMI.setActionCommand("#ffffff");
        whiteMI.setSelected(true);
        JRadioButtonMenuItem blackMI = new JRadioButtonMenuItem("Black");
        blackMI.setActionCommand("#000000");
        JMenu background = new JMenu("Background");
        background.getPopupMenu().setLightWeightPopupEnabled(false);
        JRadioButtonMenuItem white = new JRadioButtonMenuItem("White");
        white.setActionCommand("#ffffff");
        white.setSelected(true);
        JRadioButtonMenuItem black = new JRadioButtonMenuItem("Black");
        black.setActionCommand("#000000");
        ButtonGroup bgbg = new ButtonGroup();
        bgbg.add(white);
        bgbg.add(black);
        ButtonGroup lcbg = new ButtonGroup();
        lcbg.add(whiteMI);
        lcbg.add(blackMI);
        ButtonGroup labelsizebg = new ButtonGroup();
        labelsizebg.add(smallMenuItem);
        labelsizebg.add(medMenuItem);
        labelsizebg.add(largeMenuItem);
        popup.add(label);
        label.add(draw2d);
        label.addSeparator();
        label.add(smallMenuItem);
        label.add(medMenuItem);
        label.add(largeMenuItem);
        label.addSeparator();
        label.add(whiteMI);
        label.add(blackMI);
        popup.add(background);
        background.add(white);
        background.add(black);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelExample.this.mspace.callback(e.getActionCommand(), null);
            }
        };
        ActionListener chbal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem chb = (JCheckBoxMenuItem)e.getSource();
                LabelExample.this.mspace.callback("setProperty", new String[]{e.getActionCommand(), "" + chb.getState()});
            }
        };
        draw2d.addActionListener(chbal);
        this.addActionListener(smallMenuItem, "Label.Size", this.mspace);
        this.addActionListener(medMenuItem, "Label.Size", this.mspace);
        this.addActionListener(largeMenuItem, "Label.Size", this.mspace);
        this.addActionListener(whiteMI, "Label.BackgroundColor", this.mspace);
        this.addActionListener(blackMI, "Label.BackgroundColor", this.mspace);
        this.addActionListener(white, "BackgroundColor", this.mspace);
        this.addActionListener(black, "BackgroundColor", this.mspace);
        this.mspace.callback("addPopupMenu", popup);
        ActionListener colorAL = this.getLabelColorActionListener();
        whiteMI.addActionListener(colorAL);
        blackMI.addActionListener(colorAL);
    }

    private void addActionListener(AbstractButton b, final String property, final CallbackIface mspace) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mspace.callback("setProperty", new String[]{property, e.getActionCommand()});
            }
        });
    }

    private ActionListener getLabelColorActionListener() {
        return new ActionListener(){
            private String whiteString = "#ffffff";
            private String blackString = "#000000";

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < LabelExample.this.labels.length; ++i) {
                    Label label = LabelExample.this.labels[i];
                    if (e.getActionCommand().equals(this.whiteString)) {
                        label.setBackgroundColor(Color.white);
                        label.setForegroundColor(Color.black);
                        continue;
                    }
                    if (!e.getActionCommand().equals(this.blackString)) continue;
                    label.setBackgroundColor(Color.black);
                    label.setForegroundColor(Color.white);
                }
            }
        };
    }
}

