/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.gui.GuiFactory;
import chemaxon.marvin.space.gui.MSpaceViewerBase;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class MSpaceViewer
extends MSpaceViewerBase {
    JDialog dialog = null;

    public MSpaceViewer(boolean install, URL codebase) {
        super(install, codebase);
        this.title = "MarvinSpace Viewer";
    }

    public MSpaceViewer(boolean install, URL codebase, boolean verbose) {
        super(install, codebase, verbose);
        this.title = "MarvinSpace Viewer";
    }

    @Override
    protected Object get(String method, Object arg) {
        if (method.equals("getMSpaceDialog")) {
            try {
                return this.getMSpaceDialog(arg);
            }
            catch (Exception e) {
                return e;
            }
        }
        return super.get(method, arg);
    }

    @Override
    protected boolean set(String method, Object arg) {
        return super.set(method, arg);
    }

    @Override
    public Window getMSpaceViewer(Object parent) throws Exception {
        return this.getMSpaceDialog(parent);
    }

    public JDialog getMSpaceDialog(Object parent) throws Exception {
        this.mspace = new MSpaceEasy(this.install, this.verbose, this.codebase);
        this.createDialog((Component)parent);
        this.dialog.setTitle(this.title);
        this.mspace.addCanvas(this.dialog.getContentPane());
        this.mspace.setSize(800, 600);
        this.createListener();
        this.createMSpacePopupMenu();
        this.mspace.refresh();
        this.dialog.pack();
        return this.dialog;
    }

    private void createMSpacePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.setLightWeightPopupEnabled(false);
        JMenuItem bestFit = new JMenuItem("Best fit");
        bestFit.setActionCommand("resetAll");
        JMenuItem about = new JMenuItem("About MarvinSpace Light");
        popup.add(bestFit);
        bestFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSpaceViewer.this.mspace.callback(e.getActionCommand(), null);
            }
        });
        GuiFactory guiFactory = new GuiFactory();
        JMenu mol = new JMenu("Draw Type");
        mol.getPopupMenu().setLightWeightPopupEnabled(false);
        String[] ldt = new String[]{"Wire", "Ball", "Stick", "Ball and Wire", "Ball and Stick", "Spacefill"};
        ArrayList ligandDrawTypes = new ArrayList();
        ActionListener drawTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSpaceViewer.this.mspace.getGraphicScene().processEvent("Ligand.DrawType", evt.getActionCommand());
                MSpaceViewer.this.mspace.refresh();
            }
        };
        JMenu dligandMenu = guiFactory.getRadioButtonMenu("Draw Type", ldt, ligandDrawTypes, drawTypeActionListener);
        ((JRadioButtonMenuItem)ligandDrawTypes.get(4)).setSelected(true);
        JCheckBoxMenuItem addHys = new JCheckBoxMenuItem("Hydrogens", false);
        addHys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSpaceViewer.this.mspace.getGraphicScene().processEvent("Ligand.Hydrogens", "" + ((JCheckBoxMenuItem)evt.getSource()).getState());
            }
        });
        dligandMenu.add(addHys);
        popup.add(dligandMenu);
        JMenu qualityMenu = new JMenu("Quality");
        qualityMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JRadioButtonMenuItem highMenuItem = new JRadioButtonMenuItem("High");
        highMenuItem.setActionCommand("High");
        JRadioButtonMenuItem mediumMenuItem = new JRadioButtonMenuItem("Medium");
        mediumMenuItem.setSelected(true);
        mediumMenuItem.setActionCommand("Medium");
        JRadioButtonMenuItem lowMenuItem = new JRadioButtonMenuItem("Low");
        lowMenuItem.setActionCommand("Low");
        ButtonGroup qualitybg = new ButtonGroup();
        qualitybg.add(highMenuItem);
        qualitybg.add(mediumMenuItem);
        qualitybg.add(lowMenuItem);
        qualityMenu.add(highMenuItem);
        qualityMenu.add(mediumMenuItem);
        qualityMenu.add(lowMenuItem);
        ActionListener qualityActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSpaceViewer.this.mspace.getGraphicScene().processEvent("Quality", evt.getActionCommand());
                MSpaceViewer.this.mspace.refresh();
            }
        };
        highMenuItem.addActionListener(qualityActionListener);
        mediumMenuItem.addActionListener(qualityActionListener);
        lowMenuItem.addActionListener(qualityActionListener);
        popup.add(qualityMenu);
        JCheckBoxMenuItem autoCB = new JCheckBoxMenuItem("Auto Clean3D", this.autoClean);
        autoCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSpaceViewer.this.autoClean = ((JCheckBoxMenuItem)evt.getSource()).getState();
            }
        });
        popup.addSeparator();
        popup.add(autoCB);
        this.mspace.callback("addPopupMenu", popup);
    }

    private JDialog createDialog(Component parent) {
        Frame pw;
        Dialog pd = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
        this.dialog = pd != null ? new JDialog(pd){

            @Override
            public void dispose() {
                MSpaceViewer.this.mspace.getGraphicScene().removeAllComponents();
                if (MSpaceViewer.this.sketchPanel != null) {
                    MSpaceViewer.this.sketchPanel.removePropertyChangeListener(MSpaceViewer.this.pcl);
                    MSpaceViewer.this.sketchPanel = null;
                }
                super.dispose();
            }
        } : ((pw = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent)) != null ? new JDialog(pw){

            @Override
            public void dispose() {
                MSpaceViewer.this.mspace.getGraphicScene().removeAllComponents();
                if (MSpaceViewer.this.sketchPanel != null) {
                    MSpaceViewer.this.sketchPanel.removePropertyChangeListener(MSpaceViewer.this.pcl);
                    MSpaceViewer.this.sketchPanel = null;
                }
                super.dispose();
            }
        } : new JDialog(){

            @Override
            public void dispose() {
                MSpaceViewer.this.mspace.getGraphicScene().removeAllComponents();
                if (MSpaceViewer.this.sketchPanel != null) {
                    MSpaceViewer.this.sketchPanel.removePropertyChangeListener(MSpaceViewer.this.pcl);
                    MSpaceViewer.this.sketchPanel = null;
                }
                super.dispose();
            }
        });
        return this.dialog;
    }
}

