/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.util.CallbackIface;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.SwingUtilities;

public abstract class MSpaceViewerBase
implements CallbackIface {
    String title;
    boolean install;
    URL codebase;
    boolean verbose = false;
    protected SketchPanel sketchPanel = null;
    protected PropertyChangeListener pcl = null;
    protected MSpaceEasy mspace;
    protected boolean autoClean = true;

    protected MSpaceViewerBase() {
    }

    protected MSpaceViewerBase(boolean install, URL codebase) {
        this.install = install;
        this.codebase = codebase;
    }

    protected MSpaceViewerBase(boolean install, URL codebase, boolean verbose) {
        this.install = install;
        this.codebase = codebase;
        this.verbose = verbose;
    }

    protected abstract Window getMSpaceViewer(Object var1) throws Exception;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSketchPanel(SketchPanel sp) {
        this.sketchPanel = sp;
        this.sketchPanel.addPropertyChangeListener(this.pcl);
    }

    @Override
    public Object callback(String method, Object arg) {
        boolean b = false;
        if (method.startsWith("get")) {
            Object o = this.get(method, arg);
            if (o != null) {
                return o;
            }
            b = true;
        } else if (method.startsWith("set")) {
            b = this.set(method, arg);
        }
        if (!b) {
            this.mspace.callback(method, arg);
        }
        return null;
    }

    protected Object get(String method, Object arg) {
        if (method.equals("getMSpaceViewer")) {
            try {
                return this.getMSpaceViewer(arg);
            }
            catch (Exception e) {
                return e;
            }
        }
        if (method.equals("getTitle")) {
            return this.getTitle();
        }
        return null;
    }

    protected boolean set(String method, Object arg) {
        if (method.equals("setTitle")) {
            this.setTitle((String)arg);
            return true;
        }
        if (method.equals("setSketchPanel")) {
            this.setSketchPanel((SketchPanel)arg);
            return true;
        }
        return false;
    }

    protected void createListener() {
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("mol")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MSpaceViewerBase.this.mspace.getGraphicScene().removeAllComponents();
                            try {
                                if (MSpaceViewerBase.this.autoClean) {
                                    MSpaceViewerBase.this.mspace.addMolecule(MSpaceViewerBase.this.sketchPanel.getMol().cloneMolecule());
                                } else {
                                    MSpaceViewerBase.this.mspace.addMoleculeWithoutChange(MSpaceViewerBase.this.sketchPanel.getMol().cloneMolecule(), false);
                                }
                            }
                            catch (Throwable e) {
                                MSpaceViewerBase.this.mspace.getEventHandler().handleMyErrors(e, "Error passing molecule");
                            }
                            MSpaceViewerBase.this.mspace.refresh();
                        }
                    });
                }
            }
        };
    }
}

